/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.resource.adapter.jdbc.JBossWrapper;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedConnectionRequestInfo;
import org.jboss.resource.connectionmanager.JTATransactionChecker;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.util.NestedSQLException;

public class WrapperDataSource
extends JBossWrapper
implements Referenceable,
DataSource,
Serializable {
    static final long serialVersionUID = 3570285419164793501L;
    private final BaseWrapperManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private Reference reference;

    protected WrapperDataSource(BaseWrapperManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter param1) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int param1) throws SQLException {
    }

    public Connection getConnection() throws SQLException {
        try {
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, null);
            wc.setDataSource(this);
            return wc;
        }
        catch (ResourceException re) {
            throw new NestedSQLException((Throwable)re);
        }
    }

    public Connection getConnection(String user, String password) throws SQLException {
        WrappedConnectionRequestInfo cri = new WrappedConnectionRequestInfo(user, password);
        try {
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
            wc.setDataSource(this);
            return wc;
        }
        catch (ResourceException re) {
            throw new NestedSQLException((Throwable)re);
        }
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    protected int getTimeLeftBeforeTransactionTimeout() throws SQLException {
        try {
            if (this.cm instanceof TransactionTimeoutConfiguration) {
                long timeout = ((TransactionTimeoutConfiguration)this.cm).getTimeLeftBeforeTransactionTimeout(true);
                if (timeout == -1L) {
                    return -1;
                }
                long result = timeout / 1000L;
                if (result % 1000L != 0L) {
                    ++result;
                }
                return (int)result;
            }
            return -1;
        }
        catch (RollbackException e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    protected void checkTransactionActive() throws SQLException {
        if (this.cm == null) {
            throw new SQLException("No connection manager");
        }
        try {
            if (this.cm instanceof JTATransactionChecker) {
                ((JTATransactionChecker)this.cm).checkTransactionActive();
            }
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }
}

