/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.deployment.HotDeploymentStrategy;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.web.AbstractFilter;
import org.jboss.seam.web.FilterConfigWrapper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.wicketFilter")
@Install(precedence=0, dependencies={"org.jboss.seam.wicket.web.wicketFilterInstantiator"})
@BypassInterceptors
@Filter(within={"org.jboss.seam.debug.hotDeployFilter"})
public class WicketFilter
extends AbstractFilter {
    private javax.servlet.Filter delegate = null;
    private String applicationClass;
    private String applicationFactoryClass;
    private boolean detectPortletContext;
    private long lastInitTime = 0L;
    private FilterConfig savedConfig;
    private ClassLoader hotDeployClassLoader;

    @Observer(value={"org.jboss.seam.postInitialization", "org.jboss.seam.postReInitialization"})
    public void postReInitialization() {
        HotDeploymentStrategy strategy = (HotDeploymentStrategy)Contexts.getEventContext().get("hotDeploymentStrategy");
        this.hotDeployClassLoader = strategy != null ? strategy.getClassLoader() : null;
    }

    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain chain) throws IOException, ServletException {
        if (this.delegate == null) {
            chain.doFilter(servletRequest, servletResponse);
        } else {
            new ContextualHttpServletRequest((HttpServletRequest)servletRequest){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process() throws Exception {
                    if (WicketFilter.this.lastInitTime != Init.instance().getTimestamp()) {
                        WicketFilter.this.delegate.destroy();
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        if (WicketFilter.this.getApplicationClass() != null) {
                            parameters.put("applicationClassName", WicketFilter.this.getApplicationClass());
                        }
                        if (WicketFilter.this.getUrlPattern() != null) {
                            parameters.put("filterMappingUrlPattern", WicketFilter.this.getUrlPattern());
                        } else {
                            parameters.put("filterMappingUrlPattern", "/*");
                        }
                        if (WicketFilter.this.getApplicationFactoryClass() != null) {
                            parameters.put("applicationFactoryClassName", WicketFilter.this.getApplicationFactoryClass());
                        }
                        if (WicketFilter.this.isDetectPortletContext()) {
                            parameters.put("detectPortletContext", "true");
                        }
                        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
                        if (WicketFilter.this.hotDeployClassLoader != null) {
                            Thread.currentThread().setContextClassLoader(WicketFilter.this.hotDeployClassLoader);
                        }
                        try {
                            WicketFilter.this.delegate.init((FilterConfig)new FilterConfigWrapper(WicketFilter.this.savedConfig, parameters));
                        }
                        finally {
                            if (WicketFilter.this.hotDeployClassLoader != null) {
                                Thread.currentThread().setContextClassLoader(previousClassLoader);
                            }
                        }
                        WicketFilter.this.lastInitTime = Init.instance().getTimestamp();
                    }
                    WicketFilter.this.delegate.doFilter(servletRequest, servletResponse, chain);
                }
            }.run();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.delegate = (javax.servlet.Filter)Component.getInstance("org.jboss.seam.wicket.web.wicketFilterInstantiator", ScopeType.STATELESS);
        this.savedConfig = filterConfig;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public void setApplicationClass(String applicationClassName) {
        this.applicationClass = applicationClassName;
    }

    public String getApplicationFactoryClass() {
        return this.applicationFactoryClass;
    }

    public void setApplicationFactoryClass(String applicationFactoryClass) {
        this.applicationFactoryClass = applicationFactoryClass;
    }

    public boolean isDetectPortletContext() {
        return this.detectPortletContext;
    }

    public void setDetectPortletContext(boolean detectPortletContext) {
        this.detectPortletContext = detectPortletContext;
    }
}

