/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ConcurrentRequestTimeoutException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.util.Id;
import org.jboss.seam.web.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.core.manager")
@Install(precedence=0)
@BypassInterceptors
public class Manager {
    public static final String EVENT_CONVERSATION_TIMEOUT = "org.jboss.seam.conversationTimeout";
    public static final String EVENT_CONVERSATION_DESTROYED = "org.jboss.seam.conversationDestroyed";
    public static final String EVENT_CONVERSATION_BEGIN = "org.jboss.seam.beginConversation";
    public static final String EVENT_CONVERSATION_END = "org.jboss.seam.endConversation";
    private static final LogProvider log = Logging.getLogProvider(Manager.class);
    public static final String REDIRECT_FROM_MANAGER = "org.jboss.seam.core.Manager";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private String currentConversationId;
    private List<String> currentConversationIdStack;
    private boolean isLongRunningConversation;
    private boolean destroyBeforeRedirect;
    private int conversationTimeout = 600000;
    private int concurrentRequestTimeout = 1000;
    private String conversationIdParameter = "conversationId";
    private String parentConversationIdParameter = "parentConversationId";
    private String URIEncoding = "UTF-8";
    private FlushModeType defaultFlushMode;
    private ConversationEntry currentConversationEntry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllOtherConversations() {
        Events events;
        ConversationEntries conversationEntries = ConversationEntries.instance();
        Events events2 = events = Events.exists() ? Events.instance() : null;
        if (conversationEntries != null) {
            ArrayList<ConversationEntry> entries = new ArrayList<ConversationEntry>(conversationEntries.getConversationEntries());
            for (ConversationEntry conversationEntry : entries) {
                if (this.getCurrentConversationEntry() != null && this.getCurrentConversationIdStack().contains(conversationEntry.getId())) continue;
                log.info("Kill all other conversations, executed: kill conversation id = " + conversationEntry.getId());
                boolean locked = conversationEntry.lockNoWait();
                try {
                    if (locked) {
                        if (log.isDebugEnabled()) {
                            log.debug("conversation killed manually: " + conversationEntry.getId());
                        }
                    } else {
                        log.debug("kill conversation with garbage lock: " + conversationEntry.getId());
                    }
                    if (events != null) {
                        events.raiseEvent(EVENT_CONVERSATION_DESTROYED, conversationEntry);
                    }
                    this.destroyConversation(conversationEntry.getId(), this.getSessionMap());
                }
                finally {
                    if (locked) {
                        conversationEntry.unlock();
                    }
                }
            }
        }
    }

    private Map<String, Object> getSessionMap() {
        String[] sessionAttributeNames;
        HashMap<String, Object> session = new HashMap<String, Object>();
        for (String attributeName : sessionAttributeNames = Contexts.getSessionContext().getNames()) {
            session.put(attributeName, Contexts.getSessionContext().get(attributeName));
        }
        return session;
    }

    public String getCurrentConversationId() {
        return this.currentConversationId;
    }

    public void setCurrentConversationId(String id) {
        this.currentConversationId = id;
        this.currentConversationEntry = null;
    }

    public void updateCurrentConversationId(String id) {
        if (id != null && id.equals(this.currentConversationId)) {
            return;
        }
        if (ConversationEntries.instance().getConversationIds().contains(id)) {
            throw new IllegalStateException("Conversation id is already in use: " + id);
        }
        String[] names = Contexts.getConversationContext().getNames();
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = Contexts.getConversationContext().get(names[i]);
            Contexts.getConversationContext().remove(names[i]);
        }
        Contexts.getConversationContext().flush();
        ConversationEntry ce = ConversationEntries.instance().updateConversationId(this.currentConversationId, id);
        String priorId = this.currentConversationId;
        this.setCurrentConversationId(id);
        if (ce != null) {
            this.setCurrentConversationIdStack(ce.getConversationIdStack());
        } else {
            int pos = this.currentConversationIdStack.indexOf(priorId);
            if (pos != -1) {
                this.currentConversationIdStack.set(pos, id);
            }
        }
        for (int i = 0; i < names.length; ++i) {
            Contexts.getConversationContext().set(names[i], values[i]);
        }
    }

    private void touchConversationStack(List<String> stack) {
        if (stack != null) {
            ListIterator<String> iter = stack.listIterator(stack.size());
            while (iter.hasPrevious()) {
                String conversationId = iter.previous();
                ConversationEntry conversationEntry = ConversationEntries.instance().getConversationEntry(conversationId);
                if (conversationEntry == null) continue;
                conversationEntry.touch();
            }
        }
    }

    private void endNestedConversations(String id) {
        for (ConversationEntry ce : ConversationEntries.instance().getConversationEntries()) {
            if (!ce.getConversationIdStack().contains(id)) continue;
            ce.end();
        }
    }

    public List<String> getCurrentConversationIdStack() {
        return this.currentConversationIdStack;
    }

    public void setCurrentConversationIdStack(List<String> stack) {
        this.currentConversationIdStack = stack;
    }

    private List<String> createCurrentConversationIdStack(String id) {
        this.currentConversationIdStack = new ArrayList<String>();
        this.currentConversationIdStack.add(id);
        return this.currentConversationIdStack;
    }

    public String getCurrentConversationDescription() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getDescription();
    }

    public Integer getCurrentConversationTimeout() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getTimeout();
    }

    public Integer getCurrentConversationConcurrentRequestTimeout() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getConcurrentRequestTimeout();
    }

    public String getCurrentConversationViewId() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getViewId();
    }

    public String getParentConversationViewId() {
        ConversationEntry conversationEntry = ConversationEntries.instance().getConversationEntry(this.getParentConversationId());
        return conversationEntry == null ? null : conversationEntry.getViewId();
    }

    public String getParentConversationId() {
        return this.currentConversationIdStack == null || this.currentConversationIdStack.size() < 2 ? null : this.currentConversationIdStack.get(1);
    }

    public String getRootConversationId() {
        return this.currentConversationIdStack == null || this.currentConversationIdStack.size() < 1 ? null : this.currentConversationIdStack.get(this.currentConversationIdStack.size() - 1);
    }

    public boolean isLongRunningConversation() {
        return this.isLongRunningConversation;
    }

    public boolean isLongRunningOrNestedConversation() {
        return this.isLongRunningConversation() || this.isNestedConversation();
    }

    public boolean isReallyLongRunningConversation() {
        return this.isLongRunningConversation() && !this.getCurrentConversationEntry().isRemoveAfterRedirect() && !Session.instance().isInvalid();
    }

    public boolean isNestedConversation() {
        return this.currentConversationIdStack != null && this.currentConversationIdStack.size() > 1;
    }

    public void setLongRunningConversation(boolean isLongRunningConversation) {
        this.isLongRunningConversation = isLongRunningConversation;
    }

    public static Manager instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("No active event context");
        }
        Manager instance = (Manager)Component.getInstance(Manager.class, ScopeType.EVENT);
        if (instance == null) {
            throw new IllegalStateException("No Manager could be created, make sure the Component exists in application scope");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conversationTimeout(Map<String, Object> session) {
        long currentTime = System.currentTimeMillis();
        ConversationEntries conversationEntries = ConversationEntries.getInstance();
        if (conversationEntries != null) {
            ArrayList<ConversationEntry> entries = new ArrayList<ConversationEntry>(conversationEntries.getConversationEntries());
            for (ConversationEntry conversationEntry : entries) {
                boolean locked = conversationEntry.lockNoWait();
                try {
                    long delta = currentTime - conversationEntry.getLastRequestTime();
                    if (delta <= (long)conversationEntry.getTimeout()) continue;
                    if (locked) {
                        if (log.isDebugEnabled()) {
                            log.debug("conversation timeout for conversation: " + conversationEntry.getId());
                        }
                    } else {
                        log.info("destroying conversation with garbage lock: " + conversationEntry.getId());
                    }
                    if (Events.exists()) {
                        Events.instance().raiseEvent(EVENT_CONVERSATION_TIMEOUT, conversationEntry.getId());
                    }
                    this.destroyConversation(conversationEntry.getId(), session);
                }
                finally {
                    if (locked) {
                        conversationEntry.unlock();
                    }
                }
            }
        }
    }

    private void destroyConversation(String conversationId, Map<String, Object> session) {
        Lifecycle.destroyConversationContext(session, conversationId);
        ConversationEntries.instance().removeConversationEntry(conversationId);
    }

    public void endRequest(Map<String, Object> session) {
        if (this.isLongRunningConversation()) {
            if (log.isDebugEnabled()) {
                log.debug("Storing conversation state: " + this.getCurrentConversationId());
            }
            this.touchConversationStack(this.getCurrentConversationIdStack());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Discarding conversation state: " + this.getCurrentConversationId());
            }
            this.removeCurrentConversationAndDestroyNestedContexts(session);
        }
        Manager.instance().conversationTimeout(session);
    }

    public void unlockConversation() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce != null) {
            if (ce.isLockedByCurrentThread()) {
                ce.unlock();
            }
        } else if (this.isNestedConversation()) {
            ConversationEntries.instance().getConversationEntry(this.getParentConversationId()).unlock();
        }
    }

    private void removeCurrentConversationAndDestroyNestedContexts(Map<String, Object> session) {
        ConversationEntries conversationEntries = ConversationEntries.getInstance();
        if (conversationEntries != null) {
            conversationEntries.removeConversationEntry(this.getCurrentConversationId());
            this.destroyNestedConversationContexts(session, this.getCurrentConversationId());
        }
    }

    private void destroyNestedConversationContexts(Map<String, Object> session, String conversationId) {
        ArrayList<ConversationEntry> entries = new ArrayList<ConversationEntry>(ConversationEntries.instance().getConversationEntries());
        for (ConversationEntry ce : entries) {
            if (!ce.getConversationIdStack().contains(conversationId)) continue;
            String entryConversationId = ce.getId();
            log.debug("destroying nested conversation: " + entryConversationId);
            this.destroyConversation(entryConversationId, session);
        }
    }

    public void handleConversationPropagation(Map parameters) {
        ConversationPropagation propagation = ConversationPropagation.instance();
        if (propagation.getPropagationType() == null) {
            return;
        }
        switch (propagation.getPropagationType()) {
            case BEGIN: {
                if (this.isLongRunningConversation) {
                    throw new IllegalStateException("long-running conversation already active");
                }
                this.beginConversation();
                if (propagation.getPageflow() == null) break;
                Pageflow.instance().begin(propagation.getPageflow());
                break;
            }
            case JOIN: {
                if (this.isLongRunningConversation) break;
                this.beginConversation();
                if (propagation.getPageflow() == null) break;
                Pageflow.instance().begin(propagation.getPageflow());
                break;
            }
            case NEST: {
                if (this.isLongRunningOrNestedConversation()) {
                    this.beginNestedConversation();
                } else {
                    this.beginConversation();
                }
                if (propagation.getPageflow() == null) break;
                Pageflow.instance().begin(propagation.getPageflow());
                break;
            }
            case END: {
                this.endConversation(false);
            }
        }
    }

    public boolean restoreConversation() {
        ConversationEntries entries;
        ConversationPropagation cp = ConversationPropagation.instance();
        String conversationId = cp.getConversationId();
        String parentConversationId = cp.getParentConversationId();
        ConversationEntry ce = null;
        if (conversationId != null && (ce = (entries = ConversationEntries.instance()).getConversationEntry(conversationId)) == null) {
            ce = entries.getConversationEntry(parentConversationId);
        }
        return this.restoreAndLockConversation(ce) || !cp.isValidateLongRunningConversation();
    }

    private boolean restoreAndLockConversation(ConversationEntry ce) {
        if (ce == null) {
            log.debug("No stored conversation");
            this.initializeTemporaryConversation();
            return false;
        }
        if (ce.lock()) {
            boolean removeAfterRedirect;
            this.touchConversationStack(ce.getConversationIdStack());
            log.debug("Restoring conversation with id: " + ce.getId());
            this.setLongRunningConversation(true);
            this.setCurrentConversationId(ce.getId());
            this.setCurrentConversationIdStack(ce.getConversationIdStack());
            boolean bl = removeAfterRedirect = ce.isRemoveAfterRedirect() && !Pages.isDebugPage();
            if (removeAfterRedirect) {
                this.setLongRunningConversation(false);
                ce.setRemoveAfterRedirect(false);
            }
            return true;
        }
        log.debug("Concurrent call to conversation");
        throw new ConcurrentRequestTimeoutException("Concurrent call to conversation");
    }

    public void initializeTemporaryConversation() {
        String id = this.generateInitialConversationId();
        this.setCurrentConversationId(id);
        this.createCurrentConversationIdStack(id);
        this.setLongRunningConversation(false);
    }

    protected String generateInitialConversationId() {
        return Id.nextId();
    }

    private ConversationEntry createConversationEntry() {
        ConversationEntry entry = ConversationEntries.instance().createConversationEntry(this.getCurrentConversationId(), this.getCurrentConversationIdStack());
        if (!entry.isNested()) {
            entry.lock();
        }
        return entry;
    }

    public void beginConversation() {
        if (!this.isLongRunningConversation()) {
            log.debug("Beginning long-running conversation");
            this.setLongRunningConversation(true);
            this.createConversationEntry();
            Conversation.instance();
            this.storeConversationToViewRootIfNecessary();
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_CONVERSATION_BEGIN, new Object[0]);
            }
        }
    }

    public void beginNestedConversation() {
        log.debug("Beginning nested conversation");
        List<String> oldStack = this.getCurrentConversationIdStack();
        if (oldStack == null) {
            throw new IllegalStateException("No long-running conversation active");
        }
        String id = Id.nextId();
        this.setCurrentConversationId(id);
        this.createCurrentConversationIdStack(id).addAll(oldStack);
        this.createConversationEntry();
        this.storeConversationToViewRootIfNecessary();
        if (Events.exists()) {
            Events.instance().raiseEvent(EVENT_CONVERSATION_BEGIN, new Object[0]);
        }
    }

    public void endConversation(boolean beforeRedirect) {
        if (this.isLongRunningConversation()) {
            log.debug("Ending long-running conversation");
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_CONVERSATION_END, new Object[0]);
            }
            this.setLongRunningConversation(false);
            this.destroyBeforeRedirect = beforeRedirect;
            this.endNestedConversations(this.getCurrentConversationId());
            this.storeConversationToViewRootIfNecessary();
        }
    }

    public void endRootConversation(boolean beforeRedirect) {
        if (this.isNestedConversation()) {
            this.switchConversation(this.getRootConversationId());
        }
        this.endConversation(beforeRedirect);
    }

    protected void storeConversationToViewRootIfNecessary() {
    }

    public ConversationEntry getCurrentConversationEntry() {
        if (this.currentConversationEntry == null) {
            this.currentConversationEntry = ConversationEntries.instance().getConversationEntry(this.getCurrentConversationId());
        }
        return this.currentConversationEntry;
    }

    public void leaveConversation() {
        this.unlockConversation();
        this.initializeTemporaryConversation();
    }

    public boolean switchConversation(String id) {
        ConversationEntry ce = ConversationEntries.instance().getConversationEntry(id);
        if (ce != null) {
            if (ce.lock()) {
                this.unlockConversation();
                this.setCurrentConversationId(id);
                this.setCurrentConversationIdStack(ce.getConversationIdStack());
                this.setLongRunningConversation(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public int getConversationTimeout() {
        return this.conversationTimeout;
    }

    public void setConversationTimeout(int conversationTimeout) {
        this.conversationTimeout = conversationTimeout;
    }

    public void beforeRedirect() {
        if (!this.destroyBeforeRedirect) {
            ConversationEntry ce = this.getCurrentConversationEntry();
            if (ce == null) {
                ce = this.createConversationEntry();
            }
            ce.setRemoveAfterRedirect(!this.isLongRunningConversation());
            this.setLongRunningConversation(true);
        }
    }

    protected static boolean isDifferentConversationId(ConversationIdParameter sp, ConversationIdParameter tp) {
        return sp.getName() != tp.getName() && (sp.getName() == null || !sp.getName().equals(tp.getName()));
    }

    public String encodeConversationId(String url) {
        return this.encodeConversationIdParameter(url, this.getConversationIdParameter(), this.getCurrentConversationId());
    }

    public String encodeConversationId(String url, String viewId) {
        ConversationIdParameter cip = Pages.instance().getPage(viewId).getConversationIdParameter();
        return this.encodeConversationIdParameter(url, cip.getParameterName(), cip.getParameterValue());
    }

    public String encodeConversationId(String url, String viewId, String conversationId) {
        ConversationIdParameter cip = Pages.instance().getPage(viewId).getConversationIdParameter();
        return this.encodeConversationIdParameter(url, cip.getParameterName(), cip.getParameterValue(conversationId));
    }

    protected String encodeConversationIdParameter(String url, String paramName, String paramValue) {
        if (Session.instance().isInvalid() || this.containsParameter(url, paramName)) {
            return url;
        }
        if (this.destroyBeforeRedirect) {
            if (this.isNestedConversation()) {
                return new StringBuilder(url.length() + paramName.length() + 5).append(url).append(url.contains("?") ? (char)'&' : '?').append(paramName).append('=').append(this.encode(this.getParentConversationId())).toString();
            }
            return url;
        }
        StringBuilder builder = new StringBuilder(url.length() + paramName.length() + 5).append(url).append(url.contains("?") ? (char)'&' : '?').append(paramName).append('=').append(this.encode(paramValue));
        if (this.isNestedConversation() && !this.isReallyLongRunningConversation()) {
            builder.append('&').append(this.parentConversationIdParameter).append('=').append(this.encode(this.getParentConversationId()));
        }
        return builder.toString();
    }

    public String encodeParameters(String url, Map<String, Object> parameters) {
        if (parameters.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            String parameterName = param.getKey();
            if (this.containsParameter(url, parameterName)) continue;
            Object parameterValue = param.getValue();
            if (parameterValue instanceof Iterable) {
                for (Object value : (Iterable)parameterValue) {
                    builder.append('&').append(parameterName).append('=');
                    if (value == null) continue;
                    builder.append(this.encode(value));
                }
                continue;
            }
            builder.append('&').append(parameterName).append('=');
            if (parameterValue == null) continue;
            builder.append(this.encode(parameterValue));
        }
        if (url.indexOf(63) < 0) {
            builder.setCharAt(url.length(), '?');
        }
        return builder.toString();
    }

    private boolean containsParameter(String url, String parameterName) {
        return url.indexOf('?' + parameterName + '=') > 0 || url.indexOf('&' + parameterName + '=') > 0;
    }

    private String encode(Object value) {
        try {
            return URLEncoder.encode(String.valueOf(value), this.getUriEncoding());
        }
        catch (UnsupportedEncodingException iee) {
            throw new RuntimeException(iee);
        }
    }

    public String getConversationIdParameter() {
        return this.conversationIdParameter;
    }

    public void setConversationIdParameter(String conversationIdParameter) {
        this.conversationIdParameter = conversationIdParameter;
    }

    public String getParentConversationIdParameter() {
        return this.parentConversationIdParameter;
    }

    public void setParentConversationIdParameter(String nestedConversationIdParameter) {
        this.parentConversationIdParameter = nestedConversationIdParameter;
    }

    public int getConcurrentRequestTimeout() {
        return this.concurrentRequestTimeout;
    }

    public void setConcurrentRequestTimeout(int requestWait) {
        this.concurrentRequestTimeout = requestWait;
    }

    public FlushModeType getDefaultFlushMode() {
        return this.defaultFlushMode;
    }

    public void setDefaultFlushMode(FlushModeType defaultFlushMode) {
        this.defaultFlushMode = defaultFlushMode;
    }

    public String toString() {
        return "Manager(" + this.currentConversationIdStack + ")";
    }

    public void redirect(String viewId, String id) {
        throw new UnsupportedOperationException();
    }

    public void redirect(String viewId) {
        throw new UnsupportedOperationException();
    }

    protected void flushConversationMetadata() {
        if (this.isLongRunningConversation()) {
            Conversation.instance().flush();
        }
    }

    public String getUriEncoding() {
        return this.URIEncoding;
    }

    public void setUriEncoding(String encoding) {
        this.URIEncoding = encoding;
    }
}

