/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.media;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.Implementation;
import org.dcm4che2.data.VR;

public class FileMetaInformation {
    public static final int VERSION_01 = 1;
    protected final DicomObject dcmobj;

    public FileMetaInformation(DicomObject dcmobj) {
        if (dcmobj == null) {
            throw new NullPointerException("dcmobj");
        }
        this.dcmobj = dcmobj;
    }

    public FileMetaInformation() {
        this.dcmobj = new BasicDicomObject();
    }

    public FileMetaInformation(String cuid, String iuid, String tsuid) {
        this.dcmobj = new BasicDicomObject();
        this.init(cuid, iuid, tsuid);
    }

    public final DicomObject getDicomObject() {
        return this.dcmobj;
    }

    protected String getSOPClassUID() {
        return this.dcmobj.getString(524310);
    }

    protected String getSOPInstanceUID() {
        return this.dcmobj.getString(524312);
    }

    public void init() {
        this.init(this.getSOPClassUID(), this.getSOPInstanceUID(), "1.2.840.10008.1.2.1");
    }

    public final void init(String cuid, String iuid, String tsuid) {
        this.setFileMetaInformationVersion(1);
        this.setMediaStorageSOPClassUID(cuid);
        this.setMediaStorageSOPInstanceUID(iuid);
        this.setTransferSyntaxUID(tsuid);
        this.setImplementationClassUID(Implementation.classUID());
        this.setImplementationVersionName(Implementation.versionName());
    }

    public int getFileMetaInformationVersion() {
        byte[] b = this.dcmobj.getBytes(131073);
        return (b[0] & 0xFF) << 8 | b[1] & 0xFF;
    }

    public void setFileMetaInformationVersion(int version) {
        byte[] b = new byte[]{(byte)(version >> 8), (byte)version};
        this.dcmobj.putBytes(131073, VR.OB, b);
    }

    public String getMediaStorageSOPInstanceUID() {
        return this.dcmobj.getString(131075);
    }

    public void setMediaStorageSOPInstanceUID(String uid) {
        this.dcmobj.putString(131075, VR.UI, uid);
    }

    public String getMediaStorageSOPClassUID() {
        return this.dcmobj.getString(131074);
    }

    public void setMediaStorageSOPClassUID(String uid) {
        this.dcmobj.putString(131074, VR.UI, uid);
    }

    public String getImplementationClassUID() {
        return this.dcmobj.getString(131090);
    }

    public void setImplementationClassUID(String uid) {
        this.dcmobj.putString(131090, VR.UI, uid);
    }

    public String getImplementationVersionName() {
        return this.dcmobj.getString(131091);
    }

    public void setImplementationVersionName(String name) {
        this.dcmobj.putString(131091, VR.SH, name);
    }

    public String getTransferSyntaxUID() {
        return this.dcmobj.getString(131088);
    }

    public void setTransferSyntaxUID(String uid) {
        this.dcmobj.putString(131088, VR.UI, uid);
    }

    public String getSourceApplicationEntityTitle() {
        return this.dcmobj.getString(131094);
    }

    public void setSourceApplicationEntityTitle(String ae) {
        this.dcmobj.putString(131094, VR.AE, ae);
    }

    public String getPrivateInformationCreatorUID() {
        return this.dcmobj.getString(131328);
    }

    public void setPrivateInformationCreatorUID(String uid) {
        this.dcmobj.putString(131328, VR.UI, uid);
    }

    public byte[] getPrivateInformation() {
        return this.dcmobj.getBytes(131330);
    }

    public void setPrivateInformation(byte[] ob) {
        this.dcmobj.putBytes(131073, VR.OB, ob);
    }
}

