/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.data.VR;
import org.dcm4che2.data.VRMap;
import org.dcm4che2.io.DicomCodingException;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.ImageInputStreamAdapter;
import org.dcm4che2.io.RAFInputStreamAdapter;
import org.dcm4che2.util.ByteUtils;
import org.dcm4che2.util.CloseUtils;
import org.dcm4che2.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomInputStream
extends FilterInputStream
implements DicomInputHandler {
    private static Logger log = LoggerFactory.getLogger(DicomInputStream.class);
    private static final int ZLIB_HEADER = 30876;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private DicomInputHandler handler = this;
    private TransferSyntax ts;
    private DicomObject attrs;
    private ArrayList<DicomElement> sqStack;
    private long pos = 0L;
    private long tagpos = 0L;
    private boolean expectFmiEnd = false;
    private long fmiEndPos = 0L;
    private long markedPos = 0L;
    private byte[] preamble;
    private byte[] header = new byte[8];
    private int tag;
    private VR vr;
    private int vallen;
    private boolean stopAtFmiEnd;

    public DicomInputStream(RandomAccessFile raf) throws IOException {
        this(new RAFInputStreamAdapter(raf));
        this.pos = raf.getFilePointer();
    }

    public DicomInputStream(RandomAccessFile raf, TransferSyntax ts) throws IOException {
        this((InputStream)new RAFInputStreamAdapter(raf), ts);
        this.pos = raf.getFilePointer();
    }

    public DicomInputStream(File f) throws IOException {
        super(new BufferedInputStream(new FileInputStream(f)));
        try {
            this.ts = this.guessTransferSyntax();
        }
        catch (IOException e) {
            CloseUtils.safeClose(this);
            throw e;
        }
    }

    public DicomInputStream(ImageInputStream iis, TransferSyntax ts) throws IOException {
        this((InputStream)new ImageInputStreamAdapter(iis), ts);
        this.pos = iis.getStreamPosition();
    }

    public DicomInputStream(ImageInputStream iis) throws IOException {
        this(new ImageInputStreamAdapter(iis));
        this.pos = iis.getStreamPosition();
    }

    public DicomInputStream(InputStream in, String tsuid) throws IOException {
        this(in, TransferSyntax.valueOf(tsuid));
    }

    public DicomInputStream(InputStream in) throws IOException {
        super(in);
        this.ts = this.guessTransferSyntax();
    }

    public DicomInputStream(InputStream in, TransferSyntax ts) throws IOException {
        super(in);
        if (ts == null) {
            throw new NullPointerException("ts");
        }
        this.switchTransferSyntax(ts);
    }

    public byte[] getPreamble() {
        return this.preamble == null ? null : (byte[])this.preamble.clone();
    }

    public final long getStreamPosition() {
        return this.pos;
    }

    public final void setStreamPosition(long pos) {
        this.pos = pos;
    }

    public final long tagPosition() {
        return this.tagpos;
    }

    public final long getEndOfFileMetaInfoPosition() {
        return this.fmiEndPos;
    }

    public final void setEndOfFileMetaInfoPosition(long fmiEndPos) {
        this.fmiEndPos = fmiEndPos;
    }

    public final void setHandler(DicomInputHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public final int tag() {
        return this.tag;
    }

    public final int level() {
        return this.sqStack != null ? this.sqStack.size() : 0;
    }

    public final int valueLength() {
        return this.vallen;
    }

    public final VR vr() {
        return this.vr;
    }

    public final DicomElement sq() {
        return this.sqStack.get(this.sqStack.size() - 1);
    }

    public final TransferSyntax getTransferSyntax() {
        return this.ts;
    }

    public final DicomObject getDicomObject() {
        return this.attrs;
    }

    private TransferSyntax guessTransferSyntax() throws IOException {
        this.mark(132);
        byte[] b = new byte[128];
        try {
            this.readFully(b, 0, 128);
            this.readFully(this.header, 0, 4);
            if (this.header[0] == 68 && this.header[1] == 73 && this.header[2] == 67 && this.header[3] == 77) {
                this.preamble = b;
                b = this.header;
                if (!this.markSupported()) {
                    this.expectFmiEnd = true;
                    return TransferSyntax.ExplicitVRLittleEndian;
                }
                this.mark(6);
                this.readFully(b, 0, 6);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reset();
        VRMap vrmap = VRMap.getVRMap();
        int vrcode = (b[4] & 0xFF) << 8 | b[5] & 0xFF;
        VR vr = vrmap.vrOf(ByteUtils.bytesLE2tag(b, 0));
        if (vr != VR.UN) {
            this.expectFmiEnd = b[0] == 2;
            return vrcode == vr.code() ? TransferSyntax.ExplicitVRLittleEndian : TransferSyntax.ImplicitVRLittleEndian;
        }
        vr = vrmap.vrOf(ByteUtils.bytesBE2tag(b, 0));
        if (vr != VR.UN) {
            this.expectFmiEnd = b[1] == 2;
            return vrcode == vr.code() ? TransferSyntax.ExplicitVRBigEndian : TransferSyntax.ImplicitVRBigEndian;
        }
        throw new DicomCodingException("Not a DICOM Stream");
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (ch != -1) {
            ++this.pos;
        }
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.pos += (long)result;
        }
        return result;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markedPos = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.pos = this.markedPos;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        if (result > 0L) {
            this.pos += result;
        }
        return result;
    }

    public final void skipFully(long len) throws IOException {
        long remaining = len;
        while (remaining > 0L) {
            long count = this.skip(remaining);
            if (count <= 0L) {
                throw new EOFException();
            }
            remaining -= count;
        }
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public int readHeader() throws IOException {
        this.tagpos = this.pos;
        this.readFully(this.header, 0, 8);
        int n = this.tag = this.ts.bigEndian() ? ByteUtils.bytesBE2tag(this.header, 0) : ByteUtils.bytesLE2tag(this.header, 0);
        if (this.expectFmiEnd && !TagUtils.isFileMetaInfoElement(this.tag)) {
            log.warn("Missing or wrong (0002,0000) Group Length of File Meta Information");
            String tsuid = this.attrs.getString(131088);
            if (tsuid != null) {
                this.ts = TransferSyntax.valueOf(tsuid);
                this.tag = this.ts.bigEndian() ? ByteUtils.bytesBE2tag(this.header, 0) : ByteUtils.bytesLE2tag(this.header, 0);
            } else {
                log.warn("Missing (0002,0010) Transfer Synatx in File Meta Information");
            }
            this.expectFmiEnd = false;
        }
        this.vr = null;
        if (TagUtils.hasVR(this.tag) && this.ts.explicitVR()) {
            try {
                this.vr = VR.valueOf((this.header[4] & 0xFF) << 8 | this.header[5] & 0xFF);
            }
            catch (IllegalArgumentException e) {
                this.vr = this.attrs.vrOf(this.tag);
                log.warn("Catch " + e + " for attribute " + TagUtils.toString(this.tag) + " at pos: " + this.tagpos + " - assume " + this.vr);
            }
            if (this.vr.explicitVRHeaderLength() == 8) {
                int n2 = this.vallen = this.ts.bigEndian() ? ByteUtils.bytesBE2ushort(this.header, 6) : ByteUtils.bytesLE2ushort(this.header, 6);
                if (this.vr == VR.UN_SIEMENS) {
                    if (log.isInfoEnabled()) {
                        log.info("Replace invalid VR '??' of " + TagUtils.toString(this.tag) + " by 'UN'");
                    }
                    this.vr = VR.UN;
                }
                return this.tag;
            }
            this.readFully(this.header, 4, 4);
        }
        this.vallen = this.ts.bigEndian() ? ByteUtils.bytesBE2int(this.header, 4) : ByteUtils.bytesLE2int(this.header, 4);
        return this.tag;
    }

    public void readItem(DicomObject dest) throws IOException {
        dest.setItemOffset(this.pos);
        if (this.readHeader() != -73728) {
            throw new DicomCodingException("Expected (FFFE,E000) but read " + TagUtils.toString(this.tag));
        }
        this.readDicomObject(dest, this.vallen);
    }

    public void readDicomObject(DicomObject dest, int len) throws IOException {
        DicomObject oldAttrs = this.attrs;
        this.attrs = dest;
        try {
            this.parse(len, -73715);
        }
        finally {
            this.attrs = oldAttrs;
        }
    }

    public DicomObject readDicomObject() throws IOException {
        BasicDicomObject dest = new BasicDicomObject();
        this.readDicomObject(dest, -1);
        return dest;
    }

    public void readFileMetaInformation(DicomObject dest) throws IOException {
        if (!this.expectFmiEnd) {
            return;
        }
        this.stopAtFmiEnd = true;
        try {
            this.readDicomObject(dest, -1);
        }
        finally {
            this.stopAtFmiEnd = false;
        }
    }

    public DicomObject readFileMetaInformation() throws IOException {
        if (!this.expectFmiEnd) {
            return null;
        }
        BasicDicomObject dest = new BasicDicomObject();
        this.readFileMetaInformation(dest);
        return dest;
    }

    private void parse(int len, int endTag) throws IOException {
        long endPos = len == -1 ? Long.MAX_VALUE : this.pos + ((long)len & 0xFFFFFFFFL);
        boolean quit = false;
        int tag0 = 0;
        while (!quit && tag0 != endTag && this.pos < endPos) {
            this.mark(12);
            try {
                tag0 = this.readHeader();
            }
            catch (EOFException e) {
                if (len != -1) {
                    throw e;
                }
                if (endTag == -73507) {
                    log.warn("Unexpected EOF - treat as (FFFE,E0DD) Sequence Delimitation Item");
                    this.tag = -73507;
                    tag0 = -73507;
                } else {
                    this.tag = -73715;
                    tag0 = -73715;
                }
                this.vr = null;
                this.vallen = 0;
            }
            if (this.stopAtFmiEnd && !this.expectFmiEnd) {
                this.reset();
                return;
            }
            TransferSyntax prevTs = this.ts;
            if (TagUtils.hasVR(this.tag) && (this.vr == null || this.vr == VR.UN)) {
                this.ts = TransferSyntax.ImplicitVRLittleEndian;
                this.vr = this.attrs.vrOf(this.tag);
            }
            quit = !this.handler.readValue(this);
            this.ts = prevTs;
            if (!this.expectFmiEnd || this.pos != this.fmiEndPos) continue;
            String tsuid = this.attrs.getString(131088);
            if (tsuid != null) {
                this.switchTransferSyntax(TransferSyntax.valueOf(tsuid));
            } else {
                log.warn("Missing (0002,0010) Transfer Syntax in File Meta Information");
            }
            this.expectFmiEnd = false;
            if (!this.stopAtFmiEnd) continue;
            return;
        }
    }

    private void switchTransferSyntax(TransferSyntax ts) throws IOException {
        if (this.ts != null && this.ts.deflated()) {
            throw new IllegalStateException("Cannot switch back from Deflated TS");
        }
        if (ts.deflated()) {
            if (this.hasZLIBHeader()) {
                log.warn("Deflated DICOM Stream with ZLIB Header");
                this.in = new InflaterInputStream(this.in);
            } else {
                this.in = new InflaterInputStream(this.in, new Inflater(true));
            }
        }
        this.ts = ts;
    }

    private boolean hasZLIBHeader() throws IOException {
        if (!this.markSupported()) {
            return false;
        }
        byte[] buf = this.header;
        this.mark(2);
        this.read(buf, 0, 2);
        this.reset();
        return ((buf[0] & 0xFF) << 8 | buf[1] & 0xFF) == 30876;
    }

    @Override
    public boolean readValue(DicomInputStream dis) throws IOException {
        if (dis != this) {
            throw new IllegalArgumentException("dis != this");
        }
        switch (this.tag) {
            case -73728: {
                this.readItemValue();
                break;
            }
            case -73715: {
                if (this.vallen <= 0) break;
                log.warn("Item Delimitation Item (FFFE,E00D) with non-zero Item Length:" + this.vallen + " at pos: " + this.tagpos + " - try to skip length");
                this.skip(this.vallen);
                break;
            }
            case -73507: {
                if (this.vallen <= 0) break;
                log.warn("Sequence Delimitation Item (FFFE,E0DD) with non-zero Item Length:" + this.vallen + " at pos: " + this.tagpos + " - try to skip length");
                this.skip(this.vallen);
                break;
            }
            default: {
                if (this.vallen == -1 || this.vr == VR.SQ) {
                    DicomElement a = this.vr == VR.SQ ? this.attrs.putSequence(this.tag) : this.attrs.putFragments(this.tag, this.vr, this.ts.bigEndian());
                    this.readItems(a, this.vallen);
                    break;
                }
                DicomElement a = this.attrs.putBytes(this.tag, this.vr, this.readBytes(this.vallen), this.ts.bigEndian());
                if (this.tag != 131072) break;
                this.fmiEndPos = this.pos + (long)a.getInt(false);
            }
        }
        return true;
    }

    public void readItems(DicomElement sq, int sqlen) throws IOException {
        if (this.sqStack == null) {
            this.sqStack = new ArrayList();
        }
        this.sqStack.add(sq);
        try {
            this.parse(sqlen, -73507);
        }
        finally {
            this.sqStack.remove(this.sqStack.size() - 1);
        }
    }

    private void readItemValue() throws IOException, DicomCodingException {
        DicomElement sq = this.sqStack.get(this.sqStack.size() - 1);
        if (this.vallen == -1) {
            if (sq.vr() == VR.UN) {
                DicomElement tmp = this.attrs.putSequence(sq.tag());
                int i = 0;
                int n = sq.countItems();
                while (i < n) {
                    byte[] b = sq.getFragment(i);
                    ByteArrayInputStream is = new ByteArrayInputStream(b);
                    DicomInputStream dis1 = new DicomInputStream((InputStream)is, TransferSyntax.ImplicitVRLittleEndian);
                    BasicDicomObject item = new BasicDicomObject();
                    dis1.readDicomObject(item, b.length);
                    tmp.addDicomObject(item);
                    ++i;
                }
                sq = tmp;
                this.sqStack.set(this.sqStack.size() - 1, sq);
            }
            if (sq.vr() != VR.SQ) {
                throw new DicomCodingException(String.valueOf(TagUtils.toString(this.tag)) + " " + sq.vr() + " contains item with unknown length.");
            }
        }
        if (sq.vr() == VR.SQ) {
            BasicDicomObject item = new BasicDicomObject();
            item.setParent(this.attrs);
            item.setItemOffset(this.tagpos);
            this.readDicomObject(item, this.vallen);
            sq.addDicomObject(item);
        } else {
            sq.addFragment(this.readBytes(this.vallen));
        }
    }

    public byte[] readBytes(int vallen) throws IOException {
        if (vallen == 0) {
            return EMPTY_BYTES;
        }
        byte[] val = new byte[vallen];
        this.readFully(val, 0, vallen);
        return val;
    }
}

