/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.Tag;
import org.dcm4che2.util.ByteUtils;
import org.dcm4che2.util.DateUtils;
import org.dcm4che2.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class VR {
    private static final Logger LOG = LoggerFactory.getLogger(VR.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final Date[] EMPTY_DATE_ARRAY = new Date[0];
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final VR UN_SIEMENS = new UN_SIEMENS();
    public static final VR AE = new AE();
    public static final VR AS = new AS();
    public static final VR AT = new AT();
    public static final VR CS = new CS();
    public static final VR DA = new DA();
    public static final VR DS = new DS();
    public static final VR DT = new DT();
    public static final VR FL = new FL();
    public static final VR FD = new FD();
    public static final VR IS = new IS();
    public static final VR LO = new LO();
    public static final VR LT = new LT();
    public static final VR OB = new OB();
    public static final VR OF = new OF();
    public static final VR OW = new OW();
    public static final VR PN = new PN();
    public static final VR SH = new SH();
    public static final VR SL = new SL();
    public static final VR SQ = new SQ();
    public static final VR SS = new SS();
    public static final VR ST = new ST();
    public static final VR TM = new TM();
    public static final VR UI = new UI();
    public static final VR UL = new UL();
    public static final VR UN = new UN();
    public static final VR US = new US();
    public static final VR UT = new UT();
    protected final int code;
    protected final int headerLength;
    protected final int padding;

    private static byte[] str2bytes(String val, SpecificCharacterSet cs) {
        return val == null ? null : (cs == null ? val.getBytes() : cs.encode(val));
    }

    private static String bytes2str(byte[] val, SpecificCharacterSet cs) {
        return val == null ? null : (cs == null ? new String(val) : cs.decode(val));
    }

    private static byte[] strs2bytes(String[] val, SpecificCharacterSet cs) {
        return VR.str2bytes(StringUtils.join(val, '\\'), cs);
    }

    private static String[] bytes2strs(byte[] val, SpecificCharacterSet cs) {
        return StringUtils.split(VR.bytes2str(val, cs), '\\');
    }

    private static String bytes2str1(byte[] val, SpecificCharacterSet cs) {
        return StringUtils.first(VR.bytes2str(val, cs), '\\');
    }

    private static byte[] parseShortXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last) {
        int end;
        if (sb.length() == 0) {
            return null;
        }
        int begin = 0;
        while ((end = sb.indexOf("\\", begin)) != -1) {
            VR.outShortLE(out, Integer.parseInt(sb.substring(begin, end)));
            begin = end + 1;
        }
        String remain = sb.substring(begin);
        sb.setLength(0);
        if (!last) {
            sb.append(remain);
            return null;
        }
        VR.outShortLE(out, Integer.parseInt(remain));
        return out.toByteArray();
    }

    private static void ushort2chars(byte[] val, boolean bigEndian, char[] cbuf, int maxLen, CharOut out) {
        if (val == null || val.length == 0) {
            return;
        }
        int cpos = 0;
        int clen = 0;
        int i = 0;
        while (i + 2 <= val.length) {
            if (clen + 8 >= cbuf.length) {
                out.write(cbuf, 0, clen);
                clen = 0;
            }
            if (i != 0) {
                cbuf[clen++] = 92;
                ++cpos;
            }
            if (maxLen > 0 && cpos + 8 > maxLen) {
                cbuf[clen++] = 46;
                cbuf[clen++] = 46;
                cbuf[clen++] = 46;
                break;
            }
            String s = Integer.toString(bigEndian ? ByteUtils.bytesBE2ushort(val, i) : ByteUtils.bytesLE2ushort(val, i));
            int sl = s.length();
            s.getChars(0, sl, cbuf, clen);
            clen += sl;
            cpos += sl;
            i += 2;
        }
        if (clen > 0) {
            out.write(cbuf, 0, clen);
        }
    }

    private static byte[] parseFloatXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last) {
        int end;
        if (sb.length() == 0) {
            return null;
        }
        int begin = 0;
        while ((end = sb.indexOf("\\", begin)) != -1) {
            VR.outIntLE(out, Float.floatToIntBits(Float.parseFloat(sb.substring(begin, end))));
            begin = end + 1;
        }
        String remain = sb.substring(begin);
        sb.setLength(0);
        if (!last) {
            sb.append(remain);
            return null;
        }
        VR.outIntLE(out, Float.floatToIntBits(Float.parseFloat(remain)));
        return out.toByteArray();
    }

    public static void float2chars(byte[] b, boolean bigEndian, CharOut ch, char[] cbuf, int maxLen) {
        if (b == null || b.length == 0) {
            return;
        }
        int cpos = 0;
        int clen = 0;
        int i = 0;
        while (i + 4 <= b.length) {
            if (clen + 16 >= cbuf.length) {
                ch.write(cbuf, 0, clen);
                clen = 0;
            }
            if (i != 0) {
                cbuf[clen++] = 92;
                ++cpos;
            }
            if (maxLen > 0 && cpos + 16 > maxLen) {
                cbuf[clen++] = 46;
                cbuf[clen++] = 46;
                cbuf[clen++] = 46;
                break;
            }
            String s = Float.toString(bigEndian ? ByteUtils.bytesBE2float(b, i) : ByteUtils.bytesLE2float(b, i));
            int sl = s.length();
            s.getChars(0, sl, cbuf, clen);
            clen += sl;
            cpos += sl;
            i += 4;
        }
        if (clen > 0) {
            ch.write(cbuf, 0, clen);
        }
    }

    private static void outShortLE(ByteArrayOutputStream out, int val) {
        out.write(val);
        out.write(val >> 8);
    }

    private static void outIntLE(ByteArrayOutputStream out, int val) {
        out.write(val);
        out.write(val >> 8);
        out.write(val >> 16);
        out.write(val >> 24);
    }

    private static void outLongLE(ByteArrayOutputStream out, long val) {
        out.write((int)val);
        out.write((int)(val >> 8));
        out.write((int)(val >> 16));
        out.write((int)(val >> 24));
        out.write((int)(val >> 32));
        out.write((int)(val >> 40));
        out.write((int)(val >> 48));
        out.write((int)(val >> 56));
    }

    private static int parseIS(String val) {
        return (int)Long.parseLong(val.startsWith("+") ? val.substring(1) : val);
    }

    public static VR valueOf(int code) {
        switch (code) {
            case 16191: {
                return UN_SIEMENS;
            }
            case 16709: {
                return AE;
            }
            case 16723: {
                return AS;
            }
            case 16724: {
                return AT;
            }
            case 17235: {
                return CS;
            }
            case 17473: {
                return DA;
            }
            case 17491: {
                return DS;
            }
            case 17492: {
                return DT;
            }
            case 17988: {
                return FD;
            }
            case 17996: {
                return FL;
            }
            case 18771: {
                return IS;
            }
            case 19535: {
                return LO;
            }
            case 19540: {
                return LT;
            }
            case 20290: {
                return OB;
            }
            case 20294: {
                return OF;
            }
            case 20311: {
                return OW;
            }
            case 20558: {
                return PN;
            }
            case 21320: {
                return SH;
            }
            case 21324: {
                return SL;
            }
            case 21329: {
                return SQ;
            }
            case 21331: {
                return SS;
            }
            case 21332: {
                return ST;
            }
            case 21581: {
                return TM;
            }
            case 21833: {
                return UI;
            }
            case 21836: {
                return UL;
            }
            case 21838: {
                return UN;
            }
            case 21843: {
                return US;
            }
            case 21844: {
                return UT;
            }
        }
        throw new IllegalArgumentException("vr:" + StringUtils.shortToHex(code));
    }

    private VR(int code, int padding, int headerLength) {
        this.code = code;
        this.padding = padding;
        this.headerLength = headerLength;
    }

    public final String toString() {
        return new String(new char[]{(char)(this.code >> 8), (char)(this.code & 0xFF)});
    }

    public final int code() {
        return this.code;
    }

    public final int padding() {
        return this.padding;
    }

    public final int explicitVRHeaderLength() {
        return this.headerLength;
    }

    public byte[] toBytes(int val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(int[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(short[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(float val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(float[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(double val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(double[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(Date val) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(Date[] val) {
        throw new UnsupportedOperationException();
    }

    public byte[] toBytes(DateRange val) {
        throw new UnsupportedOperationException();
    }

    public short[] toShorts(byte[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public int toInt(byte[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public int[] toInts(byte[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public float toFloat(byte[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public float[] toFloats(byte[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public double toDouble(byte[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public double[] toDoubles(byte[] val, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
        throw new UnsupportedOperationException();
    }

    public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
        throw new UnsupportedOperationException();
    }

    public Date toDate(byte[] val) {
        throw new UnsupportedOperationException();
    }

    public Date[] toDates(byte[] val) {
        throw new UnsupportedOperationException();
    }

    public DateRange toDateRange(byte[] val) {
        throw new UnsupportedOperationException();
    }

    public Pattern toPattern(byte[] bs, boolean bigEndian, SpecificCharacterSet cs, boolean ignoreCase) {
        String s = this.toString(bs, bigEndian, cs);
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s.length() + 10);
        StringTokenizer stk = new StringTokenizer(s, "*?", true);
        while (stk.hasMoreTokens()) {
            String tk = stk.nextToken();
            char c = tk.charAt(0);
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (c == '?') {
                sb.append(".");
                continue;
            }
            sb.append("\\Q").append(tk).append("\\E");
        }
        return Pattern.compile(sb.toString(), ignoreCase ? 66 : 0);
    }

    protected void toChars(byte[] bs, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
        int sl;
        if (bs == null || bs.length == 0) {
            return;
        }
        String s = StringUtils.trim(VR.bytes2str(bs, cs));
        int eclipsePos = sl = s.length();
        if (maxLen > 0 && sl > maxLen) {
            sl = maxLen;
            eclipsePos = maxLen - 3;
        }
        int pos = 0;
        while (pos < sl) {
            int l = Math.min(cbuf.length, sl - pos);
            s.getChars(pos, pos + l, cbuf, 0);
            pos += l;
            while (eclipsePos < pos) {
                cbuf[l - pos + eclipsePos++] = 46;
            }
            out.write(cbuf, 0, l);
        }
    }

    public void formatXMLValue(byte[] bs, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, final ContentHandler out) throws SAXException {
        try {
            this.toChars(bs, bigEndian, cs, cbuf, -1, new CharOut(){

                @Override
                public void write(char[] ch, int start, int length) {
                    try {
                        out.characters(ch, start, length);
                    }
                    catch (SAXException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw e;
        }
    }

    public void promptValue(byte[] bs, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, final StringBuffer out) {
        this.toChars(bs, bigEndian, cs, cbuf, maxLen, new CharOut(){

            @Override
            public void write(char[] ch, int start, int length) {
                out.append(ch, start, length);
            }
        });
    }

    public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
        throw new UnsupportedOperationException();
    }

    public int vm(byte[] bs, SpecificCharacterSet cs) {
        return bs == null || bs.length == 0 ? 0 : 1;
    }

    public void toggleEndian(byte[] val) {
        if (val != null) {
            this.toggleEndian(val, 0, val.length);
        }
    }

    public void toggleEndian(byte[] val, int off, int len) {
    }

    public boolean isSingleValue(String val) {
        return val != null && val.length() != 0 && val.indexOf(92) == -1;
    }

    public boolean containsSingleValues(String[] vals) {
        if (vals == null) {
            return false;
        }
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (!this.isSingleValue(val)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /* synthetic */ VR(int n, int n2, int n3, VR vR) {
        this(n, n2, n3);
    }

    private static final class AE
    extends ASCIIVR {
        private AE() {
            super(16709, 32, 8);
        }
    }

    private static final class AS
    extends ASCIIVR {
        private AS() {
            super(16723, 32, 8);
        }
    }

    private static class ASCIIVR
    extends VR {
        private ASCIIVR(int code, int padding, int valueLengthBytes) {
            super(code, padding, valueLengthBytes, null);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return VR.str2bytes(val, null);
        }

        @Override
        public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return VR.strs2bytes(val, null);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.trim(VR.bytes2str1(val, null));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return EMPTY_STRING_ARRAY;
            }
            return StringUtils.trim(VR.bytes2strs(val, null));
        }

        @Override
        public int vm(byte[] val, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return StringUtils.count(VR.bytes2str(val, null), '\\') + 1;
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            return last ? VR.str2bytes(sb.toString(), null) : null;
        }
    }

    private static final class AT
    extends VR {
        private AT() {
            super(16724, 0, 8, null);
        }

        @Override
        public byte[] toBytes(int val, boolean bigEndian) {
            byte[] b = new byte[4];
            return bigEndian ? ByteUtils.tag2bytesBE(val, b, 0) : ByteUtils.tag2bytesLE(val, b, 0);
        }

        @Override
        public byte[] toBytes(int[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.tags2bytesBE(val) : ByteUtils.tags2bytesLE(val);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return this.toBytes(StringUtils.split(val, '\\'), bigEndian, cs);
        }

        @Override
        public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
            int[] t = new int[val.length];
            int i = 0;
            while (i < val.length) {
                t[i] = Tag.toTag(val[i]);
                ++i;
            }
            return this.toBytes(t, bigEndian);
        }

        @Override
        public int toInt(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return bigEndian ? ByteUtils.bytesBE2tag(val, 0) : ByteUtils.bytesLE2tag(val, 0);
        }

        @Override
        public int[] toInts(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_INT_ARRAY;
            }
            return bigEndian ? ByteUtils.bytesBE2tags(val) : ByteUtils.bytesLE2tags(val);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return StringUtils.intToHex(this.toInt(val, bigEndian));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            int[] ints = this.toInts(val, bigEndian);
            return StringUtils.intsToHex(ints);
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            if (val == null || val.length == 0) {
                return;
            }
            int b1 = bigEndian ? 0 : 1;
            int b2 = 1 - b1;
            int b3 = 2 + b1;
            int b4 = 2 + b2;
            int cpos = 0;
            int clen = 0;
            int i = 0;
            while (i + 4 <= val.length) {
                if (clen + 9 >= cbuf.length) {
                    out.write(cbuf, 0, clen);
                    clen = 0;
                }
                if (i != 0) {
                    cbuf[clen++] = 92;
                    ++cpos;
                }
                if (maxLen > 0 && cpos + 9 > maxLen) {
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    break;
                }
                cbuf[clen++] = HEX_DIGITS[val[i + b1] >> 4 & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i + b1] & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i + b2] >> 4 & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i + b2] & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i + b3] >> 4 & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i + b3] & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i + b4] >> 4 & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i + b4] & 0xF];
                cpos += 8;
                i += 4;
            }
            if (clen > 0) {
                out.write(cbuf, 0, clen);
            }
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            int end;
            if (sb.length() == 0) {
                return last ? out.toByteArray() : null;
            }
            int begin = 0;
            while ((end = sb.indexOf("\\", begin)) != -1) {
                VR.outShortLE(out, Integer.parseInt(sb.substring(begin, begin + 4), 16));
                VR.outShortLE(out, Integer.parseInt(sb.substring(begin + 4, begin + 8), 16));
                begin = end + 1;
            }
            String remain = sb.substring(begin);
            sb.setLength(0);
            if (!last) {
                sb.append(remain);
                return null;
            }
            VR.outShortLE(out, Integer.parseInt(remain.substring(0, 4), 16));
            VR.outShortLE(out, Integer.parseInt(remain.substring(4), 16));
            return out.toByteArray();
        }

        @Override
        public int vm(byte[] val, SpecificCharacterSet cs) {
            return val == null ? 0 : val.length / 4;
        }

        @Override
        public void toggleEndian(byte[] val, int off, int len) {
            ByteUtils.toggleShortEndian(val, off, len);
        }
    }

    private static final class CS
    extends ASCIIVR {
        private CS() {
            super(17235, 32, 8);
        }
    }

    protected static interface CharOut {
        public void write(char[] var1, int var2, int var3);
    }

    private static final class DA
    extends ASCIIVR {
        private DA() {
            super(17473, 32, 8);
        }

        @Override
        public byte[] toBytes(Date d) {
            return VR.str2bytes(DateUtils.formatDA(d), null);
        }

        @Override
        public byte[] toBytes(Date[] d) {
            if (d == null || d.length == 0) {
                return null;
            }
            String[] ss = new String[d.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = DateUtils.formatDA(d[i]);
                ++i;
            }
            return VR.strs2bytes(ss, null);
        }

        @Override
        public byte[] toBytes(DateRange dr) {
            if (dr == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer(9);
            if (dr.getStart() != null) {
                sb.append(DateUtils.formatDA(dr.getStart()));
            }
            sb.append("-");
            if (dr.getEnd() != null) {
                sb.append(DateUtils.formatDA(dr.getEnd()));
            }
            return VR.str2bytes(sb.toString(), null);
        }

        @Override
        public Date toDate(byte[] val) {
            return DateUtils.parseDA(StringUtils.trim(VR.bytes2str1(val, null)), false);
        }

        @Override
        public Date[] toDates(byte[] val) {
            if (val == null || val.length == 0) {
                return EMPTY_DATE_ARRAY;
            }
            String[] ss = StringUtils.trim(VR.bytes2strs(val, null));
            Date[] ds = new Date[ss.length];
            int i = 0;
            while (i < ds.length) {
                ds[i] = DateUtils.parseDA(ss[i], false);
                ++i;
            }
            return ds;
        }

        @Override
        public DateRange toDateRange(byte[] val) {
            int l;
            String s = StringUtils.trim(VR.bytes2str1(val, null));
            if (s == null || (l = s.length()) == 0 || s.equals("-")) {
                return null;
            }
            int hypen = s.indexOf(45);
            Date start = hypen == 0 ? null : DateUtils.parseDA(hypen == -1 ? s : s.substring(0, hypen), false);
            Date end = hypen + 1 == l ? null : DateUtils.parseDA(s.substring(hypen + 1), true);
            return new DateRange(start, end);
        }
    }

    private static final class DS
    extends ASCIIVR {
        private DS() {
            super(17491, 32, 8);
        }

        @Override
        public byte[] toBytes(float val, boolean bigEndian) {
            return this.toBytes(this.toDS(val), bigEndian, null);
        }

        @Override
        public byte[] toBytes(double val, boolean bigEndian) {
            return this.toBytes(this.toDS(val), bigEndian, null);
        }

        private String toDS(double val) {
            String s = Double.toString(val);
            int skip = s.length() - 16;
            if (skip > 0) {
                int e = s.lastIndexOf(69);
                return e < 0 ? s.substring(0, 16) : String.valueOf(s.substring(0, e - skip)) + s.substring(e);
            }
            return s;
        }

        @Override
        public byte[] toBytes(float[] val, boolean bigEndian) {
            if (val == null) {
                return null;
            }
            String[] ss = new String[val.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = this.toDS(val[i]);
                ++i;
            }
            return this.toBytes(ss, bigEndian, null);
        }

        @Override
        public byte[] toBytes(double[] val, boolean bigEndian) {
            if (val == null) {
                return null;
            }
            String[] ss = new String[val.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = this.toDS(val[i]);
                ++i;
            }
            return this.toBytes(ss, bigEndian, null);
        }

        @Override
        public float toFloat(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0.0f;
            }
            return Float.parseFloat(org.dcm4che2.data.VR$DS.commaToPeriod(this.toString(val, bigEndian, null)));
        }

        @Override
        public float[] toFloats(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_FLOAT_ARRAY;
            }
            String[] ss = this.toStrings(val, bigEndian, null);
            float[] fs = new float[ss.length];
            int i = 0;
            while (i < fs.length) {
                if (ss[i].length() > 0) {
                    fs[i] = Float.parseFloat(org.dcm4che2.data.VR$DS.commaToPeriod(ss[i]));
                }
                ++i;
            }
            return fs;
        }

        @Override
        public double toDouble(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0.0;
            }
            return Double.parseDouble(org.dcm4che2.data.VR$DS.commaToPeriod(this.toString(val, bigEndian, null)));
        }

        @Override
        public double[] toDoubles(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_DOUBLE_ARRAY;
            }
            String[] ss = this.toStrings(val, bigEndian, null);
            double[] fs = new double[ss.length];
            int i = 0;
            while (i < fs.length) {
                if (ss[i].length() > 0) {
                    fs[i] = Double.parseDouble(org.dcm4che2.data.VR$DS.commaToPeriod(ss[i]));
                }
                ++i;
            }
            return fs;
        }

        private static String commaToPeriod(String ds) {
            String s = ds.replace(',', '.');
            if (s != ds) {
                LOG.warn("Illegal DS value: {}", (Object)ds);
            }
            return s;
        }
    }

    private static final class DT
    extends ASCIIVR {
        private DT() {
            super(17492, 32, 8);
        }

        @Override
        public byte[] toBytes(Date d) {
            return VR.str2bytes(DateUtils.formatDT(d), null);
        }

        @Override
        public byte[] toBytes(Date[] d) {
            if (d == null || d.length == 0) {
                return null;
            }
            String[] ss = new String[d.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = DateUtils.formatDT(d[i]);
                ++i;
            }
            return VR.strs2bytes(ss, null);
        }

        @Override
        public byte[] toBytes(DateRange dr) {
            if (dr == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer(36);
            if (dr.getStart() != null) {
                sb.append(DateUtils.formatDT(dr.getStart()));
            }
            sb.append("-");
            if (dr.getEnd() != null) {
                sb.append(DateUtils.formatDT(dr.getEnd()));
            }
            return VR.str2bytes(sb.toString(), null);
        }

        @Override
        public Date toDate(byte[] val) {
            return DateUtils.parseDT(StringUtils.trim(VR.bytes2str1(val, null)), false);
        }

        @Override
        public Date[] toDates(byte[] val) {
            if (val == null || val.length == 0) {
                return EMPTY_DATE_ARRAY;
            }
            String[] ss = StringUtils.trim(VR.bytes2strs(val, null));
            Date[] ds = new Date[ss.length];
            int i = 0;
            while (i < ds.length) {
                ds[i] = DateUtils.parseDT(ss[i], false);
                ++i;
            }
            return ds;
        }

        @Override
        public DateRange toDateRange(byte[] val) {
            int l;
            String s = StringUtils.trim(VR.bytes2str1(val, null));
            if (s == null || (l = s.length()) == 0 || s.equals("-")) {
                return null;
            }
            int hypen = s.indexOf(45);
            Date start = hypen == 0 ? null : DateUtils.parseDT(hypen == -1 ? s : s.substring(0, hypen), false);
            Date end = hypen + 1 == l ? null : DateUtils.parseDT(s.substring(hypen + 1), true);
            return new DateRange(start, end);
        }
    }

    private static final class FD
    extends VR {
        private FD() {
            super(17988, 0, 8, null);
        }

        @Override
        public byte[] toBytes(double val, boolean bigEndian) {
            byte[] b = new byte[8];
            return bigEndian ? ByteUtils.double2bytesBE(val, b, 0) : ByteUtils.double2bytesLE(val, b, 0);
        }

        @Override
        public byte[] toBytes(double[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.doubles2bytesBE(val) : ByteUtils.doubles2bytesLE(val);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return this.toBytes(StringUtils.split(val, '\\'), bigEndian, cs);
        }

        @Override
        public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
            double[] t = new double[val.length];
            int i = 0;
            while (i < val.length) {
                t[i] = Double.parseDouble(val[i]);
                ++i;
            }
            return this.toBytes(t, bigEndian);
        }

        @Override
        public double toDouble(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0.0;
            }
            return bigEndian ? ByteUtils.bytesBE2double(val, 0) : ByteUtils.bytesLE2double(val, 0);
        }

        @Override
        public double[] toDoubles(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_DOUBLE_ARRAY;
            }
            return bigEndian ? ByteUtils.bytesBE2doubles(val) : ByteUtils.bytesLE2doubles(val);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return Double.toString(this.toDouble(val, bigEndian));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.doubles2strs(this.toDoubles(val, bigEndian));
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            if (val == null || val.length == 0) {
                return;
            }
            int cpos = 0;
            int clen = 0;
            int i = 0;
            while (i + 8 <= val.length) {
                if (clen + 26 >= cbuf.length) {
                    out.write(cbuf, 0, clen);
                    clen = 0;
                }
                if (i != 0) {
                    cbuf[clen++] = 92;
                    ++cpos;
                }
                if (maxLen > 0 && cpos + 26 > maxLen) {
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    break;
                }
                String s = Double.toString(bigEndian ? ByteUtils.bytesBE2double(val, i) : ByteUtils.bytesLE2double(val, i));
                int sl = s.length();
                s.getChars(0, sl, cbuf, clen);
                clen += sl;
                cpos += sl;
                i += 8;
            }
            if (clen > 0) {
                out.write(cbuf, 0, clen);
            }
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            int end;
            if (sb.length() == 0) {
                return last ? out.toByteArray() : null;
            }
            int begin = 0;
            while ((end = sb.indexOf("\\", begin)) != -1) {
                VR.outLongLE(out, Double.doubleToLongBits(Double.parseDouble(sb.substring(begin, end))));
                begin = end + 1;
            }
            String remain = sb.substring(begin);
            sb.setLength(0);
            if (!last) {
                sb.append(remain);
                return null;
            }
            VR.outLongLE(out, Double.doubleToLongBits(Double.parseDouble(remain)));
            return out.toByteArray();
        }

        @Override
        public int vm(byte[] val, SpecificCharacterSet cs) {
            return val == null ? 0 : val.length / 8;
        }

        @Override
        public void toggleEndian(byte[] b, int off, int len) {
            ByteUtils.toggleLongEndian(b, off, len);
        }
    }

    private static final class FL
    extends VR {
        private FL() {
            super(17996, 0, 8, null);
        }

        @Override
        public byte[] toBytes(float val, boolean bigEndian) {
            byte[] b = new byte[4];
            return bigEndian ? ByteUtils.float2bytesBE(val, b, 0) : ByteUtils.float2bytesLE(val, b, 0);
        }

        @Override
        public byte[] toBytes(float[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.floats2bytesBE(val) : ByteUtils.floats2bytesLE(val);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return this.toBytes(StringUtils.split(val, '\\'), bigEndian, cs);
        }

        @Override
        public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
            float[] t = new float[val.length];
            int i = 0;
            while (i < val.length) {
                t[i] = Float.parseFloat(val[i]);
                ++i;
            }
            return this.toBytes(t, bigEndian);
        }

        @Override
        public float toFloat(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0.0f;
            }
            return bigEndian ? ByteUtils.bytesBE2float(val, 0) : ByteUtils.bytesLE2float(val, 0);
        }

        @Override
        public float[] toFloats(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_FLOAT_ARRAY;
            }
            return bigEndian ? ByteUtils.bytesBE2floats(val) : ByteUtils.bytesLE2floats(val);
        }

        @Override
        public double toDouble(byte[] val, boolean bigEndian) {
            return this.toFloat(val, bigEndian);
        }

        @Override
        public double[] toDoubles(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_DOUBLE_ARRAY;
            }
            return bigEndian ? ByteUtils.bytesBE2floats2doubles(val) : ByteUtils.bytesLE2floats2doubles(val);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return Float.toString(this.toFloat(val, bigEndian));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.floats2strs(this.toFloats(val, bigEndian));
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            VR.float2chars(val, bigEndian, out, cbuf, maxLen);
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            return VR.parseFloatXMLValue(sb, out, last);
        }

        @Override
        public int vm(byte[] val, SpecificCharacterSet cs) {
            return val == null ? 0 : val.length / 4;
        }

        @Override
        public void toggleEndian(byte[] b, int off, int len) {
            ByteUtils.toggleIntEndian(b, off, len);
        }
    }

    public static interface Fragment {
    }

    private static final class IS
    extends ASCIIVR {
        private IS() {
            super(18771, 32, 8);
        }

        @Override
        public byte[] toBytes(int val, boolean bigEndian) {
            return this.toBytes(String.valueOf(val), bigEndian, null);
        }

        @Override
        public byte[] toBytes(int[] val, boolean bigEndian) {
            if (val == null) {
                return null;
            }
            String[] ss = new String[val.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = Integer.toString(val[i]);
                ++i;
            }
            return this.toBytes(ss, bigEndian, null);
        }

        @Override
        public int toInt(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return VR.parseIS(this.toString(val, bigEndian, null));
        }

        @Override
        public int[] toInts(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_INT_ARRAY;
            }
            String[] ss = this.toStrings(val, bigEndian, null);
            int[] is = new int[ss.length];
            int i = 0;
            while (i < is.length) {
                if (ss[i].length() > 0) {
                    is[i] = VR.parseIS(ss[i]);
                }
                ++i;
            }
            return is;
        }
    }

    private static class IntVR
    extends VR {
        private IntVR(int code, int padding, int valueLengthBytes) {
            super(code, padding, valueLengthBytes, null);
        }

        @Override
        public byte[] toBytes(int val, boolean bigEndian) {
            byte[] b = new byte[4];
            return bigEndian ? ByteUtils.int2bytesBE(val, b, 0) : ByteUtils.int2bytesLE(val, b, 0);
        }

        @Override
        public byte[] toBytes(int[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.ints2bytesBE(val) : ByteUtils.ints2bytesLE(val);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return this.toBytes(StringUtils.split(val, '\\'), bigEndian, cs);
        }

        @Override
        public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
            int[] t = new int[val.length];
            int i = 0;
            while (i < val.length) {
                t[i] = VR.parseIS(val[i]);
                ++i;
            }
            return this.toBytes(t, bigEndian);
        }

        @Override
        public int toInt(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return bigEndian ? ByteUtils.bytesBE2int(val, 0) : ByteUtils.bytesLE2int(val, 0);
        }

        @Override
        public int[] toInts(byte[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.bytesBE2ints(val) : ByteUtils.bytesLE2ints(val);
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            int end;
            if (sb.length() == 0) {
                return last ? out.toByteArray() : null;
            }
            int begin = 0;
            while ((end = sb.indexOf("\\", begin)) != -1) {
                VR.outIntLE(out, VR.parseIS(sb.substring(begin, end)));
                begin = end + 1;
            }
            String remain = sb.substring(begin);
            sb.setLength(0);
            if (!last) {
                sb.append(remain);
                return null;
            }
            VR.outIntLE(out, VR.parseIS(remain));
            return out.toByteArray();
        }

        @Override
        public int vm(byte[] val, SpecificCharacterSet cs) {
            return val == null ? 0 : val.length / 4;
        }

        @Override
        public void toggleEndian(byte[] val, int off, int len) {
            ByteUtils.toggleIntEndian(val, off, len);
        }
    }

    private static final class LO
    extends StringVR {
        private LO() {
            super(19535, 32, 8);
        }
    }

    private static final class LT
    extends TextVR {
        private LT() {
            super(19540, 32, 8);
        }
    }

    private static class OB
    extends VR
    implements Fragment {
        private OB() {
            super(20290, 0, 12, null);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer(val.length * 3 - 1);
            sb.append(HEX_DIGITS[val[0] >> 4 & 0xF]);
            sb.append(HEX_DIGITS[val[0] & 0xF]);
            int i = 1;
            while (i < val.length) {
                sb.append('\\');
                sb.append(HEX_DIGITS[val[i] >> 4 & 0xF]);
                sb.append(HEX_DIGITS[val[i] & 0xF]);
                ++i;
            }
            return sb.toString();
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            if (val == null || val.length == 0) {
                return;
            }
            int cpos = 0;
            int clen = 0;
            int i = 0;
            while (i < val.length) {
                if (clen + 3 >= cbuf.length) {
                    out.write(cbuf, 0, clen);
                    clen = 0;
                }
                if (i != 0) {
                    cbuf[clen++] = 92;
                    ++cpos;
                }
                if (maxLen > 0 && cpos + 3 > maxLen) {
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    break;
                }
                cbuf[clen++] = HEX_DIGITS[val[i] >> 4 & 0xF];
                cbuf[clen++] = HEX_DIGITS[val[i] & 0xF];
                ++cpos;
                ++cpos;
                ++i;
            }
            if (clen > 0) {
                out.write(cbuf, 0, clen);
            }
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            int end;
            if (sb.length() == 0) {
                return last ? out.toByteArray() : null;
            }
            int begin = 0;
            while ((end = sb.indexOf("\\", begin)) != -1) {
                out.write(Integer.parseInt(sb.substring(begin, end), 16));
                begin = end + 1;
            }
            String remain = sb.substring(begin);
            sb.setLength(0);
            if (!last) {
                sb.append(remain);
                return null;
            }
            out.write(Integer.parseInt(remain, 16));
            return out.toByteArray();
        }
    }

    private static final class OF
    extends VR
    implements Fragment {
        private OF() {
            super(20294, 0, 12, null);
        }

        @Override
        public byte[] toBytes(float val, boolean bigEndian) {
            byte[] b = new byte[4];
            return bigEndian ? ByteUtils.float2bytesBE(val, b, 0) : ByteUtils.float2bytesLE(val, b, 0);
        }

        @Override
        public byte[] toBytes(float[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.floats2bytesBE(val) : ByteUtils.floats2bytesLE(val);
        }

        @Override
        public float toFloat(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0.0f;
            }
            return bigEndian ? ByteUtils.bytesBE2float(val, 0) : ByteUtils.bytesLE2float(val, 0);
        }

        @Override
        public float[] toFloats(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_FLOAT_ARRAY;
            }
            return bigEndian ? ByteUtils.bytesBE2floats(val) : ByteUtils.bytesLE2floats(val);
        }

        @Override
        public double toDouble(byte[] val, boolean bigEndian) {
            return this.toFloat(val, bigEndian);
        }

        @Override
        public double[] toDoubles(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return EMPTY_DOUBLE_ARRAY;
            }
            return bigEndian ? ByteUtils.bytesBE2floats2doubles(val) : ByteUtils.bytesLE2floats2doubles(val);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return Float.toString(this.toFloat(val, bigEndian));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.floats2strs(this.toFloats(val, bigEndian));
        }

        @Override
        protected void toChars(byte[] bs, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            VR.float2chars(bs, bigEndian, out, cbuf, maxLen);
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            return VR.parseFloatXMLValue(sb, out, last);
        }

        @Override
        public void toggleEndian(byte[] val, int off, int len) {
            ByteUtils.toggleIntEndian(val, off, len);
        }
    }

    private static final class OW
    extends VR
    implements Fragment {
        private OW() {
            super(20311, 0, 12, null);
        }

        @Override
        public byte[] toBytes(int val, boolean bigEndian) {
            byte[] b = new byte[4];
            return bigEndian ? ByteUtils.ushort2bytesBE(val, b, 0) : ByteUtils.ushort2bytesLE(val, b, 0);
        }

        @Override
        public byte[] toBytes(int[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.ushorts2bytesBE(val) : ByteUtils.ushorts2bytesLE(val);
        }

        @Override
        public byte[] toBytes(short[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.shorts2bytesBE(val) : ByteUtils.shorts2bytesLE(val);
        }

        @Override
        public short[] toShorts(byte[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.bytesBE2shorts(val) : ByteUtils.bytesLE2shorts(val);
        }

        @Override
        public int toInt(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return bigEndian ? ByteUtils.bytesBE2ushort(val, 0) : ByteUtils.bytesLE2ushort(val, 0);
        }

        @Override
        public int[] toInts(byte[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.bytesBE2ushorts(val) : ByteUtils.bytesLE2ushorts(val);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return Integer.toString(this.toInt(val, bigEndian));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.ints2strs(this.toInts(val, bigEndian));
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            VR.ushort2chars(val, bigEndian, cbuf, maxLen, out);
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            return VR.parseShortXMLValue(sb, out, last);
        }

        @Override
        public void toggleEndian(byte[] val, int off, int len) {
            ByteUtils.toggleShortEndian(val, off, len);
        }
    }

    private static final class PN
    extends StringVR {
        private PN() {
            super(20558, 32, 8);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.trimPN(VR.bytes2str1(val, cs));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return EMPTY_STRING_ARRAY;
            }
            return StringUtils.trimPN(VR.bytes2strs(val, cs));
        }
    }

    private static final class SH
    extends StringVR {
        private SH() {
            super(21320, 32, 8);
        }
    }

    private static final class SL
    extends IntVR {
        private SL() {
            super(21324, 32, 8);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return Integer.toString(this.toInt(val, bigEndian));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.ints2strs(this.toInts(val, bigEndian));
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            if (val == null || val.length == 0) {
                return;
            }
            int cpos = 0;
            int clen = 0;
            int i = 0;
            while (i + 4 <= val.length) {
                if (clen + 12 >= cbuf.length) {
                    out.write(cbuf, 0, clen);
                    clen = 0;
                }
                if (i != 0) {
                    cbuf[clen++] = 92;
                    ++cpos;
                }
                if (maxLen > 0 && cpos + 12 > maxLen) {
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    break;
                }
                String s = Integer.toString(bigEndian ? ByteUtils.bytesBE2int(val, i) : ByteUtils.bytesLE2int(val, i));
                int sl = s.length();
                s.getChars(0, sl, cbuf, clen);
                clen += sl;
                cpos += sl;
                i += 4;
            }
            if (clen > 0) {
                out.write(cbuf, 0, clen);
            }
        }
    }

    private static final class SQ
    extends VR {
        private SQ() {
            super(21329, 0, 12, null);
        }
    }

    private static final class SS
    extends ShortVR {
        private SS() {
            super(21331, 0, 8);
        }

        @Override
        public int toInt(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return bigEndian ? ByteUtils.bytesBE2sshort(val, 0) : ByteUtils.bytesLE2sshort(val, 0);
        }

        @Override
        public int[] toInts(byte[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.bytesBE2sshorts(val) : ByteUtils.bytesLE2sshorts(val);
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            if (val == null || val.length == 0) {
                return;
            }
            int cpos = 0;
            int clen = 0;
            int i = 0;
            while (i + 2 <= val.length) {
                if (clen + 8 >= cbuf.length) {
                    out.write(cbuf, 0, clen);
                    clen = 0;
                }
                if (i != 0) {
                    cbuf[clen++] = 92;
                    ++cpos;
                }
                if (maxLen > 0 && cpos + 8 > maxLen) {
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    break;
                }
                String s = Integer.toString(bigEndian ? ByteUtils.bytesBE2sshort(val, i) : ByteUtils.bytesLE2sshort(val, i));
                int sl = s.length();
                s.getChars(0, sl, cbuf, clen);
                clen += sl;
                cpos += sl;
                i += 2;
            }
            if (clen > 0) {
                out.write(cbuf, 0, clen);
            }
        }
    }

    private static final class ST
    extends TextVR {
        private ST() {
            super(21332, 32, 8);
        }
    }

    private static class ShortVR
    extends VR {
        private ShortVR(int code, int padding, int valueLengthBytes) {
            super(code, padding, valueLengthBytes, null);
        }

        @Override
        public byte[] toBytes(int val, boolean bigEndian) {
            byte[] b = new byte[2];
            return bigEndian ? ByteUtils.ushort2bytesBE(val, b, 0) : ByteUtils.ushort2bytesLE(val, b, 0);
        }

        @Override
        public byte[] toBytes(int[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.ushorts2bytesBE(val) : ByteUtils.ushorts2bytesLE(val);
        }

        @Override
        public byte[] toBytes(short[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.shorts2bytesBE(val) : ByteUtils.shorts2bytesLE(val);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return this.toBytes(StringUtils.split(val, '\\'), bigEndian, cs);
        }

        @Override
        public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
            int[] t = new int[val.length];
            int i = 0;
            while (i < val.length) {
                t[i] = Integer.parseInt(val[i]);
                ++i;
            }
            return this.toBytes(t, bigEndian);
        }

        @Override
        public short[] toShorts(byte[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.bytesBE2shorts(val) : ByteUtils.bytesLE2shorts(val);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return Integer.toString(this.toInt(val, bigEndian));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.ints2strs(this.toInts(val, bigEndian));
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            return VR.parseShortXMLValue(sb, out, last);
        }

        @Override
        public int vm(byte[] val, SpecificCharacterSet cs) {
            return val == null ? 0 : val.length / 2;
        }

        @Override
        public void toggleEndian(byte[] val, int off, int len) {
            ByteUtils.toggleShortEndian(val, off, len);
        }
    }

    private static class StringVR
    extends VR {
        protected StringVR(int code, int padding, int valueLengthBytes) {
            super(code, padding, valueLengthBytes, null);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return VR.str2bytes(val, cs);
        }

        @Override
        public byte[] toBytes(String[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return VR.strs2bytes(val, cs);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.trim(VR.bytes2str1(val, cs));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return EMPTY_STRING_ARRAY;
            }
            return StringUtils.trim(VR.bytes2strs(val, cs));
        }

        @Override
        public int vm(byte[] val, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return StringUtils.count(VR.bytes2str(val, cs), '\\') + 1;
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            return last ? VR.str2bytes(sb.toString(), cs) : null;
        }
    }

    private static final class TM
    extends ASCIIVR {
        private TM() {
            super(21581, 32, 8);
        }

        @Override
        public byte[] toBytes(Date d) {
            return VR.str2bytes(DateUtils.formatTM(d), null);
        }

        @Override
        public byte[] toBytes(Date[] d) {
            if (d == null || d.length == 0) {
                return null;
            }
            String[] ss = new String[d.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = DateUtils.formatTM(d[i]);
                ++i;
            }
            return VR.strs2bytes(ss, null);
        }

        @Override
        public byte[] toBytes(DateRange dr) {
            if (dr == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer(20);
            if (dr.getStart() != null) {
                sb.append(DateUtils.formatTM(dr.getStart()));
            }
            sb.append("-");
            if (dr.getEnd() != null) {
                sb.append(DateUtils.formatTM(dr.getEnd()));
            }
            return VR.str2bytes(sb.toString(), null);
        }

        @Override
        public Date toDate(byte[] val) {
            return DateUtils.parseTM(StringUtils.trim(VR.bytes2str1(val, null)), false);
        }

        @Override
        public Date[] toDates(byte[] val) {
            if (val == null || val.length == 0) {
                return EMPTY_DATE_ARRAY;
            }
            String[] ss = StringUtils.trim(VR.bytes2strs(val, null));
            Date[] ds = new Date[ss.length];
            int i = 0;
            while (i < ds.length) {
                ds[i] = DateUtils.parseTM(ss[i], false);
                ++i;
            }
            return ds;
        }

        @Override
        public DateRange toDateRange(byte[] val) {
            int l;
            String s = StringUtils.trim(VR.bytes2str1(val, null));
            if (s == null || (l = s.length()) == 0 || s.equals("-")) {
                return null;
            }
            int hypen = s.indexOf(45);
            Date start = hypen == 0 ? null : DateUtils.parseTM(hypen == -1 ? s : s.substring(0, hypen), false);
            Date end = hypen + 1 == l ? null : DateUtils.parseTM(s.substring(hypen + 1), true);
            return new DateRange(start, end);
        }
    }

    private static class TextVR
    extends VR {
        protected TextVR(int code, int padding, int valueLengthBytes) {
            super(code, padding, valueLengthBytes, null);
        }

        @Override
        public byte[] toBytes(String val, boolean bigEndian, SpecificCharacterSet cs) {
            return VR.str2bytes(val, cs);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.trimEnd(VR.bytes2str(val, cs));
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return EMPTY_STRING_ARRAY;
            }
            return new String[]{this.toString(val, bigEndian, cs)};
        }

        @Override
        public boolean isSingleValue(String val) {
            return val != null && val.length() != 0;
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            return last ? VR.str2bytes(sb.toString(), cs) : null;
        }
    }

    private static final class UI
    extends ASCIIVR {
        private UI() {
            super(21833, 0, 8);
        }
    }

    private static final class UL
    extends IntVR {
        private UL() {
            super(21836, 0, 8);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            return Long.toString((long)this.toInt(val, bigEndian) & 0xFFFFFFFFL);
        }

        @Override
        public String[] toStrings(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            return StringUtils.uints2strs(this.toInts(val, bigEndian));
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            if (val == null || val.length == 0) {
                return;
            }
            int cpos = 0;
            int clen = 0;
            int i = 0;
            while (i + 4 <= val.length) {
                if (clen + 12 >= cbuf.length) {
                    out.write(cbuf, 0, clen);
                    clen = 0;
                }
                if (i != 0) {
                    cbuf[clen++] = 92;
                    ++cpos;
                }
                if (maxLen > 0 && cpos + 12 > maxLen) {
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    break;
                }
                String s = Long.toString((long)(bigEndian ? ByteUtils.bytesBE2int(val, i) : ByteUtils.bytesLE2int(val, i)) & 0xFFFFFFFFL);
                int sl = s.length();
                s.getChars(0, sl, cbuf, clen);
                clen += sl;
                cpos += sl;
                i += 4;
            }
            if (clen > 0) {
                out.write(cbuf, 0, clen);
            }
        }
    }

    private static final class UN
    extends VR
    implements Fragment {
        private UN() {
            super(21838, 0, 12, null);
        }

        @Override
        public String toString(byte[] val, boolean bigEndian, SpecificCharacterSet cs) {
            if (val == null || val.length == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer(val.length);
            int i = 0;
            while (i < val.length) {
                if (val[i] >= 32 && val[i] <= 126) {
                    sb.append((char)val[i]);
                    if (val[i] == 92) {
                        sb.append('\\');
                    }
                } else {
                    sb.append('\\');
                    sb.append(HEX_DIGITS[val[i] >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[val[i] & 0xF]);
                }
                ++i;
            }
            return sb.toString();
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            if (val == null || val.length == 0) {
                return;
            }
            int cpos = 0;
            int clen = 0;
            int i = 0;
            while (i < val.length) {
                if (clen + 3 >= cbuf.length) {
                    out.write(cbuf, 0, clen);
                    clen = 0;
                }
                if (maxLen > 0 && cpos + 3 > maxLen) {
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    cbuf[clen++] = 46;
                    break;
                }
                if (val[i] >= 32 && val[i] <= 126) {
                    cbuf[clen++] = (char)val[i];
                    ++cpos;
                    if (val[i] == 92) {
                        cbuf[clen++] = 92;
                        ++cpos;
                    }
                } else {
                    cbuf[clen++] = 92;
                    cbuf[clen++] = HEX_DIGITS[val[i] >> 4 & 0xF];
                    cbuf[clen++] = HEX_DIGITS[val[i] & 0xF];
                    cpos += 3;
                }
                ++i;
            }
            if (clen > 0) {
                out.write(cbuf, 0, clen);
            }
        }

        @Override
        public byte[] parseXMLValue(StringBuffer sb, ByteArrayOutputStream out, boolean last, SpecificCharacterSet cs) {
            if (sb.length() == 0) {
                return last ? out.toByteArray() : null;
            }
            int begin = 0;
            int end = sb.length() - 2;
            while (begin < end) {
                char ch = sb.charAt(begin);
                if (ch != '\\' || sb.charAt(++begin) == '\\') {
                    out.write(ch);
                } else {
                    out.write(Integer.parseInt(sb.substring(begin, begin + 2), 16));
                    ++begin;
                }
                ++begin;
            }
            String remain = sb.substring(begin);
            sb.setLength(0);
            if (!last) {
                sb.append(remain);
                return null;
            }
            out.write(remain.getBytes(), 0, remain.length());
            return out.toByteArray();
        }
    }

    private static final class UN_SIEMENS
    extends VR {
        private UN_SIEMENS() {
            super(16191, 0, 8, null);
        }
    }

    private static final class US
    extends ShortVR {
        private US() {
            super(21843, 0, 8);
        }

        @Override
        public int toInt(byte[] val, boolean bigEndian) {
            if (val == null || val.length == 0) {
                return 0;
            }
            return bigEndian ? ByteUtils.bytesBE2ushort(val, 0) : ByteUtils.bytesLE2ushort(val, 0);
        }

        @Override
        public int[] toInts(byte[] val, boolean bigEndian) {
            return bigEndian ? ByteUtils.bytesBE2ushorts(val) : ByteUtils.bytesLE2ushorts(val);
        }

        @Override
        protected void toChars(byte[] val, boolean bigEndian, SpecificCharacterSet cs, char[] cbuf, int maxLen, CharOut out) {
            VR.ushort2chars(val, bigEndian, cbuf, maxLen, out);
        }
    }

    private static final class UT
    extends TextVR {
        private UT() {
            super(21844, 32, 12);
        }
    }
}

