/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che2.data.ConfigurationError;

public class SpecificCharacterSet {
    private static final Map<String, String> CHARSET = new HashMap<String, String>();
    protected final String charset;

    static {
        CHARSET.put("", "US-ASCII");
        CHARSET.put("ISO_IR 100", "ISO-8859-1");
        CHARSET.put("ISO_IR 101", "ISO-8859-2");
        CHARSET.put("ISO_IR 109", "ISO-8859-3");
        CHARSET.put("ISO_IR 110", "ISO-8859-4");
        CHARSET.put("ISO_IR 144", "ISO-8859-5");
        CHARSET.put("ISO_IR 127", "ISO-8859-6");
        CHARSET.put("ISO_IR 126", "ISO-8859-7");
        CHARSET.put("ISO_IR 138", "ISO-8859-8");
        CHARSET.put("ISO_IR 148", "ISO-8859-9");
        CHARSET.put("ISO_IR 13", "JIS_X0201");
        CHARSET.put("ISO_IR 166", "TIS-620");
        CHARSET.put("ISO 2022 IR 6", "US-ASCII");
        CHARSET.put("ISO 2022 IR 100", "ISO-8859-1");
        CHARSET.put("ISO 2022 IR 101", "ISO-8859-2");
        CHARSET.put("ISO 2022 IR 109", "ISO-8859-3");
        CHARSET.put("ISO 2022 IR 110", "ISO-8859-4");
        CHARSET.put("ISO 2022 IR 144", "ISO-8859-5");
        CHARSET.put("ISO 2022 IR 127", "ISO-8859-6");
        CHARSET.put("ISO 2022 IR 126", "ISO-8859-7");
        CHARSET.put("ISO 2022 IR 138", "ISO-8859-8");
        CHARSET.put("ISO 2022 IR 148", "ISO-8859-9");
        CHARSET.put("ISO 2022 IR 13", "JIS_X0201");
        CHARSET.put("ISO 2022 IR 166", "TIS-620");
        CHARSET.put("ISO 2022 IR 87", "JIS0208");
        CHARSET.put("ISO 2022 IR 159", "JIS0212");
        CHARSET.put("ISO 2022 IR 149", "cp949");
        CHARSET.put("ISO_IR 192", "UTF-8");
        CHARSET.put("GB18030", "GB18030");
    }

    public SpecificCharacterSet(String charset) {
        this.charset = charset;
    }

    public static SpecificCharacterSet valueOf(String[] codes) {
        if (codes == null || codes.length == 0) {
            return null;
        }
        String charset = CHARSET.get(codes[0]);
        if (charset == null) {
            return null;
        }
        return codes.length > 1 ? new ISO2022(charset) : new SpecificCharacterSet(charset);
    }

    public byte[] encode(String val) {
        try {
            return val.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationError(e);
        }
    }

    public String decode(byte[] val) {
        return SpecificCharacterSet.decode(val, 0, val.length, this.charset);
    }

    static String decode(byte[] b, int off, int len, String cs) {
        try {
            return new String(b, off, len, cs);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationError(e);
        }
    }

    private static final class ISO2022
    extends SpecificCharacterSet {
        ISO2022(String charset) {
            super(charset);
        }

        @Override
        public String decode(byte[] b) {
            String cs = this.charset;
            int off = 0;
            int cur = 0;
            int step = 1;
            StringBuffer sb = new StringBuffer(b.length);
            while (cur < b.length) {
                if (b[cur] == 27) {
                    if (off < cur) {
                        sb.append(ISO2022.decode(b, off, cur - off, cs));
                    }
                    switch (b[(cur += 3) - 2] << 8 | b[cur - 1]) {
                        case 9256: {
                            if (b[cur++] == 68) {
                                cs = "JIS0212";
                                step = 2;
                                break;
                            }
                            sb.append(ISO2022.decode(b, cur - 4, 4, cs));
                            break;
                        }
                        case 9257: {
                            if (b[cur++] == 67) {
                                cs = "cp949";
                                step = -1;
                                break;
                            }
                            sb.append(ISO2022.decode(b, cur - 4, 4, cs));
                            break;
                        }
                        case 9282: {
                            cs = "JIS0208";
                            step = 2;
                            break;
                        }
                        case 10306: {
                            cs = "US-ASCII";
                            step = 1;
                            break;
                        }
                        case 10314: 
                        case 10569: {
                            cs = "JIS_X0201";
                            step = 1;
                            break;
                        }
                        case 11585: {
                            cs = "ISO-8859-1";
                            step = 1;
                            break;
                        }
                        case 11586: {
                            cs = "ISO-8859-2";
                            step = 1;
                            break;
                        }
                        case 11587: {
                            cs = "ISO-8859-3";
                            step = 1;
                            break;
                        }
                        case 11588: {
                            cs = "ISO-8859-4";
                            step = 1;
                            break;
                        }
                        case 11590: {
                            cs = "ISO-8859-7";
                            step = 1;
                            break;
                        }
                        case 11591: {
                            cs = "ISO-8859-6";
                            step = 1;
                            break;
                        }
                        case 11592: {
                            cs = "ISO-8859-8";
                            step = 1;
                            break;
                        }
                        case 11596: {
                            cs = "ISO-8859-5";
                            step = 1;
                            break;
                        }
                        case 11597: {
                            cs = "ISO-8859-9";
                            step = 1;
                            break;
                        }
                        case 11604: {
                            cs = "TIS-620";
                            step = 1;
                            break;
                        }
                        default: {
                            sb.append(ISO2022.decode(b, cur - 3, 3, cs));
                        }
                    }
                    off = cur;
                    continue;
                }
                cur += step > 0 ? step : (b[cur] < 0 ? 2 : 1);
            }
            if (off < cur) {
                sb.append(ISO2022.decode(b, off, cur - off, cs));
            }
            return sb.toString();
        }
    }
}

