/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.validator;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class EqualityValidator
implements Validator,
StateHolder {
    private static LogProvider log = Logging.getLogProvider(EqualityValidator.class);
    public static final String MESSAGE_ID = "org.jboss.seam.ui.validator.NOT_EQUAL";
    public static final String VALIDATOR_ID = "org.jboss.seam.ui.validator.Equality";
    private String forId;
    private String message = "Value does not equal that in '#0'";
    private String messageId = "org.jboss.seam.ui.validator.NOT_EQUAL";
    private ValidOperation operator = ValidOperation.EQUAL;

    public EqualityValidator() {
    }

    public EqualityValidator(String forId) {
        this();
        this.setFor(forId);
    }

    public EqualityValidator(String forId, String message, String messageId, String operator) {
        this(forId);
        if (message != null) {
            this.setMessage(message);
        }
        if (messageId != null) {
            this.setMessageId(messageId);
        }
        if (operator != null && !"".equals(operator)) {
            if (ValidOperation.valueOf(operator.toUpperCase()) != null) {
                this.setOperator(ValidOperation.valueOf(operator.toUpperCase()));
            } else {
                throw new IllegalStateException("Illegal operator. Supported are: " + this.validOperatorsAsString());
            }
        }
    }

    private String validOperatorsAsString() {
        StringBuffer buff = new StringBuffer();
        for (ValidOperation op : ValidOperation.values()) {
            buff.append(op.name()).append(" ");
        }
        return buff.toString();
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String forId = this.getFor();
        if (forId == null) {
            throw new FacesException("Must specify a component to validate equality against");
        }
        UIComponent otherComponent = component.findComponent(forId);
        Object other = new OtherComponent(context, otherComponent).getValue();
        if ((value != null || other != null) && value != null) {
            switch (this.operator) {
                case EQUAL: {
                    if (value.equals(other)) break;
                    this.throwValidationException(value, otherComponent, other);
                    break;
                }
                case NOT_EQUAL: {
                    if (!value.equals(other)) break;
                    this.throwValidationException(value, otherComponent, other);
                    break;
                }
                case GREATER: {
                    if (this.compare(value, other) > 0) break;
                    this.throwValidationException(value, otherComponent, other);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    if (this.compare(value, other) >= 0) break;
                    this.throwValidationException(value, otherComponent, other);
                    break;
                }
                case LESS: {
                    if (this.compare(value, other) < 0) break;
                    this.throwValidationException(value, otherComponent, other);
                    break;
                }
                case LESS_OR_EQUAL: {
                    if (this.compare(value, other) <= 0) break;
                    this.throwValidationException(value, otherComponent, other);
                }
            }
        }
    }

    private int compare(Object value, Object other) throws IllegalArgumentException {
        try {
            Comparable c1 = (Comparable)value;
            return c1.compareTo(other);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Values are not comparable", e);
        }
    }

    private void throwValidationException(Object value, UIComponent otherComponent, Object other) {
        throw new ValidatorException(FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)this.getMessageId(), (String)this.getMessage(), (Object[])new Object[]{otherComponent.getId(), value, other}));
    }

    public String getFor() {
        return this.forId;
    }

    public void setFor(String forId) {
        this.forId = forId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] fields = (Object[])state;
        this.forId = (String)fields[0];
        this.message = (String)fields[1];
        this.messageId = (String)fields[2];
        this.operator = ValidOperation.valueOf((String)fields[3]);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.forId, this.message, this.messageId, this.operator.toString()};
        return state;
    }

    public void setTransient(boolean newTransientValue) {
    }

    public ValidOperation getOperator() {
        return this.operator;
    }

    public void setOperator(ValidOperation operator) {
        this.operator = operator;
    }

    private class OtherComponent {
        private FacesContext context;
        private UIComponent component;
        private EditableValueHolder editableValueHolder;
        private Renderer renderer;
        private Converter converter;

        public OtherComponent(FacesContext facesContext, UIComponent component) {
            this.component = component;
            this.context = facesContext;
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalStateException("forId must reference an EditableValueHolder (\"input\") component");
            }
            this.editableValueHolder = (EditableValueHolder)component;
            this.initRenderer();
            this.initConverter();
        }

        private void initRenderer() {
            if (this.renderer == null) {
                String rendererType = this.component.getRendererType();
                if (rendererType != null) {
                    this.renderer = this.context.getRenderKit().getRenderer(this.component.getFamily(), rendererType);
                    if (null == this.renderer) {
                        log.trace((Object)("Can't get Renderer for type " + rendererType));
                    }
                } else if (log.isTraceEnabled()) {
                    String id = this.component.getId();
                    id = null != id ? id : this.component.getClass().getName();
                    log.trace((Object)("No renderer-type for component " + id));
                }
            }
        }

        private void initConverter() {
            Class converterType;
            this.converter = this.editableValueHolder.getConverter();
            if (this.converter != null) {
                return;
            }
            ValueExpression valueExpression = this.component.getValueExpression("value");
            if (valueExpression == null) {
                return;
            }
            try {
                converterType = valueExpression.getType(this.context.getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            if (converterType == null || converterType == String.class || converterType == Object.class) {
                return;
            }
            try {
                Application application = this.context.getApplication();
                this.converter = application.createConverter(converterType);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }

        private Object getConvertedValue(Object newSubmittedValue) throws ConverterException {
            Object newValue = this.renderer != null ? this.renderer.getConvertedValue(this.context, this.component, newSubmittedValue) : (newSubmittedValue instanceof String ? (this.converter != null ? this.converter.getAsObject(this.context, this.component, (String)newSubmittedValue) : newSubmittedValue) : newSubmittedValue);
            return newValue;
        }

        public Object getValue() {
            if (this.editableValueHolder.isLocalValueSet()) {
                return this.editableValueHolder.getValue();
            }
            Object submittedValue = this.editableValueHolder.getLocalValue();
            if (submittedValue == null) {
                return null;
            }
            Object newValue = null;
            try {
                newValue = this.getConvertedValue(submittedValue);
            }
            catch (ConverterException ce) {
                return null;
            }
            return newValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValidOperation {
        EQUAL,
        NOT_EQUAL,
        GREATER,
        GREATER_OR_EQUAL,
        LESS,
        LESS_OR_EQUAL;

    }
}

