/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.varia.scheduler.AbstractScheduleProvider;
import org.jboss.varia.scheduler.SingleScheduleProviderMBean;

public class SingleScheduleProvider
extends AbstractScheduleProvider
implements SingleScheduleProviderMBean {
    private ObjectName mSchedulableMBean;
    private String mSchedulableMBeanMethod;
    private String mSchedulableMBeanMethodName;
    private String[] mMethodSignature = new String[0];
    private SimpleDateFormat mDateFormatter;
    private Date mStartDate;
    private String mStartDateString;
    private long mSchedulePeriod;
    private long mInitialRepetitions;
    private int mScheduleID;

    public void startProviding() throws JMException {
        this.mScheduleID = this.addSchedule(this.mSchedulableMBean, this.mSchedulableMBeanMethodName, this.mMethodSignature, this.mStartDate, this.mSchedulePeriod, (int)this.mInitialRepetitions);
    }

    public void stopProviding() {
        try {
            this.removeSchedule(this.mScheduleID);
        }
        catch (JMException jme) {
            this.log.error((Object)"Could not remove Schedule in stop providing", (Throwable)jme);
        }
    }

    public ObjectName getTargetName() {
        return this.mSchedulableMBean;
    }

    public void setTargetName(ObjectName pTargetObjectName) {
        if (pTargetObjectName == null) {
            throw new IllegalArgumentException("Schedulable MBean must be specified");
        }
        this.mSchedulableMBean = pTargetObjectName;
    }

    public String getTargetMethod() {
        return this.mSchedulableMBeanMethod;
    }

    public void setTargetMethod(String pTargetMethod) throws IllegalArgumentException {
        if (pTargetMethod == null) {
            this.mSchedulableMBeanMethod = null;
            return;
        }
        int lIndex = pTargetMethod.indexOf(40);
        String lMethodName = "";
        if (lIndex < 0) {
            lMethodName = pTargetMethod.trim();
            this.mMethodSignature = new String[0];
        } else if (lIndex > 0) {
            lMethodName = pTargetMethod.substring(0, lIndex).trim();
        }
        if (lMethodName.equals("")) {
            lMethodName = "perform";
        }
        if (lIndex >= 0) {
            String lRest;
            int lIndex2 = pTargetMethod.indexOf(41);
            if (lIndex2 < lIndex) {
                throw new IllegalArgumentException("Schedulable MBean Method: closing bracket must be after opening bracket");
            }
            if (lIndex2 < pTargetMethod.length() - 1 && (lRest = pTargetMethod.substring(lIndex2 + 1).trim()).length() > 0) {
                throw new IllegalArgumentException("Schedulable MBean Method: nothing should be after closing bracket");
            }
            String lArguments = pTargetMethod.substring(lIndex + 1, lIndex2).trim();
            if (lArguments.equals("")) {
                this.mMethodSignature = new String[0];
            } else {
                StringTokenizer lTokenizer = new StringTokenizer(lArguments, ",");
                this.mMethodSignature = new String[lTokenizer.countTokens()];
                int i = 0;
                while (lTokenizer.hasMoreTokens()) {
                    this.mMethodSignature[i] = lTokenizer.nextToken().trim();
                    ++i;
                }
            }
        }
        this.mSchedulableMBeanMethodName = lMethodName;
        this.mSchedulableMBeanMethod = pTargetMethod;
    }

    public long getPeriod() {
        return this.mSchedulePeriod;
    }

    public void setPeriod(long pPeriod) {
        if (pPeriod <= 0L) {
            throw new IllegalArgumentException("Schedulable Period may be not less or equals than 0");
        }
        this.mSchedulePeriod = pPeriod;
    }

    public String getDateFormat() {
        if (this.mDateFormatter == null) {
            this.mDateFormatter = new SimpleDateFormat();
        }
        return this.mDateFormatter.toPattern();
    }

    public void setDateFormat(String dateFormat) {
        this.mDateFormatter = dateFormat == null || dateFormat.trim().length() == 0 ? new SimpleDateFormat() : new SimpleDateFormat(dateFormat);
    }

    public String getStartDate() {
        return this.mStartDateString;
    }

    public void setStartDate(String pStartDate) {
        String string = this.mStartDateString = pStartDate == null ? "" : pStartDate.trim();
        if (this.mStartDateString.equals("")) {
            this.mStartDate = new Date(0L);
        } else if (this.mStartDateString.equals("NOW")) {
            this.mStartDate = new Date(new Date().getTime() + 1000L);
        } else {
            try {
                long lDate = new Long(pStartDate);
                this.mStartDate = new Date(lDate);
            }
            catch (Exception e) {
                try {
                    if (this.mDateFormatter == null) {
                        this.mDateFormatter = new SimpleDateFormat();
                    }
                    this.mStartDate = this.mDateFormatter.parse(this.mStartDateString);
                }
                catch (Exception e2) {
                    this.log.error((Object)("Could not parse given date string: " + this.mStartDateString), (Throwable)e2);
                    throw new IllegalArgumentException("Schedulable Date is not of correct format");
                }
            }
        }
        this.log.debug((Object)("Initial Start Date is set to: " + this.mStartDate));
    }

    public long getRepetitions() {
        return this.mInitialRepetitions;
    }

    public void setRepetitions(long pNumberOfCalls) {
        if (pNumberOfCalls <= 0L) {
            pNumberOfCalls = -1L;
        }
        this.mInitialRepetitions = pNumberOfCalls;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) throws MalformedObjectNameException {
        return pName == null ? SingleScheduleProviderMBean.OBJECT_NAME : pName;
    }
}

