/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.scriptio.ScriptWriterBinary;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.scriptio.ScriptWriterZipped;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isDump;
    boolean includeCachedData;
    long byteCount;
    volatile boolean needsSync;
    volatile boolean forceSync;
    volatile boolean busyWriting;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    public static final int SCRIPT_TEXT_170 = 0;
    public static final int SCRIPT_BINARY_172 = 1;
    public static final int SCRIPT_ZIPPED_BINARY_172 = 3;
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    public static ScriptWriterBase newScriptWriter(Database database, String string, boolean bl, boolean bl2, int n) throws HsqlException {
        if (n == 0) {
            return new ScriptWriterText(database, string, bl, bl2, false);
        }
        if (n == 1) {
            return new ScriptWriterBinary(database, string, bl, bl2);
        }
        return new ScriptWriterZipped(database, string, bl, bl2);
    }

    ScriptWriterBase() {
    }

    ScriptWriterBase(Database database, String string, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        this.isDump = bl3;
        this.initBuffers();
        boolean bl4 = false;
        bl4 = bl3 ? FileUtil.exists(string) : database.getFileAccess().isStreamElement(string);
        if (bl4 && bl2) {
            throw Trace.error(29, string);
        }
        this.database = database;
        this.includeCachedData = bl;
        this.outFile = string;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void reopen() throws HsqlException {
        this.openFile();
    }

    protected abstract void initBuffers();

    public synchronized void sync() {
        if (this.needsSync && this.fileStreamOut != null) {
            if (this.busyWriting) {
                this.forceSync = true;
                return;
            }
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException iOException) {
                Trace.printSystemOut("flush() or sync() error: " + iOException.toString());
            }
            this.needsSync = false;
            this.forceSync = false;
        }
    }

    public void close() throws HsqlException {
        this.stop();
        try {
            if (this.fileStreamOut != null) {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                this.fileStreamOut.close();
                this.fileStreamOut = null;
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
        this.byteCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() throws HsqlException {
        try {
            this.writeDDL();
            this.writeExistingData();
            this.finishStream();
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
    }

    protected void openFile() throws HsqlException {
        try {
            FileUtil fileUtil = this.isDump ? FileUtil.getDefaultInstance() : this.database.getFileAccess();
            OutputStream outputStream = fileUtil.openOutputStreamElement(this.outFile);
            this.outDescriptor = fileUtil.getFileSync(outputStream);
            this.fileStreamOut = new BufferedOutputStream(outputStream, 8192);
        }
        catch (IOException iOException) {
            throw Trace.error(29, 115, new Object[]{iOException.toString(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL() throws IOException, HsqlException {
        Result result = DatabaseScript.getScript(this.database, !this.includeCachedData);
        this.writeSingleColumnResult(result);
    }

    protected void writeExistingData() throws HsqlException, IOException {
        this.currentSession.loggedSchema = null;
        Iterator iterator = this.database.schemaManager.userSchemaNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.database.schemaManager.tablesIterator(string);
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                boolean bl = false;
                switch (table.getTableType()) {
                    case 3: {
                        bl = true;
                        break;
                    }
                    case 4: {
                        bl = this.includeCachedData;
                        break;
                    }
                    case 6: {
                        bl = this.includeCachedData && !table.isReadOnly();
                    }
                }
                try {
                    if (!bl) continue;
                    this.schemaToLog = table.getName().schema;
                    this.writeTableInit(table);
                    RowIterator rowIterator = table.rowIterator(this.currentSession);
                    while (rowIterator.hasNext()) {
                        this.writeRow(this.currentSession, table, rowIterator.next().getData());
                    }
                    this.writeTableTerm(table);
                }
                catch (Exception exception) {
                    throw Trace.error(38, exception.toString());
                }
            }
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Table table) throws HsqlException, IOException {
    }

    protected void writeTableTerm(Table table) throws HsqlException, IOException {
        if (table.isDataReadOnly() && !table.isTemp() && !table.isText()) {
            StringBuffer stringBuffer = new StringBuffer("SET TABLE ");
            stringBuffer.append(table.getName().statementName);
            stringBuffer.append(" READONLY TRUE");
            this.writeLogStatement(this.currentSession, stringBuffer.toString());
        }
    }

    protected void writeSingleColumnResult(Result result) throws HsqlException, IOException {
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            this.writeLogStatement(this.currentSession, (String)objectArray[0]);
        }
    }

    abstract void writeRow(Session var1, Table var2, Object[] var3) throws HsqlException, IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void addSessionId(Session var1) throws IOException;

    public abstract void writeLogStatement(Session var1, String var2) throws IOException, HsqlException;

    public abstract void writeInsertStatement(Session var1, Table var2, Object[] var3) throws HsqlException, IOException;

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3) throws HsqlException, IOException;

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2) throws HsqlException, IOException;

    public abstract void writeCommitStatement(Session var1) throws HsqlException, IOException;

    public void run() {
        block3: {
            try {
                if (this.writeDelay != 0) {
                    this.sync();
                }
            }
            catch (Exception exception) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(exception.toString());
            }
        }
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
        int n2 = this.writeDelay == 0 ? 1000 : this.writeDelay;
        HsqlTimer.setPeriod(this.timerTask, n2);
    }

    public void start() {
        int n = this.writeDelay == 0 ? 1000 : this.writeDelay;
        this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, n, this, false);
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

