/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.util;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.wicket.RequestCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtils {
    public static ResultSet getResultSet(Connection jdbcConnection, String statement, Map<String, String> parameters) throws SQLException, Exception {
        ResultSet resultSet = null;
        resultSet = parameters == null ? jdbcConnection.createStatement(1004, 1007).executeQuery(statement) : DatabaseUtils.createPreparedStatement(jdbcConnection, statement, parameters).executeQuery();
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getDatabaseConnection(String dataSourceName) {
        InitialContext jndiContext = null;
        try {
            jndiContext = new InitialContext();
            Connection connection = ((DataSource)jndiContext.lookup(dataSourceName)).getConnection();
            return connection;
        }
        catch (Exception e) {
        }
        finally {
            try {
                jndiContext.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static PreparedStatement createPreparedStatement(Connection connection, String sqlStatement, Map<String, String> parameters) throws SQLException, Exception {
        PreparedStatement preparedStatement = connection.prepareStatement(DatabaseUtils.createSQLStatement(sqlStatement), 1005, 1007);
        int i = 1;
        for (String parameterName : DatabaseUtils.getParameterOccurences(sqlStatement)) {
            if (parameterName.startsWith("text")) {
                preparedStatement.setString(i, parameters.get(parameterName));
            } else if (parameterName.startsWith("int")) {
                preparedStatement.setInt(i, new Integer(parameters.get(parameterName)));
            } else if (parameterName.startsWith("float")) {
                preparedStatement.setFloat(i, new Float(parameters.get(parameterName)).floatValue());
            } else if (parameterName.startsWith("boolean")) {
                preparedStatement.setBoolean(i, new Boolean(parameters.get(parameterName)));
            } else if (parameterName.startsWith("date")) {
                preparedStatement.setDate(i, Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(SimpleDateFormat.getDateInstance(3, RequestCycle.get().getSession().getLocale()).parse(parameters.get(parameterName)))));
            }
            ++i;
        }
        return preparedStatement;
    }

    public static String createSQLStatement(String statement) {
        return Pattern.compile("\\[\\:(text|int|float|boolean|date)\\:[A-Za-z0-9\\.]*\\:\\]").matcher(statement).replaceAll("?");
    }

    public static List<String> getParameterOccurences(String statement) {
        ArrayList<String> parameters = new ArrayList<String>();
        Matcher m = Pattern.compile("\\[\\:(text|int|float|boolean|date)\\:[A-Za-z0-9\\.]*\\:\\]").matcher(statement);
        while (m.find()) {
            parameters.add(m.group().replaceAll("(\\[\\:|\\:\\])", "").replaceAll("\\:", " "));
        }
        return parameters;
    }

    public static boolean isConfigurableStatement(String statement) {
        return Pattern.compile("\\[\\:(text|int|float|boolean|date)\\:[A-Za-z0-9\\.]*\\:\\]").matcher(statement).find();
    }

    public static Set<String> getParameterSet(String statement) {
        TreeSet<String> parameters = new TreeSet<String>();
        Matcher m = Pattern.compile("\\[\\:(text|int|float|boolean|date)\\:[A-Za-z0-9\\.]*\\:\\]").matcher(statement);
        while (m.find()) {
            parameters.add(m.group().replaceAll("(\\[\\:|\\:\\])", "").replaceAll("\\:", " "));
        }
        return parameters;
    }
}

