/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.systeminfo;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyRenderableColumn;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyTreeColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.dcm4chee.dashboard.mbean.DashboardDelegator;
import org.dcm4chee.dashboard.model.SystemPropertyModel;
import org.dcm4chee.dashboard.ui.DashboardPanel;
import org.dcm4chee.dashboard.ui.common.DashboardTreeTable;
import org.dcm4chee.dashboard.ui.util.CSSUtils;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(SystemInfoPanel.class);
    private static final ResourceReference DashboardCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-style.css");

    public SystemInfoPanel(String id) {
        super(id);
        if (DashboardCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)DashboardCSS)});
        }
    }

    public void onBeforeRender() {
        super.onBeforeRender();
        try {
            Class<?> memoryPoolMXBean = Thread.currentThread().getContextClassLoader().loadClass("java.lang.management.MemoryPoolMXBean");
            Class<?> memoryUsage = Thread.currentThread().getContextClassLoader().loadClass("java.lang.management.MemoryUsage");
            ArrayList<MemoryInstanceModel> memoryInstanceList = new ArrayList<MemoryInstanceModel>();
            for (Object pool : (List)Thread.currentThread().getContextClassLoader().loadClass("java.lang.management.ManagementFactory").getMethod("getMemoryPoolMXBeans", new Class[0]).invoke(null, new Object[0])) {
                Object usage = memoryPoolMXBean.getMethod("getUsage", new Class[0]).invoke(pool, new Object[0]);
                if (usage == null) continue;
                memoryInstanceList.add(new MemoryInstanceModel(memoryPoolMXBean.getMethod("getName", new Class[0]).invoke(pool, new Object[0]).toString(), memoryPoolMXBean.getMethod("getType", new Class[0]).invoke(pool, new Object[0]).toString(), (Long)memoryUsage.getMethod("getInit", new Class[0]).invoke(usage, new Object[0]), (Long)memoryUsage.getMethod("getUsed", new Class[0]).invoke(usage, new Object[0]), (Long)memoryUsage.getMethod("getCommitted", new Class[0]).invoke(usage, new Object[0]), (Long)memoryUsage.getMethod("getMax", new Class[0]).invoke(usage, new Object[0])));
            }
            this.addOrReplace(new Component[]{new ListView<MemoryInstanceModel>("memory-instance-rows", memoryInstanceList){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<MemoryInstanceModel> item) {
                    MemoryInstanceModel memoryInstanceModel = (MemoryInstanceModel)item.getModelObject();
                    item.add(new Component[]{new Label("name", String.valueOf(memoryInstanceModel.getName()))});
                    item.add(new Component[]{new Label("type", String.valueOf(memoryInstanceModel.getType()))});
                    item.add(new Component[]{new Label("init", String.valueOf(memoryInstanceModel.getInit()))});
                    item.add(new Component[]{new Label("used", String.valueOf(memoryInstanceModel.getUsed()))});
                    item.add(new Component[]{new Label("committed", String.valueOf(memoryInstanceModel.getCommitted()))});
                    item.add(new Component[]{new Label("max", String.valueOf(memoryInstanceModel.getMax()))});
                    item.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(item.getIndex()))))});
                }
            }});
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new SystemPropertyModel());
            Map propertyMap = DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).getSystemProperties();
            for (String key : propertyMap.keySet()) {
                SystemPropertyModel group = new SystemPropertyModel();
                group.setLabel(key);
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group);
                rootNode.add(groupNode);
                for (SystemPropertyModel propertyModel : (List)propertyMap.get(key)) {
                    groupNode.add(new DefaultMutableTreeNode(propertyModel));
                }
            }
            SystemPropertyTreeTable systemPropertyTreeTable = new SystemPropertyTreeTable("systemproperty-tree-table", new DefaultTreeModel(rootNode), new IColumn[]{new PropertyTreeColumn(new ColumnLocation(ColumnLocation.Alignment.LEFT, 39, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.systemproperty.table.column.label").wrapOnAssignment((Component)this).getObject(), "userObject.label"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 30, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.systemproperty.table.column.name").wrapOnAssignment((Component)this).getObject(), "userObject.name"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 30, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.systemproperty.table.column.value").wrapOnAssignment((Component)this).getObject(), "userObject.value")});
            systemPropertyTreeTable.getTreeState().setAllowSelectMultiple(true);
            systemPropertyTreeTable.getTreeState().expandAll();
            systemPropertyTreeTable.setRootLess(true);
            this.addOrReplace(new Component[]{systemPropertyTreeTable});
        }
        catch (Exception e) {
            log.error(((Object)((Object)this)).getClass().toString() + ": " + "onBeforeRender: " + e.getMessage());
            log.debug("Exception: ", (Throwable)e);
            throw new WicketRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String getModuleName() {
        return "dashboard.systeminfo";
    }

    private class MemoryInstanceModel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int MEGA = 0x100000;
        private final int memoryDisplayLength = 8;
        private NumberFormat formatter;
        private String name;
        private String type;
        private long init;
        private long used;
        private long committed;
        private long max;

        public MemoryInstanceModel(String name, String type, long init, long used, long committed, long max) {
            this.name = name;
            this.type = type;
            this.init = init;
            this.used = used;
            this.committed = committed;
            this.max = max;
            this.formatter = DecimalFormat.getInstance();
            this.formatter.setMaximumFractionDigits(3);
            this.formatter.setMinimumIntegerDigits(1);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getInit() {
            return this.format(this.init);
        }

        public String getUsed() {
            return this.format(this.used);
        }

        public String getCommitted() {
            return this.format(this.committed);
        }

        public String getMax() {
            return this.format(this.max);
        }

        private String format(long memory) {
            String memoryString = this.formatter.format(new Float(memory).floatValue() / 1048576.0f);
            return memoryString.substring(0, Math.min(memoryString.length(), this.memoryDisplayLength)) + " MB";
        }
    }

    private class SystemPropertyTreeTable
    extends DashboardTreeTable {
        private static final long serialVersionUID = 1L;

        public SystemPropertyTreeTable(String id, TreeModel model, IColumn[] columns) {
            super(id, model, columns);
        }

        protected Component newNodeIcon(MarkupContainer parent, String id, final TreeNode node) {
            return new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("style", (CharSequence)("background-image: url('" + (((SystemPropertyModel)((DefaultMutableTreeNode)node).getUserObject()).getGroup() == null ? this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_PROPERTY_FOLDER) : this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_PROPERTY)) + "')"));
                }
            };
        }
    }
}

