/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.report.display;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.dcm4chee.dashboard.model.ReportModel;
import org.dcm4chee.dashboard.ui.DashboardPanel;
import org.dcm4chee.dashboard.ui.report.display.DisplayReportDiagramPanel;
import org.dcm4chee.dashboard.ui.report.display.DisplayReportTablePanel;
import org.dcm4chee.dashboard.ui.util.DatabaseUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDisplayPage
extends WebPage {
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private static final ResourceReference DashboardCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-style.css");
    private static final ResourceReference PrintCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-print.css");

    public DynamicDisplayPage(ReportModel report, Map<String, String> parameters, boolean displayDiagram, boolean displayTable) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        if (DashboardCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)DashboardCSS)});
        }
        if (PrintCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)PrintCSS, (String)"print")});
        }
        this.add(new Component[]{new Label("title", report.getTitle())});
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(report.getCreated());
        this.add(new Component[]{new Label("date", new SimpleDateFormat("dd.MM.yyyy hh:mm").format(calendar.getTime()))});
        this.add(new Component[]{new Label("statement", DatabaseUtils.createSQLStatement(report.getStatement()))});
        this.add(new Component[]{displayDiagram ? new DisplayReportDiagramPanel("diagramPanel", report, parameters) : new Label("diagramPanel", "").setVisible(false)});
        this.add(new Component[]{displayTable ? new DisplayReportTablePanel("tablePanel", report, parameters) : new Label("tablePanel", "").setVisible(false)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PlaceholderLink
    extends Link<Object> {
        private static final long serialVersionUID = 1L;

        public PlaceholderLink(String id) {
            super(id);
            this.setVisible(false);
        }

        public void onClick() {
        }
    }
}

