/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.report.display;

import com.csvreader.CsvWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.WebResponse;
import org.dcm4chee.dashboard.mbean.DashboardDelegator;
import org.dcm4chee.dashboard.model.ReportModel;
import org.dcm4chee.dashboard.ui.util.CSSUtils;
import org.dcm4chee.dashboard.ui.util.DatabaseUtils;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.icons.behaviours.ImageSizeBehaviour;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayReportTablePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DisplayReportTablePanel.class);
    private ReportModel report;
    private int offset = 0;
    private int total = 0;
    private int pagesize = 0;
    private ArrayList<String> headers;
    private Map<String, String> parameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayReportTablePanel(String id, ReportModel report, Map<String, String> parameters) {
        super(id);
        this.report = report;
        this.parameters = parameters;
        this.setOutputMarkupId(true);
        Connection jdbcConnection = null;
        try {
            this.add(new Component[]{new Link<Object>("table-download-xml"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    RequestCycle.get().setRequestTarget(new IRequestTarget(){

                        public void respond(RequestCycle requestCycle) {
                            WebResponse wr = null;
                            try {
                                StringWriter writer = new StringWriter();
                                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(DisplayReportTablePanel.this.generateXMLDocument()), new StreamResult(writer));
                                wr = (WebResponse)requestCycle.getResponse();
                                wr.setContentType("text/xml");
                                wr.setHeader("content-disposition", "attachment;filename=table.xml");
                                OutputStream os = wr.getOutputStream();
                                os.write(writer.toString().getBytes());
                                os.close();
                            }
                            catch (Exception e) {
                                log.error(this.getClass().toString() + ": " + "respond: " + e.getMessage());
                                log.debug("Exception: ", (Throwable)e);
                            }
                            wr.close();
                        }

                        public void detach(RequestCycle arg0) {
                        }
                    });
                }
            }.add(new Component[]{new Label("table-download-xml-image", "XML")}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.reporttable.", "xml.downloadlink")})});
            this.add(new Component[]{new Link<Object>("table-download-csv"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    RequestCycle.get().setRequestTarget(new IRequestTarget(){

                        public void respond(RequestCycle requestCycle) {
                            WebResponse wr = null;
                            try {
                                wr = (WebResponse)requestCycle.getResponse();
                                wr.setContentType("text/xml");
                                wr.setHeader("content-disposition", "attachment;filename=table.csv");
                                OutputStream os = wr.getOutputStream();
                                CsvWriter csvWriter = new CsvWriter((Writer)new BufferedWriter(new OutputStreamWriter(os)), ';');
                                for (String[] row : DisplayReportTablePanel.this.generateCSVDocument()) {
                                    csvWriter.writeRecord(row);
                                }
                                csvWriter.close();
                                os.close();
                            }
                            catch (IOException e) {
                                log.error(this.getClass().toString() + ": " + "respond: " + e.getMessage());
                                log.debug("Exception: ", (Throwable)e);
                            }
                            wr.close();
                        }

                        public void detach(RequestCycle arg0) {
                        }
                    });
                }
            }.add(new Component[]{new Label("table-download-csv-image", "CSV")}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.reporttable.", "csv.downloadlink")})});
            this.add(new Component[]{new Image("table-print-image", ImageManager.IMAGE_DASHBOARD_REPORT_PRINT).add(new IBehavior[]{new ImageSizeBehaviour()}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.reporttable.", "table.printbutton")})});
            this.add(new Component[]{new AjaxFallbackLink<Object>("prev"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    DisplayReportTablePanel.this.offset -= DisplayReportTablePanel.this.pagesize;
                    DisplayReportTablePanel.this.refreshView();
                    target.addComponent((Component)DisplayReportTablePanel.this.getPanel());
                }

                public boolean isVisible() {
                    return DisplayReportTablePanel.this.offset != 0;
                }
            }.add(new Component[]{new Image("prevImg", ImageManager.IMAGE_COMMON_BACK).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.reporttable.", "table.previous")})})});
            this.add(new Component[]{new AjaxFallbackLink<Object>("next"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    DisplayReportTablePanel.this.offset += DisplayReportTablePanel.this.pagesize;
                    DisplayReportTablePanel.this.refreshView();
                    target.addComponent((Component)DisplayReportTablePanel.this.getPanel());
                }

                public boolean isVisible() {
                    return DisplayReportTablePanel.this.total - DisplayReportTablePanel.this.offset > DisplayReportTablePanel.this.pagesize;
                }
            }.add(new Component[]{new Image("nextImg", ImageManager.IMAGE_COMMON_FORWARD).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.reporttable.", "table.next")})})});
            this.add(new Component[]{new Label("viewport", (IModel)new StringResourceModel("dashboard.report.reporttable.pagination.text", (Component)this, null, new Object[]{"dummy"}){
                private static final long serialVersionUID = 1L;

                protected Object[] getParameters() {
                    return new Object[]{Math.min(DisplayReportTablePanel.this.offset + 1, DisplayReportTablePanel.this.total), Math.min(DisplayReportTablePanel.this.offset + DisplayReportTablePanel.this.pagesize, DisplayReportTablePanel.this.total), DisplayReportTablePanel.this.total};
                }
            })});
            RepeatingView columnHeaders = new RepeatingView("column-headers");
            this.add(new Component[]{columnHeaders});
            this.add(new Component[]{new RepeatingView("report-rows")});
            this.pagesize = DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).getReportTablePagesize();
            jdbcConnection = DatabaseUtils.getDatabaseConnection(report.getDataSource());
            ResultSet resultSet = DatabaseUtils.getResultSet(jdbcConnection, report.getStatement(), parameters);
            resultSet.last();
            this.total = resultSet.getRow();
            this.headers = new ArrayList(resultSet.getMetaData().getColumnCount());
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                this.headers.add(resultSet.getMetaData().getColumnName(i));
                columnHeaders.add(new Component[]{new Label(columnHeaders.newChildId(), resultSet.getMetaData().getColumnName(i))});
            }
            resultSet.close();
            this.refreshView();
            this.add(new Component[]{new Label("error-message", "").setVisible(false)});
            this.add(new Component[]{new Label("error-reason", "").setVisible(false)});
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage());
            this.add(new Component[]{new Label("error-message", (String)new ResourceModel("dashboard.report.reporttable.statement.error").wrapOnAssignment((Component)this).getObject()).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"message-error")))})});
            this.add(new Component[]{new Label("error-reason", e.getMessage()).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"message-error")))})});
            log.debug(((Object)((Object)this)).getClass() + ": ", (Throwable)e);
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        int start = this.offset + 1;
        int end = Math.min(this.offset + this.pagesize, this.total);
        RepeatingView reportRows = new RepeatingView("report-rows");
        this.addOrReplace(new Component[]{reportRows});
        Connection jdbcConnection = null;
        try {
            jdbcConnection = DatabaseUtils.getDatabaseConnection(this.report.getDataSource());
            ResultSet resultSet = DatabaseUtils.getResultSet(jdbcConnection, this.report.getStatement(), this.parameters);
            resultSet.first();
            if (resultSet.getRow() > 0) {
                while (resultSet.getRow() <= end && !resultSet.isAfterLast()) {
                    if (resultSet.getRow() >= start) {
                        WebMarkupContainer parent = new WebMarkupContainer(reportRows.newChildId());
                        parent.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(resultSet.getRow() - 1))))});
                        reportRows.add(new Component[]{parent});
                        RepeatingView columnValues = new RepeatingView("column-values");
                        parent.add(new Component[]{columnValues});
                        for (int i = 1; i <= this.headers.size(); ++i) {
                            columnValues.add(new Component[]{new WebMarkupContainer(columnValues.newChildId()).add(new Component[]{new Label("column-value", resultSet.getString(i))})});
                        }
                    }
                    resultSet.next();
                }
            }
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage());
            log.debug(((Object)((Object)this)).getClass() + ": ", (Throwable)e);
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (Exception ignore) {}
        }
    }

    private Panel getPanel() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document generateXMLDocument() {
        Connection jdbcConnection = null;
        try {
            jdbcConnection = DatabaseUtils.getDatabaseConnection(this.report.getDataSource());
            ResultSet resultSet = DatabaseUtils.getResultSet(jdbcConnection, this.report.getStatement(), this.parameters);
            resultSet.first();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node1 = document.createElement("report");
            Element node2 = document.createElement("header");
            node1.appendChild(node2);
            Element node3 = document.createElement("title");
            node2.appendChild(node3);
            node3.appendChild(document.createTextNode(this.report.getTitle()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.report.getCreated());
            node3 = document.createElement("created");
            node2.appendChild(node3);
            node3.appendChild(document.createTextNode(new SimpleDateFormat("dd.MM.yyyy hh:mm").format(calendar.getTime())));
            node3 = document.createElement("statement");
            node2.appendChild(node3);
            node3.appendChild(document.createTextNode(this.report.getStatement()));
            node2 = document.createElement("table");
            node1.appendChild(node2);
            document.appendChild(node1);
            if (this.total > 0) {
                while (!resultSet.isAfterLast()) {
                    Element rowNode = document.createElement("row");
                    for (int i = 1; i <= this.headers.size(); ++i) {
                        Element columnNode = document.createElement("column");
                        columnNode.setAttribute("name", this.headers.get(i - 1));
                        rowNode.appendChild(columnNode);
                        columnNode.appendChild(document.createTextNode(resultSet.getString(i)));
                    }
                    node2.appendChild(rowNode);
                    resultSet.next();
                }
            }
            Document document2 = document;
            return document2;
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage());
            log.debug(((Object)((Object)this)).getClass() + ": ", (Throwable)e);
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String[]> generateCSVDocument() {
        Connection jdbcConnection = null;
        try {
            jdbcConnection = DatabaseUtils.getDatabaseConnection(this.report.getDataSource());
            ResultSet resultSet = DatabaseUtils.getResultSet(jdbcConnection, this.report.getStatement(), this.parameters);
            resultSet.first();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.report.getCreated());
            ArrayList<String[]> csvList = new ArrayList<String[]>();
            csvList.add(new String[]{this.report.getTitle(), new SimpleDateFormat("dd.MM.yyyy hh:mm").format(calendar.getTime()), this.report.getStatement()});
            if (this.total > 0) {
                ArrayList<String> columnList = new ArrayList<String>(this.headers.size());
                while (!resultSet.isAfterLast()) {
                    columnList.clear();
                    for (int i = 1; i <= this.headers.size(); ++i) {
                        columnList.add(resultSet.getString(i));
                    }
                    csvList.add(columnList.toArray(new String[0]));
                    resultSet.next();
                }
            }
            ArrayList<String[]> arrayList = csvList;
            return arrayList;
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage());
            log.debug(((Object)((Object)this)).getClass() + ": ", (Throwable)e);
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

