/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.report.display;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.protocol.http.WebResponse;
import org.dcm4chee.dashboard.model.ReportModel;
import org.dcm4chee.dashboard.ui.common.JFreeChartImage;
import org.dcm4chee.dashboard.ui.config.delegate.DashboardCfgDelegate;
import org.dcm4chee.dashboard.ui.report.display.DynamicDisplayPage;
import org.dcm4chee.dashboard.ui.util.DatabaseUtils;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.icons.behaviours.ImageSizeBehaviour;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryStepRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.text.TextBlock;
import org.jfree.ui.RectangleEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayReportDiagramPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DisplayReportDiagramPanel.class);
    private ReportModel report;
    private Map<String, String> parameters;

    public DisplayReportDiagramPanel(String id, ReportModel report, Map<String, String> parameters) {
        super(id);
        this.report = report;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBeforeRender() {
        super.onBeforeRender();
        Connection jdbcConnection = null;
        try {
            DefaultCategoryDataset dataset;
            if (this.report == null) {
                throw new Exception("No report given to render diagram");
            }
            jdbcConnection = DatabaseUtils.getDatabaseConnection(this.report.getDataSource());
            ResultSet resultSet = DatabaseUtils.getResultSet(jdbcConnection, this.report.getStatement(), this.parameters);
            ResultSetMetaData metaData = resultSet.getMetaData();
            JFreeChart chart = null;
            resultSet.beforeFirst();
            if (this.report.getDiagram() == 0) {
                if (metaData.getColumnCount() != 1) {
                    throw new Exception((String)new ResourceModel("dashboard.report.reportdiagram.image.render.error.1numvalues").wrapOnAssignment((Component)this).getObject());
                }
                dataset = new DefaultCategoryDataset();
                while (resultSet.next()) {
                    dataset.addValue(resultSet.getDouble(1), (Comparable)((Object)metaData.getColumnName(1)), (Comparable)((Object)String.valueOf(resultSet.getRow())));
                }
                chart = ChartFactory.createLineChart((String)((String)new ResourceModel("dashboard.report.reportdiagram.image.label").wrapOnAssignment((Component)this).getObject()), (String)((String)new ResourceModel("dashboard.report.reportdiagram.image.row-label").wrapOnAssignment((Component)this).getObject()), (String)metaData.getColumnName(1), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            } else if (this.report.getDiagram() == 1) {
                if (metaData.getColumnCount() != 2) {
                    throw new Exception((String)new ResourceModel("dashboard.report.reportdiagram.image.render.error.2numvalues").wrapOnAssignment((Component)this).getObject());
                }
                XYSeries series = new XYSeries((Comparable)((Object)(metaData.getColumnName(1) + " / " + metaData.getColumnName(2))));
                while (resultSet.next()) {
                    series.add(resultSet.getDouble(1), resultSet.getDouble(2));
                }
                chart = ChartFactory.createXYLineChart((String)((String)new ResourceModel("dashboard.report.reportdiagram.image.label").wrapOnAssignment((Component)this).getObject()), (String)metaData.getColumnName(1), (String)metaData.getColumnName(2), (XYDataset)new XYSeriesCollection(series), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            } else if (this.report.getDiagram() == 2) {
                if (metaData.getColumnCount() != 2) {
                    throw new Exception((String)new ResourceModel("dashboard.report.reportdiagram.image.render.error.2values").wrapOnAssignment((Component)this).getObject());
                }
                dataset = new DefaultCategoryDataset();
                while (resultSet.next()) {
                    dataset.setValue(resultSet.getDouble(1), (Comparable)((Object)(metaData.getColumnName(1) + " / " + metaData.getColumnName(2))), (Comparable)((Object)resultSet.getString(2)));
                }
                chart = new JFreeChart((String)new ResourceModel("dashboard.report.reportdiagram.image.label").wrapOnAssignment((Component)this).getObject(), (Plot)new CategoryPlot((CategoryDataset)dataset, (CategoryAxis)new LabelAdaptingCategoryAxis(14.0f, metaData.getColumnName(2)), (ValueAxis)new NumberAxis(metaData.getColumnName(1)), (CategoryItemRenderer)new CategoryStepRenderer(true)));
            } else if (this.report.getDiagram() == 3 || this.report.getDiagram() == 4) {
                if (metaData.getColumnCount() != 2) {
                    throw new Exception((String)new ResourceModel("dashboard.report.reportdiagram.image.render.error.2values").wrapOnAssignment((Component)this).getObject());
                }
                dataset = new DefaultPieDataset();
                while (resultSet.next()) {
                    dataset.setValue((Comparable)((Object)resultSet.getString(2)), resultSet.getDouble(1));
                }
                if (this.report.getDiagram() == 3) {
                    chart = ChartFactory.createPieChart((String)((String)new ResourceModel("dashboard.report.reportdiagram.image.label").wrapOnAssignment((Component)this).getObject()), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)true);
                } else if (this.report.getDiagram() == 4) {
                    chart = ChartFactory.createPieChart3D((String)((String)new ResourceModel("dashboard.report.reportdiagram.image.label").wrapOnAssignment((Component)this).getObject()), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)true);
                    ((PiePlot3D)chart.getPlot()).setForegroundAlpha(Float.valueOf((String)new ResourceModel("dashboard.report.reportdiagram.image.alpha").wrapOnAssignment((Component)this).getObject()).floatValue());
                }
            } else if (this.report.getDiagram() == 5) {
                if (metaData.getColumnCount() != 2 && metaData.getColumnCount() != 3) {
                    throw new Exception((String)new ResourceModel("dashboard.report.reportdiagram.image.render.error.3values").wrapOnAssignment((Component)this).getObject());
                }
                dataset = new DefaultCategoryDataset();
                while (resultSet.next()) {
                    dataset.setValue(resultSet.getDouble(1), (Comparable)((Object)resultSet.getString(2)), (Comparable)((Object)resultSet.getString(metaData.getColumnCount())));
                }
                chart = ChartFactory.createBarChart((String)((String)new ResourceModel("dashboard.report.reportdiagram.image.label").wrapOnAssignment((Component)this).getObject()), (String)metaData.getColumnName(2), (String)metaData.getColumnName(1), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            int[] winSize = DashboardCfgDelegate.getInstance().getWindowSize("reportDiagramImage");
            this.addOrReplace(new Component[]{new JFreeChartImage("diagram", chart, winSize[0], winSize[1])});
            final JFreeChart downloadableChart = chart;
            this.addOrReplace(new Component[]{new Link<Object>("diagram-download"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    RequestCycle.get().setRequestTarget(new IRequestTarget(){

                        public void respond(RequestCycle requestCycle) {
                            WebResponse wr = (WebResponse)requestCycle.getResponse();
                            wr.setContentType("image/png");
                            wr.setHeader("content-disposition", "attachment;filename=diagram.png");
                            OutputStream os = wr.getOutputStream();
                            try {
                                ImageIO.write((RenderedImage)downloadableChart.createBufferedImage(800, 600), "png", os);
                                os.close();
                            }
                            catch (IOException e) {
                                log.error(this.getClass().toString() + ": " + "respond: " + e.getMessage());
                                log.debug("Exception: ", (Throwable)e);
                            }
                            wr.close();
                        }

                        public void detach(RequestCycle arg0) {
                        }
                    });
                }
            }.add(new Component[]{new Image("diagram-download-image", ImageManager.IMAGE_DASHBOARD_REPORT_DOWNLOAD).add(new IBehavior[]{new ImageSizeBehaviour()}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.reportdiagram.", "image.downloadlink")})})});
            this.addOrReplace(new Component[]{new Image("diagram-print-image", ImageManager.IMAGE_DASHBOARD_REPORT_PRINT).add(new IBehavior[]{new ImageSizeBehaviour()}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.reportdiagram.", "image.printbutton")})});
            this.addOrReplace(new Component[]{new Label("error-message", "").setVisible(false)});
            this.addOrReplace(new Component[]{new Label("error-reason", "").setVisible(false)});
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage());
            Component[] componentArray = new Component[1];
            DynamicDisplayPage dynamicDisplayPage = (DynamicDisplayPage)this.getPage();
            ((Object)((Object)dynamicDisplayPage)).getClass();
            componentArray[0] = new DynamicDisplayPage.PlaceholderLink(dynamicDisplayPage, "diagram-download");
            this.addOrReplace(componentArray);
            this.addOrReplace(new Component[]{new Image("diagram-print-image")});
            this.addOrReplace(new Component[]{new Image("diagram")});
            this.addOrReplace(new Component[]{new Label("error-message", (String)new ResourceModel("dashboard.report.reportdiagram.statement.error").wrapOnAssignment((Component)this).getObject()).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"message-error")))})});
            this.addOrReplace(new Component[]{new Label("error-reason", e.getMessage()).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"message-error")))})});
            log.debug(((Object)((Object)this)).getClass() + ": ", (Throwable)e);
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LabelAdaptingCategoryAxis
    extends CategoryAxis {
        private static final long serialVersionUID = 1L;
        private final float labeledTicks;

        public LabelAdaptingCategoryAxis(float labeledTicks, String label) {
            super(label);
            this.labeledTicks = labeledTicks;
        }

        public List<CategoryTick> refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
            int interval;
            List standardTicks = super.refreshTicks(g2, state, dataArea, edge);
            if (standardTicks.isEmpty() || (interval = Math.round((float)standardTicks.size() / this.labeledTicks)) < 1) {
                return standardTicks;
            }
            ArrayList<CategoryTick> newTicks = new ArrayList<CategoryTick>(standardTicks.size());
            for (int i = 0; i < standardTicks.size(); i += interval) {
                if (i % interval != 0) continue;
                CategoryTick tick = (CategoryTick)standardTicks.get(i);
                TextBlock textBlock = new TextBlock();
                textBlock.addLine(tick.getCategory().toString().substring(0, Math.min(tick.getCategory().toString().length(), 8)), tick.getLabel().getLastLine().getFirstTextFragment().getFont(), tick.getLabel().getLastLine().getFirstTextFragment().getPaint());
                newTicks.add(new CategoryTick(tick.getCategory(), textBlock, tick.getLabelAnchor(), tick.getRotationAnchor(), tick.getAngle()));
            }
            return newTicks;
        }
    }
}

