/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.report;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.tree.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyTreeColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.dcm4chee.dashboard.mbean.DashboardDelegator;
import org.dcm4chee.dashboard.model.ReportModel;
import org.dcm4chee.dashboard.ui.DashboardPanel;
import org.dcm4chee.dashboard.ui.common.DashboardTreeTable;
import org.dcm4chee.dashboard.ui.config.delegate.DashboardCfgDelegate;
import org.dcm4chee.dashboard.ui.report.CreateGroupPage;
import org.dcm4chee.dashboard.ui.report.DynamicLinkPanel;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.icons.behaviours.ImageSizeBehaviour;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.dcm4chee.web.common.markup.ModalWindowLink;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ReportPanel.class);
    private static final ResourceReference DashboardCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-style.css");
    private ModalWindow createGroupWindow;
    private ModalWindow modalWindow;

    public ReportPanel(String id) {
        super(id);
        if (DashboardCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)DashboardCSS)});
        }
        Component[] componentArray = new Component[1];
        this.createGroupWindow = new ModalWindow("create-group-window").setPageCreator(new ModalWindow.PageCreator(){
            private static final long serialVersionUID = 1L;

            public Page createPage() {
                return new CreateGroupPage(ReportPanel.this.createGroupWindow);
            }
        });
        componentArray[0] = this.createGroupWindow;
        this.add(componentArray);
        int[] winSize = DashboardCfgDelegate.getInstance().getWindowSize("createGroup");
        this.add(new Component[]{new ModalWindowLink("toggle-group-form-link", this.createGroupWindow, winSize[0], winSize[1]).add(new Component[]{new Image("toggle-group-form-image", ImageManager.IMAGE_COMMON_ADD).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new Component[]{new Label("dashboard.report.add-group-form.title", (IModel)new ResourceModel("dashboard.report.add-group-form.title"))}).add(new IBehavior[]{new TooltipBehaviour("dashboard.report.")}).add(new IBehavior[]{new SecurityBehavior(ReportPanel.getModuleName() + ":newGroupLink")})});
        Component[] componentArray2 = new Component[1];
        this.modalWindow = new ModalWindow("modal-window");
        componentArray2[0] = this.modalWindow;
        this.add(componentArray2);
    }

    public void onBeforeRender() {
        super.onBeforeRender();
        try {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new ReportModel());
            for (ReportModel group : DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).listAllReports(true)) {
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode();
                groupNode.setUserObject(group);
                rootNode.add(groupNode);
                for (ReportModel report : DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).listAllReports(false)) {
                    if (report.getGroupUuid() == null || !report.getGroupUuid().equals(group.getUuid())) continue;
                    DefaultMutableTreeNode reportNode = new DefaultMutableTreeNode();
                    reportNode.setUserObject(report);
                    groupNode.add(reportNode);
                }
            }
            ReportTreeTable reportTreeTable = new ReportTreeTable("report-tree-table", new DefaultTreeModel(rootNode), new IColumn[]{new PropertyTreeColumn(new ColumnLocation(ColumnLocation.Alignment.LEFT, 44, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.report.table.title_title").wrapOnAssignment((Component)this).getObject(), "userObject.title"), new DynamicRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 10, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.report.table.link.edit").wrapOnAssignment((Component)this).getObject(), "CreateOrEditReportLink", this.modalWindow), new DynamicRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 10, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.report.table.link.remove").wrapOnAssignment((Component)this).getObject(), "RemoveLink", this.modalWindow), new DynamicRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 10, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.report.table.link.diagram").wrapOnAssignment((Component)this).getObject(), "DisplayDiagramLink", this.modalWindow), new DynamicRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 10, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.report.table.link.table").wrapOnAssignment((Component)this).getObject(), "DisplayTableLink", this.modalWindow), new DynamicRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 15, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.report.table.link.diagram+table").wrapOnAssignment((Component)this).getObject(), "DisplayDiagramAndTableLink", this.modalWindow)});
            reportTreeTable.setRootLess(true);
            reportTreeTable.getTreeState().expandAll();
            reportTreeTable.getTreeState().setAllowSelectMultiple(false);
            this.addOrReplace(new Component[]{reportTreeTable});
        }
        catch (Exception e) {
            log.error(((Object)((Object)this)).getClass().toString() + ": " + "onBeforeRender: " + e.getMessage());
            log.debug("Exception: ", (Throwable)e);
            throw new WicketRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String getModuleName() {
        return "dashboard.report";
    }

    private class DynamicRenderableColumn
    extends AbstractColumn {
        private static final long serialVersionUID = 1L;
        private String className;
        private ModalWindow modalWindow;

        public DynamicRenderableColumn(ColumnLocation location, String header, String className, ModalWindow modalWindow) {
            super(location, header);
            this.className = className;
            this.modalWindow = modalWindow;
        }

        public IRenderable newCell(TreeNode node, int level) {
            return null;
        }

        public Component newCell(MarkupContainer parent, String id, TreeNode node, int level) {
            return new DynamicLinkPanel(id, this.className, (ReportModel)((DefaultMutableTreeNode)node).getUserObject(), this.modalWindow);
        }
    }

    private class ReportTreeTable
    extends DashboardTreeTable {
        private static final long serialVersionUID = 1L;

        public ReportTreeTable(String id, TreeModel model, IColumn[] columns) {
            super(id, model, columns);
        }

        protected Component newNodeIcon(MarkupContainer parent, String id, final TreeNode node) {
            return new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("style", (CharSequence)("background-image: url('" + (((ReportModel)((DefaultMutableTreeNode)node).getUserObject()).getGroupUuid() == null ? this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_REPORT_FOLDER) : this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_REPORT)) + "')"));
                    tag.put("title", (CharSequence)((ReportModel)((DefaultMutableTreeNode)node).getUserObject()).getStatement());
                }
            };
        }
    }
}

