/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.report;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.apache.wicket.validation.IValidator;
import org.dcm4chee.dashboard.mbean.DashboardDelegator;
import org.dcm4chee.dashboard.model.ReportModel;
import org.dcm4chee.dashboard.ui.DashboardPanel;
import org.dcm4chee.dashboard.ui.util.DatabaseUtils;
import org.dcm4chee.dashboard.ui.validator.ReportTitleValidator;
import org.dcm4chee.dashboard.ui.validator.SQLSelectStatementValidator;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.markup.BaseForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOrEditReportPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(CreateOrEditReportPage.class);
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private static final ResourceReference DashboardCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-style.css");
    protected ModalWindow window;
    private ReportModel report;
    String[] diagramOptionsTypes;
    String[] diagramOptionsTooltips;
    private Label resultMessage;

    public CreateOrEditReportPage(ModalWindow window, ReportModel report) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        if (DashboardCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)DashboardCSS)});
        }
        ReportModel reportModel = this.report = report == null ? new ReportModel() : report;
        if (this.report.getGroupUuid() == null) {
            this.report.setGroupUuid(this.report.getUuid());
            this.report.setUuid(null);
            this.report.setTitle(null);
        }
        this.window = window;
        Component[] componentArray = new Component[1];
        this.resultMessage = new Label("result-message");
        componentArray[0] = this.resultMessage;
        this.add(componentArray);
        this.resultMessage.setOutputMarkupId(true);
        this.resultMessage.setDefaultModel((IModel)new Model((Serializable)((Object)"")));
        this.add(new Component[]{new WebMarkupContainer("create-page-title").setVisible(this.report.getUuid() == null)});
        this.add(new Component[]{new WebMarkupContainer("edit-page-title").setVisible(this.report.getUuid() != null)});
    }

    public void onBeforeRender() {
        super.onBeforeRender();
        try {
            this.diagramOptionsTypes = ((String)new ResourceModel("dashboard.report.createoredit.diagram.options.types").wrapOnAssignment((Component)this).getObject()).split(";");
            this.diagramOptionsTooltips = ((String)new ResourceModel("dashboard.report.createoredit.diagram.options.tooltips").wrapOnAssignment((Component)this).getObject()).split(";");
            this.addOrReplace(new Component[]{new CreateOrEditReportForm("create-or-edit-report-form", this.report, this.resultMessage, this.window)});
        }
        catch (Exception e) {
            log.error(((Object)((Object)this)).getClass().toString() + ": " + "onBeforeRender: " + e.getMessage());
            log.debug("Exception: ", (Throwable)e);
            throw new WicketRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private final class CreateOrEditReportForm
    extends BaseForm {
        private static final long serialVersionUID = 1L;

        public CreateOrEditReportForm(String id, ReportModel report, final Label resultMessage, final ModalWindow window) throws InstanceNotFoundException, MalformedObjectNameException, AttributeNotFoundException, ReflectionException, MBeanException, NullPointerException {
            super(id);
            final ReportModel thisReport = report == null ? new ReportModel(UUID.randomUUID().toString(), null, null, null, null, false, null, null) : report;
            this.add(new Component[]{new TextField("dashboard.report.createoredit.form.title.input", (IModel)new PropertyModel((Object)thisReport, "title")).setRequired(true).add((IValidator)new ReportTitleValidator()).add(new IBehavior[]{new AttributeModifier("size", true, (IModel)new ResourceModel("dashboard.report.createoredit.form.title.columns"))})});
            this.add(new Component[]{new DropDownChoice("report-datasource-dropdown-choice", (IModel)new PropertyModel((Object)thisReport, "dataSource"), Arrays.asList(DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).getDataSources())).setNullValid(true)});
            this.add(new Component[]{new TextArea("dashboard.report.createoredit.form.statement.input", (IModel)new PropertyModel((Object)thisReport, "statement")).setRequired(true).add((IValidator)new SQLSelectStatementValidator()).add(new IBehavior[]{new AttributeModifier("rows", true, (IModel)new ResourceModel("dashboard.report.createoredit.form.statement.rows"))}).add(new IBehavior[]{new AttributeModifier("cols", true, (IModel)new ResourceModel("dashboard.report.createoredit.form.statement.columns"))})});
            this.add(new Component[]{new AjaxFallbackButton("statement-test-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    block20: {
                        block15: {
                            block19: {
                                block14: {
                                    block18: {
                                        block13: {
                                            message = null;
                                            jdbcConnection = null;
                                            try {
                                                try {
                                                    if (DatabaseUtils.isConfigurableStatement(thisReport.getStatement())) {
                                                        message = (String)new ResourceModel("dashboard.report.createoredit.form.statement-test-submit.configurable-statement-message").wrapOnAssignment((Component)this.getParent()).getObject();
                                                        var7_5 = null;
                                                        break block13;
                                                    }
                                                    dataSourceName = null;
                                                    dataSourceName = form.get("report-datasource-dropdown-choice").getDefaultModelObject();
                                                    if (dataSourceName == null) {
                                                        message = (String)new ResourceModel("dashboard.report.createoredit.form.statement-test-submit.no-datasource-message").wrapOnAssignment((Component)this.getParent()).getObject();
                                                        break block14;
                                                    }
                                                    jdbcConnection = ((DataSource)new InitialContext().lookup(dataSourceName.toString())).getConnection();
                                                    jdbcConnection.createStatement(1005, 1007).executeQuery(thisReport.getStatement()).close();
                                                    break block15;
                                                }
                                                catch (Exception e) {
                                                    message = e.getLocalizedMessage();
                                                    var7_8 = null;
                                                    try {
                                                        jdbcConnection.close();
                                                    }
                                                    catch (Exception ignore) {
                                                        // empty catch block
                                                    }
                                                    resultMessage.setDefaultModel((IModel)new Model((Serializable)(((String)new ResourceModel(message == null ? "dashboard.report.createoredit.form.statement-test-submit.success-message" : "dashboard.report.createoredit.form.statement-test-submit.failure-message").wrapOnAssignment((Component)this.getParent()).getObject()).toString() + (message == null ? "" : message)))).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)(message == null ? "result-message" : "error-message")))});
                                                    target.addComponent((Component)resultMessage);
                                                    return;
                                                }
                                            }
                                            catch (Throwable var6_17) {
                                                block17: {
                                                    var7_9 = null;
                                                    ** try [egrp 2[TRYBLOCK] [8 : 178->188)] { 
lbl37:
                                                    // 1 sources

                                                    jdbcConnection.close();
                                                    break block17;
lbl39:
                                                    // 1 sources

                                                    catch (Exception ignore) {
                                                        // empty catch block
                                                    }
                                                }
                                                resultMessage.setDefaultModel((IModel)new Model((Serializable)(((String)new ResourceModel(message == null ? "dashboard.report.createoredit.form.statement-test-submit.success-message" : "dashboard.report.createoredit.form.statement-test-submit.failure-message").wrapOnAssignment((Component)this.getParent()).getObject()).toString() + (message == null ? "" : message)))).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)(message == null ? "result-message" : "error-message")))});
                                                target.addComponent((Component)resultMessage);
                                                throw var6_17;
                                            }
                                        }
                                        ** try [egrp 2[TRYBLOCK] [8 : 178->188)] { 
lbl48:
                                        // 1 sources

                                        jdbcConnection.close();
                                        break block18;
lbl50:
                                        // 1 sources

                                        catch (Exception ignore) {
                                            // empty catch block
                                        }
                                    }
                                    resultMessage.setDefaultModel((IModel)new Model((Serializable)(((String)new ResourceModel(message == null ? "dashboard.report.createoredit.form.statement-test-submit.success-message" : "dashboard.report.createoredit.form.statement-test-submit.failure-message").wrapOnAssignment((Component)this.getParent()).getObject()).toString() + (message == null ? "" : message)))).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)(message == null ? "result-message" : "error-message")))});
                                    target.addComponent((Component)resultMessage);
                                    return;
                                }
                                var7_6 = null;
                                ** try [egrp 2[TRYBLOCK] [8 : 178->188)] { 
lbl60:
                                // 1 sources

                                jdbcConnection.close();
                                break block19;
lbl62:
                                // 1 sources

                                catch (Exception ignore) {
                                    // empty catch block
                                }
                            }
                            resultMessage.setDefaultModel((IModel)new Model((Serializable)(((String)new ResourceModel(message == null ? "dashboard.report.createoredit.form.statement-test-submit.success-message" : "dashboard.report.createoredit.form.statement-test-submit.failure-message").wrapOnAssignment((Component)this.getParent()).getObject()).toString() + (message == null ? "" : message)))).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)(message == null ? "result-message" : "error-message")))});
                            target.addComponent((Component)resultMessage);
                            return;
                        }
                        var7_7 = null;
                        ** try [egrp 2[TRYBLOCK] [8 : 178->188)] { 
lbl72:
                        // 1 sources

                        jdbcConnection.close();
                        break block20;
lbl74:
                        // 1 sources

                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    resultMessage.setDefaultModel((IModel)new Model((Serializable)(((String)new ResourceModel(message == null ? "dashboard.report.createoredit.form.statement-test-submit.success-message" : "dashboard.report.createoredit.form.statement-test-submit.failure-message").wrapOnAssignment((Component)this.getParent()).getObject()).toString() + (message == null ? "" : message)))).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)(message == null ? "result-message" : "error-message")))});
                    target.addComponent((Component)resultMessage);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }
            }});
            this.add(new Component[]{new DropDownChoice("report-diagram-dropdown-choice", (IModel)new PropertyModel((Object)thisReport, "diagram"), (IModel)new ListModel<Integer>(){
                private static final long serialVersionUID = 1L;

                public List<Integer> getObject() {
                    return new AbstractList<Integer>(){

                        @Override
                        public Integer get(int i) {
                            return new Integer(i);
                        }

                        @Override
                        public int size() {
                            return CreateOrEditReportPage.this.diagramOptionsTypes.length;
                        }
                    };
                }
            }, (IChoiceRenderer)new ChoiceRenderer<Integer>(){
                private static final long serialVersionUID = 1L;

                public Object getDisplayValue(Integer index) {
                    return index == null ? null : CreateOrEditReportPage.this.diagramOptionsTypes[index] + " (" + CreateOrEditReportPage.this.diagramOptionsTooltips[index] + ")";
                }
            }).setNullValid(true)});
            this.add(new Component[]{new CheckBox("report-table-checkbox", (IModel)new PropertyModel((Object)thisReport, "table"))});
            this.add(new Component[]{new AjaxFallbackButton("form-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    try {
                        thisReport.setStatement(thisReport.getStatement().replaceAll("(, )|(,)", ", "));
                        if (thisReport == null || thisReport.getUuid() == null) {
                            DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).createReport(thisReport, false);
                        } else {
                            DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).updateReport(thisReport);
                        }
                        window.close(target);
                    }
                    catch (Exception e) {
                        log.error(((Object)((Object)this)).getClass().toString() + ": " + "onSubmit: " + e.getMessage());
                        log.debug("Exception: ", (Throwable)e);
                        throw new WicketRuntimeException(e.getLocalizedMessage(), (Throwable)e);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }
            }});
        }
    }
}

