/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.report;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.dcm4chee.dashboard.model.ReportModel;
import org.dcm4chee.dashboard.ui.DashboardPanel;
import org.dcm4chee.dashboard.ui.report.display.DynamicDisplayPage;
import org.dcm4chee.dashboard.ui.util.DatabaseUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.dcm4chee.web.common.markup.BaseForm;
import org.dcm4chee.web.common.markup.SimpleDateTimeField;
import org.dcm4chee.web.common.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureReportPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ConfigureReportPage.class);
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private static final ResourceReference DashboardBaseCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-style.css");
    private ReportModel report;
    protected ModalWindow window;
    private boolean diagram;
    private boolean table;
    private Label resultMessage;

    public ConfigureReportPage(ModalWindow window, ReportModel report, boolean diagram, boolean table) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        if (DashboardBaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)DashboardBaseCSS)});
        }
        try {
            this.report = report;
            this.window = window;
            this.diagram = diagram;
            this.table = table;
            Component[] componentArray = new Component[1];
            this.resultMessage = new Label("result-message");
            componentArray[0] = this.resultMessage;
            this.add(componentArray);
            this.resultMessage.setOutputMarkupId(true);
            this.resultMessage.setDefaultModel((IModel)new Model((Serializable)((Object)"")));
            this.add(new Component[]{new ConfigureReportForm("configure-report-form", this.report, this.resultMessage, this.window)});
        }
        catch (Exception e) {
            log.error(((Object)((Object)this)).getClass().toString() + ": " + "init: " + e.getMessage());
            log.debug("Exception: ", (Throwable)e);
            throw new WicketRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void onBeforeRender() {
        super.onBeforeRender();
        if (!DatabaseUtils.isConfigurableStatement(this.report.getStatement())) {
            this.redirectToInterceptPage((Page)new DynamicDisplayPage(this.report, null, this.diagram, this.table));
        }
    }

    private final class ConfigureReportForm
    extends BaseForm {
        private static final long serialVersionUID = 1L;
        private Map<String, String> parameters;

        public ConfigureReportForm(String id, final ReportModel report, final Label resultMessage, final ModalWindow window) throws InstanceNotFoundException, MalformedObjectNameException, AttributeNotFoundException, ReflectionException, MBeanException, NullPointerException {
            super(id);
            this.parameters = new HashMap<String, String>();
            this.add(new Component[]{new Label("dashboard.report.configure.form.title.name", (IModel)new PropertyModel((Object)report, "title")).add(new IBehavior[]{new AttributeModifier("size", true, (IModel)new ResourceModel("dashboard.report.configure.form.title.columns"))})});
            RepeatingView variableRows = new RepeatingView("variable-rows");
            this.add(new Component[]{variableRows});
            for (final String parameterName : DatabaseUtils.getParameterSet(report.getStatement())) {
                WebMarkupContainer parameterRow = new WebMarkupContainer(parameterName);
                parameterRow.add(new Component[]{new Label("variable-name", parameterName.toString())});
                variableRows.add(new Component[]{parameterRow});
                if (parameterName.toString().startsWith("date")) {
                    Component[] componentArray = new Component[1];
                    SimpleDateTimeField dtf = new SimpleDateTimeField("date-variable-value", (IModel)new IModel<Date>(){
                        private static final long serialVersionUID = 1L;

                        public void setObject(Date value) {
                            ConfigureReportForm.this.parameters.put(parameterName, value != null ? DateFormat.getDateTimeInstance(3, 3, ConfigureReportForm.this.getSession().getLocale()).format(value) : "");
                        }

                        public Date getObject() {
                            return null;
                        }

                        public void detach() {
                        }
                    });
                    componentArray[0] = dtf;
                    parameterRow.add(componentArray);
                    dtf.addToDateField(new IBehavior[]{new TooltipBehaviour("dashboard.report.configure.", "date-variable-value", (IModel)new AbstractReadOnlyModel<String>(){
                        private static final long serialVersionUID = 1L;

                        public String getObject() {
                            return DateUtils.getDatePattern((Component)ConfigureReportForm.this.getParent());
                        }
                    })});
                    dtf.addToTimeField(new IBehavior[]{new TooltipBehaviour("dashboard.report.configure.", "date-variable-value.timeField")});
                    parameterRow.add(new Component[]{new TextField("variable-value").setVisible(false)});
                    continue;
                }
                parameterRow.add(new Component[]{new TextField("variable-value", (IModel)new Model<String>(){
                    private static final long serialVersionUID = 1L;

                    public void setObject(String value) {
                        ConfigureReportForm.this.parameters.put(parameterName, value != null ? value : "");
                    }
                }).setVisible(!parameterName.toString().startsWith("date"))});
                parameterRow.add(new Component[]{new Label("date-variable-value").setVisible(false)});
            }
            this.add(new Component[]{new AjaxFallbackButton("form-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    String message = null;
                    try {
                        if (report.getDataSource() == null) {
                            message = (String)new ResourceModel("dashboard.report.configure.form.statement-test-submit.no-datasource-message").wrapOnAssignment((Component)this.getParent()).getObject();
                            return;
                        }
                        window.setResponsePage((Page)new DynamicDisplayPage(report, ConfigureReportForm.this.parameters, ConfigureReportPage.this.diagram, ConfigureReportPage.this.table));
                    }
                    catch (Exception e) {
                        message = e.getLocalizedMessage();
                        log.debug("Exception: ", (Throwable)e);
                        resultMessage.setDefaultModel((IModel)new Model((Serializable)((Object)(((String)new ResourceModel("dashboard.report.configure.form.form-submit.failure-message").wrapOnAssignment((Component)this.getParent()).getObject()).toString() + (message == null ? "" : message))))).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"message-error")))}).setVisible(true);
                        target.addComponent((Component)resultMessage);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }
            }});
        }
    }
}

