/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.messaging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyRenderableColumn;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyTreeColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.ResourceModel;
import org.dcm4chee.dashboard.mbean.DashboardDelegator;
import org.dcm4chee.dashboard.model.QueueDepthModel;
import org.dcm4chee.dashboard.model.QueueDepthTupel;
import org.dcm4chee.dashboard.ui.DashboardPanel;
import org.dcm4chee.dashboard.ui.common.DashboardTreeTable;
import org.dcm4chee.dashboard.ui.messaging.SideColumnsView;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(QueuePanel.class);
    private static final ResourceReference DashboardCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-style.css");
    public static final String CONNECTION_FACTORY = "java:ConnectionFactory";
    private Map<String, List<QueueDepthTupel>> queueDepthConfig = new HashMap<String, List<QueueDepthTupel>>();

    public QueuePanel(String id) {
        super(id);
        if (DashboardCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)DashboardCSS)});
        }
        try {
            DashboardDelegator dashboardDelegator = DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName"));
            String[] queueModelStrings = dashboardDelegator.listQueueDepthConfig();
            for (int i = 0; i < queueModelStrings.length; ++i) {
                QueueDepthModel queueDepthModel = (QueueDepthModel)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)queueModelStrings[i]), QueueDepthModel.class);
                ListIterator iterator = JSONArray.fromObject((Object)queueDepthModel.getDepths()).listIterator();
                ArrayList<QueueDepthTupel> tupelList = new ArrayList<QueueDepthTupel>();
                while (iterator.hasNext()) {
                    tupelList.add((QueueDepthTupel)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)((JSONObject)iterator.next()).toString()), QueueDepthTupel.class));
                }
                Collections.sort(tupelList);
                this.queueDepthConfig.put(queueDepthModel.getDomain() + ":" + queueDepthModel.getName(), tupelList);
            }
        }
        catch (Exception e) {
            log.error("Error fetching queue depth colors from DashboardService", (Throwable)e);
        }
    }

    public void onBeforeRender() {
        super.onBeforeRender();
        Object connection = null;
        InitialContext initialContext = null;
        try {
            Session session = ((QueueConnectionFactory)new InitialContext().lookup(CONNECTION_FACTORY)).createQueueConnection().createSession(false, 1);
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new QueueModel());
            DashboardDelegator dashboardDelegator = DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName"));
            for (String[] queueName : dashboardDelegator.listQueueNames()) {
                int[] counts = dashboardDelegator.listQueueAttributes(queueName[0], queueName[1]);
                QueueModel queueModel = new QueueModel(queueName[0], queueName[1]);
                queueModel.setQueue(true);
                queueModel.setMessageCount(counts == null ? -1 : counts[0]);
                queueModel.setDeliveringCount(counts == null ? -1 : counts[1]);
                queueModel.setScheduledMessageCount(counts == null ? -1 : counts[2]);
                queueModel.setConsumerCount(counts == null ? -1 : counts[3]);
                DefaultMutableTreeNode queueNode = new DefaultMutableTreeNode(queueModel);
                rootNode.add(queueNode);
                List<QueueDepthTupel> tupelList = this.queueDepthConfig.get(queueModel.getDomainName() + ":" + queueModel.getJndiName());
                if (tupelList != null) {
                    for (QueueDepthTupel tupel : tupelList) {
                        if (tupel.getDepth() > queueModel.getMessageCount()) break;
                        queueModel.setColor(tupel.getColor());
                    }
                }
                try {
                    Enumeration e = session.createBrowser((Queue)new InitialContext().lookup("/queue/" + queueName)).getEnumeration();
                    while (e.hasMoreElements()) {
                        Message m = (Message)e.nextElement();
                        QueueModel queueMessage = new QueueModel(m.getJMSMessageID());
                        queueMessage.setQueue(false);
                        queueNode.add(new DefaultMutableTreeNode(queueMessage));
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            QueueTreeTable queueTreeTable = new QueueTreeTable("queue-tree-table", new DefaultTreeModel(rootNode), new IColumn[]{new PropertyTreeColumn(new ColumnLocation(ColumnLocation.Alignment.LEFT, 25, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.queue.table.column.name").wrapOnAssignment((Component)this).getObject(), "userObject.jndiName"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 18, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.queue.table.column.domain").wrapOnAssignment((Component)this).getObject(), "userObject.domainName"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 12, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.queue.table.column.messageCount").wrapOnAssignment((Component)this).getObject(), "userObject.messageCount"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 12, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.queue.table.column.deliveringCount").wrapOnAssignment((Component)this).getObject(), "userObject.deliveringCount"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 16, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.queue.table.column.scheduledMessageCount").wrapOnAssignment((Component)this).getObject(), "userObject.scheduledMessageCount"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 12, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.queue.table.column.consumerCount").wrapOnAssignment((Component)this).getObject(), "userObject.consumerCount")});
            queueTreeTable.getTreeState().setAllowSelectMultiple(true);
            queueTreeTable.getTreeState().collapseAll();
            queueTreeTable.setRootLess(true);
            this.addOrReplace(new Component[]{queueTreeTable});
        }
        catch (Exception e) {
            log.error(((Object)((Object)this)).getClass().toString() + ": " + "onBeforeRender: " + e.getMessage());
            log.debug("Exception: ", (Throwable)e);
            throw new WicketRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException ignore) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException ignore) {}
            }
        }
    }

    public static String getModuleName() {
        return "dashboard.queue";
    }

    protected class QueueModel
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private String jndiName;
        private String domainName;
        private int messageCount;
        private int deliveringCount;
        private int scheduledMessageCount;
        private int consumerCount;
        private boolean isQueue;
        private String color;

        public QueueModel() {
        }

        public QueueModel(String jndiName) {
            this.jndiName = jndiName;
        }

        public QueueModel(String domainName, String jndiName) {
            this.domainName = domainName;
            this.jndiName = jndiName;
        }

        public void setJndiName(String jndiName) {
            this.jndiName = jndiName;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public void setMessageCount(int messageCount) {
            this.messageCount = messageCount;
        }

        public int getMessageCount() {
            return this.messageCount;
        }

        public void setDeliveringCount(int deliveringCount) {
            this.deliveringCount = deliveringCount;
        }

        public int getDeliveringCount() {
            return this.deliveringCount;
        }

        public void setScheduledMessageCount(int scheduledMessageCount) {
            this.scheduledMessageCount = scheduledMessageCount;
        }

        public int getScheduledMessageCount() {
            return this.scheduledMessageCount;
        }

        public void setConsumerCount(int consumerCount) {
            this.consumerCount = consumerCount;
        }

        public int getConsumerCount() {
            return this.consumerCount;
        }

        public void setQueue(boolean isQueue) {
            this.isQueue = isQueue;
        }

        public boolean isQueue() {
            return this.isQueue;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }
    }

    private class QueueTreeTable
    extends DashboardTreeTable {
        private static final long serialVersionUID = 1L;
        private IColumn[] columns;

        public QueueTreeTable(String id, TreeModel model, IColumn[] columns) {
            super(id, model, columns);
            this.columns = columns;
        }

        protected void populateTreeItem(WebMarkupContainer item, int level) {
            super.populateTreeItem(item, level);
            TreeNode node = (TreeNode)item.getDefaultModelObject();
            SideColumnsView sideColumns = new SideColumnsView("sideColumns", node);
            item.addOrReplace(new Component[]{sideColumns});
            if (this.columns != null) {
                for (int i = 0; i < this.columns.length; ++i) {
                    Component component;
                    IColumn column = this.columns[i];
                    if (column.getLocation().getAlignment() != ColumnLocation.Alignment.LEFT && column.getLocation().getAlignment() != ColumnLocation.Alignment.RIGHT) continue;
                    IRenderable renderable = column.newCell(node, level);
                    if (renderable == null) {
                        component = column.newCell((MarkupContainer)sideColumns, "" + i, node, level);
                        sideColumns.add(new Component[]{component});
                    } else {
                        component = null;
                    }
                    sideColumns.addColumn(column, component, renderable);
                }
            }
        }

        protected Component newNodeIcon(MarkupContainer parent, String id, final TreeNode node) {
            return new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("style", (CharSequence)("background-image: url('" + (((QueueModel)((DefaultMutableTreeNode)node).getUserObject()).isQueue() ? this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_QUEUE) : this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_QUEUE_MESSAGE)) + "')"));
                }
            };
        }
    }
}

