/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.filesystem;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.management.MBeanException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyRenderableColumn;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyTreeColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.ResourceModel;
import org.dcm4chee.dashboard.mbean.DashboardDelegator;
import org.dcm4chee.dashboard.ui.DashboardPanel;
import org.dcm4chee.dashboard.ui.common.DashboardTreeTable;
import org.dcm4chee.dashboard.ui.common.JFreeChartImage;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(FileSystemPanel.class);
    private static final ResourceReference DashboardCSS = new CompressedResourceReference(DashboardPanel.class, "dashboard-style.css");
    private static final ResourceReference CSS = new CompressedResourceReference(FileSystemPanel.class, "filesystem-style.css");

    public FileSystemPanel(String id) {
        super(id);
        if (DashboardCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)DashboardCSS)});
        }
        if (CSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)CSS)});
        }
    }

    public void onBeforeRender() {
        super.onBeforeRender();
        try {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new FileSystemModel());
            for (String groupname : DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).listAllFileSystemGroups()) {
                FileSystemModel group = new FileSystemModel();
                int index = groupname.indexOf("group=");
                if (index < 0) continue;
                group.setDirectoryPath(groupname.substring(index + 6));
                group.setDescription(groupname + ",AET=" + DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).getDefaultRetrieveAETitle(groupname));
                group.setGroup(true);
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group);
                rootNode.add(groupNode);
                File[] fileSystems = null;
                try {
                    fileSystems = DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).listFileSystemsOfGroup(groupname);
                }
                catch (MBeanException mbe) {
                    // empty catch block
                }
                if (fileSystems == null || fileSystems.length == 0) continue;
                long minBytesFree = DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).getMinimumFreeDiskSpaceOfGroup(groupname);
                for (File file : fileSystems) {
                    FileSystemModel fsm = new FileSystemModel();
                    fsm.setDirectoryPath(file.getName());
                    fsm.setDescription(file.getName().startsWith("tar:") ? file.getName() : file.getAbsolutePath());
                    fsm.setOverallDiskSpace(file.getTotalSpace() / 1000000L);
                    fsm.setUsedDiskSpace(Math.max((file.getTotalSpace() - file.getUsableSpace()) / 1000000L, 0L));
                    fsm.setFreeDiskSpace(Math.max(file.getUsableSpace() / 1000000L, 0L));
                    fsm.setMinimumFreeDiskSpace(fsm.getOverallDiskSpaceLong() == 0L ? 0L : minBytesFree / 1000000L);
                    fsm.setUsableDiskSpace(Math.max((file.getUsableSpace() - minBytesFree) / 1000000L, 0L));
                    fsm.setRemainingTime(Math.max((file.getUsableSpace() - minBytesFree) / DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).getExpectedDataVolumePerDay(groupname), 0L));
                    group.setOverallDiskSpace(group.getOverallDiskSpaceLong() + fsm.getOverallDiskSpaceLong());
                    group.setUsedDiskSpace(group.getUsedDiskSpaceLong() + fsm.getUsedDiskSpaceLong());
                    group.setFreeDiskSpace(group.getFreeDiskSpaceLong() + fsm.getFreeDiskSpaceLong());
                    group.setMinimumFreeDiskSpace(group.getMinimumFreeDiskSpaceLong() + fsm.getMinimumFreeDiskSpaceLong());
                    group.setUsableDiskSpace(group.getUsableDiskSpaceLong() + fsm.getUsableDiskSpaceLong());
                    group.setRemainingTime(group.getRemainingTime() + fsm.getRemainingTime());
                    groupNode.add(new DefaultMutableTreeNode(fsm));
                }
            }
            String[] otherFileSystems = DashboardDelegator.getInstance((String)((BaseWicketApplication)this.getApplication()).getInitParameter("DashboardServiceName")).listOtherFileSystems();
            if (otherFileSystems != null && otherFileSystems.length > 0) {
                FileSystemModel group = new FileSystemModel();
                group.setDirectoryPath((String)new ResourceModel("dashboard.filesystem.group.other").wrapOnAssignment((Component)this).getObject());
                group.setGroup(true);
                group.setRemainingTime(-1L);
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group);
                rootNode.add(groupNode);
                for (String otherFileSystem : otherFileSystems) {
                    File file = new File(otherFileSystem);
                    FileSystemModel fsm = new FileSystemModel();
                    fsm.setDirectoryPath(file.getAbsolutePath());
                    fsm.setDescription(file.getName().startsWith("tar:") ? file.getName() : file.getAbsolutePath());
                    fsm.setOverallDiskSpace(file.getTotalSpace() / 1000000L);
                    fsm.setUsedDiskSpace(Math.max((file.getTotalSpace() - file.getUsableSpace()) / 1000000L, 0L));
                    fsm.setFreeDiskSpace(Math.max(file.getUsableSpace() / 1000000L, 0L));
                    fsm.setMinimumFreeDiskSpace(fsm.getOverallDiskSpaceLong() / 1000000L);
                    fsm.setUsableDiskSpace(Math.max(file.getUsableSpace() / 1000000L, 0L));
                    fsm.setRemainingTime(-1L);
                    group.setOverallDiskSpace(group.getOverallDiskSpaceLong() + fsm.getOverallDiskSpaceLong());
                    group.setUsedDiskSpace(group.getUsedDiskSpaceLong() + fsm.getUsedDiskSpaceLong());
                    group.setFreeDiskSpace(group.getFreeDiskSpaceLong() + fsm.getFreeDiskSpaceLong());
                    group.setMinimumFreeDiskSpace(group.getMinimumFreeDiskSpaceLong() + fsm.getMinimumFreeDiskSpaceLong());
                    group.setUsableDiskSpace(group.getUsableDiskSpaceLong() + fsm.getUsableDiskSpaceLong());
                    group.setVisible(false);
                    groupNode.add(new DefaultMutableTreeNode(fsm));
                }
            }
            FileSystemTreeTable fileSystemTreeTable = new FileSystemTreeTable("filesystem-tree-table", new DefaultTreeModel(rootNode), new IColumn[]{new PropertyTreeColumn(new ColumnLocation(ColumnLocation.Alignment.LEFT, 25, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.filesystem.table.column.name").wrapOnAssignment((Component)this).getObject(), "userObject.directoryPath"), new ImageRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.MIDDLE, 30, ColumnLocation.Unit.PROPORTIONAL), (String)new ResourceModel("dashboard.filesystem.table.column.image").wrapOnAssignment((Component)this).getObject(), "userObject.directoryPath"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 7, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.filesystem.table.column.overall").wrapOnAssignment((Component)this).getObject(), "userObject.overallDiskSpaceString"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 7, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.filesystem.table.column.used").wrapOnAssignment((Component)this).getObject(), "userObject.usedDiskSpaceString"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 7, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.filesystem.table.column.free").wrapOnAssignment((Component)this).getObject(), "userObject.freeDiskSpaceString"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 7, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.filesystem.table.column.minimumfree").wrapOnAssignment((Component)this).getObject(), "userObject.minimumFreeDiskSpaceString"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 7, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.filesystem.table.column.usable").wrapOnAssignment((Component)this).getObject(), "userObject.usableDiskSpaceString"), new PropertyRenderableColumn(new ColumnLocation(ColumnLocation.Alignment.RIGHT, 10, ColumnLocation.Unit.PERCENT), (String)new ResourceModel("dashboard.filesystem.table.column.remainingtime").wrapOnAssignment((Component)this).getObject(), "userObject.remainingTimeString")});
            fileSystemTreeTable.getTreeState().setAllowSelectMultiple(true);
            fileSystemTreeTable.getTreeState().collapseAll();
            fileSystemTreeTable.setRootLess(true);
            this.addOrReplace(new Component[]{fileSystemTreeTable});
        }
        catch (Exception e) {
            log.error(((Object)((Object)this)).getClass().toString() + ": " + "onBeforeRender: " + e.getMessage());
            log.debug("Exception: ", (Throwable)e);
            throw new WicketRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String getModuleName() {
        return "dashboard.filesystem";
    }

    protected class FileSystemModel
    implements Serializable {
        private static final long serialVersionUID = -1L;
        public static final int KILO = 1000;
        public static final int MEGA = 1000000;
        private final int diskSpaceDisplayLength = 8;
        private NumberFormat memoryFormatter = DecimalFormat.getInstance();
        private NumberFormat daysFormatter;
        private String directoryPath;
        private String description;
        private long overallDiskSpace = 0L;
        private long usedDiskSpace = 0L;
        private long usableDiskSpace = 0L;
        private long freeDiskSpace = 0L;
        private long minimumFreeDiskSpace = 0L;
        private boolean isGroup = false;
        private boolean visible = true;
        private long remainingTime = 0L;

        public FileSystemModel() {
            this.memoryFormatter.setMaximumFractionDigits(3);
            this.memoryFormatter.setMinimumIntegerDigits(1);
            this.daysFormatter = DecimalFormat.getInstance();
            this.daysFormatter.setMaximumFractionDigits(0);
            this.daysFormatter.setMinimumIntegerDigits(1);
            this.daysFormatter.setGroupingUsed(false);
        }

        public void setDirectoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
        }

        public String getDirectoryPath() {
            return this.directoryPath;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setOverallDiskSpace(long overallDiskSpace) {
            this.overallDiskSpace = overallDiskSpace;
        }

        public long getOverallDiskSpaceLong() {
            return this.overallDiskSpace;
        }

        public String getOverallDiskSpaceString() {
            String overallDiskSpaceString = this.memoryFormatter.format(new Float(this.overallDiskSpace).floatValue() / 1000.0f);
            return overallDiskSpaceString.substring(0, Math.min(overallDiskSpaceString.length(), this.diskSpaceDisplayLength)) + " GB";
        }

        public void setUsedDiskSpace(long usedDiskSpace) {
            this.usedDiskSpace = usedDiskSpace;
        }

        public long getUsedDiskSpaceLong() {
            return this.usedDiskSpace;
        }

        public String getUsedDiskSpaceString() {
            String usedDiskSpaceString = this.memoryFormatter.format(new Float(this.usedDiskSpace).floatValue() / 1000.0f);
            return usedDiskSpaceString.substring(0, Math.min(usedDiskSpaceString.length(), this.diskSpaceDisplayLength)) + " GB";
        }

        public void setUsableDiskSpace(long usableDiskSpace) {
            this.usableDiskSpace = usableDiskSpace;
        }

        public long getUsableDiskSpaceLong() {
            return this.usableDiskSpace;
        }

        public String getUsableDiskSpaceString() {
            String usableDiskSpaceString = this.memoryFormatter.format(new Float(this.usableDiskSpace).floatValue() / 1000.0f);
            return usableDiskSpaceString.substring(0, Math.min(usableDiskSpaceString.length(), this.diskSpaceDisplayLength)) + " GB";
        }

        public void setFreeDiskSpace(long freeDiskSpace) {
            this.freeDiskSpace = freeDiskSpace;
        }

        public long getFreeDiskSpaceLong() {
            return this.freeDiskSpace;
        }

        public String getFreeDiskSpaceString() {
            String freeDiskSpaceString = this.memoryFormatter.format(new Float(this.freeDiskSpace).floatValue() / 1000.0f);
            return freeDiskSpaceString.substring(0, Math.min(freeDiskSpaceString.length(), this.diskSpaceDisplayLength)) + " GB";
        }

        public void setMinimumFreeDiskSpace(long minimumFreeDiskSpace) {
            this.minimumFreeDiskSpace = minimumFreeDiskSpace;
        }

        public long getMinimumFreeDiskSpaceLong() {
            return this.minimumFreeDiskSpace;
        }

        public String getMinimumFreeDiskSpaceString() {
            String minimumFreeDiskSpaceString = this.memoryFormatter.format(new Float(this.minimumFreeDiskSpace).floatValue() / 1000.0f);
            return minimumFreeDiskSpaceString.substring(0, Math.min(minimumFreeDiskSpaceString.length(), this.diskSpaceDisplayLength)) + " GB";
        }

        public void setGroup(boolean isGroup) {
            this.isGroup = isGroup;
        }

        public boolean isGroup() {
            return this.isGroup;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setRemainingTime(long l) {
            this.remainingTime = l;
        }

        public long getRemainingTime() {
            return this.remainingTime;
        }

        public String getRemainingTimeString() {
            return this.remainingTime >= 0L ? "~ " + this.daysFormatter.format(new Float(this.remainingTime)) : "";
        }
    }

    private class FileSystemTreeTable
    extends DashboardTreeTable {
        private static final long serialVersionUID = 1L;

        public FileSystemTreeTable(String id, TreeModel model, IColumn[] columns) {
            super(id, model, columns);
        }

        protected Component newNodeIcon(MarkupContainer parent, String id, final TreeNode node) {
            return new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("style", (CharSequence)("background-image: url('" + (((FileSystemModel)((DefaultMutableTreeNode)node).getUserObject()).isGroup() ? this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_FILESYSTEM_GROUP) : (((FileSystemModel)((DefaultMutableTreeNode)node).getUserObject()).getDirectoryPath().contains("tar:") ? this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_FILESYSTEM_TAR) : this.getRequestCycle().urlFor(ImageManager.IMAGE_DASHBOARD_FILESYSTEM))) + "')"));
                    tag.put("title", (CharSequence)((FileSystemModel)((DefaultMutableTreeNode)node).getUserObject()).getDescription());
                }
            };
        }
    }

    private class ImageRenderableColumn
    extends PropertyTreeColumn {
        private static final long serialVersionUID = 1L;

        public ImageRenderableColumn(ColumnLocation location, String header, String propertyExpression) {
            super(location, header, propertyExpression);
        }

        public IRenderable newCell(TreeNode node, int level) {
            return null;
        }

        public Component newCell(MarkupContainer parent, String id, TreeNode node, int level) {
            if (!(node instanceof DefaultMutableTreeNode) || !(((DefaultMutableTreeNode)node).getUserObject() instanceof FileSystemModel)) {
                return null;
            }
            if (!((FileSystemModel)((DefaultMutableTreeNode)node).getUserObject()).isVisible()) {
                return new Label("image"){
                    private static final long serialVersionUID = 1L;

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                    }
                };
            }
            final FileSystemModel fsm = (FileSystemModel)((DefaultMutableTreeNode)node).getUserObject();
            boolean noDiskSpace = (float)fsm.getOverallDiskSpaceLong() == 0.0f;
            float used = noDiskSpace ? 0.0f : 100.0f * (float)fsm.getUsedDiskSpaceLong() / (float)fsm.getOverallDiskSpaceLong();
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            dataset.addValue(noDiskSpace ? 0.0 : (double)used, (Comparable)new Integer(1), (Comparable)((Object)""));
            dataset.addValue(noDiskSpace ? 0.0 : ((float)fsm.getMinimumFreeDiskSpaceLong() == 0.0f ? (double)(100.0f - used) : (double)(100.0f * (float)fsm.getUsableDiskSpaceLong() / (float)fsm.getOverallDiskSpaceLong())), (Comparable)new Integer(2), (Comparable)((Object)""));
            dataset.addValue(noDiskSpace ? 0.0 : (double)(100.0f * (float)Math.min(fsm.getMinimumFreeDiskSpaceLong(), fsm.getFreeDiskSpaceLong()) / (float)fsm.getOverallDiskSpaceLong()), (Comparable)new Integer(3), (Comparable)((Object)""));
            JFreeChart chart = ChartFactory.createStackedBarChart3D(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
            chart.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setForegroundAlpha(0.7f);
            NumberAxis3D numberaxis = new NumberAxis3D();
            numberaxis.setRange(new Range(0.0, 100.0));
            plot.setRangeAxis((ValueAxis)numberaxis);
            CategoryAxis3D categoryaxis = new CategoryAxis3D();
            categoryaxis.setLabel("%");
            plot.setDomainAxis((CategoryAxis)categoryaxis);
            StackedBarRenderer3D renderer = new StackedBarRenderer3D(10.0, 10.0){
                private static final long serialVersionUID = 1L;

                public Paint getItemPaint(int row, int column) {
                    if (fsm.getOverallDiskSpaceLong() <= 0L) {
                        return Color.white;
                    }
                    return row == 0 ? Color.red : (row == 1 ? Color.green : (row == 2 ? Color.yellow : Color.white));
                }
            };
            renderer.setBaseItemLabelsVisible(false);
            plot.setRenderer((CategoryItemRenderer)renderer);
            return new JFreeChartImage("image", chart, 350, 50){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    tag.setName("img");
                    super.onComponentTag(tag);
                }
            };
        }
    }
}

