/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.dashboard.ui.common;

import java.io.Serializable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.TreeTable;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.dcm4chee.icons.ImageManager;

public abstract class DashboardTreeTable
extends TreeTable {
    private static final long serialVersionUID = 1L;

    public DashboardTreeTable(String id, TreeModel model, IColumn[] columns) {
        super(id, model, columns);
        this.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"table")))});
    }

    protected Component newTreePanel(MarkupContainer parent, String id, TreeNode node, int level, TreeTable.IRenderNodeCallback renderNodeCallback) {
        return new TreeFragment(id, node, level, renderNodeCallback);
    }

    protected MarkupContainer newJunctionImage(MarkupContainer parent, String id, final TreeNode node) {
        return (MarkupContainer)new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                RequestCycle.get().getResponse().write((CharSequence)("<span class=\"" + (node.getParent() == null || node.getParent().getChildAt(node.getParent().getChildCount() - 1).equals(node) ? "junction-last" : "junction") + "\"><span class=\"" + (!node.isLeaf() ? "plus" : "corner") + "\"" + (!node.isLeaf() ? " style=\"background-image: url('" + (DashboardTreeTable.this.isNodeExpanded(node) ? this.getRequestCycle().urlFor(ImageManager.IMAGE_COMMON_COLLAPSE) : this.getRequestCycle().urlFor(ImageManager.IMAGE_COMMON_EXPAND)) + "')\"" : "") + "></span></span>"));
            }
        }.setRenderBodyOnly(true);
    }

    private class TreeFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public TreeFragment(String id, final TreeNode node, int level, final TreeTable.IRenderNodeCallback renderNodeCallback) {
            super(id, "fragment", (MarkupContainer)DashboardTreeTable.this);
            this.add(new Component[]{DashboardTreeTable.this.newIndentation((MarkupContainer)this, "indent", node, level)});
            this.add(new Component[]{DashboardTreeTable.this.newJunctionLink((MarkupContainer)this, "link", "image", node)});
            this.add(new Component[]{DashboardTreeTable.this.newNodeLink((MarkupContainer)this, "nodeLink", node).add(new Component[]{DashboardTreeTable.this.newNodeIcon((MarkupContainer)this, "icon", node)}).add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<Object>(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return renderNodeCallback.renderNode(node);
                }
            })}).setEnabled(false)});
        }
    }
}

