/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="code", uniqueConstraints={@UniqueConstraint(columnNames={"code_value", "code_designator"})})
public class Code
implements Serializable {
    private static final long serialVersionUID = 4271322436818986479L;
    private static final Logger log = Logger.getLogger(Code.class);
    private long pk;
    private String value;
    private String designator;
    private String meaning;

    @Id
    @GeneratedValue(generator="hibseq")
    @GenericGenerator(name="hibseq", strategy="seqhilo", parameters={@Parameter(name="max_lo", value="100"), @Parameter(name="sequence", value="code_pk_seq")})
    @Column(name="pk")
    public long getPk() {
        return this.pk;
    }

    public void setPk(long pk) {
        this.pk = pk;
    }

    @Column(name="code_value", nullable=false)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Column(name="code_designator", nullable=false)
    public String getDesignator() {
        return this.designator;
    }

    public void setDesignator(String designator) {
        this.designator = designator;
    }

    @Column(name="code_meaning")
    public String getMeaning() {
        return this.meaning;
    }

    public void setMeaning(String meaning) {
        this.meaning = meaning;
    }

    @PostPersist
    public void postPersit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.toString()));
        }
    }

    @PostRemove
    public void postRemove() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed " + this.toString()));
        }
    }

    public String toString() {
        return "Code[pk=" + this.pk + ", (" + this.value + ", " + this.designator + ", \"" + this.meaning + "\")]";
    }
}

