/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.dcm4chee.arr.entities.AuditRecord;
import org.dcm4chee.arr.entities.Code;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="active_part")
public class ActiveParticipant
implements Serializable {
    private static final long serialVersionUID = 513457139488147710L;
    private static final Logger log = Logger.getLogger(ActiveParticipant.class);
    private long pk;
    private AuditRecord auditRecord;
    private String userID;
    private String alternativeUserID;
    private String userName;
    private boolean userIsRequestor;
    private String networkAccessPointID;
    private int networkAccessPointType;
    private Code roleID;

    @Id
    @GeneratedValue(generator="hibseq")
    @GenericGenerator(name="hibseq", strategy="seqhilo", parameters={@Parameter(name="max_lo", value="100"), @Parameter(name="sequence", value="active_part_pk_seq")})
    @Column(name="pk")
    public long getPk() {
        return this.pk;
    }

    public void setPk(long pk) {
        this.pk = pk;
    }

    @ManyToOne
    @JoinColumn(name="audit_record_fk")
    public AuditRecord getAuditRecord() {
        return this.auditRecord;
    }

    public void setAuditRecord(AuditRecord auditRecord) {
        this.auditRecord = auditRecord;
    }

    @ManyToOne
    @JoinColumn(name="role_id_fk")
    public Code getRoleID() {
        return this.roleID;
    }

    public void setRoleID(Code roleID) {
        this.roleID = roleID;
    }

    @Column(name="user_id")
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Column(name="alt_user_id")
    public String getAlternativeUserID() {
        return this.alternativeUserID;
    }

    public void setAlternativeUserID(String alternativeUserID) {
        this.alternativeUserID = alternativeUserID;
    }

    @Column(name="user_name")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="requestor")
    public boolean getUserIsRequestor() {
        return this.userIsRequestor;
    }

    public void setUserIsRequestor(boolean userIsRequestor) {
        this.userIsRequestor = userIsRequestor;
    }

    @Column(name="net_access_pt_id")
    public String getNetworkAccessPointID() {
        return this.networkAccessPointID;
    }

    public void setNetworkAccessPointID(String id) {
        this.networkAccessPointID = id;
    }

    @Column(name="net_access_pt_type")
    public int getNetworkAccessPointType() {
        return this.networkAccessPointType;
    }

    public void setNetworkAccessPointType(int code) {
        this.networkAccessPointType = code;
    }

    @PostPersist
    public void postPersit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.toString()));
        }
    }

    @PostRemove
    public void postRemove() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed " + this.toString()));
        }
    }

    public String toString() {
        return "ActiveParticipant[pk=" + this.pk + ", id=" + this.userID + "]";
    }
}

