/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.listeners.mdb;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dcm4chee.arr.entities.AuditRecord;
import org.dcm4chee.arr.listeners.mdb.AuditRecordHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/ARRIncoming"), @ActivationConfigProperty(propertyName="maxSession", propertyValue="1")})
public class ReceiverMDB
implements MessageListener {
    private static final Logger log = Logger.getLogger(ReceiverMDB.class);
    private static final int MSG_PROMPT_LEN = 200;
    private static final String IHEYR4_TO_ATNA_XSL = "arr-iheyr4-to-atna.xsl";
    private static Templates iheYr4toATNATpl;
    @PersistenceContext(unitName="dcm4chee-arr")
    private EntityManager em;
    private XMLReader xmlReader;
    private SAXTransformerFactory tf;

    public void onMessage(Message msg) {
        if (!(msg instanceof BytesMessage)) {
            log.warn((Object)("Ignore unsupported " + msg.getClass().getName()));
            return;
        }
        try {
            BytesMessage bytesMessage = (BytesMessage)msg;
            Date receiveDate = new Date(msg.getJMSTimestamp());
            int bodyLength = (int)bytesMessage.getBodyLength();
            byte[] xmldata = new byte[bodyLength];
            bytesMessage.readBytes(xmldata, bodyLength);
            this.process(xmldata, receiveDate);
        }
        catch (Throwable e) {
            log.error((Object)"Failed processing Byte Message", e);
            return;
        }
    }

    private void process(byte[] xmldata, Date receiveDate) {
        try {
            boolean iheyr4;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start processing - " + ReceiverMDB.prompt(xmldata)));
            }
            XMLReader reader = (iheyr4 = ReceiverMDB.isIHEYr4(xmldata)) ? this.xmlFilter() : this.xmlReader();
            AuditRecord rec = new AuditRecord();
            AuditRecordHandler dh = new AuditRecordHandler(this.em, rec);
            reader.setContentHandler(dh);
            reader.setEntityResolver(dh);
            reader.setErrorHandler(dh);
            reader.setDTDHandler(dh);
            reader.parse(new InputSource(new ByteArrayInputStream(xmldata)));
            rec.setReceiveDateTime(receiveDate);
            rec.setIHEYr4(iheyr4);
            rec.setXmldata(xmldata);
            this.em.persist((Object)rec);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished processing - " + ReceiverMDB.prompt(xmldata)));
            }
        }
        catch (Throwable e) {
            log.error((Object)("Failed processing - " + ReceiverMDB.prompt(xmldata)), e);
        }
    }

    private static String prompt(byte[] data) {
        try {
            return data.length > 200 ? new String(data, 0, 200, "UTF-8") + "..." : new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private XMLReader xmlReader() throws SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = XMLReaderFactory.createXMLReader();
        }
        return this.xmlReader;
    }

    private XMLFilter xmlFilter() throws TransformerConfigurationException {
        if (this.tf == null) {
            this.tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        if (iheYr4toATNATpl == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            iheYr4toATNATpl = this.tf.newTemplates(new StreamSource(cl.getResource(IHEYR4_TO_ATNA_XSL).toString()));
        }
        return this.tf.newXMLFilter(iheYr4toATNATpl);
    }

    private static boolean isIHEYr4(byte[] xmldata) {
        int i = 0;
        while (xmldata[i++] != 60) {
        }
        if (xmldata[i] == 63) {
            while (xmldata[i++] != 60) {
            }
        }
        return xmldata[i] == 73;
    }
}

