/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.listeners.mdb;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.ejb.EJBException;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import org.apache.log4j.Logger;
import org.dcm4chee.arr.entities.ActiveParticipant;
import org.dcm4chee.arr.entities.AuditRecord;
import org.dcm4chee.arr.entities.Code;
import org.dcm4chee.arr.entities.ParticipantObject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class AuditRecordHandler
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(AuditRecordHandler.class);
    private final EntityManager em;
    private final AuditRecord rec;
    private ActiveParticipant ap;
    private ParticipantObject po;
    private StringBuffer sb = new StringBuffer(32);
    private boolean expectAuditSourceTypeCode;
    private boolean append;

    public AuditRecordHandler(EntityManager em, AuditRecord rec) {
        this.em = em;
        this.rec = rec;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.append) {
            this.sb.append(ch, start, length);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if ("EventIdentification".equals(qName)) {
            this.rec.setEventAction(attrs.getValue("EventActionCode"));
            this.rec.setEventOutcome(this.getInt(attrs, "EventOutcomeIndicator", "EventIdentification"));
            this.rec.setEventDateTime(AuditRecordHandler.parseISO8601DateTime(attrs.getValue("EventDateTime")));
        } else if ("EventID".equals(qName)) {
            this.rec.setEventID(this.toCode(attrs));
        } else if ("EventTypeCode".equals(qName)) {
            if (this.rec.getEventType() == null) {
                this.rec.setEventType(this.toCode(attrs));
            } else {
                log.info((Object)"Received Audit Record with multiple Event Type Codes. Only matching against first value supported!");
            }
        } else if ("ActiveParticipant".equals(qName)) {
            this.ap = new ActiveParticipant();
            this.ap.setAuditRecord(this.rec);
            this.ap.setUserID(AuditRecordHandler.toUpper(attrs.getValue("UserID")));
            this.ap.setAlternativeUserID(AuditRecordHandler.toUpper(attrs.getValue("AlternativeUserID")));
            this.ap.setUserName(AuditRecordHandler.toUpper(attrs.getValue("UserName")));
            this.ap.setUserIsRequestor(!"false".equalsIgnoreCase(attrs.getValue("UserIsRequestor")));
            this.ap.setNetworkAccessPointID(AuditRecordHandler.toUpper(attrs.getValue("NetworkAccessPointID")));
            this.ap.setNetworkAccessPointType(this.getInt(attrs, "NetworkAccessPointTypeCode", "ActiveParticipant"));
            this.rec.addActiveParticipant(this.ap);
        } else if ("RoleIDCode".equals(qName)) {
            if (this.ap.getRoleID() == null) {
                this.ap.setRoleID(this.toCode(attrs));
            } else {
                log.info((Object)"Received Audit Record with multiple Role ID Codes for one Active Participant. Only matching against first value supported!");
            }
        } else if ("AuditSourceIdentification".equals(qName)) {
            if (this.rec.getSourceID() == null) {
                this.rec.setSourceID(AuditRecordHandler.toUpper(attrs.getValue("AuditSourceID")));
                this.rec.setEnterpriseSiteID(AuditRecordHandler.toUpper(attrs.getValue("AuditEnterpriseSiteID")));
                this.expectAuditSourceTypeCode = true;
            } else {
                log.info((Object)"Received Audit Record with multiple Audit Source Identifications. Only matching against first value supported!");
            }
        } else if ("AuditSourceTypeCode".equals(qName)) {
            if (this.expectAuditSourceTypeCode) {
                if (this.rec.getSourceType() == 0) {
                    this.rec.setSourceType(this.getInt(attrs, "code", "AuditSourceTypeCode"));
                } else {
                    log.info((Object)"Received Audit Record with multiple Audit Source Type Codes. Only matching against first value supported!");
                }
            }
        } else if ("ParticipantObjectIdentification".equals(qName)) {
            this.po = new ParticipantObject();
            this.po.setAuditRecord(this.rec);
            this.po.setObjectID(AuditRecordHandler.toUpper(attrs.getValue("ParticipantObjectID")));
            this.po.setObjectType(this.getInt(attrs, "ParticipantObjectTypeCode", "ParticipantObjectIdentification"));
            this.po.setObjectRole(this.getInt(attrs, "ParticipantObjectTypeCodeRole", "ParticipantObjectIdentification"));
            this.po.setDataLifeCycle(this.getInt(attrs, "ParticipantObjectDataLifeCycle", "ParticipantObjectIdentification"));
            this.po.setObjectSensitivity(AuditRecordHandler.toUpper(attrs.getValue("ParticipantObjectSensitivity")));
            this.po.setObjectName(AuditRecordHandler.toUpper(attrs.getValue("ParticipantObjectName")));
            this.rec.addParticipantObject(this.po);
        } else if ("ParticipantObjectIDTypeCode".equals(qName)) {
            Code code = this.toCode(attrs);
            if (code != null) {
                this.po.setObjectIDType(code);
            } else {
                this.po.setObjectIDTypeRFC(this.getInt(attrs, "code", "ParticipantObjectIDTypeCode"));
            }
        } else if ("ParticipantObjectName".equals(qName)) {
            this.append = true;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("ActiveParticipant".equals(qName)) {
            this.ap = null;
        } else if ("AuditSourceIdentification".equals(qName)) {
            this.expectAuditSourceTypeCode = false;
        } else if ("ParticipantObjectIdentification".equals(qName)) {
            this.po = null;
        } else if ("ParticipantObjectName".equals(qName)) {
            this.po.setObjectName(AuditRecordHandler.toUpper(this.sb.toString()));
        }
        this.sb.setLength(0);
        this.append = false;
    }

    private int getInt(Attributes attrs, String attrName, String elName) {
        String val = attrs.getValue(attrName);
        if (val != null && val.trim().length() > 0) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                log.info((Object)("Expected int value but received <" + elName + " " + attrName + "=\"" + val + "\""));
            }
        }
        return 0;
    }

    private Code toCode(Attributes attrs) {
        String value = attrs.getValue("code");
        String designator = attrs.getValue("codeSystemName");
        if (value == null || designator == null) {
            return null;
        }
        String meaning = attrs.getValue("displayName");
        Code code = this.findCode(value, designator);
        if (code != null) {
            return code;
        }
        code = new Code();
        code.setValue(value);
        code.setDesignator(designator);
        code.setMeaning(meaning);
        try {
            this.em.persist((Object)code);
            return code;
        }
        catch (EJBException ex) {
            if (ex.getCause() instanceof EntityExistsException) {
                return this.findCode(value, designator);
            }
            throw ex;
        }
    }

    private Code findCode(String value, String designator) {
        List queryResult = this.em.createQuery("FROM Code c WHERE c.value = :value AND c.designator = :designator").setParameter("value", (Object)value).setParameter("designator", (Object)designator).setHint("org.hibernate.readOnly", (Object)Boolean.TRUE).getResultList();
        if (!queryResult.isEmpty()) {
            return (Code)queryResult.get(0);
        }
        return null;
    }

    private static String toUpper(String s) {
        return s != null ? s.toUpperCase() : null;
    }

    private static Date parseISO8601DateTime(String s) {
        Calendar cal;
        int tzindex = AuditRecordHandler.indexOfTimeZone(s);
        if (tzindex == -1) {
            cal = Calendar.getInstance();
        } else {
            cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(15, AuditRecordHandler.timeZoneOffset(s, tzindex));
            s = s.substring(0, tzindex);
        }
        int pos = 0;
        int len = 4;
        cal.set(1, Integer.parseInt(s.substring(pos, len)));
        if (!AuditRecordHandler.isDigit(s.charAt(pos += len))) {
            ++pos;
        }
        len = !AuditRecordHandler.isDigit(s.charAt(pos + 1)) ? 1 : 2;
        cal.set(2, Integer.parseInt(s.substring(pos, pos + len)) - 1);
        if (!AuditRecordHandler.isDigit(s.charAt(pos += len))) {
            ++pos;
        }
        len = !AuditRecordHandler.isDigit(s.charAt(pos + 1)) ? 1 : 2;
        cal.set(5, Integer.parseInt(s.substring(pos, pos + len)));
        if (!AuditRecordHandler.isDigit(s.charAt(pos += len))) {
            ++pos;
        }
        len = !AuditRecordHandler.isDigit(s.charAt(pos + 1)) ? 1 : 2;
        cal.set(11, Integer.parseInt(s.substring(pos, pos + len)));
        if (!AuditRecordHandler.isDigit(s.charAt(pos += len))) {
            ++pos;
        }
        len = !AuditRecordHandler.isDigit(s.charAt(pos + 1)) ? 1 : 2;
        cal.set(12, Integer.parseInt(s.substring(pos, pos + len)));
        int sec = 0;
        int ms = 0;
        if ((pos += 2) < s.length()) {
            if (!AuditRecordHandler.isDigit(s.charAt(pos))) {
                ++pos;
            }
            float f = Float.parseFloat(s.substring(pos));
            sec = (int)f;
            ms = (int)((f - (float)sec) * 1000.0f);
        }
        cal.set(13, sec);
        cal.set(14, ms);
        return cal.getTime();
    }

    private static int indexOfTimeZone(String s) {
        int len = s.length();
        int index = len - 1;
        char c = s.charAt(index);
        if (c == 'Z') {
            return index;
        }
        index = len - 6;
        c = s.charAt(index);
        if (c == '-' || c == '+') {
            return index;
        }
        index = len - 3;
        c = s.charAt(index);
        if (c == '-' || c == '+') {
            return index;
        }
        return -1;
    }

    private static int timeZoneOffset(String s, int tzindex) {
        char c = s.charAt(tzindex);
        if (c == 'Z') {
            return 0;
        }
        int off = Integer.parseInt(s.substring(tzindex + 1, tzindex + 3)) * 3600000;
        if (tzindex + 6 == s.length()) {
            off += Integer.parseInt(s.substring(tzindex + 4)) * 60000;
        }
        return c == '-' ? -off : off;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

