/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.util.ArrayList;
import java.util.List;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.singleton.ExtendedElectionPolicyMBean;
import org.jboss.ha.singleton.HASingletonElectionPolicyBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendedElectionPolicyBase
extends HASingletonElectionPolicyBase
implements ExtendedElectionPolicyMBean {
    private String singletonName;

    @Override
    public String getSingletonName() {
        return this.singletonName;
    }

    @Override
    public void setSingletonName(String serviceName) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Singleton name set to " + serviceName));
        }
        this.singletonName = serviceName;
    }

    @Override
    public ClusterNode pickSingleton() {
        List<ClusterNode> candidates = this.getCandidates();
        if (candidates == null) {
            this.log.debug((Object)"List of cluster node candidates where to run the singleton is null");
            return null;
        }
        return this.elect(candidates);
    }

    @Override
    public boolean isElectedMaster() {
        ClusterNode selectedNode = this.pickSingleton();
        if (selectedNode != null) {
            return selectedNode.equals(this.getHAPartition().getClusterNode());
        }
        return false;
    }

    protected List<ClusterNode> getCandidates() {
        HAPartition partition = this.getHAPartition();
        if (partition == null) {
            throw new IllegalStateException("HAPartition has not been set");
        }
        DistributedReplicantManager drm = partition.getDistributedReplicantManager();
        List nodeNames = drm.lookupReplicantsNodeNames(this.getSingletonName());
        if (nodeNames != null) {
            ClusterNode[] allNodes = partition.getClusterNodes();
            ArrayList<ClusterNode> nodesSingletonIn = new ArrayList<ClusterNode>(nodeNames.size());
            block0: for (String nodeName : nodeNames) {
                for (int i = 0; i < allNodes.length; ++i) {
                    ClusterNode node = allNodes[i];
                    if (!node.getName().equals(nodeName)) continue;
                    nodesSingletonIn.add(node);
                    continue block0;
                }
            }
            return nodesSingletonIn;
        }
        return null;
    }

    protected abstract ClusterNode elect(List<ClusterNode> var1);
}

