/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.SecurityAlertMessage;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.dcm.mppsscp.MPPSScpService;
import org.dcm4chex.archive.dcm.storescp.StoreScpService;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionDTO;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManager;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManagerHome;
import org.dcm4chex.archive.hl7.HL7ServerService;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StudyPermissionService
extends ServiceMBeanSupport {
    private ObjectName hl7ServerName;
    private ObjectName storeScpServiceName;
    private ObjectName mppsScpServiceName;
    private ObjectName contentEditServiceName;
    private TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);
    private String hl7Stylesheet;
    private String seriesStylesheet;
    private String mppsStylesheet;
    private boolean updateOnHl7Received;
    private boolean updateOnSeriesStored;
    private boolean updateOnMppsCreate;
    private boolean updateOnNewStudy;
    private final NotificationListener hl7ReceivedListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            Object[] hl7msg = (Object[])notif.getUserData();
            StudyPermissionService.this.onHl7Received((Document)hl7msg[1]);
        }
    };
    private final NotificationListener seriesStoredListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            StudyPermissionService.this.onSeriesStored((SeriesStored)notif.getUserData());
        }
    };
    private final NotificationListener mppsReceivedListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            StudyPermissionService.this.onMppsCreate((Dataset)notif.getUserData());
        }
    };
    private final NotificationListener newStudyListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            StudyPermissionService.this.onNewStudy((Dataset)notif.getUserData());
        }
    };

    public final ObjectName getHL7ServerName() {
        return this.hl7ServerName;
    }

    public final void setHL7ServerName(ObjectName hl7ServerName) {
        this.hl7ServerName = hl7ServerName;
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getMppsScpServiceName() {
        return this.mppsScpServiceName;
    }

    public final void setMppsScpServiceName(ObjectName name) {
        this.mppsScpServiceName = name;
    }

    public final ObjectName getContentEditServiceName() {
        return this.contentEditServiceName;
    }

    public final void setContentEditServiceName(ObjectName name) {
        this.contentEditServiceName = name;
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final String getHl7ReceivedStylesheet() {
        return this.hl7Stylesheet;
    }

    public final void setHl7ReceivedStylesheet(String xslPath) {
        this.hl7Stylesheet = xslPath;
    }

    public final String getSeriesStoredStylesheet() {
        return this.seriesStylesheet;
    }

    public final void setSeriesStoredStylesheet(String xslPath) {
        this.seriesStylesheet = xslPath;
    }

    public final String getMppsCreateStylesheet() {
        return this.mppsStylesheet;
    }

    public final void setMppsCreateStylesheet(String xslPath) {
        this.mppsStylesheet = xslPath;
    }

    public final boolean isUpdateOnHl7Received() {
        return this.updateOnHl7Received;
    }

    public final void setUpdateOnHl7Received(boolean updateOnHl7Received) {
        this.updateOnHl7Received = updateOnHl7Received;
    }

    public final boolean isUpdateOnMppsCreate() {
        return this.updateOnMppsCreate;
    }

    public final void setUpdateOnMppsCreate(boolean updateOnMppsCreate) {
        this.updateOnMppsCreate = updateOnMppsCreate;
    }

    public final boolean isUpdateOnSeriesStored() {
        return this.updateOnSeriesStored;
    }

    public final void setUpdateOnSeriesStored(boolean updateOnSeriesStored) {
        this.updateOnSeriesStored = updateOnSeriesStored;
    }

    public boolean isUpdateOnNewStudy() {
        return this.updateOnNewStudy;
    }

    public void setUpdateOnNewStudy(boolean updateOnNewStudy) {
        this.updateOnNewStudy = updateOnNewStudy;
    }

    private StudyPermissionManager getStudyPermissionManager() throws Exception {
        StudyPermissionManagerHome home = (StudyPermissionManagerHome)EJBHomeFactory.getFactory().lookup(StudyPermissionManagerHome.class, "ejb/StudyPermissionManager");
        return home.create();
    }

    public boolean hasPermission(String suid, String action, String role) throws Exception {
        return this.getStudyPermissionManager().hasPermission(suid, action, role);
    }

    public Collection findByPatientPk(long pk) throws Exception {
        return this.getStudyPermissionManager().findByPatientPk(new Long(pk));
    }

    public Collection findByStudyIuid(String suid) throws Exception {
        return this.getStudyPermissionManager().findByStudyIuid(suid);
    }

    public Collection findByStudyIuidAndAction(String suid, String action) throws Exception {
        return this.getStudyPermissionManager().findByStudyIuidAndAction(suid, action);
    }

    public int grant(String suid, String actions, String role) throws Exception {
        String[] newActions = StringUtils.split((String)actions, (char)',');
        int success = this.getStudyPermissionManager().grant(suid, newActions, role);
        this.logSecurityAlert(success == newActions.length, "Grant StudyPermission: StudyIuid=" + suid + " role=" + role + " actions:" + actions);
        return success;
    }

    public boolean revoke(StudyPermissionDTO dto) throws Exception {
        boolean granted = this.getStudyPermissionManager().revoke(dto);
        String desc = "Revoke StudyPermission: StudyIuid=" + dto.getStudyIuid() + " role=" + dto.getRole() + " action:" + dto.getAction();
        this.logSecurityAlert(granted, desc);
        return granted;
    }

    public Collection grantForPatient(long patPk, String actions, String role) throws Exception {
        try {
            Collection suids = this.getStudyPermissionManager().grantForPatient(patPk, StringUtils.split((String)actions, (char)','), role);
            if (suids.size() > 0) {
                String desc = "Grant StudyPermissions for patient patPk:" + patPk + " StudyIuids:" + this.toString(suids) + " role=" + role + " actions:" + actions;
                this.logSecurityAlert(true, desc);
            } else {
                this.log.warn((Object)("No studies found to grant StudyPermissions for patient patPk:" + patPk));
            }
            return suids;
        }
        catch (Exception x) {
            this.logSecurityAlert(false, "Grant StudyPermissions for patient: patPk:" + patPk + "actions:" + actions + " role:" + role);
            throw x;
        }
    }

    public Collection grantForPatient(String pid, String issuer, String actions, String role) throws Exception {
        try {
            Collection suids = this.getStudyPermissionManager().grantForPatient(pid, issuer, StringUtils.split((String)actions, (char)','), role);
            if (suids.size() > 0) {
                String desc = "Grant StudyPermissions for patient patID:" + pid + " issuer:" + issuer + " StudyIuids:" + this.toString(suids) + " role=" + role + " actions:" + actions;
                this.logSecurityAlert(true, desc);
            } else {
                this.log.warn((Object)("No studies found to grant StudyPermissions for patient patID:" + pid + " issuer:" + issuer));
            }
            return suids;
        }
        catch (Exception x) {
            this.logSecurityAlert(false, "Grant StudyPermissions for patient: pid:" + pid + " issuer:" + issuer + "actions:" + actions + " role:" + role);
            throw x;
        }
    }

    public Collection revokeForPatient(long patPk, String actions, String role) throws Exception {
        try {
            Collection suids = this.getStudyPermissionManager().revokeForPatient(patPk, StringUtils.split((String)actions, (char)','), role);
            if (suids.size() > 0) {
                String desc = "Revoke StudyPermissions for patient patPk:" + patPk + " StudyIuids:" + this.toString(suids) + " role=" + role + " actions:" + actions;
                this.logSecurityAlert(true, desc);
            } else {
                this.log.warn((Object)("No studies found to revoke StudyPermissions for patient patPk:" + patPk));
            }
            return suids;
        }
        catch (Exception x) {
            this.logSecurityAlert(false, "Revoke StudyPermissions for patient: patPk:" + patPk + "actions:" + actions + " role:" + role);
            throw x;
        }
    }

    public Collection revokeForPatient(String pid, String issuer, String actions, String role) throws Exception {
        try {
            Collection suids = this.getStudyPermissionManager().revokeForPatient(pid, issuer, StringUtils.split((String)actions, (char)','), role);
            if (suids.size() > 0) {
                String desc = "Revoke StudyPermissions for patient patID:" + pid + " issuer:" + issuer + " StudyIuids:" + this.toString(suids) + " role=" + role + " actions:" + actions;
                this.logSecurityAlert(true, desc);
            } else {
                this.log.warn((Object)("No studies found to revoke StudyPermissions for patient patID:" + pid + " issuer:" + issuer));
            }
            return suids;
        }
        catch (Exception x) {
            this.logSecurityAlert(false, "Revoke StudyPermissions for patient: pid:" + pid + " issuer:" + issuer + "actions:" + actions + " role:" + role);
            throw x;
        }
    }

    public int countStudiesOfPatient(Long patPk) throws Exception {
        return this.getStudyPermissionManager().countStudiesOfPatient(patPk);
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.hl7ServerName, this.hl7ReceivedListener, HL7ServerService.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.mppsScpServiceName, this.mppsReceivedListener, MPPSScpService.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.storeScpServiceName, this.newStudyListener, StoreScpService.NOTIF_FILTER_NEW_STUDY, null);
        this.server.addNotificationListener(this.contentEditServiceName, this.newStudyListener, StoreScpService.NOTIF_FILTER_NEW_STUDY, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.hl7ServerName, this.hl7ReceivedListener, HL7ServerService.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.mppsScpServiceName, this.mppsReceivedListener, MPPSScpService.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.storeScpServiceName, this.newStudyListener, StoreScpService.NOTIF_FILTER_NEW_STUDY, null);
        this.server.removeNotificationListener(this.contentEditServiceName, this.newStudyListener, StoreScpService.NOTIF_FILTER_NEW_STUDY, null);
    }

    private ContentHandler newContentHandler() {
        return new DefaultHandler(){
            private StudyPermissionManager manager;

            private StudyPermissionManager manager() throws Exception {
                if (this.manager == null) {
                    this.manager = StudyPermissionService.this.getStudyPermissionManager();
                }
                return this.manager;
            }

            public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
                try {
                    if (qName.equals("grant")) {
                        String pid = attrs.getValue("pid");
                        String issuer = attrs.getValue("issuer");
                        String suid = attrs.getValue("suid");
                        String role = attrs.getValue("role");
                        if (role == null) {
                            throw new SAXException("Missing role attribute of <grant>");
                        }
                        String action = attrs.getValue("action");
                        if (action == null) {
                            throw new SAXException("Missing action attribute of <grant>");
                        }
                        if (pid != null) {
                            StudyPermissionService.this.grantForPatient(pid, issuer, action, role);
                        }
                        if (suid != null) {
                            StudyPermissionService.this.grant(suid, action, role);
                        }
                    } else if (qName.equals("revoke")) {
                        String pid = attrs.getValue("pid");
                        String issuer = attrs.getValue("issuer");
                        String suid = attrs.getValue("suid");
                        String role = attrs.getValue("role");
                        if (role == null) {
                            throw new SAXException("Missing role attribute of <revoke>");
                        }
                        String action = attrs.getValue("action");
                        if (action == null) {
                            throw new SAXException("Missing action attribute of <revoke>");
                        }
                        String[] actions = StringUtils.split((String)action, (char)',');
                        if (pid != null) {
                            this.manager().revokeForPatient(pid, issuer, actions, role);
                        }
                        if (suid != null) {
                            this.manager().revoke(suid, actions, role);
                        }
                    }
                }
                catch (SAXException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
        };
    }

    private void onHl7Received(Document msg) {
        if (!this.updateOnHl7Received) {
            return;
        }
        try {
            File xslFile = FileUtils.toExistingFile((String)this.hl7Stylesheet);
            Transformer t = this.templates.getTemplates(xslFile).newTransformer();
            t.transform((Source)new DocumentSource(msg), new SAXResult(this.newContentHandler()));
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update permissions on HL7 received", (Throwable)e);
        }
    }

    private void onSeriesStored(SeriesStored stored) {
        if (!this.updateOnSeriesStored) {
            return;
        }
        try {
            Dataset ds = DcmObjectFactory.getInstance().newDataset();
            ds.putAll((DcmObject)stored.getPatientAttrs());
            ds.putAll((DcmObject)stored.getStudyAttrs());
            ds.putAll((DcmObject)stored.getSeriesAttrs());
            this.xslt(this.seriesStylesheet, ds, stored.getSourceAET());
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update permissions on Series stored", (Throwable)e);
        }
    }

    private void onMppsCreate(Dataset ds) {
        if (!this.updateOnMppsCreate) {
            return;
        }
        Dataset ssa = ds.getItem(4194928);
        if (ssa == null) {
            return;
        }
        try {
            this.xslt(this.mppsStylesheet, ds, ds.getString(4194881));
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update permissions on MPPS received", (Throwable)e);
        }
    }

    private void onNewStudy(Dataset ds) {
        this.log.debug((Object)"NewStudy notification received! ds:");
        this.log.debug((Object)ds);
        if (!this.updateOnNewStudy) {
            return;
        }
        try {
            ds.setPrivateCreatorID("dcm4che/archive");
            String callingAET = ds.getString(4390932);
            ds.setPrivateCreatorID(null);
            if (callingAET == null) {
                callingAET = "UNKNOWN";
            }
            this.xslt(this.seriesStylesheet, ds, callingAET);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update permissions on NewStudy received", (Throwable)e);
        }
    }

    private void xslt(String xslt, Dataset ds, String calling) throws Exception {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        File xslFile = FileUtils.toExistingFile((String)xslt);
        Templates tpl = this.templates.getTemplates(xslFile);
        TransformerHandler th = tf.newTransformerHandler(tpl);
        Transformer t = th.getTransformer();
        t.setParameter("calling", calling);
        th.setResult(new SAXResult(this.newContentHandler()));
        ds.writeDataset2((ContentHandler)th, null, null, 64, null);
    }

    private void logSecurityAlert(boolean success, String desc) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        SecurityAlertMessage msg = new SecurityAlertMessage(SecurityAlertMessage.OBJECT_SECURITY_ATTRIBUTES_CHANGED);
        msg.setOutcomeIndicator(AuditEvent.OutcomeIndicator.SUCCESS);
        msg.addReportingProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
        if (userInfo.getHostName() != null) {
            msg.addPerformingPerson(userInfo.getUserId(), null, null, userInfo.getHostName());
        } else {
            msg.addPerformingNode(AuditMessage.getLocalHostName());
        }
        msg.addAlertSubjectWithNodeID(AuditMessage.getLocalNodeID(), desc);
        msg.validate();
        Logger.getLogger((String)"auditlog").warn((Object)msg);
    }

    private String toString(Collection c) {
        if (c.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString()).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

