/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionDTO;

public class StudyPermissionDelegate {
    private final MBeanServer server;
    private ObjectName studyPermissionServiceName;

    public StudyPermissionDelegate(MBeanServer server) {
        this.server = server;
    }

    public final ObjectName getStudyPermissionServiceName() {
        return this.studyPermissionServiceName;
    }

    public final void setStudyPermissionServiceName(ObjectName serviceName) {
        this.studyPermissionServiceName = serviceName;
    }

    public boolean hasPermission(String suid, String action, String role) throws Exception {
        Boolean b = (Boolean)this.server.invoke(this.studyPermissionServiceName, "hasPermission", new Object[]{suid, action, role}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        return b;
    }

    public Collection findByPatientPk(long pk) throws Exception {
        return (Collection)this.server.invoke(this.studyPermissionServiceName, "findByPatientPk", new Object[]{new Long(pk)}, new String[]{Long.TYPE.getName()});
    }

    public Collection findByStudyIuid(String suid) throws Exception {
        return (Collection)this.server.invoke(this.studyPermissionServiceName, "findByStudyIuid", new Object[]{suid}, new String[]{String.class.getName()});
    }

    public Collection findByStudyIuidAndAction(String suid, String action) throws Exception {
        return (Collection)this.server.invoke(this.studyPermissionServiceName, "findByStudyIuidAndAction", new Object[]{suid, action}, new String[]{String.class.getName(), String.class.getName()});
    }

    public int grant(String suid, String actions, String role) throws Exception {
        Integer i = (Integer)this.server.invoke(this.studyPermissionServiceName, "grant", new Object[]{suid, actions, role}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        return i;
    }

    public boolean revoke(StudyPermissionDTO dto) throws Exception {
        Boolean b = (Boolean)this.server.invoke(this.studyPermissionServiceName, "revoke", new Object[]{dto}, new String[]{StudyPermissionDTO.class.getName()});
        return b;
    }

    public Collection grantForPatient(long patPk, String actions, String role) throws Exception {
        return (Collection)this.server.invoke(this.studyPermissionServiceName, "grantForPatient", new Object[]{new Long(patPk), actions, role}, new String[]{Long.TYPE.getName(), String.class.getName(), String.class.getName()});
    }

    public Collection grantForPatient(String pid, String issuer, String actions, String role) throws Exception {
        return (Collection)this.server.invoke(this.studyPermissionServiceName, "grantForPatient", new Object[]{pid, issuer, actions, role}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public Collection revokeForPatient(long patPk, String actions, String role) throws Exception {
        return (Collection)this.server.invoke(this.studyPermissionServiceName, "revokeForPatient", new Object[]{new Long(patPk), actions, role}, new String[]{Long.TYPE.getName(), String.class.getName(), String.class.getName()});
    }

    public Collection revokeForPatient(String pid, String issuer, String actions, String role) throws Exception {
        return (Collection)this.server.invoke(this.studyPermissionServiceName, "revokeForPatient", new Object[]{pid, issuer, actions, role}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public int countStudiesOfPatient(Long patPk) throws Exception {
        Integer i = (Integer)this.server.invoke(this.studyPermissionServiceName, "countStudiesOfPatient", new Object[]{patPk}, new String[]{Long.class.getName()});
        return i;
    }
}

