/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.Collections;
import java.util.List;
import org.dcm4chex.archive.hl7.ACK;
import org.dcm4chex.archive.hl7.PID;
import org.dom4j.Document;
import org.dom4j.Element;

class RSP
extends ACK {
    public final String queryTag;
    public final String queryResponseStatus;
    public final PID pid;

    public RSP(Document msg) {
        super(msg);
        Element qak = msg.getRootElement().element("QAK");
        if (qak == null) {
            throw new IllegalArgumentException("Missing QAK Segment");
        }
        List qakfds = qak.elements("field");
        this.queryTag = RSP.toString(qakfds.get(0));
        this.queryResponseStatus = RSP.toString(qakfds.get(1));
        this.pid = "OK".equals(this.queryResponseStatus) && !PID.isEmpty(msg) ? new PID(msg) : null;
    }

    public String toString() {
        return "RSP[code=" + this.acknowledgmentCode + ", msgID=" + this.messageControlID + ',' + ", errorMsg=" + this.textMessage + ", status=" + this.queryResponseStatus + ", pid# =" + (this.pid != null ? this.pid.countPatientIDs() : 0) + "]";
    }

    public List getPatientIDs() {
        return this.pid != null ? this.pid.getPatientIDs() : Collections.EMPTY_LIST;
    }
}

