/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.PersonName;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.FutureRSP;
import org.dcm4che.util.DTFormat;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.hl7.HL7ServerService;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.hl7.MessageTypeMatcher;
import org.dcm4chex.archive.hl7.PrefetchOrder;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.ContentHandlerAdapter;
import org.dcm4chex.archive.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXContentHandler;
import org.jboss.system.ServiceMBeanSupport;
import org.regenstrief.xhl7.HL7XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefetchService
extends AbstractScuService
implements NotificationListener,
MessageListener {
    private static final String ONLINE = "ONLINE";
    private static final String NONE = "NONE";
    private MessageTypeMatcher[] prefetchMessageTypes;
    private String prefetchSourceAET;
    private String destinationQueryAET;
    private String destinationStorageAET;
    private String xslPath;
    private String postSelectXslPath;
    private ObjectName hl7ServerName;
    private ObjectName moveScuServiceName;
    private String queueName;
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private int sourceQueryPriority = 0;
    private int destinationQueryPriority = 0;
    private int retrievePriority = 0;
    private boolean onlyKnownSeries;
    private boolean logPostSelectXML;
    private AuditEvent.ID prefetchAuditEventID;
    private int concurrency = 1;
    private JMSDelegate jmsDelegate = new JMSDelegate((ServiceMBeanSupport)this);
    private TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);
    public static final SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
    private static final byte[] RELATIONAL_QUERY = new byte[]{1};

    public String getPrefetchMessageTypes() {
        if (this.prefetchMessageTypes == null || this.prefetchMessageTypes.length == 0) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        for (MessageTypeMatcher prefetchMessageType : this.prefetchMessageTypes) {
            prefetchMessageType.toString(sb).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void setPrefetchMessageTypes(String messageTypes) {
        String trim = messageTypes.trim();
        if (NONE.equalsIgnoreCase(trim)) {
            this.prefetchMessageTypes = null;
        } else {
            StringTokenizer stk = new StringTokenizer(messageTypes, ", ");
            MessageTypeMatcher[] tmp = new MessageTypeMatcher[stk.countTokens()];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = new MessageTypeMatcher(stk.nextToken());
            }
            this.prefetchMessageTypes = tmp;
        }
    }

    public final String getPrefetchSourceAET() {
        return this.prefetchSourceAET;
    }

    public final void setPrefetchSourceAET(String aet) {
        this.prefetchSourceAET = aet;
    }

    public final String getDestinationQueryAET() {
        return this.destinationQueryAET;
    }

    public final void setDestinationQueryAET(String aet) {
        this.destinationQueryAET = aet;
    }

    public final String getDestinationStorageAET() {
        return this.destinationStorageAET;
    }

    public final void setDestinationStorageAET(String aet) {
        this.destinationStorageAET = aet;
    }

    public final String getSourceQueryPriority() {
        return DicomPriority.toString((int)this.sourceQueryPriority);
    }

    public final void setSourceQueryPriority(String cs) {
        this.sourceQueryPriority = DicomPriority.toCode((String)cs);
    }

    public final String getDestinationQueryPriority() {
        return DicomPriority.toString((int)this.destinationQueryPriority);
    }

    public final void setDestinationQueryPriority(String cs) {
        this.destinationQueryPriority = DicomPriority.toCode((String)cs);
    }

    public final String getRetrievePriority() {
        return DicomPriority.toString((int)this.retrievePriority);
    }

    public final void setRetrievePriority(String retrievePriority) {
        this.retrievePriority = DicomPriority.toCode((String)retrievePriority);
    }

    public final String getStylesheet() {
        return this.xslPath;
    }

    public void setStylesheet(String path) {
        this.xslPath = path;
    }

    public boolean isOnlyKnownSeries() {
        return this.onlyKnownSeries;
    }

    public void setOnlyKnownSeries(boolean b) {
        this.onlyKnownSeries = b;
    }

    public final String getPostSelectStylesheet() {
        return this.postSelectXslPath == null ? NONE : this.postSelectXslPath;
    }

    public void setPostSelectStylesheet(String path) {
        this.postSelectXslPath = NONE.equals(path) ? null : path;
    }

    public boolean isLogPostSelectXML() {
        return this.logPostSelectXML;
    }

    public void setLogPostSelectXML(boolean b) {
        this.logPostSelectXML = b;
    }

    public String getPrefetchAuditEventID() {
        return this.prefetchAuditEventID == null ? NONE : this.prefetchAuditEventID.getCode() + "^" + this.prefetchAuditEventID.getCodeSystemName() + "^" + this.prefetchAuditEventID.getDisplayName();
    }

    public void setPrefetchAuditEventID(String code) {
        if (NONE.equals(code)) {
            this.prefetchAuditEventID = null;
        } else {
            StringTokenizer st = new StringTokenizer(code, "^");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("EventID must be <code>^<code system>^<display name>! " + code);
            }
            this.prefetchAuditEventID = new AuditEvent.ID(st.nextToken(), st.nextToken(), st.nextToken());
        }
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls(text);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final ObjectName getHL7ServerName() {
        return this.hl7ServerName;
    }

    public final void setHL7ServerName(ObjectName hl7ServerName) {
        this.hl7ServerName = hl7ServerName;
    }

    public final ObjectName getMoveScuServiceName() {
        return this.moveScuServiceName;
    }

    public final void setMoveScuServiceName(ObjectName moveScuServiceName) {
        this.moveScuServiceName = moveScuServiceName;
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, (MessageListener)this, this.concurrency);
        this.server.addNotificationListener(this.hl7ServerName, this, HL7ServerService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.hl7ServerName, this, HL7ServerService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
        Object[] data = (Object[])notif.getUserData();
        Document hl7doc = (Document)data[1];
        if (this.matchPrefetchMessageTypes(hl7doc)) {
            Dataset findRQ = DcmObjectFactory.getInstance().newDataset();
            try {
                File xslFile = FileUtils.toExistingFile((String)this.xslPath);
                Transformer t = this.templates.getTemplates(xslFile).newTransformer();
                t.transform((Source)new DocumentSource(hl7doc), new SAXResult(findRQ.getSAXHandler2(null)));
            }
            catch (TransformerException e) {
                this.log.error((Object)"Failed to transform ORM into prefetch request", (Throwable)e);
                return;
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)("No such stylesheet: " + this.xslPath));
                return;
            }
            this.prepareFindReqDS(findRQ);
            PrefetchOrder order = new PrefetchOrder(findRQ, hl7doc);
            try {
                this.log.info((Object)("Scheduling " + order));
                this.jmsDelegate.queue(this.queueName, (Serializable)order, 4, 0L);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            }
        }
    }

    private boolean matchPrefetchMessageTypes(Document hl7doc) {
        if (this.prefetchMessageTypes == null || this.prefetchMessageTypes.length == 0) {
            return false;
        }
        MSH msh = new MSH(hl7doc);
        for (MessageTypeMatcher prefetchMessageType : this.prefetchMessageTypes) {
            if (!prefetchMessageType.match(msh, hl7doc)) continue;
            return true;
        }
        return false;
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                PrefetchOrder order = (PrefetchOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, (Serializable)order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, (Serializable)order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    private void process(PrefetchOrder order) throws Exception {
        Dataset keys = order.getDataset();
        this.log.debug((Object)"SearchDS from order:");
        this.log.debug((Object)keys);
        Map<String, Dataset> srcList = this.doCFIND(this.prefetchSourceAET, keys, this.sourceQueryPriority);
        Map<String, Dataset> destList = this.doCFIND(this.destinationQueryAET, keys, this.destinationQueryPriority);
        List<Dataset> notAvail = this.getListOfNotAvail(srcList, destList);
        if (notAvail.size() > 0) {
            this.log.debug((Object)("notAvail:" + notAvail));
            if (this.postSelectXslPath == null || !this.postSelect(notAvail, order, srcList)) {
                this.log.info((Object)(notAvail.size() + " Series are not available on destination AE! Schedule for Pre-Fetch"));
                Iterator<Dataset> iter = notAvail.iterator();
                while (iter.hasNext()) {
                    this.scheduleMove(this.prefetchSourceAET, this.destinationStorageAET, this.retrievePriority, iter.next(), 0L);
                }
            }
        }
    }

    private boolean postSelect(List<Dataset> notAvail, PrefetchOrder order, final Map<String, Dataset> srcList) {
        try {
            Document doc = order.getHL7Document();
            if (this.logPostSelectXML) {
                File logFile = new File(System.getProperty("jboss.server.log.dir"), "postselect/" + new DTFormat().format(new Date()) + ".xml");
                logFile.getParentFile().mkdirs();
                TransformerHandler thLog = tf.newTransformerHandler();
                thLog.setResult(new StreamResult(new FileOutputStream(logFile)));
                this.transformPostSelect(notAvail, thLog, doc);
                this.log.info((Object)("postselect XML logged in " + logFile));
            }
            File xslFile = FileUtils.toExistingFile((String)this.postSelectXslPath);
            DefaultHandler ch = new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attr) {
                    if ("schedule".equals(qName)) {
                        String seriesIUID = attr.getValue("seriesIUID");
                        if (seriesIUID == null) {
                            throw new IllegalArgumentException("Missing seriesIUID attribute in schedule tag!");
                        }
                        Dataset ds = (Dataset)srcList.get(seriesIUID);
                        if (ds == null) {
                            PrefetchService.this.log.warn((Object)"Series IUID of schedule tag is not known on source! Ignored.");
                        } else {
                            long l;
                            String dt = attr.getValue("scheduleAt");
                            try {
                                l = dt == null ? 0L : new DTFormat().parse(dt).getTime();
                            }
                            catch (ParseException x) {
                                PrefetchService.this.log.error((Object)"Attribute 'scheduleAt' is not in DateTime format (yyyyMMddHHmmss.SSS )!", (Throwable)x);
                                l = 0L;
                            }
                            PrefetchService.this.log.info((Object)("Schedule post selected series:" + seriesIUID + " at " + dt + " reason:" + attr.getValue("reason")));
                            PrefetchService.this.scheduleMove(PrefetchService.this.prefetchSourceAET, PrefetchService.this.destinationStorageAET, PrefetchService.this.retrievePriority, ds, l);
                        }
                    }
                }
            };
            TransformerHandler th = tf.newTransformerHandler(this.templates.getTemplates(xslFile));
            th.setResult(new SAXResult(ch));
            this.transformPostSelect(notAvail, th, doc);
            return true;
        }
        catch (Exception x) {
            this.log.error((Object)"PostSelect of C-FIND results failed! Schedule prefetch C-MOVE requests without post selection!", (Throwable)x);
            return false;
        }
    }

    private void transformPostSelect(List<Dataset> notAvail, ContentHandler handler, Document hl7Doc) throws SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        ContentHandlerAdapter cha = new ContentHandlerAdapter(handler);
        cha.forcedStartDocument();
        cha.startElement("prefetch");
        if (hl7Doc != null) {
            DocumentSource src = new DocumentSource(hl7Doc);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform((Source)src, new SAXResult((ContentHandler)cha));
        }
        Iterator<Dataset> iter = notAvail.iterator();
        while (iter.hasNext()) {
            iter.next().writeDataset2((ContentHandler)cha, null, null, 64, null);
        }
        cha.endElement("prefetch");
        cha.forcedEndDocument();
    }

    private void prepareFindReqDS(Dataset keys) {
        String qrLevel = keys.getString(524370);
        if (qrLevel != null && !qrLevel.equals("SERIES")) {
            this.log.warn((Object)("QueryRetrieveLevel of PrefetchOrder is " + qrLevel + "! Set to SERIES!"));
        }
        keys.putCS(524370, "SERIES");
        if (!keys.contains(0x100020)) {
            keys.putUI(0x100020);
        }
        if (!keys.contains(0x20000D)) {
            keys.putUI(0x20000D);
        }
        if (!keys.contains(0x20000E)) {
            keys.putUI(0x20000E);
        }
        keys.putIS(2101769);
        keys.putCS(524374);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Dataset> doCFIND(String calledAET, Dataset keys, int priority) throws Exception {
        ExtNegotiation extNeg = AssociationFactory.getInstance().newExtNegotiation("1.2.840.10008.5.1.4.1.2.2.1", RELATIONAL_QUERY);
        ActiveAssociation assoc = this.openAssociation(calledAET, "1.2.840.10008.5.1.4.1.2.2.1", extNeg);
        try {
            HashMap<String, Dataset> result = new HashMap<String, Dataset>();
            Command cmd = DcmObjectFactory.getInstance().newCommand();
            cmd.initCFindRQ(1, "1.2.840.10008.5.1.4.1.2.2.1", priority);
            Dimse mcRQ = AssociationFactory.getInstance().newDimse(1, cmd, keys);
            FutureRSP findRsp = assoc.invoke(mcRQ);
            Dimse dimse = findRsp.get();
            List pending = findRsp.listPending();
            Iterator iter = pending.iterator();
            while (iter.hasNext()) {
                Dataset ds = ((Dimse)iter.next()).getDataset();
                result.put(ds.getString(0x20000E), ds);
                this.log.debug((Object)(calledAET + ": received Dataset:"));
                this.log.debug((Object)ds);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(calledAET + " : received final C-FIND RSP :" + dimse));
            }
            HashMap<String, Dataset> hashMap = result;
            return hashMap;
        }
        finally {
            if (assoc != null) {
                try {
                    assoc.release(true);
                }
                catch (Exception e1) {
                    this.log.error((Object)("Cant release association for CFIND" + assoc.getAssociation()), (Throwable)e1);
                }
            }
        }
    }

    private List<Dataset> getListOfNotAvail(Map<String, Dataset> srcList, Map<String, Dataset> destList) {
        ArrayList<Dataset> l = new ArrayList<Dataset>();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Dataset> entry : srcList.entrySet()) {
            String seriesIUID = entry.getKey();
            Dataset dsAll = entry.getValue();
            Dataset ds = destList.get(seriesIUID);
            sb.setLength(0);
            sb.append("Series ").append(seriesIUID).append(": ");
            if (ds == null) {
                if (this.onlyKnownSeries) {
                    sb.append(" - Ignored! Must be known on destination!");
                } else {
                    sb.append("Only known on source AE");
                    l.add(dsAll);
                }
                this.log.debug((Object)sb);
                continue;
            }
            if (!ONLINE.equals(ds.getString(524374))) {
                this.log.debug((Object)sb.append("Instances are not available (ONLINE) on destination AE!"));
                l.add(dsAll);
                continue;
            }
            int noi = ds.getInt(2101769, -1);
            int noi1 = dsAll.getInt(2101769, -1);
            sb.append("NumberOfSeriesRelatedInstances ");
            if (noi == -1 || noi1 == -1) {
                sb.append("is not available to check count of instances! dest:");
                this.log.warn((Object)sb.append(noi).append(" src:").append(noi1));
                continue;
            }
            if (noi >= noi1) continue;
            sb.append("on destination AE is less than on source AE! dest:");
            this.log.debug((Object)sb.append(noi).append(" src:").append(noi1));
            l.add(dsAll);
        }
        return l;
    }

    private void scheduleMove(String retrieveAET, String destAET, int priority, Dataset ds, long scheduledTime) {
        boolean success = false;
        try {
            this.server.invoke(this.moveScuServiceName, "scheduleMove", new Object[]{retrieveAET, destAET, new Integer(priority), ds.getString(0x100020), ds.getString(0x20000D), ds.getString(0x20000E), null, new Long(scheduledTime)}, new String[]{String.class.getName(), String.class.getName(), Integer.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String[].class.getName(), Long.TYPE.getName()});
            success = true;
        }
        catch (Exception e) {
            this.log.error((Object)"Schedule Move failed:", (Throwable)e);
        }
        if (this.prefetchAuditEventID != null) {
            this.logPrefetchSchedule(retrieveAET, destAET, ds, scheduledTime, success);
        }
    }

    private void logPrefetchSchedule(String retrieveAET, String destAET, Dataset ds, long scheduledTime, boolean success) {
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            SchedulePrefetchMessage msg = new SchedulePrefetchMessage(this.prefetchAuditEventID);
            msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addActiveParticipant(ActiveParticipant.createActivePerson((String)userInfo.getUserId(), null, null, (String)userInfo.getHostName(), (boolean)true));
            PersonName pn = ds.getPersonName(0x100010);
            String pname = pn != null ? pn.format() : null;
            msg.addParticipantObject(ParticipantObject.createPatient((String)ds.getString(0x100020), (String)pname));
            ParticipantObjectDescription descr = new ParticipantObjectDescription();
            ParticipantObject study = msg.addParticipantObject(ParticipantObject.createStudy((String)ds.getString(0x20000D), (ParticipantObjectDescription)descr));
            String scheduledAt = scheduledTime == 0L ? "NOW" : new Date(scheduledTime).toString();
            study.addParticipantObjectDetail("Description", "Prefetching series " + ds.getString(0x20000E) + " from " + retrieveAET + " to " + destAET + " scheduled at " + scheduledAt);
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception x) {
            this.log.warn((Object)"Audit Log 'Prefetch Schedule' failed:", (Throwable)x);
        }
    }

    public void processFile(String filename) throws DocumentException, IOException, SAXException {
        Dataset findRQ = DcmObjectFactory.getInstance().newDataset();
        HL7XMLReader reader = new HL7XMLReader();
        File file = new File(filename);
        SAXContentHandler hl7in = new SAXContentHandler();
        reader.setContentHandler((ContentHandler)hl7in);
        reader.parse(new InputSource(new FileInputStream(file)));
        Document doc = hl7in.getDocument();
        try {
            File xslFile = FileUtils.toExistingFile((String)this.xslPath);
            Transformer t = this.templates.getTemplates(xslFile).newTransformer();
            t.transform((Source)new DocumentSource(doc), new SAXResult(findRQ.getSAXHandler2(null)));
        }
        catch (TransformerException e) {
            this.log.error((Object)"Failed to transform into prefetch request", (Throwable)e);
            return;
        }
        this.prepareFindReqDS(findRQ);
        PrefetchOrder order = new PrefetchOrder(findRQ, doc);
        try {
            this.log.info((Object)("Scheduling Test PrefetchOrder:" + order));
            this.jmsDelegate.queue(this.queueName, (Serializable)order, 4, 0L);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to schedule Test Order" + order), (Throwable)e);
        }
    }

    class SchedulePrefetchMessage
    extends AuditMessage {
        public SchedulePrefetchMessage(AuditEvent.ID eventID) {
            super(new AuditEvent(eventID, AuditEvent.ActionCode.EXECUTE));
        }
    }
}

