/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

class PID {
    private final ArrayList pids = new ArrayList();

    public PID(Document msg) {
        Element pid = msg.getRootElement().element("PID");
        if (pid == null) {
            throw new IllegalArgumentException("Missing PID Segment");
        }
        List pidfds = pid.elements("field");
        if (pidfds.size() < 3) {
            throw new IllegalArgumentException("Missing PID-3 Field");
        }
        Element pidfd = (Element)pidfds.get(2);
        this.pids.add(PID.toPID(pidfd));
        List furtherPids = pidfd.elements("repeat");
        Iterator iter = furtherPids.iterator();
        while (iter.hasNext()) {
            this.pids.add(PID.toPID((Element)iter.next()));
        }
    }

    public List getPatientIDs() {
        return Collections.unmodifiableList(this.pids);
    }

    public int countPatientIDs() {
        return this.pids.size();
    }

    public static String[] toPID(Element pidfd) {
        List comps = pidfd.elements("component");
        if (comps.size() < 3) {
            throw new IllegalArgumentException("Missing Authority in PID-3");
        }
        Element authority = (Element)comps.get(2);
        List authorityUID = authority.elements("subcomponent");
        String[] pid = new String[2 + authorityUID.size()];
        pid[0] = pidfd.getText();
        pid[1] = authority.getText();
        for (int i = 2; i < pid.length; ++i) {
            pid[i] = ((Element)authorityUID.get(i - 2)).getText();
        }
        return pid;
    }

    public static boolean isEmpty(Document msg) {
        Element pid = msg.getRootElement().element("PID");
        if (pid == null) {
            return true;
        }
        List pidfds = pid.elements("field");
        if (pidfds.size() < 3) {
            return true;
        }
        Element pidfd = (Element)pidfds.get(2);
        String pid3 = pidfd.getText();
        return pid3 == null || pid3.length() == 0;
    }
}

