/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.ejb.jdbc.QueryCmd;
import org.dcm4chex.archive.hl7.HL7Exception;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.hl7.ORU_MDMService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.xml.sax.ContentHandler;

public class ORUService
extends ORU_MDMService {
    private static final int DEFAULT_STATUS_FIELD_NR = 10;
    private static final String NO_RESULT_STATUS = "NO_OBSERV_RESULT_STATUS";
    private static final String NO_OBX = "NO_OBX";
    private HashSet obxIgnoreStati = new HashSet();
    private int obxStatusFieldNr = 10;
    private int fetchSize;

    public void setObxIgnoreStati(String stati) {
        this.obxIgnoreStati.clear();
        if (stati.equalsIgnoreCase("NONE")) {
            return;
        }
        int start = 0;
        int end = stati.indexOf(58);
        if (end != -1) {
            this.obxStatusFieldNr = Integer.parseInt(stati.substring(0, end));
            --this.obxStatusFieldNr;
            start = ++end;
        } else {
            this.obxStatusFieldNr = 10;
        }
        end = stati.indexOf(44, start);
        while (end != -1) {
            this.obxIgnoreStati.add(stati.substring(start, end));
            start = ++end;
            end = stati.indexOf(44, start);
        }
        this.obxIgnoreStati.add(stati.substring(start));
    }

    public String getObxIgnoreStati() {
        if (this.obxIgnoreStati.isEmpty()) {
            return "NONE";
        }
        StringBuffer sb = new StringBuffer();
        if (this.obxStatusFieldNr != 10) {
            sb.append(this.obxStatusFieldNr + 1).append(':');
        }
        Iterator iter = this.obxIgnoreStati.iterator();
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(',').append(iter.next());
        }
        return sb.toString();
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean process(MSH msh, Document msg, ContentHandler hl7out, String[] xslSubdirs) throws HL7Exception {
        String status = this.getOBXStatus(msg);
        if (this.obxIgnoreStati.contains(status)) {
            this.log.info((Object)("Ignore ORU message with OBX status='" + status + "'! MSH:" + msh));
        } else {
            this.process(msg, xslSubdirs);
        }
        return true;
    }

    public void process(Document msg, String[] xslSubdirs) throws HL7Exception {
        try {
            Dataset doc = this.xslt(msg, this.xslPath, xslSubdirs);
            this.addIUIDs(doc);
            this.storeSR(doc);
        }
        catch (Exception e) {
            throw new HL7Exception("AE", e.getMessage(), e);
        }
    }

    private String getOBXStatus(Document msg) {
        Element rootElement = msg.getRootElement();
        List obxs = rootElement.elements("OBX");
        if (obxs.isEmpty()) {
            return NO_OBX;
        }
        List obxFields = ((Element)obxs.get(0)).elements("field");
        if (obxFields.size() <= this.obxStatusFieldNr) {
            return NO_RESULT_STATUS;
        }
        return ((Element)obxFields.get(this.obxStatusFieldNr)).getText();
    }

    private void addIUIDs(Dataset sr) {
        UIDGenerator uidgen = UIDGenerator.getInstance();
        if (!sr.containsValue(0x20000D) && !this.addSUIDs(sr)) {
            sr.putUI(0x20000D, uidgen.createUID());
        }
        if (!sr.containsValue(0x20000E)) {
            sr.putUI(0x20000E, uidgen.createUID());
        }
        if (!sr.containsValue(524312)) {
            sr.putUI(524312, uidgen.createUID());
        }
        String cuid = sr.getString(524310);
        DcmElement identicalDocumentsSeq = sr.get(4236581);
        if (identicalDocumentsSeq != null) {
            int n = identicalDocumentsSeq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset studyItem = identicalDocumentsSeq.getItem(i);
                Dataset seriesItem = studyItem.putSQ(528661).addNewItem();
                seriesItem.putUI(0x20000E, uidgen.createUID());
                Dataset sopItem = seriesItem.putSQ(528793).addNewItem();
                sopItem.putUI(528725, uidgen.createUID());
                sopItem.putUI(528720, cuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSUIDs(Dataset sr) {
        String accno = sr.getString(524368);
        if (accno == null) {
            this.log.warn((Object)"Missing Accession Number in ORU - store report in new Study");
            return false;
        }
        Dataset keys = DcmObjectFactory.getInstance().newDataset();
        keys.putSH(524368, accno);
        keys.putUI(0x20000D);
        QueryCmd.StudyQueryCmd query = null;
        try {
            query = QueryCmd.createStudyQuery((Dataset)keys, null, (boolean)false, (boolean)false, (boolean)true, (boolean)false, null);
            query.setFetchSize(this.fetchSize).execute();
            if (!query.next()) {
                this.log.warn((Object)("No Study with given Accession Number: " + accno + " - store report in new Study"));
                boolean bl = false;
                return bl;
            }
            this.copyStudyInstanceUID((QueryCmd)query, sr);
            if (query.next()) {
                DcmElement sq = sr.putSQ(4236581);
                do {
                    this.copyStudyInstanceUID((QueryCmd)query, sq.addNewItem());
                } while (query.next());
            }
            boolean sq = true;
            return sq;
        }
        catch (Exception e) {
            this.log.error((Object)("Query DB for Studies with Accession Number " + accno + " failed - store report in new Study"), (Throwable)e);
            sr.putSQ(4236581);
            boolean bl = false;
            return bl;
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
    }

    private void copyStudyInstanceUID(QueryCmd query, Dataset sr) throws SQLException {
        sr.putUI(0x20000D, query.getDataset().getString(0x20000D));
    }
}

