/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.PPSStatus;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.common.SPSStatus;
import org.dcm4chex.archive.ejb.interfaces.MPPSManager;
import org.dcm4chex.archive.ejb.interfaces.MPPSManagerHome;
import org.dcm4chex.archive.ejb.interfaces.MWLManager;
import org.dcm4chex.archive.ejb.interfaces.MWLManagerHome;
import org.dcm4chex.archive.exceptions.DuplicateMWLItemException;
import org.dcm4chex.archive.exceptions.PatientMergedException;
import org.dcm4chex.archive.exceptions.PatientMismatchException;
import org.dcm4chex.archive.hl7.AbstractHL7Service;
import org.dcm4chex.archive.hl7.HL7Exception;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.XSLTUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.system.ServiceMBeanSupport;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORMService
extends AbstractHL7Service {
    private TemplatesDelegate aeTemplates = new TemplatesDelegate((ServiceMBeanSupport)this);
    private static final String MWL2STORE_XSL = "mwl-cfindrsp2cstorerq.xsl";
    private static final String[] OP_CODES = new String[]{"NW", "XO", "CA", "NOOP", "SC(SCHEDULED)", "SC(ARRIVED)", "SC(READY)", "SC(STARTED)", "SC(COMPLETED)", "SC(DISCONTINUED)"};
    private static final List<String> OP_CODES_LIST = Arrays.asList(OP_CODES);
    private static final int NW = 0;
    private static final int XO = 1;
    private static final int CA = 2;
    private static final int NOOP = 3;
    private static final int SC_OFF = 4;
    private List<String> orderControls;
    private int[] ops = new int[0];
    private boolean updateDifferentPatientOfExistingStudy;
    private ObjectName deviceServiceName;
    private String xslPath;
    private String defaultStationAET = "UNKOWN";
    private String defaultStationName = "UNKOWN";
    private String defaultModality = "OT";
    public PatientMatching patientMatching;

    public String getPatientMatching() {
        return this.patientMatching.toString();
    }

    public void setPatientMatching(String s) {
        this.patientMatching = new PatientMatching(s.trim());
    }

    public final String getStylesheet() {
        return this.xslPath;
    }

    public void setStylesheet(String path) {
        this.xslPath = path;
    }

    public final ObjectName getDeviceServiceName() {
        return this.deviceServiceName;
    }

    public final void setDeviceServiceName(ObjectName deviceServiceName) {
        this.deviceServiceName = deviceServiceName;
    }

    public String getOrderControlOperationMap() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.ops.length; ++i) {
            sb.append(this.orderControls.get(i)).append(':').append(OP_CODES[this.ops[i]]).append("\r\n");
        }
        return sb.toString();
    }

    public void setOrderControlOperationMap(String s) {
        StringTokenizer stk = new StringTokenizer(s, " \r\n\t,;");
        int lines = stk.countTokens();
        int[] newops = new int[lines];
        ArrayList<String> newocs = new ArrayList<String>(lines);
        for (int i = 0; i < lines; ++i) {
            String[] ocop = StringUtils.split((String)stk.nextToken(), (char)':');
            if (ocop.length != 2 || (newops[i] = OP_CODES_LIST.indexOf(ocop[1])) == -1) {
                throw new IllegalArgumentException(s);
            }
            newocs.add(ocop[0]);
        }
        this.ops = newops;
        this.orderControls = newocs;
    }

    public final boolean isUpdateDifferentPatientOfExistingStudy() {
        return this.updateDifferentPatientOfExistingStudy;
    }

    public final void setUpdateDifferentPatientOfExistingStudy(boolean update) {
        this.updateDifferentPatientOfExistingStudy = update;
    }

    public final String getDefaultModality() {
        return this.defaultModality;
    }

    public final void setDefaultModality(String defaultModality) {
        this.defaultModality = defaultModality;
    }

    public final String getDefaultStationAET() {
        return this.defaultStationAET;
    }

    public final void setDefaultStationAET(String defaultStationAET) {
        this.defaultStationAET = defaultStationAET;
    }

    public final String getDefaultStationName() {
        return this.defaultStationName;
    }

    public final void setDefaultStationName(String defaultStationName) {
        this.defaultStationName = defaultStationName;
    }

    public final String getMWL2StoreConfigDir() {
        return this.aeTemplates.getConfigDir();
    }

    public final void setMWL2StoreConfigDir(String path) {
        this.aeTemplates.setConfigDir(path);
    }

    @Override
    public boolean process(MSH msh, Document msg, ContentHandler hl7out, String[] xslSubdirs) throws HL7Exception {
        this.process(this.toOp(msg), msg, xslSubdirs);
        return true;
    }

    public void process(String orderControl, String orderStatus, Document msg, String[] xslSubdirs) throws HL7Exception {
        this.process(new int[]{this.toOp(orderControl, orderStatus)}, msg, xslSubdirs);
    }

    private void process(int[] op, Document msg, String[] xslSubdirs) throws HL7Exception {
        try {
            Dataset ds = this.xslt(msg, this.xslPath, xslSubdirs);
            String pid = ds.getString(0x100020);
            if (pid == null) {
                throw new HL7Exception("AR", "Missing required PID-3: Patient ID (Internal ID)");
            }
            String pname = ds.getString(0x100010);
            if (pname == null) {
                throw new HL7Exception("AR", "Missing required PID-5: Patient Name");
            }
            this.mergeProtocolCodes(ds, op);
            ds = this.addScheduledStationInfo(ds);
            MWLManager mwlManager = this.getMWLManager();
            DcmElement spsSq = ds.remove(0x400100);
            int n = spsSq.countItems();
            block12: for (int i = 0; i < n; ++i) {
                Dataset sps = spsSq.getItem(i);
                ds.putSQ(0x400100).addItem(sps);
                this.adjustAttributes(ds);
                int opIdx = op.length == 1 ? 0 : i;
                switch (op[opIdx]) {
                    case 0: {
                        this.processNW(ds, mwlManager);
                        continue block12;
                    }
                    case 1: {
                        this.processXO(ds, mwlManager);
                        continue block12;
                    }
                    case 2: {
                        this.processCA(ds, mwlManager);
                        continue block12;
                    }
                    case 3: {
                        this.log("NOOP", ds);
                        continue block12;
                    }
                    default: {
                        sps.putCS(0x400020, SPSStatus.toString((int)(op[opIdx] - 4)));
                        this.updateSPSStatus(ds, mwlManager);
                    }
                }
            }
        }
        catch (HL7Exception e) {
            throw e;
        }
        catch (PatientMismatchException e) {
            throw new HL7Exception("AR", e.getMessage(), e);
        }
        catch (PatientMergedException e) {
            throw new HL7Exception("AR", e.getMessage(), e);
        }
        catch (DuplicateMWLItemException e) {
            throw new HL7Exception("AR", e.getMessage(), e);
        }
        catch (Exception e) {
            throw new HL7Exception("AE", e.getMessage(), e);
        }
    }

    protected void processNW(Dataset ds, MWLManager mwlManager) throws Exception {
        this.addMissingAttributes(ds);
        this.log("Schedule", ds);
        this.logDataset("Insert MWL Item:", ds);
        mwlManager.addWorklistItem(ds, this.patientMatching);
        this.updateRequestAttributes(ds, mwlManager);
    }

    protected void processXO(Dataset ds, MWLManager mwlManager) throws Exception {
        this.log("Update", ds);
        this.logDataset("Update MWL Item:", ds);
        if (!mwlManager.updateWorklistItem(ds, this.patientMatching)) {
            this.log("No Such ", ds);
            this.addMissingAttributes(ds);
            this.log("->Schedule New ", ds);
            this.logDataset("Insert MWL Item:", ds);
            mwlManager.addWorklistItem(ds, this.patientMatching);
        }
        this.updateRequestAttributes(ds, mwlManager);
    }

    protected void processCA(Dataset ds, MWLManager mwlManager) throws Exception {
        this.log("Cancel", ds);
        if (mwlManager.removeWorklistItem(ds, this.patientMatching) == null) {
            this.log("No Such ", ds);
        } else {
            ds.getItem(0x400100).putCS(0x400020, "DISCONTINUED");
            this.updateRequestAttributes(ds, mwlManager);
        }
    }

    private void updateRequestAttributes(Dataset mwlitem, MWLManager mwlManager) throws Exception {
        MPPSManager mppsManager = this.getMPPSManager();
        List mppsList = mppsManager.updateScheduledStepAttributes(mwlitem, this.patientMatching, this.updateDifferentPatientOfExistingStudy);
        if (!mppsList.isEmpty()) {
            if ("DISCONTINUED".equals(mwlitem.getItem(0x400100).getString(0x400020))) {
                HashSet<String> seriesIuids = new HashSet<String>();
                for (Dataset mpps : mppsList) {
                    DcmElement perfSeriesSq = mpps.get(0x400340);
                    if (perfSeriesSq == null || perfSeriesSq.isEmpty()) continue;
                    int n = perfSeriesSq.countItems();
                    for (int i = 0; i < n; ++i) {
                        seriesIuids.add(perfSeriesSq.getItem(i).getString(0x20000E));
                    }
                }
                mppsManager.removeRequestAttributesInSeries(mwlitem, seriesIuids);
            } else {
                this.updateSPSStatus(mwlitem, (Dataset)mppsList.get(0), mwlManager);
                this.updateRequestAttributesInSeries(mwlitem, mppsList, mppsManager);
            }
        }
    }

    private void updateRequestAttributesInSeries(Dataset mwlitem, List<Dataset> mppsList, MPPSManager mppsManager) throws Exception {
        for (Dataset mpps : mppsList) {
            String aet = mpps.getString(4194881);
            Templates xslt = null;
            try {
                if (this.aeTemplates.getTemplatesServiceName() == null) {
                    this.aeTemplates.setTemplatesServiceName(this.getTemplatesServiceName());
                }
                xslt = this.aeTemplates.getTemplatesForAET(aet, MWL2STORE_XSL);
            }
            catch (Exception x) {
                this.log.error((Object)"Internal error to get template for mwl-cfindrsp2cstorerq.xsl", (Throwable)x);
            }
            if (xslt == null) {
                this.log.warn((Object)("Failed to find or load stylesheet mwl-cfindrsp2cstorerq.xsl for " + aet + ". Cannot update object attributes with request information."));
                continue;
            }
            Dataset rqAttrs = DcmObjectFactory.getInstance().newDataset();
            XSLTUtils.xslt((Dataset)mwlitem, (Templates)xslt, (Dataset)rqAttrs);
            DcmElement perfSeriesSq = mpps.get(0x400340);
            if (perfSeriesSq == null || perfSeriesSq.isEmpty()) continue;
            int n = perfSeriesSq.countItems();
            for (int i = 0; i < n; ++i) {
                String uid = perfSeriesSq.getItem(i).getString(0x20000E);
                this.updateSeriesAttributes(mppsManager, uid, rqAttrs, i == 0);
            }
        }
    }

    protected void updateSeriesAttributes(MPPSManager mppsManager, String uid, Dataset newAttrs, boolean updateStudyAttributes) {
        try {
            mppsManager.updateSeriesAttributes(uid, newAttrs, updateStudyAttributes);
        }
        catch (Exception x) {
            this.log.warn((Object)("Failed to update series attributes! Series IUID:" + uid + " - Reason:" + x));
        }
    }

    protected void updateSPSStatus(Dataset mwlitem, Dataset mpps, MWLManager mwlManager) throws PatientMismatchException, RemoteException {
        String spsStatus;
        Dataset sps = mwlitem.get(0x400100).getItem();
        switch (PPSStatus.toInt((String)mpps.getString(4194898))) {
            case 0: {
                spsStatus = "STARTED";
                break;
            }
            case 1: {
                spsStatus = "COMPLETED";
                break;
            }
            default: {
                spsStatus = "DISCONTINUED";
            }
        }
        sps.putCS(0x400020, spsStatus);
        this.updateSPSStatus(mwlitem, mwlManager);
    }

    protected void updateSPSStatus(Dataset ds, MWLManager mwlManager) throws PatientMismatchException, RemoteException {
        this.log("Change SPS status of MWL Item:", ds);
        if (!mwlManager.updateSPSStatus(ds, this.patientMatching)) {
            this.log("No Such ", ds);
        }
    }

    private void log(String op, Dataset ds) {
        Dataset sps = ds.getItem(0x400100);
        this.log.info((Object)(op + " Procedure Step[id:" + (sps == null ? "<unknown>(SPSSeq missing)" : sps.getString(0x400009)) + "] of Requested Procedure[id:" + ds.getString(0x401001) + ", uid:" + ds.getString(0x20000D) + "] of Order[accNo:" + ds.getString(524368) + "] for Patient [name:" + ds.getString(0x100010) + ",id:" + ds.getString(0x100020) + "]"));
    }

    private MWLManager getMWLManager() throws Exception {
        return ((MWLManagerHome)EJBHomeFactory.getFactory().lookup(MWLManagerHome.class, "ejb/MWLManager")).create();
    }

    private MPPSManager getMPPSManager() throws Exception {
        return ((MPPSManagerHome)EJBHomeFactory.getFactory().lookup(MPPSManagerHome.class, "ejb/MPPSManager")).create();
    }

    private int[] toOp(Document msg) throws HL7Exception {
        Element rootElement = msg.getRootElement();
        List orcs = rootElement.elements("ORC");
        List obrs = rootElement.elements("OBR");
        if (orcs.isEmpty()) {
            throw new HL7Exception("AR", "Missing ORC Segment");
        }
        int[] op = new int[orcs.size()];
        for (int i = 0; i < op.length; ++i) {
            List orc = ((Element)orcs.get(i)).elements("field");
            String orderControl = this.getText(orc, 0);
            String orderStatus = this.getText(orc, 4);
            if (orderStatus.length() == 0 && obrs.size() > i) {
                List obr = ((Element)obrs.get(i)).elements("field");
                orderStatus = this.getText(obr, 24);
            }
            op[i] = this.toOp(orderControl, orderStatus);
        }
        return op;
    }

    private int toOp(String orderControl, String orderStatus) throws HL7Exception {
        int opIndex = this.orderControls.indexOf(orderControl + "(" + orderStatus + ")");
        if (opIndex == -1 && (opIndex = this.orderControls.indexOf(orderControl)) == -1) {
            throw new HL7Exception("AR", "Illegal Order Control Code ORC-1:" + orderControl);
        }
        return this.ops[opIndex];
    }

    private String getText(List<Element> fields, int i) throws HL7Exception {
        try {
            return fields.get(i).getText();
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    private Dataset addScheduledStationInfo(Dataset spsItems) throws Exception {
        return (Dataset)this.server.invoke(this.deviceServiceName, "addScheduledStationInfo", new Object[]{spsItems}, new String[]{Dataset.class.getName()});
    }

    private void addMissingAttributes(Dataset ds) {
        Dataset sps = ds.getItem(0x400100);
        if (!sps.containsValue(0x400001)) {
            this.log.info((Object)("No Scheduled Station AET - use default: " + this.defaultStationAET));
            sps.putAE(0x400001, this.defaultStationAET);
        }
        if (!sps.containsValue(0x400010)) {
            this.log.info((Object)("No Scheduled Station Name - use default: " + this.defaultStationName));
            sps.putSH(0x400010, this.defaultStationName);
        }
        if (!sps.containsValue(524384)) {
            this.log.info((Object)("No Modality - use default: " + this.defaultModality));
            sps.putCS(524384, this.defaultModality);
        }
        if (!sps.containsValue(0x400002)) {
            this.log.info((Object)"No SPS Start Date - use current date/time");
            Date now = new Date();
            sps.putDA(0x400002, now);
            sps.putTM(0x400003, now);
        }
    }

    private void adjustAttributes(Dataset ds) {
        Dataset code;
        Dataset sps = ds.getItem(0x400100);
        String val = sps.getString(3280946);
        if (val != null) {
            this.log.info((Object)"Detect Requesting Physician on SPS Level");
            ds.putPN(3280946, val);
            sps.remove(3280946);
        }
        if ((val = sps.getString(3280947)) != null) {
            this.log.info((Object)"Detect Requesting Service on SPS Level");
            ds.putLO(3280947, val);
            sps.remove(3280947);
        }
        if ((val = sps.getString(0x20000D)) != null) {
            this.log.info((Object)"Detect Study Instance UID on SPS Level");
            ds.putUI(0x20000D, val);
            sps.remove(0x20000D);
        }
        if ((val = sps.getString(524368)) != null) {
            this.log.info((Object)"Detect Accession Number on SPS Level");
            ds.putSH(524368, val);
            sps.remove(524368);
        }
        if ((val = sps.getString(4198403)) != null) {
            this.log.info((Object)"Detect Requested Procedure Priority on SPS Level");
            ds.putCS(4198403, val);
            sps.remove(4198403);
        }
        if ((val = sps.getString(0x401001)) != null) {
            this.log.info((Object)"Detect Requested Procedure ID on SPS Level");
            ds.putSH(0x401001, val);
            sps.remove(0x401001);
        }
        if ((val = sps.getString(3280992)) != null) {
            this.log.info((Object)"Detect Requested Procedure Description on SPS Level");
            ds.putLO(3280992, val);
            sps.remove(3280992);
        }
        if ((code = sps.getItem(3280996)) != null) {
            this.log.info((Object)"Detect Requested Procedure Code on SPS Level");
            ds.putSQ(3280996).addItem(code);
            sps.remove(3280996);
        }
    }

    private void mergeProtocolCodes(Dataset orm, int[] op) {
        DcmElement prevSpsSq = orm.remove(0x400100);
        DcmElement newSpsSq = orm.putSQ(0x400100);
        HashMap<String, DcmElement> spcSqMap = new HashMap<String, DcmElement>();
        int j = 0;
        int n = prevSpsSq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset sps = prevSpsSq.getItem(i);
            String spsid = sps.getString(0x400009);
            DcmElement spcSqI = sps.get(0x400008);
            DcmElement spcSq0 = (DcmElement)spcSqMap.get(spsid);
            if (spcSq0 != null) {
                spcSq0.addItem(spcSqI.getItem());
                continue;
            }
            spcSqMap.put(spsid, spcSqI);
            newSpsSq.addItem(sps);
            if (op.length <= 1) continue;
            op[j++] = op[i];
        }
    }
}

