/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.List;
import java.util.StringTokenizer;
import org.dcm4chex.archive.hl7.MSH;
import org.dom4j.Document;
import org.dom4j.Element;

class MessageTypeMatcher {
    private String messageType;
    private String triggerEvent;
    private String[] segment;
    private int[] field;
    private String[] value;

    public MessageTypeMatcher(String pattern) {
        int messageTypeEnd = pattern.indexOf(94);
        if (messageTypeEnd < 0) {
            throw new IllegalArgumentException(pattern);
        }
        this.messageType = pattern.substring(0, messageTypeEnd);
        int triggerEventEnd = pattern.indexOf(91, messageTypeEnd + 1);
        if (triggerEventEnd == -1) {
            this.triggerEvent = pattern.substring(messageTypeEnd + 1);
            this.segment = null;
            this.field = null;
            this.value = null;
        } else {
            int valueEnd = pattern.length() - 1;
            if (pattern.charAt(valueEnd) != ']') {
                throw new IllegalArgumentException(pattern);
            }
            this.triggerEvent = pattern.substring(messageTypeEnd + 1, triggerEventEnd);
            StringTokenizer st = new StringTokenizer(pattern.substring(triggerEventEnd + 1, valueEnd), "|");
            int nrOfConditions = st.countTokens();
            this.segment = new String[nrOfConditions];
            this.field = new int[nrOfConditions];
            this.value = new String[nrOfConditions];
            int i = 0;
            while (st.hasMoreTokens()) {
                String cond = st.nextToken();
                if (cond.length() < 7) {
                    throw new IllegalArgumentException(pattern);
                }
                if (cond.charAt(3) != '-') {
                    throw new IllegalArgumentException(pattern);
                }
                int fieldEnd = cond.indexOf(61);
                if (fieldEnd == -1) {
                    throw new IllegalArgumentException(pattern);
                }
                this.segment[i] = cond.substring(0, 3);
                try {
                    this.field[i] = Integer.parseInt(cond.substring(4, fieldEnd));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(pattern);
                }
                if (this.field[i] <= 0) {
                    throw new IllegalArgumentException(pattern);
                }
                this.value[i] = cond.substring(fieldEnd + 1);
                ++i;
            }
        }
    }

    public StringBuffer toString(StringBuffer sb) {
        sb.append(this.messageType).append('^').append(this.triggerEvent);
        if (this.segment != null) {
            sb.append('[');
            int len = this.segment.length;
            for (int i = 0; i < len; ++i) {
                sb.append(this.segment[i]).append('-').append(this.field[i]).append('=').append(this.value[i]).append('|');
            }
            sb.setLength(sb.length() - 1);
            sb.append(']');
        }
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuffer()).toString();
    }

    public boolean match(MSH msh, Document msg) {
        if (!this.messageType.equals(msh.messageType) || !this.triggerEvent.equals(msh.triggerEvent)) {
            return false;
        }
        if (this.segment == null) {
            return true;
        }
        int len = this.segment.length;
        for (int i = 0; i < len; ++i) {
            Element seg = msg.getRootElement().element(this.segment[i]);
            if (seg == null) {
                return false;
            }
            List fds = seg.elements("field");
            if (fds.size() <= this.field[i]) {
                return false;
            }
            Element fd = (Element)fds.get(this.field[i] - 1);
            if (this.value[i].equals(MessageTypeMatcher.maskNull(fd.getText()))) continue;
            return false;
        }
        return true;
    }

    private static String maskNull(String s) {
        return s != null ? s : "";
    }
}

