/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class MSH {
    public final String sendingApplication;
    public final String sendingFacility;
    public final String receivingApplication;
    public final String receivingFacility;
    public final String messageType;
    public final String triggerEvent;
    public final String messageControlID;
    public final String processingID;
    public final String versionID;
    public final String characterSet;

    public MSH(Document msg) {
        Element msh = msg.getRootElement().element("MSH");
        if (msh == null) {
            throw new IllegalArgumentException("Missing MSH Segment");
        }
        List fields = msh.elements("field");
        this.sendingApplication = MSH.toString(fields.get(0));
        this.sendingFacility = MSH.toString(fields.get(1));
        this.receivingApplication = MSH.toString(fields.get(2));
        this.receivingFacility = MSH.toString(fields.get(3));
        Element el = (Element)fields.get(6);
        this.messageType = MSH.toString(el);
        this.triggerEvent = MSH.toString(el != null ? el.element("component") : null);
        this.messageControlID = MSH.toString(fields.get(7));
        this.processingID = MSH.toString(fields.get(8));
        this.versionID = MSH.toString(fields.get(9));
        this.characterSet = fields.size() > 15 ? MSH.toString(fields.get(15)) : null;
    }

    private static String toString(Object el) {
        return el != null ? ((Element)el).getText() : "";
    }

    public String toString() {
        return this.messageType + "^" + this.triggerEvent + "[" + this.sendingApplication + '@' + this.sendingFacility + "->" + this.receivingApplication + '@' + this.receivingFacility + ", pid=" + this.processingID + ", vers=" + this.versionID + ", charset=" + this.characterSet + "]";
    }
}

