/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4chex.archive.ejb.interfaces.MPPSManager;
import org.dcm4chex.archive.ejb.interfaces.MPPSManagerHome;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;
import org.regenstrief.xhl7.HL7XMLWriter;
import org.xml.sax.ContentHandler;

public class MPPS2ORMService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final int INIT_BUFFER_SIZE = 512;
    private static final NotificationFilterSupport mppsFilter = new NotificationFilterSupport();
    private ObjectName mppsScpServiceName;
    private ObjectName hl7SendServiceName;
    private TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);
    private String xslPath;
    private String receivedSendingApplication;
    private String receivedSendingFacility;
    private String receivedReceivingApplication;
    private String receivedReceivingFacility;
    private String linkedSendingApplication;
    private String linkedSendingFacility;
    private String linkedReceivingApplication;
    private String linkedReceivingFacility;
    private boolean mppsReceivedEnabled;
    private boolean mppsLinkedEnabled;
    private boolean ignoreUnscheduled;
    private boolean ignoreInProgress;
    private boolean oneORMperSPS;
    private File logDir;
    private boolean logXSLT;

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final String getStylesheet() {
        return this.xslPath;
    }

    public void setStylesheet(String path) {
        this.xslPath = path;
    }

    public final String getSendingApplication() {
        return this.receivedSendingApplication;
    }

    public final void setSendingApplication(String sendingApplication) {
        this.receivedSendingApplication = sendingApplication;
    }

    public final String getSendingFacility() {
        return this.receivedSendingFacility;
    }

    public final void setSendingFacility(String sendingFacility) {
        this.receivedSendingFacility = sendingFacility;
    }

    public final String getReceivingApplication() {
        return this.receivedReceivingApplication;
    }

    public final void setReceivingApplication(String receivingApplication) {
        this.receivedReceivingApplication = receivingApplication;
    }

    public final String getReceivingFacility() {
        return this.receivedReceivingFacility;
    }

    public final void setReceivingFacility(String receivingFacility) {
        this.receivedReceivingFacility = receivingFacility;
    }

    public final boolean isMPPSReceivedEnabled() {
        return this.mppsReceivedEnabled;
    }

    public final void setMPPSReceivedEnabled(boolean enabled) {
        if (enabled) {
            mppsFilter.enableType("org.dcm4chex.archive.dcm.mppsscp#received");
        } else {
            mppsFilter.disableType("org.dcm4chex.archive.dcm.mppsscp#received");
        }
        this.mppsReceivedEnabled = enabled;
    }

    public final boolean isMPPSLinkedEnabled() {
        return this.mppsLinkedEnabled;
    }

    public final void setMPPSLinkedEnabled(boolean enabled) {
        if (enabled) {
            mppsFilter.enableType("org.dcm4chex.archive.dcm.mppsscp#linked");
        } else {
            mppsFilter.disableType("org.dcm4chex.archive.dcm.mppsscp#linked");
        }
        this.mppsLinkedEnabled = enabled;
    }

    public String getLinkedSendingApplication() {
        return this.linkedSendingApplication;
    }

    public void setLinkedSendingApplication(String linkedSendingApplication) {
        this.linkedSendingApplication = linkedSendingApplication;
    }

    public String getLinkedSendingFacility() {
        return this.linkedSendingFacility;
    }

    public void setLinkedSendingFacility(String linkedSendingFacility) {
        this.linkedSendingFacility = linkedSendingFacility;
    }

    public String getLinkedReceivingApplication() {
        return this.linkedReceivingApplication;
    }

    public void setLinkedReceivingApplication(String linkedReceivingApplication) {
        this.linkedReceivingApplication = linkedReceivingApplication;
    }

    public String getLinkedReceivingFacility() {
        return this.linkedReceivingFacility;
    }

    public void setLinkedReceivingFacility(String linkedReceivingFacility) {
        this.linkedReceivingFacility = linkedReceivingFacility;
    }

    public final boolean isIgnoreUnscheduled() {
        return this.ignoreUnscheduled;
    }

    public final void setIgnoreUnscheduled(boolean ignoreUnscheduled) {
        this.ignoreUnscheduled = ignoreUnscheduled;
    }

    public final boolean isIgnoreInProgress() {
        return this.ignoreInProgress;
    }

    public final void setIgnoreInProgress(boolean ignoreInProgress) {
        this.ignoreInProgress = ignoreInProgress;
    }

    public final boolean isOneORMperSPS() {
        return this.oneORMperSPS;
    }

    public final void setOneORMperSPS(boolean splitMPPS) {
        this.oneORMperSPS = splitMPPS;
    }

    public final boolean isLogXSLT() {
        return this.logXSLT;
    }

    public final void setLogXSLT(boolean logXSLT) {
        this.logXSLT = logXSLT;
    }

    private MPPSManagerHome getMPPSManagerHome() throws HomeFactoryException {
        return (MPPSManagerHome)EJBHomeFactory.getFactory().lookup(MPPSManagerHome.class, "ejb/MPPSManager");
    }

    public final ObjectName getMppsScpServiceName() {
        return this.mppsScpServiceName;
    }

    public final void setMppsScpServiceName(ObjectName mppsScpServiceName) {
        this.mppsScpServiceName = mppsScpServiceName;
    }

    public final ObjectName getHl7SendServiceName() {
        return this.hl7SendServiceName;
    }

    public final void setHl7SendServiceName(ObjectName hl7SendServiceName) {
        this.hl7SendServiceName = hl7SendServiceName;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.mppsScpServiceName, this, (NotificationFilter)mppsFilter, null);
        this.logDir = new File(System.getProperty("jboss.server.log.dir"));
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.mppsScpServiceName, this, (NotificationFilter)mppsFilter, null);
    }

    public void handleNotification(Notification notif, Object handback) {
        this.log.debug((Object)("handleNotification called! type:" + notif.getType()));
        Dataset mpps = (Dataset)notif.getUserData();
        boolean linked = "org.dcm4chex.archive.dcm.mppsscp#linked".equals(notif.getType());
        if (!linked) {
            if (this.ignoreInProgress && "IN PROGRESS".equals(mpps.getString(4194898))) {
                return;
            }
            String iuid = mpps.getString(524312);
            mpps = this.getMPPS(iuid);
        }
        this.handle(mpps, linked);
    }

    private void handle(Dataset mpps, boolean linked) {
        DcmElement sq = mpps.get(4194928);
        if (sq == null || sq.isEmpty()) {
            this.log.error((Object)("Missing Scheduled Step Attributes Seq in MPPS - " + mpps.getString(524312)));
            return;
        }
        if (this.ignoreUnscheduled && sq.getItem().getString(524368) == null) {
            return;
        }
        if (this.oneORMperSPS) {
            int n = sq.countItems();
            for (int i = 0; i < n; ++i) {
                mpps.putSQ(4194928).addItem(sq.getItem(i));
                this.scheduleORM(this.makeORM(mpps, linked));
            }
        } else {
            this.scheduleORM(this.makeORM(mpps, linked));
        }
    }

    private void scheduleORM(byte[] bs) {
        if (bs == null) {
            return;
        }
        try {
            this.server.invoke(this.hl7SendServiceName, "forward", new Object[]{bs}, new String[]{byte[].class.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to schedule ORM", (Throwable)e);
        }
    }

    private byte[] makeORM(Dataset mpps, boolean linked) {
        if (mpps == null) {
            return null;
        }
        try {
            if (this.logXSLT) {
                try {
                    this.logXSLT(mpps, linked);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to log XSLT:", (Throwable)e);
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(512);
            TransformerHandler th = this.getTransformerHandler(linked);
            HL7XMLWriter xmlWriter = new HL7XMLWriter((Writer)new OutputStreamWriter((OutputStream)out, ISO_8859_1));
            th.setResult(new SAXResult(xmlWriter.getContentHandler()));
            mpps.writeDataset2((ContentHandler)th, null, null, 64, null);
            this.log.info((Object)new String(out.toByteArray()));
            return out.toByteArray();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to convert MPPS to ORM", (Throwable)e);
            this.log.error((Object)mpps);
            return null;
        }
    }

    private void logXSLT(Dataset mpps, boolean linked) throws Exception {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        String uid = mpps.getString(524312);
        String fn = (linked ? "mpps-linked-" : "mpps-received-") + uid;
        this.logXSLT(mpps, tf.newTransformerHandler(), new File(this.logDir, fn + ".xml"));
        this.logXSLT(mpps, this.getTransformerHandler(linked), new File(this.logDir, fn + ".orm.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logXSLT(Dataset mpps, TransformerHandler th, File logFile) throws Exception {
        TagDictionary dict = DictionaryFactory.getInstance().getDefaultTagDictionary();
        FileOutputStream out = new FileOutputStream(logFile);
        try {
            th.setResult(new StreamResult(out));
            mpps.writeDataset2((ContentHandler)th, dict, null, 64, null);
        }
        finally {
            out.close();
        }
    }

    private TransformerHandler getTransformerHandler(boolean linked) throws Exception {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        File xslFile = FileUtils.toExistingFile((String)this.xslPath);
        TransformerHandler th = tf.newTransformerHandler(this.templates.getTemplates(xslFile));
        Transformer t = th.getTransformer();
        t.setParameter("SendingApplication", linked ? this.linkedSendingApplication : this.receivedSendingApplication);
        t.setParameter("SendingFacility", linked ? this.linkedSendingFacility : this.receivedSendingFacility);
        t.setParameter("ReceivingApplication", linked ? this.linkedReceivingApplication : this.receivedReceivingApplication);
        t.setParameter("ReceivingFacility", linked ? this.linkedReceivingFacility : this.receivedReceivingFacility);
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset getMPPS(String iuid) {
        Dataset dataset;
        MPPSManager mgr = this.getMPPSManagerHome().create();
        try {
            dataset = mgr.getMPPS(iuid);
        }
        catch (Throwable throwable) {
            try {
                try {
                    mgr.remove();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to load MPPS - " + iuid), (Throwable)e);
                return null;
            }
        }
        try {
            mgr.remove();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return dataset;
    }
}

