/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.List;
import org.dcm4che.data.Dataset;
import org.dcm4che.util.Base64;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.hl7.HL7Exception;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.hl7.ORU_MDMService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.xml.sax.ContentHandler;

public class MDMService
extends ORU_MDMService {
    public boolean process(MSH msh, Document msg, ContentHandler hl7out, String[] xslSubdirs) throws HL7Exception {
        try {
            byte[] pdf = this.getPDF(msg);
            if (pdf == null) {
                this.log.warn((Object)("Ignore received " + msh.messageType + "^" + msh.triggerEvent + " without encapsulated report"));
                return true;
            }
            Dataset doc = this.xslt(msg, this.xslPath, xslSubdirs);
            if (!doc.containsValue(0x20000D)) {
                this.log.info((Object)"No Study Instance UID in MDM - store report in new Study");
                doc.putUI(0x20000D, UIDGenerator.getInstance().createUID());
            }
            doc.putOB(4325393, pdf);
            this.storeSR(doc);
        }
        catch (Exception e) {
            throw new HL7Exception("AE", e.getMessage(), e);
        }
        return true;
    }

    static String toString(Object el) {
        return el != null ? ((Element)el).getText() : "";
    }

    private byte[] getPDF(Document msg) {
        List obxs = msg.getRootElement().elements("OBX");
        String base64 = "";
        for (Element obx : obxs) {
            List cmps;
            List fds = obx.elements();
            if (fds.size() <= 4 || (cmps = ((Element)fds.get(4)).elements()).size() <= 3 || !"PDF".equals(MDMService.toString(cmps.get(1)))) continue;
            String obx2 = MDMService.toString(fds.get(1));
            if (!"ED".equals(obx2)) {
                this.log.warn((Object)("Detect encapsulated report in OBX with OBX-2: '" + obx2 + "' instead 'ED'"));
            }
            base64 = base64 + MDMService.toString(cmps.get(3));
        }
        return base64.length() > 0 ? Base64.base64ToByteArray((String)base64) : null;
    }
}

