/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che.server.Server;
import org.dcm4che.server.ServerFactory;
import org.dcm4che.util.MLLP_Protocol;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.hl7.HL7Exception;
import org.dcm4chex.archive.hl7.HL7Service;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXContentHandler;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerImplMBean;
import org.regenstrief.xhl7.HL7XMLReader;
import org.regenstrief.xhl7.HL7XMLWriter;
import org.regenstrief.xhl7.MLLPDriver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HL7ServerService
extends ServiceMBeanSupport
implements Server.Handler,
NotificationListener {
    public static final String EVENT_TYPE = "org.dcm4chex.archive.hl7";
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = 4049637871541892405L;

        public boolean isNotificationEnabled(Notification notif) {
            return HL7ServerService.EVENT_TYPE.equals(notif.getType());
        }
    };
    private static final String PREPROCESS_XSL = "preprocess";
    private static final String XSL_EXT = ".xsl";
    private String charsetName = "ISO-8859-1";
    private String ackXslPath;
    private String logXslPath;
    private File logDir;
    private String errLogDirPath;
    private File errLogDir;
    private Server hl7srv = ServerFactory.getInstance().newServer((Server.Handler)this);
    private MLLP_Protocol protocol = MLLP_Protocol.MLLP;
    private boolean fileReceivedHL7AsXML;
    private boolean fileReceivedHL7;
    private boolean fileReceivedHL7OnError;
    private boolean suppressErrorResponse;
    private boolean sendNotification;
    private boolean useHostSubdirs;
    private int soTimeout = 0;
    private int numberOfReceivedMessages = 0;
    private TLSConfigDelegate tlsConfig = new TLSConfigDelegate((ServiceMBeanSupport)this);
    private TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);
    private Hashtable serviceRegistry = new Hashtable();
    private String[] noopMessageTypes = new String[0];
    private boolean jbossStarted;

    public final String getCharsetName() {
        return this.charsetName;
    }

    public final void setCharsetName(String charsetName) {
        this.charsetName = Charset.forName(charsetName).name();
    }

    public final String getAckStylesheet() {
        return this.ackXslPath;
    }

    public void setAckStylesheet(String path) {
        this.ackXslPath = path;
    }

    public final String getLogStylesheet() {
        return this.logXslPath;
    }

    public void setLogStylesheet(String path) {
        this.logXslPath = path;
    }

    public final String getTemplateDir() {
        return this.templates.getConfigDir();
    }

    public final void setTemplateDir(String path) {
        this.templates.setConfigDir(path);
    }

    public boolean isUseHostSubdirs() {
        return this.useHostSubdirs;
    }

    public void setUseHostSubdirs(boolean useHostSubdirs) {
        this.useHostSubdirs = useHostSubdirs;
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public int getPort() {
        return this.hl7srv.getPort();
    }

    public void setPort(int port) {
        this.hl7srv.setPort(port);
    }

    public String getLocalAddress() {
        return this.hl7srv.getLocalAddress();
    }

    public void setLocalAddress(String localAddress) {
        this.hl7srv.setLocalAddress(localAddress);
    }

    public final String getNoopMessageTypes() {
        return StringUtils.toString((String[])this.noopMessageTypes, (char)',');
    }

    public final void setNoopMessageTypes(String noopMessageTypes) {
        this.noopMessageTypes = StringUtils.split((String)noopMessageTypes, (char)',');
    }

    public String getProtocolName() {
        return this.protocol.toString();
    }

    public void setProtocolName(String protocolName) {
        this.protocol = MLLP_Protocol.valueOf((String)protocolName);
    }

    public final int getReceiveBufferSize() {
        return this.hl7srv.getReceiveBufferSize();
    }

    public final void setReceiveBufferSize(int size) {
        this.hl7srv.setReceiveBufferSize(size);
    }

    public final int getSendBufferSize() {
        return this.hl7srv.getSendBufferSize();
    }

    public final void setSendBufferSize(int size) {
        this.hl7srv.setSendBufferSize(size);
    }

    public final boolean isTcpNoDelay() {
        return this.hl7srv.isTcpNoDelay();
    }

    public final void setTcpNoDelay(boolean on) {
        this.hl7srv.setTcpNoDelay(on);
    }

    public int getMaxClients() {
        return this.hl7srv.getMaxClients();
    }

    public void setMaxClients(int newMaxClients) {
        this.hl7srv.setMaxClients(newMaxClients);
    }

    public int getNumClients() {
        return this.hl7srv.getNumClients();
    }

    public int getMaxIdleThreads() {
        return this.hl7srv.getMaxIdleThreads();
    }

    public int getNumIdleThreads() {
        return this.hl7srv.getNumIdleThreads();
    }

    public void setMaxIdleThreads(int max) {
        this.hl7srv.setMaxIdleThreads(max);
    }

    public final boolean isFileReceivedHL7AsXML() {
        return this.fileReceivedHL7AsXML;
    }

    public final void setFileReceivedHL7AsXML(boolean fileReceivedHL7AsXML) {
        this.fileReceivedHL7AsXML = fileReceivedHL7AsXML;
    }

    public final boolean isFileReceivedHL7() {
        return this.fileReceivedHL7;
    }

    public final void setFileReceivedHL7(boolean fileReceivedHL7) {
        this.fileReceivedHL7 = fileReceivedHL7;
    }

    public final boolean isFileReceivedHL7OnError() {
        return this.fileReceivedHL7OnError;
    }

    public final void setFileReceivedHL7OnError(boolean fileReceivedHL7) {
        this.fileReceivedHL7OnError = fileReceivedHL7;
    }

    public final String getErrorLogDirectory() {
        return this.errLogDirPath;
    }

    public final void setErrorLogDirectory(String errLogDirPath) {
        this.errLogDirPath = errLogDirPath;
        this.errLogDir = FileUtils.toFile((String)errLogDirPath);
    }

    public final boolean isSuppressErrorResponse() {
        return this.suppressErrorResponse;
    }

    public final void setSuppressErrorResponse(boolean suppressErrorResponse) {
        this.suppressErrorResponse = suppressErrorResponse;
    }

    public final int getSoTimeout() {
        return this.soTimeout;
    }

    public final void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public final boolean isSendNotification() {
        return this.sendNotification;
    }

    public final void setSendNotification(boolean sendNotification) {
        this.sendNotification = sendNotification;
    }

    public final int getNumberOfReceivedMessages() {
        return this.numberOfReceivedMessages;
    }

    public void registerService(String messageType, HL7Service service) {
        if (service != null) {
            this.serviceRegistry.put(messageType, service);
        } else {
            this.serviceRegistry.remove(messageType);
        }
    }

    protected void startService() throws Exception {
        if (this.jbossStarted) {
            this.log.info((Object)"Start HL7 server after restart of HL7Server service!");
            this.startHL7Server();
        } else {
            this.logDir = new File(System.getProperty("jboss.server.log.dir"));
            this.hl7srv.addHandshakeFailedListener(this.tlsConfig.handshakeFailedListener());
            this.hl7srv.addHandshakeCompletedListener(this.tlsConfig.handshakeCompletedListener());
            this.hl7srv.setServerSocketFactory(this.tlsConfig.serverSocketFactory(this.protocol.getCipherSuites()));
            this.server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
        }
    }

    protected void stopService() throws Exception {
        this.hl7srv.stop();
    }

    public void handleNotification(Notification msg, Object arg1) {
        if (msg.getType().equals("org.jboss.system.server.started")) {
            this.startHL7Server();
            this.jbossStarted = true;
            try {
                this.server.removeNotificationListener(ServerImplMBean.OBJECT_NAME, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startHL7Server() {
        try {
            this.hl7srv.start();
        }
        catch (IOException x) {
            this.log.error((Object)"Start of HL7 Server failed!", (Throwable)x);
        }
    }

    public void ack(Document document, ContentHandler hl7out, HL7Exception hl7ex) {
        try {
            File ackXslFile = FileUtils.toExistingFile((String)this.ackXslPath);
            Transformer t = this.templates.getTemplates(ackXslFile).newTransformer();
            if (hl7ex != null) {
                t.setParameter("AcknowledgementCode", hl7ex.getAcknowledgementCode());
                String msg = hl7ex.getMessage();
                t.setParameter("TextMessage", msg == null ? "Exception:" + hl7ex.getCause() : msg);
            }
            t.transform((Source)new DocumentSource(document), new SAXResult(hl7out));
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to acknowlege message", (Throwable)e);
        }
    }

    private HL7Service getService(MSH msh) throws HL7Exception {
        String messageType = msh.messageType + '^' + msh.triggerEvent;
        HL7Service service = (HL7Service)this.serviceRegistry.get(messageType);
        if (service == null && Arrays.asList(this.noopMessageTypes).indexOf(messageType) == -1) {
            throw new HL7Exception("AR", "Unsupported message type: " + messageType.replace('^', '_'));
        }
        return service;
    }

    public void handle(Socket s) throws IOException {
        if (this.soTimeout > 0) {
            s.setSoTimeout(this.soTimeout);
        }
        InetSocketAddress inetAddr = (InetSocketAddress)s.getRemoteSocketAddress();
        MLLPDriver mllpDriver = new MLLPDriver(s.getInputStream(), (OutputStream)new BufferedOutputStream(s.getOutputStream()), false);
        InputStream mllpIn = mllpDriver.getInputStream();
        HL7XMLReader xmlReader = new HL7XMLReader();
        HL7XMLWriter xmlWriter = new HL7XMLWriter((Writer)new OutputStreamWriter(mllpDriver.getOutputStream(), this.charsetName));
        ContentHandler hl7out = xmlWriter.getContentHandler();
        SAXContentHandler hl7in = new SAXContentHandler();
        xmlReader.setContentHandler((ContentHandler)hl7in);
        byte[] bb = new byte[1024];
        while (mllpDriver.hasMoreInput()) {
            ++this.numberOfReceivedMessages;
            int msglen = 0;
            int read = 0;
            long msgNo = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Receiving message #" + msgNo + " from " + s));
            }
            do {
                if ((msglen += read) != bb.length) continue;
                bb = this.realloc(bb, bb.length, bb.length * 2);
            } while ((read = mllpIn.read(bb, msglen, bb.length - msglen)) > 0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received message  #" + msgNo + "of" + msglen + " bytes from " + s));
            }
            if (this.fileReceivedHL7) {
                this.fileReceivedHL7(bb, msglen, new File(this.logDir, new DecimalFormat("'hl7-'#'.hl7'").format(msgNo)));
            }
            try {
                try {
                    MSH msh;
                    HL7Service service;
                    Document newMsg;
                    ByteArrayInputStream bbin = new ByteArrayInputStream(bb, 0, msglen);
                    InputSource in = new InputSource(new InputStreamReader((InputStream)bbin, this.charsetName));
                    xmlReader.parse(in);
                    Document msg = hl7in.getDocument();
                    this.log.info((Object)"Received HL7 message:");
                    this.logMessage(msg);
                    if (this.fileReceivedHL7AsXML) {
                        this.fileReceivedHL7AsXML(msg, new File(this.logDir, new DecimalFormat("'hl7-'000000'.xml'").format(msgNo)));
                    }
                    if ((newMsg = this.preprocessHL7(msg, inetAddr)) != null) {
                        msg = newMsg;
                        this.log.info((Object)"HL7 message changed by preprocess.xsl!");
                        this.logMessage(msg);
                        if (this.fileReceivedHL7AsXML) {
                            this.fileReceivedHL7AsXML(msg, new File(this.logDir, new DecimalFormat("'hl7-'000000'.preprocessed.xml'").format(msgNo)));
                        }
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(msglen);
                        HL7XMLWriter xmlWriter1 = new HL7XMLWriter((Writer)new OutputStreamWriter((OutputStream)bos, this.getCharsetName()));
                        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
                        try {
                            Transformer t = tf.newTransformer();
                            t.transform((Source)new DocumentSource(msg), new SAXResult(xmlWriter1.getContentHandler()));
                            bb = bos.toByteArray();
                            msglen = bb.length;
                        }
                        catch (Exception x) {
                            this.log.error((Object)"Failed to preprocess HL7 message!", (Throwable)x);
                        }
                    }
                    if ((service = this.getService(msh = new MSH(msg))) == null || service.process(msh, msg, hl7out, this.getXsltSearchDirectories(inetAddr, msh))) {
                        this.ack(msg, hl7out, null);
                    }
                    if (this.sendNotification) {
                        this.sendNotification(this.makeNotification(this.realloc(bb, msglen, msglen), msg));
                    }
                }
                catch (SAXException e) {
                    throw new HL7Exception("AE", "Failed to parse message ", e);
                }
            }
            catch (HL7Exception e) {
                if (this.fileReceivedHL7OnError) {
                    this.fileReceivedHL7(bb, msglen, new File(this.errLogDir, new DecimalFormat("'hl7-'000000'.hl7'").format(msgNo)));
                }
                this.log.warn((Object)"Processing HL7 failed:", (Throwable)e);
                mllpDriver.discardPendingOutput();
                this.ack(hl7in.getDocument(), hl7out, this.suppressErrorResponse ? null : e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending response message #" + msgNo + " to " + s));
            }
            mllpDriver.turn();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Sent response message #" + msgNo + " to " + s));
        }
    }

    private String[] getXsltSearchDirectories(InetSocketAddress inetAddr, MSH msh) {
        String[] stringArray;
        String hostname;
        String sending = msh.sendingApplication + "^" + msh.sendingFacility;
        String ipAddr = !this.useHostSubdirs || inetAddr == null ? null : inetAddr.getAddress().getHostAddress();
        String string = hostname = ipAddr == null ? null : inetAddr.getHostName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("get XSLT search subdirs for ipAddr:" + ipAddr + " hostname:" + hostname + " sending:" + sending));
        }
        if (ipAddr == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = sending;
        } else if (hostname == null) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = ipAddr;
            stringArray = stringArray3;
            stringArray3[1] = sending;
        } else {
            String[] stringArray4 = new String[3];
            stringArray4[0] = ipAddr;
            stringArray4[1] = hostname;
            stringArray = stringArray4;
            stringArray4[2] = sending;
        }
        String[] subdirs = stringArray;
        return subdirs;
    }

    private Document preprocessHL7(Document msg, InetSocketAddress inetAddr) {
        MSH msh = new MSH(msg);
        String[] subdirs = this.getXsltSearchDirectories(inetAddr, msh);
        String[] variations = new String[]{"_" + msh.messageType + "^" + msh.triggerEvent, "_" + msh.messageType, ""};
        Templates xslt = this.templates.findTemplates(subdirs, PREPROCESS_XSL, variations, XSL_EXT);
        if (xslt != null) {
            this.log.info((Object)"Preprocess HL7 message with stylesheet!");
            try {
                Transformer t = xslt.newTransformer();
                DocumentResult result = new DocumentResult();
                t.transform((Source)new DocumentSource(msg), (Result)result);
                return result.getDocument();
            }
            catch (Exception x) {
                this.log.error((Object)"Can not apply preprocess stylesheet!", (Throwable)x);
            }
        }
        return null;
    }

    private void fileReceivedHL7(byte[] bb, int msglen, File logfile) {
        if (logfile.getParentFile().mkdirs()) {
            this.log.info((Object)("M-WRITE " + logfile.getParentFile()));
        }
        try {
            BufferedOutputStream loghl7 = new BufferedOutputStream(new FileOutputStream(logfile));
            ((OutputStream)loghl7).write(bb, 0, msglen);
            ((OutputStream)loghl7).close();
        }
        catch (IOException e) {
            this.log.warn((Object)("Failed to log received HL7 message to " + logfile), (Throwable)e);
        }
    }

    private byte[] realloc(byte[] bb, int len, int newlen) {
        byte[] out = new byte[newlen];
        System.arraycopy(bb, 0, out, 0, len);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileReceivedHL7AsXML(Document msg, File f) {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            FileOutputStream out = new FileOutputStream(f);
            try {
                tr.transform((Source)new DocumentSource(msg), new StreamResult(out));
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to log HL7 to " + f), (Throwable)e);
        }
    }

    public void logMessage(Document document) {
        if (!this.log.isInfoEnabled()) {
            return;
        }
        try {
            StringWriter out = new StringWriter();
            File logXslFile = FileUtils.toExistingFile((String)this.logXslPath);
            Transformer t = this.templates.getTemplates(logXslFile).newTransformer();
            t.transform((Source)new DocumentSource(document), new StreamResult(out));
            this.log.info((Object)out.toString());
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to log message", (Throwable)e);
        }
    }

    public boolean isSockedClosedByHandler() {
        return false;
    }

    private Notification makeNotification(byte[] hl7msg, Document msg) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(EVENT_TYPE, this, eventID);
        notif.setUserData(new Object[]{hl7msg, msg});
        return notif;
    }
}

