/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.QueryMessage;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.AEManagerHome;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.hl7.ACK;
import org.dcm4chex.archive.hl7.ERR;
import org.dcm4chex.archive.hl7.HL7Exception;
import org.dcm4chex.archive.hl7.HL7SendOrder;
import org.dcm4chex.archive.hl7.HL7ServerService;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.hl7.RSP;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.XSLTUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXContentHandler;
import org.jboss.system.ServiceMBeanSupport;
import org.regenstrief.xhl7.HL7XMLReader;
import org.regenstrief.xhl7.HL7XMLWriter;
import org.regenstrief.xhl7.MLLPDriver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HL7SendService
extends ServiceMBeanSupport
implements NotificationListener,
MessageListener {
    private static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    private static final ParticipantObject.IDTypeCode PIX_QUERY = new ParticipantObject.IDTypeCode("ITI-9", "IHE Transactions", "PIX Query");
    private static final AuditEvent.TypeCode PIX_QUERY_EVENT_TYPE = new AuditEvent.TypeCode("ITI-9", "IHE Transactions", "PIX Query");
    private static final String LOCAL_HL7_AET = "LOCAL^LOCAL";
    private static final String DATETIME_FORMAT = "yyyyMMddHHmmss";
    private static final String FORWARD_XSL = "hl7forward";
    private static final String XSL_EXT = ".xsl";
    private static long msgCtrlid;
    private static long queryTag;
    private String queueName;
    private String sendingApplication;
    private String sendingFacility;
    private int acTimeout;
    private int soCloseDelay;
    private boolean auditPIXQuery;
    private ObjectName hl7ServerName;
    private TLSConfigDelegate tlsConfig = new TLSConfigDelegate((ServiceMBeanSupport)this);
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private ForwardingRules forwardingRules = new ForwardingRules("");
    private int concurrency = 1;
    private JMSDelegate jmsDelegate = new JMSDelegate((ServiceMBeanSupport)this);
    protected TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);
    private static String[] FIELD_NAMES;

    public String getCharsetName() {
        try {
            return (String)this.getServer().getAttribute(this.hl7ServerName, "CharsetName");
        }
        catch (Exception x) {
            throw new ConfigurationException((Throwable)x);
        }
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public final String getSendingApplication() {
        return this.sendingApplication;
    }

    public final void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public final String getSendingFacility() {
        return this.sendingFacility;
    }

    public final void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    public String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls(text);
    }

    public final int getAcTimeout() {
        return this.acTimeout;
    }

    public final void setAcTimeout(int acTimeout) {
        this.acTimeout = acTimeout;
    }

    public final int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public final void setSoCloseDelay(int soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public final boolean isAuditPIXQuery() {
        return this.auditPIXQuery;
    }

    public final void setAuditPIXQuery(boolean auditPIXQuery) {
        this.auditPIXQuery = auditPIXQuery;
    }

    public final String getForwardTemplateDir() {
        return this.templates.getConfigDir();
    }

    public final void setForwardTemplateDir(String path) {
        this.templates.setConfigDir(path);
    }

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final ObjectName getHL7ServerName() {
        return this.hl7ServerName;
    }

    public final void setHL7ServerName(ObjectName hl7ServerName) {
        this.hl7ServerName = hl7ServerName;
    }

    public final String getForwardingRules() {
        return this.forwardingRules.toString();
    }

    public final void setForwardingRules(String s) {
        this.forwardingRules = new ForwardingRules(s);
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, (MessageListener)this, this.concurrency);
        this.server.addNotificationListener(this.hl7ServerName, this, HL7ServerService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.hl7ServerName, this, HL7ServerService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
        Object[] hl7msg = (Object[])notif.getUserData();
        this.forward((byte[])hl7msg[0], (Document)hl7msg[1]);
    }

    public int forward(byte[] hl7msg) {
        HL7XMLReader xmlReader = new HL7XMLReader();
        SAXContentHandler hl7in = new SAXContentHandler();
        xmlReader.setContentHandler((ContentHandler)hl7in);
        try {
            InputSource in = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(hl7msg), this.getCharsetName()));
            xmlReader.parse(in);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to parse HL7 message", (Throwable)e);
            return -1;
        }
        return this.forward(hl7msg, hl7in.getDocument());
    }

    private int forward(byte[] hl7msg, Document msg) {
        MSH msh = new MSH(msg);
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        String sending = msh.sendingApplication + '^' + msh.sendingFacility;
        param.put("sending", new String[]{sending});
        param.put("receiving", new String[]{msh.receivingApplication + '^' + msh.receivingFacility});
        param.put("msgtype", new String[]{msh.messageType + '^' + msh.triggerEvent});
        String[] dests = this.forwardingRules.getForwardDestinationsFor(param);
        if (dests.length > 0) {
            hl7msg = this.preprocessForward(hl7msg, msg, msh, sending);
        }
        int count = 0;
        for (int i = 0; i < dests.length; ++i) {
            HL7SendOrder order = new HL7SendOrder(hl7msg, dests[i]);
            try {
                order.processOrderProperties(msh);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to process order properties for " + order), (Throwable)e);
            }
            try {
                this.log.info((Object)("Scheduling " + order));
                this.jmsDelegate.queue(this.queueName, (Serializable)order, 4, 0L);
                ++count;
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            }
        }
        return count;
    }

    private byte[] preprocessForward(byte[] hl7msg, Document msg, MSH msh, String sending) {
        String[] variations = new String[]{"_" + msh.messageType + "^" + msh.triggerEvent, "_" + msh.messageType, ""};
        Templates xslt = this.templates.findTemplates(new String[]{sending}, FORWARD_XSL, variations, XSL_EXT);
        if (xslt != null) {
            this.log.info((Object)"Transform HL7 message with hl7forward stylesheet!");
            try {
                Transformer t = xslt.newTransformer();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(hl7msg.length);
                HL7XMLWriter xmlWriter = new HL7XMLWriter((Writer)new OutputStreamWriter((OutputStream)bos, this.getCharsetName()));
                t.transform((Source)new DocumentSource(msg), new SAXResult(xmlWriter.getContentHandler()));
                hl7msg = bos.toByteArray();
            }
            catch (Exception x) {
                this.log.error((Object)"Can not apply hl7forward stylesheet!", (Throwable)x);
            }
        }
        return hl7msg;
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                HL7SendOrder order = (HL7SendOrder)om.getObject();
                try {
                    this.log.info((Object)("Start processing " + order));
                    this.sendTo(order.getHL7Message(), order.getReceiving());
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order));
                        this.jmsDelegate.fail(this.queueName, (Serializable)order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, (Serializable)order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document invoke(byte[] message, String receiver) throws Exception {
        AEDTO localAE = new AEDTO();
        localAE.setTitle(receiver);
        localAE.setHostName("127.0.0.1");
        localAE.setPort(this.getLocalHL7Port());
        AEDTO remoteAE = LOCAL_HL7_AET.equals(receiver) ? localAE : this.aeMgt().findByAET(receiver);
        Socket s = this.tlsConfig.createSocket(localAE, remoteAE);
        try {
            MLLPDriver mllpDriver = new MLLPDriver(s.getInputStream(), s.getOutputStream(), true);
            this.writeMessage(message, receiver, mllpDriver.getOutputStream());
            mllpDriver.turn();
            if (this.acTimeout > 0) {
                s.setSoTimeout(this.acTimeout);
            }
            if (!mllpDriver.hasMoreInput()) {
                throw new IOException("Receiver " + receiver + " closed socket " + s + " during waiting on response.");
            }
            Document document = this.readMessage(mllpDriver.getInputStream());
            return document;
        }
        finally {
            if (this.soCloseDelay > 0) {
                try {
                    Thread.sleep(this.soCloseDelay);
                }
                catch (InterruptedException ignore) {}
            }
            s.close();
        }
    }

    public void sendTo(byte[] message, String receiver) throws Exception {
        Document rsp = this.invoke(message, receiver);
        this.checkResponse(rsp);
    }

    private void checkResponse(Document rsp) throws HL7Exception {
        MSH msh = new MSH(rsp);
        if ("ACK".equals(msh.messageType)) {
            ACK ack = new ACK(rsp);
            if (!"AA".equals(ack.acknowledgmentCode) && !"CA".equals(ack.acknowledgmentCode)) {
                throw new HL7Exception(ack.acknowledgmentCode, ack.textMessage);
            }
        } else {
            this.log.warn((Object)("Unsupport response message type: " + msh.messageType + '^' + msh.triggerEvent + ". Assume successful message forward."));
        }
    }

    private int getLocalHL7Port() {
        try {
            return (Integer)this.getServer().getAttribute(this.hl7ServerName, "Port");
        }
        catch (Exception x) {
            this.log.error((Object)"Cant get local HL7 port!", (Throwable)x);
            return -1;
        }
    }

    private Document readMessage(InputStream mllpIn) throws IOException, SAXException {
        InputSource in = new InputSource(mllpIn);
        in.setEncoding(this.getCharsetName());
        HL7XMLReader xmlReader = new HL7XMLReader();
        SAXContentHandler hl7in = new SAXContentHandler();
        xmlReader.setContentHandler((ContentHandler)hl7in);
        xmlReader.parse(in);
        Document msg = hl7in.getDocument();
        return msg;
    }

    private void writeMessage(byte[] message, String receiving, OutputStream out) throws UnsupportedEncodingException, IOException {
        String charsetName = this.getCharsetName();
        int offs = this.writePartTo(out, message, '|', 0, 4);
        int delim = receiving.indexOf(94);
        out.write(receiving.substring(0, delim).getBytes(charsetName));
        out.write(124);
        out.write(receiving.substring(delim + 1).getBytes(charsetName));
        while (message[++offs] != 124) {
        }
        while (message[++offs] != 124) {
        }
        out.write(message, offs, message.length - offs);
    }

    private int writePartTo(OutputStream out, byte[] ba, char b, int offs, int count) throws IOException {
        for (int i = offs; i < ba.length; ++i) {
            if (ba[i] != b || --count != 0) continue;
            out.write(ba, offs, i - offs + 1);
            return i;
        }
        return -1;
    }

    public void sendHL7PatientXXX(Dataset ds, String msgType, String sending, String receiving, boolean useForward) throws Exception {
        String timestamp = new SimpleDateFormat(DATETIME_FORMAT).format(new Date());
        StringBuffer sb = this.makeMSH(timestamp, msgType, sending, receiving, ++msgCtrlid, "2.3.1");
        this.addEVN(sb, timestamp);
        this.addPID(sb, ds);
        sb.append("\rPV1||||||||||||||||||||||||||||||||||||||||||||||||||||\r");
        String charsetName = this.getCharsetName();
        if (useForward) {
            this.forward(sb.toString().getBytes(charsetName));
        } else {
            this.sendTo(sb.toString().getBytes(charsetName), receiving);
        }
    }

    public void sendHL7PatientMerge(Dataset dsDominant, Dataset[] priorPats, String sending, String receiving, boolean useForward) throws Exception {
        String timestamp = new SimpleDateFormat(DATETIME_FORMAT).format(new Date());
        StringBuffer sb = this.makeMSH(timestamp, "ADT^A40", sending, receiving, ++msgCtrlid, "2.3.1");
        this.addEVN(sb, timestamp);
        this.addPID(sb, dsDominant);
        int SBlen = sb.length();
        String charsetName = this.getCharsetName();
        int len = priorPats.length;
        for (int i = 0; i < len; ++i) {
            sb.setLength(SBlen);
            this.addMRG(sb, priorPats[i]);
            sb.append('\r');
            if (useForward) {
                this.forward(sb.toString().getBytes(charsetName));
                continue;
            }
            this.sendTo(sb.toString().getBytes(charsetName), receiving);
        }
    }

    public List<Map<String, String>> sendQBP_Q22(String pdqManager, Map<String, String> query, String domain, int count, String continuation) throws Exception {
        String timestamp = new SimpleDateFormat(DATETIME_FORMAT).format(new Date());
        StringBuffer sb = this.makeMSH(timestamp, "QBP^Q22", null, pdqManager, ++msgCtrlid, "2.5");
        String qpd = this.makeQPD_Q22(query, domain);
        sb.append('\r').append(qpd).append("\rRCP|I||||||\r");
        String s = sb.toString();
        this.log.info((Object)("Query PDQ Manager " + pdqManager + ":\n" + s.replace('\r', '\n')));
        String charsetName = this.getCharsetName();
        Document msg = this.invoke(s.getBytes(charsetName), pdqManager);
        this.log.info((Object)"PDQ Query returns:");
        this.logMessage(msg);
        List<Map<String, String>> ret = HL7SendService.parsePDQ(msg);
        this.log.info((Object)("Returning PDQ response now:" + HL7SendService.toString(ret)));
        return ret;
    }

    public static final String toString(List<Map<String, String>> lst) {
        StringBuffer sb = new StringBuffer("[");
        boolean listFirst = true;
        for (Map<String, String> map : lst) {
            if (listFirst) {
                listFirst = false;
            } else {
                sb.append(",\n  ");
            }
            sb.append("{");
            boolean first = true;
            for (Map.Entry<String, String> me : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(me.getKey()).append(":\"").append(me.getValue()).append("\"");
            }
            sb.append("}");
        }
        sb.append(']');
        return sb.toString();
    }

    public static final List<Map<String, String>> parsePDQ(Document msg) {
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        Element root = msg.getRootElement();
        List content = root.content();
        for (Object c : content) {
            Element e;
            if (!(c instanceof Element) || !(e = (Element)c).getName().equals("PID")) continue;
            HashMap<String, String> pid = new HashMap<String, String>();
            pid.put("Type", "Patient");
            List fields = e.elements("field");
            int pidNo = 0;
            for (Object f : fields) {
                String fieldName;
                if (++pidNo >= FIELD_NAMES.length || (fieldName = FIELD_NAMES[pidNo]) == null) continue;
                Element field = (Element)f;
                if (field.isTextOnly()) {
                    String txt = field.getText();
                    if (txt == null || txt.length() == 0) continue;
                    pid.put(fieldName, txt);
                    continue;
                }
                if (pidNo == 3) {
                    List comps = field.elements("component");
                    if (comps.size() < 3) {
                        throw new IllegalArgumentException("Missing Authority in PID-3");
                    }
                    Element authority = (Element)comps.get(2);
                    List authorityUID = authority.elements("subcomponent");
                    pid.put("PatientID", field.getText());
                    StringBuffer issuer = new StringBuffer(authority.getText());
                    for (int i = 0; i < authorityUID.size(); ++i) {
                        issuer.append("&").append(((Element)authorityUID.get(i)).getText());
                    }
                    pid.put("IssuerOfPatientID", issuer.toString());
                    continue;
                }
                if (pidNo == 5) {
                    String name = field.getText() + "^" + field.elementText("component");
                    pid.put(fieldName, name);
                    continue;
                }
                pid.put(fieldName, field.asXML());
            }
            ret.add(pid);
        }
        return ret;
    }

    public String showQBP_Q22(String pdqManager, String query, String domain) throws Exception {
        String timestamp = new SimpleDateFormat(DATETIME_FORMAT).format(new Date());
        StringBuffer sb = this.makeMSH(timestamp, "QBP^Q22", null, pdqManager, ++msgCtrlid, "2.5");
        String qpd = this.makeQPD_Q22(query, domain);
        sb.append('\r').append(qpd).append("\rRCP|I||||||\r");
        String s = sb.toString();
        this.log.info((Object)("Query PDQ Manager " + pdqManager + ":\n" + s.replace('\r', '\n')));
        String charsetName = this.getCharsetName();
        Document msg = this.invoke(s.getBytes(charsetName), pdqManager);
        this.log.info((Object)"PIX Query returns:");
        this.logMessage(msg);
        List<Map<String, String>> results = HL7SendService.parsePDQ(msg);
        return "PDQ query results:\n" + HL7SendService.toString(results);
    }

    public List<String[]> sendQBP_Q23(String pixManager, String pixQueryName, String patientID, String issuer, String[] domains) throws Exception {
        String timestamp = new SimpleDateFormat(DATETIME_FORMAT).format(new Date());
        long msgCtrlid = ++HL7SendService.msgCtrlid;
        long queryTag = ++HL7SendService.queryTag;
        StringBuffer sb = this.makeMSH(timestamp, "QBP^Q23^QBP_Q21", null, pixManager, msgCtrlid, "2.5");
        String qpd = this.makeQPD(pixQueryName, queryTag, patientID, issuer, domains);
        sb.append('\r').append(qpd).append("\rRCP|I||||||\r");
        String s = sb.toString();
        this.log.info((Object)("Query PIX Manager " + pixManager + ":\n" + s.replace('\r', '\n')));
        String charsetName = this.getCharsetName();
        try {
            ERR err;
            Document msg = this.invoke(s.getBytes(charsetName), pixManager);
            this.log.info((Object)"PIX Query returns:");
            this.logMessage(msg);
            MSH msh = new MSH(msg);
            if (!"RSP".equals(msh.messageType) || !"K23".equals(msh.triggerEvent)) {
                String prompt = "Unsupport response message type: " + msh.messageType + '^' + msh.triggerEvent;
                this.log.error((Object)prompt);
                throw new IOException(prompt);
            }
            RSP rsp = new RSP(msg);
            if ("AE".equals(rsp.acknowledgmentCode) && (err = new ERR(msg)).isUnknownKeyIdentifier()) {
                return null;
            }
            if (!"AA".equals(rsp.acknowledgmentCode)) {
                this.log.error((Object)("PIX Query fails with code " + rsp.acknowledgmentCode + " - " + rsp.textMessage));
                throw new HL7Exception(rsp.acknowledgmentCode, rsp.textMessage);
            }
            if (this.auditPIXQuery) {
                this.auditPIXQuery(pixManager, patientID, issuer, msgCtrlid, queryTag, qpd, null);
            }
            return rsp.getPatientIDs();
        }
        catch (Exception e) {
            if (this.auditPIXQuery) {
                this.auditPIXQuery(pixManager, patientID, issuer, msgCtrlid, queryTag, qpd, e);
            }
            throw e;
        }
    }

    private String makeQPD(String pixQueryName, long queryTag, String patientID, String issuer, String[] domains) {
        StringBuffer sb = new StringBuffer("QPD|");
        sb.append(pixQueryName).append('|');
        sb.append(queryTag).append('|');
        sb.append(patientID).append("^^^").append(issuer);
        if (domains != null && domains.length > 0) {
            sb.append("|^^^").append(domains[0]);
            for (int i = 1; i < domains.length; ++i) {
                sb.append("~^^^").append(domains[i]);
            }
        }
        return sb.toString();
    }

    private String makeQPD_Q22(Map<String, String> params, String domain) {
        StringBuffer sb = new StringBuffer("QPD|IHE PDQ Query|");
        sb.append(++queryTag).append('|');
        Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
        String sep = null;
        while (it.hasNext()) {
            Map.Entry<String, String> me = it.next();
            if (sep == null) {
                sep = "~";
            } else {
                sb.append(sep);
            }
            sb.append('@').append(me.getKey()).append("^").append(me.getValue());
        }
        sb.append("|||||");
        if (domain != null) {
            sb.append("^^^").append(domain);
        }
        return sb.toString();
    }

    private String makeQPD_Q22(String query, String domain) {
        StringBuffer sb = new StringBuffer("QPD|IHE PDQ Query|");
        sb.append(++queryTag).append('|').append(query);
        if (domain != null) {
            sb.append("|||||^^^").append(domain);
        }
        return sb.toString();
    }

    private void auditPIXQuery(String pixManager, String patientID, String issuer, long msgCtrlid, long queryTag, String qpd, Exception e) {
        try {
            QueryMessage msg = new QueryMessage();
            msg.getAuditEvent().addEventTypeCode(PIX_QUERY_EVENT_TYPE);
            ActiveParticipant source1 = ActiveParticipant.createActivePerson((String)(this.sendingFacility + '|' + this.sendingApplication), (String)AuditMessage.getProcessID(), null, (String)AuditMessage.getLocalHostName(), (boolean)true);
            source1.addRoleIDCode(ActiveParticipant.RoleIDCode.SOURCE);
            msg.addActiveParticipant(source1);
            HttpServletRequest httprq = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
            if (httprq != null) {
                String remoteUser = httprq.getRemoteUser();
                String remoteHost = httprq.getRemoteHost();
                if (remoteUser != null) {
                    ActiveParticipant source2 = ActiveParticipant.createActivePerson((String)remoteUser, null, (String)remoteUser, (String)remoteHost, (boolean)true);
                    msg.addActiveParticipant(source2);
                }
            }
            AEDTO pixManagerInfo = this.aeMgt().findByAET(pixManager);
            ActiveParticipant dest = ActiveParticipant.createActivePerson((String)pixManager.replace('^', '|'), null, null, (String)pixManagerInfo.getHostName(), (boolean)false);
            dest.addRoleIDCode(ActiveParticipant.RoleIDCode.DESTINATION);
            msg.addActiveParticipant(dest);
            ParticipantObject patObj = new ParticipantObject(patientID + "^^^" + issuer, ParticipantObject.IDTypeCode.PATIENT_ID);
            patObj.setParticipantObjectTypeCode(ParticipantObject.TypeCode.PERSON);
            patObj.setParticipantObjectTypeCodeRole(ParticipantObject.TypeCodeRole.PATIENT);
            msg.addParticipantObject(patObj);
            ParticipantObject queryObj = new ParticipantObject(String.valueOf(queryTag), PIX_QUERY);
            queryObj.setParticipantObjectTypeCode(ParticipantObject.TypeCode.SYSTEM);
            queryObj.setParticipantObjectTypeCodeRole(ParticipantObject.TypeCodeRole.QUERY);
            queryObj.setParticipantObjectQuery(qpd.getBytes("UTF-8"));
            queryObj.addParticipantObjectDetail("MSH-10", String.valueOf(msgCtrlid));
            msg.addParticipantObject(queryObj);
            Logger auditlog = Logger.getLogger((String)"auditlog");
            if (e == null) {
                auditlog.info((Object)msg);
            } else {
                msg.setOutcomeIndicator(AuditEvent.OutcomeIndicator.MAJOR_FAILURE);
                auditlog.warn((Object)msg);
            }
        }
        catch (Exception e2) {
            this.log.warn((Object)"Failed to send Audit Log Used message", (Throwable)e2);
        }
    }

    private void logMessage(Document msg) {
        try {
            this.server.invoke(this.hl7ServerName, "logMessage", new Object[]{msg}, new String[]{Document.class.getName()});
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to log message", (Throwable)e);
        }
    }

    private StringBuffer makeMSH(String timestamp, String msgType, String sending, String receiving, long msgCtrlid, String version) {
        int delim;
        StringBuffer sb = new StringBuffer();
        sb.append("MSH|^~\\&|");
        if (sending == null || sending.trim().length() == 0) {
            sb.append(this.getSendingApplication()).append("|");
            sb.append(this.getSendingFacility()).append("|");
        } else {
            delim = sending.indexOf(94);
            sb.append(sending.substring(0, delim)).append("|");
            sb.append(sending.substring(delim + 1)).append("|");
        }
        delim = receiving.indexOf(94);
        sb.append(receiving.substring(0, delim)).append("|");
        sb.append(receiving.substring(delim + 1)).append("|");
        sb.append(timestamp).append("||");
        sb.append(msgType).append("|");
        sb.append(msgCtrlid).append("|P|");
        sb.append(version).append("||||||||");
        return sb;
    }

    private void addEVN(StringBuffer sb, String timeStamp) {
        sb.append("\rEVN||").append(timeStamp).append("||||").append(timeStamp);
    }

    private void addPID(StringBuffer sb, Dataset ds) {
        sb.append("\rPID|||");
        this.appendPatIDwithIssuer(sb, ds);
        sb.append("||");
        this.addPersonName(sb, ds.getString(0x100010));
        sb.append("||");
        Date d = ds.getDateTime(0x100030, 1048626);
        if (d != null) {
            sb.append(new SimpleDateFormat(DATETIME_FORMAT).format(d));
        }
        sb.append("|");
        String s = ds.getString(0x100040);
        if (s != null) {
            sb.append(s);
        }
        sb.append("||||||||||||||||||||||");
    }

    private void addPersonName(StringBuffer sb, String patName) {
        StringTokenizer stk = new StringTokenizer(patName, "^", true);
        for (int i = 0; i < 6 && stk.hasMoreTokens(); ++i) {
            sb.append(stk.nextToken());
        }
        if (stk.hasMoreTokens()) {
            String prefix = stk.nextToken();
            if (stk.hasMoreTokens()) {
                stk.nextToken();
                if (stk.hasMoreTokens()) {
                    sb.append(stk.nextToken());
                }
            }
            sb.append('^').append(prefix);
        }
    }

    private void appendPatIDwithIssuer(StringBuffer sb, Dataset ds) {
        sb.append(ds.getString(0x100020));
        String s = ds.getString(0x100021);
        if (s != null) {
            sb.append("^^^").append(s);
        }
    }

    private void addMRG(StringBuffer sb, Dataset ds) {
        sb.append("\rMRG|");
        this.appendPatIDwithIssuer(sb, ds);
        sb.append("||||||");
        String name = ds.getString(0x100010);
        sb.append(name != null ? name : "patName");
    }

    private AEManager aeMgt() throws Exception {
        AEManagerHome home = (AEManagerHome)EJBHomeFactory.getFactory().lookup(AEManagerHome.class, "ejb/AEManager");
        return home.create();
    }

    public void sendHL7File(File file, String receiver) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] msg = new byte[(int)file.length()];
        fis.read(msg);
        this.sendTo(msg, receiver);
    }

    public boolean sendHl7FromDataset(String dsFilename, String xslFilename, String sender, String receiver) throws IOException, TransformerConfigurationException, TransformerFactoryConfigurationError {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        ds.readFile(new File(dsFilename), null, 2145386512);
        Templates tpl = TransformerFactory.newInstance().newTemplates(new StreamSource(new File(xslFilename)));
        return this.sendHl7FromDataset(ds, tpl, sender, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendHl7FromDataset(Dataset ds, Templates tpl, String sender, String receiver) {
        Socket s = null;
        try {
            AEDTO localAE = new AEDTO();
            localAE.setTitle(receiver);
            localAE.setHostName("127.0.0.1");
            localAE.setPort(this.getLocalHL7Port());
            AEDTO remoteAE = LOCAL_HL7_AET.equals(receiver) ? localAE : this.aeMgt().findByAET(receiver);
            s = this.tlsConfig.createSocket(localAE, remoteAE);
            MLLPDriver mllpDriver = new MLLPDriver(s.getInputStream(), s.getOutputStream(), true);
            OutputStream out = mllpDriver.getOutputStream();
            this.writeDatasetAsHL7msg(ds, tpl, sender, receiver, out);
            mllpDriver.turn();
            if (this.acTimeout > 0) {
                s.setSoTimeout(this.acTimeout);
            }
            if (!mllpDriver.hasMoreInput()) {
                throw new IOException("Receiver " + receiver + " closed socket " + s + " during waiting on response.");
            }
            Document rsp = this.readMessage(mllpDriver.getInputStream());
            this.checkResponse(rsp);
            boolean bl = true;
            return bl;
        }
        catch (Exception x) {
            this.log.warn((Object)("Sending HL7 message from Dataset failed! Reason:" + x.getMessage()), (Throwable)x);
            long delay = this.retryIntervalls.getIntervall(1);
            if (delay != -1L) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    this.writeDatasetAsHL7msg(ds, tpl, sender, receiver, baos);
                    byte[] msg = baos.toByteArray();
                    if (msg.length > 3 && msg[0] == 77 && msg[1] == 83 && msg[2] == 72) {
                        HL7SendOrder order = new HL7SendOrder(msg, receiver);
                        order.setFailureCount(1);
                        this.jmsDelegate.queue(this.queueName, (Serializable)order, 0, System.currentTimeMillis() + delay);
                    } else {
                        this.log.error((Object)"Message generated from Dataset is not valid (Does not start with MSH!) and will not be scheduled for retry!");
                        this.log.debug((Object)"Dataset:");
                        this.log.debug((Object)ds);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Cannot schedule 'retry' order for failed 'send HL7 message from Dataset'!", (Throwable)e);
                    boolean bl = false;
                    if (s != null) {
                        if (this.soCloseDelay > 0) {
                            try {
                                Thread.sleep(this.soCloseDelay);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                        }
                        try {
                            s.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                if (this.soCloseDelay > 0) {
                    try {
                        Thread.sleep(this.soCloseDelay);
                    }
                    catch (InterruptedException ignore) {}
                }
                try {
                    s.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void writeDatasetAsHL7msg(Dataset ds, Templates tpl, String sender, String receiver, OutputStream out) throws TransformerConfigurationException, IOException {
        TransformerHandler th = this.getTransformHandler(tpl, sender, receiver);
        th.setResult(new StreamResult(out));
        ds.writeDataset2((ContentHandler)th, null, null, 64, null);
    }

    private TransformerHandler getTransformHandler(Templates tpl, String sender, String receiver) throws TransformerConfigurationException {
        TransformerHandler th = XSLTUtils.transformerFactory.newTransformerHandler(tpl);
        XSLTUtils.setDateParameters((TransformerHandler)th);
        Transformer t = th.getTransformer();
        SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        t.setParameter("messageControlID", String.valueOf(++msgCtrlid));
        t.setParameter("messageDateTime", tsFormat.format(new Date()));
        int pos = receiver.indexOf(94);
        t.setParameter("receivingApplication", receiver.substring(0, pos++));
        t.setParameter("receivingFacility", receiver.substring(pos));
        if (sender != null) {
            pos = sender.indexOf(94);
            t.setParameter("sendingApplication", sender.substring(0, pos++));
            t.setParameter("sendingFacility", sender.substring(pos));
        } else {
            t.setParameter("sendingApplication", this.sendingApplication);
            t.setParameter("sendingFacility", this.sendingFacility);
        }
        return th;
    }

    static {
        queryTag = msgCtrlid = System.currentTimeMillis();
        FIELD_NAMES = new String[]{null, null, null, "PatientIDList", null, "PatientName", "MothersMaidenName", "PatientBirthDate", "PatientSex", "PatientAlias", "Race", "PatientAddress", "CountyCode", "PhoneNumberHome", "PhoneNumberBusiness", "PrimaryLanguage", "MaritalStatus", "Religion", "PatientAccountNumber", "SSNNumber", "DriversLicenseNumber", "MothersIdentifier", "EthnicGroup", "BirthPlace", "MultipleBirthIndicator", "BirthOrder", "Citizenship", "VeteransMilitaryStatus", "Nationality", "PatientDeathDateTime", "PatientDeathIndicator", "IdentityUnknownIndicator", "IdentityReliabilityCode", "LastUpdateDateTime", "LastUpdateFacility", "SpeciesCode", "BreedCode", "Strain", "ProductionClassCode", "TribalCitizenship"};
    }
}

