/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.Serializable;
import java.util.List;
import org.dcm4che.hl7.HL7Exception;
import org.dcm4che.hl7.HL7Factory;
import org.dcm4che.hl7.HL7Segment;
import org.dcm4chex.archive.common.BaseJmsOrder;
import org.dcm4chex.archive.hl7.MSH;

public class HL7SendOrder
extends BaseJmsOrder
implements Serializable {
    private static final long serialVersionUID = 3257003259104147767L;
    private final byte[] hl7msg;
    private final String receiving;

    public HL7SendOrder(byte[] hl7msg, String receiving) {
        if (hl7msg == null) {
            throw new NullPointerException();
        }
        if (receiving == null) {
            throw new NullPointerException();
        }
        this.hl7msg = hl7msg;
        this.receiving = receiving;
    }

    public final byte[] getHL7Message() {
        return this.hl7msg;
    }

    public final String getReceiving() {
        return this.receiving;
    }

    public String getOrderDetails() {
        return "receiving=" + this.receiving;
    }

    public void processOrderProperties(Object ... properties) {
        try {
            List segments = HL7Factory.getInstance().parse(this.hl7msg).segments();
            for (int i = 0; i < segments.size(); ++i) {
                String id;
                HL7Segment seg = (HL7Segment)segments.get(i);
                if (!seg.id().equals("PID")) continue;
                String patientID = seg.get(3);
                String issuer = null;
                if (patientID.contains("^")) {
                    id = patientID.substring(0, patientID.indexOf(94));
                    issuer = patientID.substring(patientID.lastIndexOf(94) + 1, patientID.length());
                } else {
                    id = patientID;
                }
                this.setOrderProperty("IssuerOfPatientID", issuer);
                this.setOrderProperty("PatientID", id);
                break;
            }
            if (properties != null && properties.length == 1 && properties[0] instanceof MSH) {
                MSH msh = (MSH)properties[0];
                this.setOrderProperty("MessageType", msh.messageType);
                this.setOrderProperty("TriggerEvent", msh.triggerEvent);
            }
        }
        catch (HL7Exception e) {
            throw new RuntimeException("Failed to parse PID segment of message", e);
        }
    }
}

