/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che.util.Executer;
import org.dcm4chex.archive.hl7.HL7ServerService;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.jboss.system.ServiceMBeanSupport;
import org.regenstrief.xhl7.HL7XMLWriter;

public class HL7CmdService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final String NONE = "NONE";
    private String cmdXslPath;
    private ObjectName hl7ServerName;
    private TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);

    public final String getCmdStylesheet() {
        return this.cmdXslPath == null ? NONE : this.cmdXslPath;
    }

    public void setCmdStylesheet(String path) {
        this.cmdXslPath = NONE.equals(path) ? null : path;
    }

    public final ObjectName getHL7ServerName() {
        return this.hl7ServerName;
    }

    public final void setHL7ServerName(ObjectName hl7ServerName) {
        this.hl7ServerName = hl7ServerName;
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.hl7ServerName, this, HL7ServerService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.hl7ServerName, this, HL7ServerService.NOTIF_FILTER, null);
    }

    public void handleNotification(Notification notif, Object handback) {
        block13: {
            if (this.cmdXslPath == null) {
                return;
            }
            Object[] hl7msg = (Object[])notif.getUserData();
            Document hl7doc = (Document)hl7msg[1];
            String cmd = null;
            try {
                File xslFile = FileUtils.toExistingFile((String)this.cmdXslPath);
                Transformer t = this.templates.getTemplates(xslFile).newTransformer();
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                HL7XMLWriter xmlWriter = new HL7XMLWriter((Writer)new OutputStreamWriter((OutputStream)out, "ISO-8859-1"));
                t.transform((Source)new DocumentSource(hl7doc), new StreamResult(out));
                cmd = out.toString();
                this.log.info((Object)("CMD for HL7 message:" + cmd));
            }
            catch (TransformerException e) {
                this.log.error((Object)"Failed to transform HL7 message into command", (Throwable)e);
                return;
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)("No such stylesheet: " + this.cmdXslPath));
                return;
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)"Encoding not supported!", (Throwable)e);
                return;
            }
            catch (Throwable t) {
                this.log.error((Object)"Uncaught Exception!", t);
                return;
            }
            try {
                if (cmd == null || cmd.trim().length() == 0 || cmd.startsWith(NONE)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("No command for HL7 message! " + new MSH(hl7doc)));
                    }
                    break block13;
                }
                this.log.info((Object)("Perform command " + cmd));
                Executer ex = new Executer(cmd);
                int exit = -1;
                try {
                    exit = ex.waitFor();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (exit != 0) {
                    throw new IOException("Non-zero exit code(" + exit + ") of " + cmd);
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Command " + cmd + " failed!"), (Throwable)e);
            }
        }
    }
}

