/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.List;
import org.dcm4chex.archive.hl7.ACK;
import org.dom4j.Document;
import org.dom4j.Element;

public class ERR {
    public static final String UNKNOWN_KEY_IDENTIFIER = "204";
    public final String HL7ErrorCode;
    public final String severity;

    public ERR(Document msg) {
        Element err = msg.getRootElement().element("ERR");
        if (err == null) {
            throw new IllegalArgumentException("Missing ERR Segment");
        }
        List errfds = err.elements("field");
        this.HL7ErrorCode = ACK.fieldAt(errfds, 2);
        this.severity = ACK.fieldAt(errfds, 3);
    }

    public boolean isUnknownKeyIdentifier() {
        return UNKNOWN_KEY_IDENTIFIER.equals(this.HL7ErrorCode.trim());
    }

    public String toString() {
        return "ERR[HL7ErrorCode=" + this.HL7ErrorCode + ", severity=" + this.severity + "]";
    }
}

