/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.io.File;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.SAXResult;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.hl7.HL7Exception;
import org.dcm4chex.archive.hl7.HL7Service;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.jboss.system.ServiceMBeanSupport;

public abstract class AbstractHL7Service
extends ServiceMBeanSupport
implements HL7Service {
    protected TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);
    private ObjectName hl7ServerName;
    private String messageTypes;

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final ObjectName getHL7ServerName() {
        return this.hl7ServerName;
    }

    public final void setHL7ServerName(ObjectName hl7ServerName) {
        this.hl7ServerName = hl7ServerName;
    }

    public final String getMessageTypes() {
        return this.messageTypes;
    }

    public final void setMessageTypes(String messageTypes) {
        if (this.getState() == 3) {
            this.registerService(null);
        }
        this.messageTypes = messageTypes;
        if (this.getState() == 3) {
            this.registerService(this);
        }
    }

    private void registerService(HL7Service service) {
        try {
            StringTokenizer stk = new StringTokenizer(this.messageTypes, ", ");
            while (stk.hasMoreTokens()) {
                this.server.invoke(this.hl7ServerName, "registerService", new Object[]{stk.nextToken(), service}, new String[]{String.class.getName(), HL7Service.class.getName()});
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to register HL7 service", (Throwable)e);
            throw new RuntimeException("Failed to register HL7 service", e);
        }
    }

    public final String getTemplateDir() {
        return this.templates.getConfigDir();
    }

    public final void setTemplateDir(String path) {
        this.templates.setConfigDir(path);
    }

    protected Dataset xslt(Document msg, String xslPath, String[] subdirs) throws Exception {
        Templates tpl;
        if (xslPath.indexOf(47) != -1 || xslPath.indexOf(92) != -1) {
            File pidXslFile = FileUtils.toExistingFile((String)xslPath);
            tpl = this.templates.getTemplates(pidXslFile);
        } else if (subdirs == null) {
            MSH msh = new MSH(msg);
            tpl = this.templates.getTemplatesForAET(msh.sendingApplication + "^" + msh.sendingFacility, xslPath);
        } else {
            tpl = this.templates.findTemplates(subdirs, null, new String[]{xslPath}, null);
        }
        if (tpl == null) {
            throw new HL7Exception("AR", "Missing style sheet to process HL7 message! xslPath:" + xslPath);
        }
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        tpl.newTransformer().transform((Source)new DocumentSource(msg), new SAXResult(ds.getSAXHandler2(null)));
        return ds;
    }

    protected void startService() throws Exception {
        this.registerService(this);
    }

    protected void stopService() throws Exception {
        this.registerService(null);
    }

    public void logDataset(String prompt, Dataset ds) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug((Object)prompt);
        this.log.debug((Object)ds);
    }
}

