/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.PatientUpdate;
import org.dcm4chex.archive.ejb.interfaces.PatientUpdateHome;
import org.dcm4chex.archive.exceptions.PatientAlreadyExistsException;
import org.dcm4chex.archive.exceptions.PatientMergedException;
import org.dcm4chex.archive.hl7.AbstractHL7Service;
import org.dcm4chex.archive.hl7.HL7Exception;
import org.dcm4chex.archive.hl7.MSH;
import org.dcm4chex.archive.hl7.PID;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.xml.sax.ContentHandler;

public class ADTService
extends AbstractHL7Service {
    private static final int ID = 0;
    private static final int ISSUER = 1;
    private String pidXslPath;
    private String mrgXslPath;
    private String patientArrivingMessageType;
    private String[] patientMergeMessageTypes;
    private String changePatientIdentifierListMessageType;
    private String deletePatientMessageType;
    private String pixUpdateNotificationMessageType;
    private String[] issuersOfOnlyOtherPatientIDs;
    private Pattern ignoredIssuersOfPatientIDPattern;
    private PatientMatching patientMatching;
    private boolean ignoreDeleteErrors;
    private boolean handleEmptyMrgAsUpdate;
    private boolean keepPriorPatientAfterMerge = true;
    private ObjectName contentEditServiceName;

    public final String getPatientArrivingMessageType() {
        return this.patientArrivingMessageType;
    }

    public final void setPatientArrivingMessageType(String patientArrivingMessageType) {
        this.patientArrivingMessageType = patientArrivingMessageType;
    }

    public final String getPatientMergeMessageTypes() {
        return StringUtils.toString((String[])this.patientMergeMessageTypes, (char)',');
    }

    public final void setPatientMergeMessageTypes(String messageTypes) {
        this.patientMergeMessageTypes = ADTService.split(messageTypes);
    }

    public ObjectName getContentEditServiceName() {
        return this.contentEditServiceName;
    }

    public void setContentEditServiceName(ObjectName serviceName) {
        this.contentEditServiceName = serviceName;
    }

    private static String[] split(String s) {
        StringTokenizer stk = new StringTokenizer(s, ", ");
        String[] tmp = new String[stk.countTokens()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = stk.nextToken();
        }
        return tmp;
    }

    public final String getChangePatientIdentifierListMessageType() {
        return this.changePatientIdentifierListMessageType;
    }

    public final void setChangePatientIdentifierListMessageType(String changePatientIdentifierListMessageType) {
        this.changePatientIdentifierListMessageType = changePatientIdentifierListMessageType;
    }

    public final String getDeletePatientMessageType() {
        return this.deletePatientMessageType;
    }

    public final void setDeletePatientMessageType(String deletePatientMessageType) {
        this.deletePatientMessageType = deletePatientMessageType;
    }

    public final String getPixUpdateNotificationMessageType() {
        return this.pixUpdateNotificationMessageType;
    }

    public final void setPixUpdateNotificationMessageType(String messageType) {
        this.pixUpdateNotificationMessageType = messageType;
    }

    public final String getIssuersOfOnlyOtherPatientIDs() {
        return this.issuersOfOnlyOtherPatientIDs == null ? "-" : StringUtils.toString((String[])this.issuersOfOnlyOtherPatientIDs, (char)',');
    }

    public final void setIssuersOfOnlyOtherPatientIDs(String s) {
        this.issuersOfOnlyOtherPatientIDs = s.trim().equals("-") ? null : ADTService.split(s);
    }

    public final String getIgnoredIssuersOfPatientIDPattern() {
        return this.ignoredIssuersOfPatientIDPattern == null ? "NONE" : this.ignoredIssuersOfPatientIDPattern.pattern();
    }

    public final void setIgnoredIssuersOfPatientIDPattern(String ignoredIssuersOfPatientIDPattern) {
        this.ignoredIssuersOfPatientIDPattern = ignoredIssuersOfPatientIDPattern.compareToIgnoreCase("NONE") == 0 ? null : Pattern.compile(ignoredIssuersOfPatientIDPattern);
    }

    public String getPatientMatching() {
        return this.patientMatching.toString();
    }

    public void setPatientMatching(String s) {
        this.patientMatching = new PatientMatching(s.trim());
    }

    public final String getMrgStylesheet() {
        return this.mrgXslPath;
    }

    public void setMrgStylesheet(String path) {
        this.mrgXslPath = path;
    }

    public final String getPidStylesheet() {
        return this.pidXslPath;
    }

    public void setPidStylesheet(String path) {
        this.pidXslPath = path;
    }

    public boolean isIgnoreDeleteErrors() {
        return this.ignoreDeleteErrors;
    }

    public void setIgnoreDeleteErrors(boolean ignore) {
        this.ignoreDeleteErrors = ignore;
    }

    public boolean isHandleEmptyMrgAsUpdate() {
        return this.handleEmptyMrgAsUpdate;
    }

    public void setHandleEmptyMrgAsUpdate(boolean handleEmptyMrgAsUpdate) {
        this.handleEmptyMrgAsUpdate = handleEmptyMrgAsUpdate;
    }

    public boolean isKeepPriorPatientAfterMerge() {
        return this.keepPriorPatientAfterMerge;
    }

    public void setKeepPriorPatientAfterMerge(boolean keepPriorPatientAfterMerge) {
        this.keepPriorPatientAfterMerge = keepPriorPatientAfterMerge;
    }

    public boolean process(MSH msh, Document msg, ContentHandler hl7out, String[] xslSubdirs) throws HL7Exception {
        block16: {
            try {
                String msgtype = msh.messageType + '^' + msh.triggerEvent;
                if (this.pixUpdateNotificationMessageType.equals(msgtype) && !this.containsPatientName(msg)) {
                    return this.processUpdateNotificationMessage(msg);
                }
                Dataset pat = this.xslt(msg, this.pidXslPath, xslSubdirs);
                this.checkPID(pat);
                if (ADTService.contains(this.patientMergeMessageTypes, msgtype)) {
                    Dataset mrg = this.xslt(msg, this.mrgXslPath, xslSubdirs);
                    if (this.handleEmptyMrgAsUpdate && !mrg.containsValue(0x100020)) {
                        this.updatePatient(pat, this.patientMatching);
                    } else {
                        this.checkMRG(mrg, pat);
                        this.mergePatient(pat, mrg, this.patientMatching);
                    }
                    break block16;
                }
                if (this.changePatientIdentifierListMessageType.equals(msgtype)) {
                    Dataset mrg = this.xslt(msg, this.mrgXslPath, xslSubdirs);
                    this.checkMRG(mrg, pat);
                    this.changePatientIdentifierList(pat, mrg, this.patientMatching);
                    break block16;
                }
                if (this.deletePatientMessageType.equals(msgtype)) {
                    try {
                        this.movePatientToTrash(pat, this.patientMatching);
                        break block16;
                    }
                    catch (Exception x) {
                        if (!this.ignoreDeleteErrors) {
                            throw x;
                        }
                        break block16;
                    }
                }
                if (this.patientArrivingMessageType.equals(msgtype)) {
                    this.patientArrived(pat, this.patientMatching);
                } else {
                    this.updatePatient(pat, this.patientMatching);
                }
            }
            catch (HL7Exception e) {
                throw e;
            }
            catch (PatientAlreadyExistsException e) {
                throw new HL7Exception("AR", e.getMessage());
            }
            catch (PatientMergedException e) {
                throw new HL7Exception("AR", e.getMessage());
            }
            catch (Exception e) {
                throw new HL7Exception("AE", e.getMessage(), e);
            }
        }
        return true;
    }

    private void movePatientToTrash(Dataset pat, PatientMatching matching) throws Exception {
        try {
            this.server.invoke(this.contentEditServiceName, "movePatientToTrash", new Object[]{pat, matching}, new String[]{Dataset.class.getName(), PatientMatching.class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
    }

    private static boolean contains(String[] ss, String v) {
        for (String s : ss) {
            if (!s.equals(v)) continue;
            return true;
        }
        return false;
    }

    protected void mergePatient(Dataset dominant, Dataset prior, PatientMatching patientMatching) throws Exception {
        this.getPatientUpdate().mergePatient(dominant, prior, patientMatching, this.keepPriorPatientAfterMerge);
    }

    protected void updatePatient(Dataset attrs, PatientMatching patientMatching) throws Exception {
        this.getPatientUpdate().updatePatient(attrs, patientMatching);
    }

    protected void changePatientIdentifierList(Dataset correct, Dataset prior, PatientMatching patientMatching) throws Exception {
        this.getPatientUpdate().changePatientIdentifierList(correct, prior, patientMatching, this.keepPriorPatientAfterMerge);
    }

    protected boolean deletePatient(Dataset ds, PatientMatching patientMatching) throws Exception {
        return this.getPatientUpdate().deletePatient(ds, patientMatching);
    }

    protected void patientArrived(Dataset ds, PatientMatching patientMatching) throws Exception {
        this.getPatientUpdate().patientArrived(ds, patientMatching);
    }

    protected void updateOtherPatientIDsOrCreate(Dataset ds, PatientMatching patientMatching) throws Exception {
        this.getPatientUpdate().updateOtherPatientIDsOrCreate(ds, patientMatching);
    }

    private void checkPID(Dataset pid) throws HL7Exception {
        if (!pid.containsValue(0x100020)) {
            throw new HL7Exception("AR", "Missing required PID-3: Patient ID (Internal ID)");
        }
        if (!pid.containsValue(0x100010)) {
            throw new HL7Exception("AR", "Missing required PID-5: Patient Name");
        }
    }

    private void checkMRG(Dataset mrg, Dataset pat) throws HL7Exception {
        String mrgpid = mrg.getString(0x100020);
        if (mrgpid == null) {
            throw new HL7Exception("AR", "Missing required MRG-1: Prior Patient ID - Internal");
        }
        if (mrgpid.equals(pat.getString(0x100020))) {
            String mrgissuer = mrg.getString(0x100021);
            String patissuer = pat.getString(0x100021);
            if (mrgissuer == null || patissuer == null || mrgissuer.equals(patissuer)) {
                throw new HL7Exception("AR", "MRG-1: Prior Patient ID - Internal is equal to PID-3: Patient ID (Internal ID)");
            }
        }
    }

    private boolean containsPatientName(Document msg) {
        Element pidSegm = msg.getRootElement().element("PID");
        if (pidSegm == null) {
            return false;
        }
        List pidfds = pidSegm.elements("field");
        if (pidfds.size() < 5) {
            return false;
        }
        String pname = ((Element)pidfds.get(4)).getTextTrim();
        return pname != null && pname.length() > 0;
    }

    private boolean processUpdateNotificationMessage(Document msg) throws Exception {
        ArrayList<String[]> pids;
        String fn = "processUpdateNotificationMessage: ";
        try {
            pids = new PID(msg).getPatientIDs();
        }
        catch (IllegalArgumentException e) {
            throw new HL7Exception("AR", e.getMessage());
        }
        if (this.ignoredIssuersOfPatientIDPattern != null) {
            ArrayList<String[]> filteredPids = new ArrayList<String[]>();
            int n = pids.size();
            for (int i = 0; i < n; ++i) {
                String[] pid = (String[])pids.get(i);
                StringBuilder issuer = new StringBuilder();
                for (int s = 1; s < pid.length; ++s) {
                    if (s != 1) {
                        issuer.append('&');
                    }
                    issuer.append(pid[s]);
                }
                Matcher matcher = this.ignoredIssuersOfPatientIDPattern.matcher(issuer);
                if (matcher.matches()) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)(fn + "filtering out patient ID '" + pid[0] + "' with issuer '" + issuer + "' because the issuer matches the expression '" + this.ignoredIssuersOfPatientIDPattern.pattern() + "'"));
                    continue;
                }
                this.log.debug((Object)(fn + "keeping patient ID '" + pid[0] + "' with issuer '" + issuer + "'"));
                filteredPids.add(pid);
            }
            pids = filteredPids;
        }
        int n = pids.size();
        for (int i = 0; i < n; ++i) {
            String[] pid = (String[])pids.get(i);
            if (ADTService.contains(this.issuersOfOnlyOtherPatientIDs, pid[1])) continue;
            Dataset ds = this.toDataset(pid);
            DcmElement opids = ds.putSQ(0x101002);
            int m = pids.size();
            for (int j = 0; j < m; ++j) {
                String[] opid = (String[])pids.get(j);
                if (opid == pid) continue;
                opids.addItem(this.toDataset(opid));
            }
            this.updateOtherPatientIDsOrCreate(ds, this.patientMatching);
        }
        return true;
    }

    private Dataset toDataset(String[] pid) {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        ds.putLO(0x100020, pid[0]);
        ds.putLO(0x100021, pid[1]);
        return ds;
    }

    private PatientUpdate getPatientUpdate() throws Exception {
        PatientUpdateHome patHome = (PatientUpdateHome)EJBHomeFactory.getFactory().lookup(PatientUpdateHome.class, "ejb/PatientUpdate");
        return patHome.create();
    }
}

