/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hl7;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class ACK {
    public final String acknowledgmentCode;
    public final String messageControlID;
    public final String textMessage;

    public ACK(Document msg) {
        Element msa = msg.getRootElement().element("MSA");
        if (msa == null) {
            throw new IllegalArgumentException("Missing MSA Segment");
        }
        List fields = msa.elements("field");
        this.acknowledgmentCode = ACK.fieldAt(fields, 0);
        this.messageControlID = ACK.fieldAt(fields, 1);
        this.textMessage = ACK.fieldAt(fields, 2);
    }

    static String fieldAt(List fields, int index) {
        return index < fields.size() ? ACK.toString(fields.get(index)) : "";
    }

    static String toString(Object el) {
        return el != null ? ((Element)el).getText() : "";
    }

    public String toString() {
        return "ACK[code=" + this.acknowledgmentCode + ", msgID=" + this.messageControlID + ',' + ", errorMsg=" + this.textMessage + "]";
    }
}

