/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.captcha.kittens;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.wicket.Component;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Resource;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.captcha.kittens.OpaqueRegion;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.image.resource.DynamicImageResource;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KittenCaptchaPanel
extends Panel {
    private static final long serialVersionUID = 2711167040323855070L;
    private static BufferedImage grass = KittenCaptchaPanel.load("images/grass.png");
    private static final List<Animal> kittens = new ArrayList<Animal>();
    private static final List<Animal> nonKittens = new ArrayList<Animal>();
    private static Random random = new Random(-1L);
    private final PlacedAnimalList animals;
    private final Label animalSelectionLabel;
    private final org.apache.wicket.markup.html.image.Image image;
    private final CaptchaImageResource imageResource;
    private final Dimension imageSize;

    private static BufferedImage load(String filename) {
        try {
            return ImageIO.read(new MemoryCacheImageInputStream(KittenCaptchaPanel.class.getResourceAsStream(filename)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public KittenCaptchaPanel(String id, Dimension imageSize) {
        super(id);
        this.imageSize = imageSize;
        this.animals = new PlacedAnimalList();
        this.setOutputMarkupId(true);
        this.animalSelectionLabel = new Label("animalSelectionLabel", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 6792322972316712326L;

            public Object getObject() {
                return KittenCaptchaPanel.this.imageResource.selectString();
            }
        });
        this.animalSelectionLabel.setOutputMarkupId(true);
        this.add(new Component[]{this.animalSelectionLabel});
        this.imageResource = new CaptchaImageResource(this.animals);
        this.image = new NonCachingImage("image", (Resource)this.imageResource);
        this.image.add(new IBehavior[]{new AjaxEventBehavior("onclick"){
            private static final long serialVersionUID = 7480352029955897654L;

            protected CharSequence getCallbackScript(boolean onlyTargetActivePage) {
                return this.generateCallbackScript("showLoadingIndicator(); wicketAjaxGet('" + this.getCallbackUrl(onlyTargetActivePage) + "&x=' + getEventX(this, event) + '&y=' + getEventY(this, event)");
            }

            protected void onEvent(AjaxRequestTarget target) {
                WebRequest request = (WebRequest)RequestCycle.get().getRequest();
                Map parameters = request.getParameterMap();
                int x = Integer.parseInt(((String[])parameters.get("x"))[0]);
                int y = Integer.parseInt(((String[])parameters.get("y"))[0]);
                KittenCaptchaPanel.this.imageResource.clearData();
                PlacedAnimal animal = KittenCaptchaPanel.this.animals.atLocation(new Point(x, y));
                if (animal != null) {
                    animal.isHighlighted = !animal.isHighlighted;
                    StringBuilder javascript = new StringBuilder();
                    javascript.append("Wicket.$('" + KittenCaptchaPanel.this.image.getMarkupId() + "').src = '");
                    CharSequence url = KittenCaptchaPanel.this.image.urlFor(IResourceListener.INTERFACE);
                    javascript.append(url);
                    javascript.append((((Object)url).toString().indexOf(63) > -1 ? "&amp;" : "?") + "rand=" + Math.random());
                    javascript.append("'");
                    target.appendJavascript(javascript.toString());
                } else {
                    target.appendJavascript(" hideLoadingIndicator();");
                }
                target.addComponent((Component)KittenCaptchaPanel.this.animalSelectionLabel);
            }
        }});
        this.add(new Component[]{this.image});
    }

    public boolean allKittensSelected() {
        return this.imageResource.allKittensSelected();
    }

    public void reset() {
        this.imageResource.reset();
    }

    private PlacedAnimal placeAnimal(List<PlacedAnimal> animals, Animal newAnimal) {
        for (int iter = 0; iter < 100; ++iter) {
            int width = newAnimal.image.getWidth();
            int height = newAnimal.image.getHeight();
            int x = this.random(this.imageSize.width - width);
            int y = this.random(this.imageSize.height - height);
            Point point = new Point(x, y);
            double tooClose = new Point(width, height).distance(new Point(0, 0)) / 2.0;
            boolean tooMuchOverlap = false;
            for (PlacedAnimal animal : animals) {
                if (!(point.distance(animal.location) < tooClose)) continue;
                tooMuchOverlap = true;
                break;
            }
            if (tooMuchOverlap) continue;
            return new PlacedAnimal(newAnimal, new Point(x, y));
        }
        return null;
    }

    private int random(int max) {
        return Math.abs(random.nextInt(max));
    }

    private Animal randomKitten() {
        return kittens.get(this.random(kittens.size()));
    }

    private Animal randomNonKitten() {
        return nonKittens.get(this.random(nonKittens.size()));
    }

    static {
        kittens.add(new Animal("kitten_01", true));
        kittens.add(new Animal("kitten_02", true));
        kittens.add(new Animal("kitten_03", true));
        kittens.add(new Animal("kitten_04", true));
        nonKittens.add(new Animal("chick", false));
        nonKittens.add(new Animal("guinea_pig", false));
        nonKittens.add(new Animal("hamster", false));
        nonKittens.add(new Animal("puppy", false));
        nonKittens.add(new Animal("rabbit", false));
    }

    private class PlacedAnimalList
    implements Serializable {
        private static final long serialVersionUID = 6335852594326213439L;
        private final List<PlacedAnimal> animals = new ArrayList<PlacedAnimal>();

        private PlacedAnimalList() {
            this.animals.add(KittenCaptchaPanel.this.placeAnimal(this.animals, KittenCaptchaPanel.this.randomKitten()));
            this.animals.add(KittenCaptchaPanel.this.placeAnimal(this.animals, KittenCaptchaPanel.this.randomKitten()));
            this.animals.add(KittenCaptchaPanel.this.placeAnimal(this.animals, KittenCaptchaPanel.this.randomKitten()));
            for (int iter = 0; iter < 500; ++iter) {
                PlacedAnimal animal = KittenCaptchaPanel.this.placeAnimal(this.animals, KittenCaptchaPanel.this.randomNonKitten());
                if (animal != null) {
                    this.animals.add(animal);
                }
                if (this.animals.size() > 15) break;
            }
            Collections.shuffle(this.animals);
            ArrayList<PlacedAnimal> strayKittens = new ArrayList<PlacedAnimal>();
            for (PlacedAnimal animal : this.animals) {
                if (!animal.isKitten) continue;
                int kittenArea = animal.getAnimal().visibleRegion.areaInPixels();
                if (this.visibleRegion(animal).areaInPixels() >= kittenArea * 4 / 5) continue;
                strayKittens.add(animal);
            }
            this.animals.removeAll(strayKittens);
            this.animals.addAll(strayKittens);
        }

        private boolean allKittensSelected() {
            for (PlacedAnimal animal : this.animals) {
                if (animal.isKitten == animal.isHighlighted) continue;
                return false;
            }
            return true;
        }

        private PlacedAnimal atLocation(Point location) {
            ArrayList<PlacedAnimal> reversedAnimals = new ArrayList<PlacedAnimal>(this.animals);
            Collections.reverse(reversedAnimals);
            for (PlacedAnimal animal : reversedAnimals) {
                if (!animal.contains(location)) continue;
                return animal;
            }
            return null;
        }

        private BufferedImage createImage() {
            BufferedImage newImage = new BufferedImage(((KittenCaptchaPanel)KittenCaptchaPanel.this).imageSize.width, ((KittenCaptchaPanel)KittenCaptchaPanel.this).imageSize.height, 1);
            Graphics2D graphics = newImage.createGraphics();
            graphics.drawImage((Image)grass, 0, 0, null);
            for (PlacedAnimal animal : this.animals) {
                animal.draw(graphics);
            }
            graphics.dispose();
            return newImage;
        }

        private void reset() {
            for (PlacedAnimal animal : this.animals) {
                animal.isHighlighted = false;
            }
        }

        private String selectString() {
            int selected = 0;
            for (PlacedAnimal animal : this.animals) {
                if (!animal.isHighlighted) continue;
                ++selected;
            }
            if (selected == 0) {
                return KittenCaptchaPanel.this.getString("instructions");
            }
            return selected + " " + KittenCaptchaPanel.this.getString("animalsSelected");
        }

        private OpaqueRegion visibleRegion(PlacedAnimal animal) {
            int index = this.animals.indexOf(animal);
            if (index == -1) {
                throw new IllegalArgumentException("animal not in list");
            }
            OpaqueRegion visible = animal.getAnimal().visibleRegion;
            ++index;
            while (index < this.animals.size()) {
                PlacedAnimal remove = this.animals.get(index);
                visible = visible.subtract(remove.getAnimal().visibleRegion, new Point(((PlacedAnimal)remove).location.x - ((PlacedAnimal)animal).location.x, ((PlacedAnimal)remove).location.y - ((PlacedAnimal)animal).location.y));
                ++index;
            }
            return visible;
        }
    }

    private class PlacedAnimal
    implements Serializable {
        private static final long serialVersionUID = -6703909440564862486L;
        private transient Animal animal;
        private final int index;
        private boolean isHighlighted;
        private final boolean isKitten;
        private final Point location;
        private final float[] scales = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

        public PlacedAnimal(Animal animal, Point location) {
            this.animal = animal;
            this.location = location;
            this.isKitten = animal.isKitten;
            this.index = this.isKitten ? kittens.indexOf(animal) : nonKittens.indexOf(animal);
            for (int i = 0; i < 3; ++i) {
                this.scales[i] = this.random(0.9f, 1.0f);
            }
            this.scales[3] = this.random(0.7f, 1.0f);
        }

        public String toString() {
            return (this.isKitten ? "kitten at " : "other at ") + this.location.x + ", " + this.location.y;
        }

        private boolean contains(Point point) {
            Point relativePoint = new Point(point.x - this.location.x, point.y - this.location.y);
            return this.getAnimal().visibleRegion.contains(relativePoint);
        }

        private void draw(Graphics2D graphics) {
            float[] offsets = new float[4];
            RescaleOp rop = new RescaleOp(this.scales, offsets, null);
            if (this.isHighlighted) {
                graphics.drawImage(this.getAnimal().highlightedImage, rop, this.location.x, this.location.y);
            } else {
                graphics.drawImage(this.getAnimal().image, rop, this.location.x, this.location.y);
            }
        }

        private Animal getAnimal() {
            if (this.animal == null) {
                this.animal = this.isKitten ? (Animal)kittens.get(this.index) : (Animal)nonKittens.get(this.index);
            }
            return this.animal;
        }

        private float random(float min, float max) {
            return min + Math.abs(random.nextFloat() * (max - min));
        }
    }

    private class CaptchaImageResource
    extends DynamicImageResource {
        private static final long serialVersionUID = -1560784998742404278L;
        private final PlacedAnimalList animals;
        private transient SoftReference<byte[]> data = null;

        private CaptchaImageResource(PlacedAnimalList animals) {
            this.animals = animals;
            this.setCacheable(false);
            this.setFormat("jpg");
        }

        protected byte[] getImageData() {
            this.setLastModifiedTime(Time.now());
            WebResponse response = (WebResponse)RequestCycle.get().getResponse();
            response.setHeader("Cache-Control", "no-cache, must-revalidate, max-age=0, no-store");
            if (this.data == null || this.data.get() == null) {
                BufferedImage composedImage = this.animals.createImage();
                this.data = new SoftReference<byte[]>(this.toImageData(composedImage));
            }
            return this.data.get();
        }

        protected void invalidate() {
            this.data = null;
        }

        private boolean allKittensSelected() {
            return this.animals.allKittensSelected();
        }

        private void clearData() {
            this.invalidate();
            this.setLastModifiedTime(Time.now());
        }

        private void reset() {
            this.animals.reset();
        }

        private String selectString() {
            return this.animals.selectString();
        }
    }

    private static class Animal {
        private final BufferedImage highlightedImage;
        private final BufferedImage image;
        private final boolean isKitten;
        private final OpaqueRegion visibleRegion;

        private Animal(String filename, boolean isKitten) {
            this.isKitten = isKitten;
            this.image = this.load("images/" + filename);
            this.highlightedImage = this.load("images/" + filename + "_highlight");
            this.visibleRegion = new OpaqueRegion(this.image);
        }

        private BufferedImage load(String filename) {
            try {
                BufferedImage loadedImage = ImageIO.read(new MemoryCacheImageInputStream(KittenCaptchaPanel.class.getResourceAsStream(filename + ".png")));
                BufferedImage image = new BufferedImage(loadedImage.getWidth(), loadedImage.getHeight(), 2);
                Graphics2D graphics = image.createGraphics();
                graphics.drawImage((Image)loadedImage, 0, 0, null);
                graphics.dispose();
                return image;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

