/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.modal;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.CancelEventIfNoAjaxDecorator;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModalWindow
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String CSS_CLASS_BLUE = "w_blue";
    public static final String CSS_CLASS_GRAY = "w_silver";
    private static ResourceReference JAVASCRIPT = new JavascriptResourceReference(ModalWindow.class, "res/modal.js");
    private static ResourceReference CSS = new CompressedResourceReference(ModalWindow.class, "res/modal.css");
    private boolean deletePageMap = false;
    private boolean shown = false;
    private final boolean renderScript = false;
    private WebMarkupContainer empty;
    private int minimalWidth = 200;
    private int minimalHeight = 200;
    private String cssClassName = "w_blue";
    private int initialWidth = 600;
    private int initialHeight = 400;
    private boolean useInitialHeight = true;
    private boolean resizable = true;
    private String widthUnit = "px";
    private String heightUnit = "px";
    private String cookieName;
    private IModel<String> title = null;
    private MaskType maskType = MaskType.SEMI_TRANSPARENT;
    private String pageMapName = "modal-dialog-pagemap";
    private PageCreator pageCreator = null;
    private CloseButtonCallback closeButtonCallback = null;
    private WindowClosedCallback windowClosedCallback = null;

    public ModalWindow(String id) {
        super(id);
        this.init();
    }

    public ModalWindow(String id, IModel<?> model) {
        super(id, model);
        this.init();
    }

    private void init() {
        this.setVersioned(false);
        this.cookieName = null;
        Component[] componentArray = new Component[1];
        this.empty = new WebMarkupContainer(this.getContentId());
        componentArray[0] = this.empty;
        this.add(componentArray);
        this.add(new IBehavior[]{new CloseButtonBehavior()});
        this.add(new IBehavior[]{new WindowClosedBehavior()});
        this.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution((ResourceReference)JAVASCRIPT)});
        this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)CSS)});
    }

    public boolean isShown() {
        return this.shown;
    }

    public ModalWindow setPageMapName(String pageMapName) {
        this.pageMapName = pageMapName;
        return this;
    }

    public String getPageMapName() {
        return this.pageMapName;
    }

    public ModalWindow setPageCreator(PageCreator creator) {
        this.setContent((Component)this.empty);
        this.pageCreator = creator;
        return this;
    }

    public ModalWindow setCloseButtonCallback(CloseButtonCallback callback) {
        this.closeButtonCallback = callback;
        return this;
    }

    public ModalWindow setWindowClosedCallback(WindowClosedCallback callback) {
        this.windowClosedCallback = callback;
        return this;
    }

    public void show(AjaxRequestTarget target) {
        if (!this.shown) {
            this.getContent().setVisible(true);
            target.addComponent((Component)this);
            target.appendJavascript(this.getWindowOpenJavascript());
            this.shown = true;
        }
    }

    public static final void closeCurrent(AjaxRequestTarget target) {
        target.appendJavascript(ModalWindow.getCloseJavacript());
    }

    public void close(AjaxRequestTarget target) {
        this.getContent().setVisible(false);
        target.appendJavascript(ModalWindow.getCloseJavacript());
        this.shown = false;
    }

    private static String getCloseJavacript() {
        return "var win;\ntry {\n\twin = window.parent.Wicket.Window;\n} catch (ignore) {\n}\nif (typeof(win) == \"undefined\" || typeof(win.current) == \"undefined\") {\n  try {\n     win = window.Wicket.Window;\n  } catch (ignore) {\n  }\n}\nif (typeof(win) != \"undefined\" && typeof(win.current) != \"undefined\") {\n var close = function(w) { w.setTimeout(function() {\n\t\twin.current.close();\n\t}, 0);  } \n\ttry { close(window.parent); } catch (ignore) { close(window); };\n}";
    }

    public String getContentId() {
        return "content";
    }

    public ModalWindow setMinimalWidth(int minimalWidth) {
        this.minimalWidth = minimalWidth;
        return this;
    }

    public int getMinimalWidth() {
        return this.minimalWidth;
    }

    public ModalWindow setMinimalHeight(int minimalHeight) {
        this.minimalHeight = minimalHeight;
        return this;
    }

    public int getMinimalHeight() {
        return this.minimalHeight;
    }

    public ModalWindow setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
        return this;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public ModalWindow setInitialWidth(int initialWidth) {
        this.initialWidth = initialWidth;
        return this;
    }

    public int getInitialWidth() {
        return this.initialWidth;
    }

    public ModalWindow setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
        return this;
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public ModalWindow setUseInitialHeight(boolean useInitialHeight) {
        this.useInitialHeight = useInitialHeight;
        return this;
    }

    public boolean isUseInitialHeight() {
        return this.useInitialHeight;
    }

    public ModalWindow setResizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public ModalWindow setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        return this;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public ModalWindow setHeightUnit(String heightUnit) {
        this.heightUnit = heightUnit;
        return this;
    }

    public String getHeightUnit() {
        return this.heightUnit;
    }

    public ModalWindow setCookieName(String cookieName) {
        if (cookieName != null && cookieName.indexOf(",") != -1 && cookieName.indexOf("|") != -1) {
            throw new IllegalArgumentException("Cookie name may not contain ',' or '|' characters.");
        }
        this.cookieName = cookieName;
        return this;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public ModalWindow setTitle(String title) {
        this.title = new Model((Serializable)((Object)title));
        return this;
    }

    public ModalWindow setTitle(IModel<String> title) {
        this.title = title = this.wrap(title);
        return this;
    }

    public IModel<String> getTitle() {
        return this.title;
    }

    public ModalWindow setMaskType(MaskType mask) {
        this.maskType = mask;
        return this;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page createPage() {
        if (this.pageCreator == null) {
            return null;
        }
        RequestParameters parameters = RequestCycle.get().getRequest().getRequestParameters();
        String oldPageMapName = parameters.getPageMapName();
        if (this.getPageMapName() != null) {
            Session session = Session.get();
            if (session.pageMapForName(this.getPageMapName(), false) == null) {
                this.deletePageMap = true;
            }
            parameters.setPageMapName(this.getPageMapName());
        }
        try {
            Page page = this.pageCreator.createPage();
            return page;
        }
        finally {
            parameters.setPageMapName(oldPageMapName);
        }
    }

    protected void onBeforeRender() {
        this.shown = this.makeContentVisible();
        this.getContent().setOutputMarkupId(true);
        this.getContent().setVisible(this.shown);
        super.onBeforeRender();
    }

    protected boolean makeContentVisible() {
        if (!this.getWebRequest().isAjax()) {
            return false;
        }
        return this.shown;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("style", (CharSequence)"display:none");
    }

    protected final Component getContent() {
        return this.get(this.getContentId());
    }

    private boolean isCustomComponent() {
        return this.getContent() != this.empty;
    }

    public void remove(Component component) {
        super.remove(component);
        if (component.getId().equals(this.getContentId())) {
            Component[] componentArray = new Component[1];
            this.empty = new WebMarkupContainer(this.getContentId());
            componentArray[0] = this.empty;
            this.add(componentArray);
        }
    }

    public ModalWindow setContent(Component component) {
        if (!component.getId().equals(this.getContentId())) {
            throw new WicketRuntimeException("Modal window content id is wrong. Component ID:" + component.getId() + "; content ID: " + this.getContentId());
        }
        if (component instanceof AbstractRepeater) {
            throw new WicketRuntimeException("A repeater component cannot be used as the content of a modal window, please use repeater's parent");
        }
        component.setOutputMarkupPlaceholderTag(true);
        component.setVisible(false);
        this.replace(component);
        this.shown = false;
        this.pageCreator = null;
        return this;
    }

    private String getContentMarkupId() {
        return this.getContent().getMarkupId();
    }

    private String escapeQuotes(String string) {
        if (string.indexOf(34) != -1) {
            string = ((Object)Strings.replaceAll((CharSequence)string, (CharSequence)"\"", (CharSequence)"\\\"")).toString();
        }
        return string;
    }

    protected final String getWindowOpenJavascript() {
        AbstractDefaultAjaxBehavior behavior;
        String title;
        AppendingStringBuffer buffer = new AppendingStringBuffer(500);
        if (this.isCustomComponent()) {
            buffer.append("var element = document.getElementById(\"");
            buffer.append(this.getContentMarkupId());
            buffer.append("\");\n");
        }
        buffer.append("var settings = new Object();\n");
        this.appendAssignment(buffer, (CharSequence)"settings.minWidth", this.getMinimalWidth());
        this.appendAssignment(buffer, (CharSequence)"settings.minHeight", this.getMinimalHeight());
        this.appendAssignment(buffer, (CharSequence)"settings.className", this.getCssClassName());
        this.appendAssignment(buffer, (CharSequence)"settings.width", this.getInitialWidth());
        if (this.isUseInitialHeight() || !this.isCustomComponent()) {
            this.appendAssignment(buffer, (CharSequence)"settings.height", this.getInitialHeight());
        } else {
            buffer.append("settings.height=null;\n");
        }
        this.appendAssignment(buffer, (CharSequence)"settings.resizable", this.isResizable());
        if (!this.isResizable()) {
            this.appendAssignment(buffer, (CharSequence)"settings.widthUnit", this.getWidthUnit());
            this.appendAssignment(buffer, (CharSequence)"settings.heightUnit", this.getHeightUnit());
        }
        if (!this.isCustomComponent()) {
            Page page = this.createPage();
            if (page == null) {
                throw new WicketRuntimeException("Error creating page for modal dialog.");
            }
            RequestCycle.get().setUrlForNewWindowEncoding();
            this.appendAssignment(buffer, (CharSequence)"settings.src", RequestCycle.get().urlFor(page));
            if (this.getPageMapName() != null) {
                this.appendAssignment(buffer, (CharSequence)"settings.iframeName", this.getPageMapName());
            }
        } else {
            buffer.append("settings.element=element;\n");
        }
        if (this.getCookieName() != null) {
            this.appendAssignment(buffer, (CharSequence)"settings.cookieId", this.getCookieName());
        }
        String string = title = this.getTitle() != null ? (String)this.getTitle().getObject() : null;
        if (title != null) {
            this.appendAssignment(buffer, (CharSequence)"settings.title", this.escapeQuotes(title.toString()));
        }
        if (this.getMaskType() == MaskType.TRANSPARENT) {
            buffer.append("settings.mask=\"transparent\";\n");
        } else if (this.getMaskType() == MaskType.SEMI_TRANSPARENT) {
            buffer.append("settings.mask=\"semi-transparent\";\n");
        }
        boolean haveCloseCallback = false;
        if (!this.isCustomComponent() && this.deletePageMap || this.windowClosedCallback != null) {
            behavior = (WindowClosedBehavior)((Object)this.getBehaviors(WindowClosedBehavior.class).get(0));
            buffer.append("settings.onClose = function() { ");
            buffer.append((Object)behavior.getCallbackScript());
            buffer.append(" };\n");
            haveCloseCallback = true;
        }
        if (this.closeButtonCallback != null || !haveCloseCallback) {
            behavior = (CloseButtonBehavior)((Object)this.getBehaviors(CloseButtonBehavior.class).get(0));
            buffer.append("settings.onCloseButton = function() { ");
            buffer.append((Object)behavior.getCallbackScript());
            buffer.append("};\n");
        }
        this.postProcessSettings(buffer);
        buffer.append("Wicket.Window.create(settings).show();\n");
        return buffer.toString();
    }

    private void appendAssignment(AppendingStringBuffer buffer, CharSequence key, int value) {
        buffer.append((Object)key).append("=");
        buffer.append(value);
        buffer.append(";\n");
    }

    private void appendAssignment(AppendingStringBuffer buffer, CharSequence key, boolean value) {
        buffer.append((Object)key).append("=");
        buffer.append(Boolean.toString(value));
        buffer.append(";\n");
    }

    private void appendAssignment(AppendingStringBuffer buffer, CharSequence key, CharSequence value) {
        buffer.append((Object)key).append("=\"");
        buffer.append((Object)value);
        buffer.append("\";\n");
    }

    protected AppendingStringBuffer postProcessSettings(AppendingStringBuffer settings) {
        return settings;
    }

    protected void onDetach() {
        super.onDetach();
        if (this.title != null) {
            this.title.detach();
        }
    }

    private class CloseButtonBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private CloseButtonBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            if (ModalWindow.this.closeButtonCallback == null || ModalWindow.this.closeButtonCallback.onCloseButtonClicked(target)) {
                ModalWindow.this.close(target);
            }
        }

        protected IAjaxCallDecorator getAjaxCallDecorator() {
            return new CancelEventIfNoAjaxDecorator(super.getAjaxCallDecorator());
        }

        protected CharSequence getCallbackScript() {
            return super.getCallbackScript();
        }
    }

    private class WindowClosedBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private WindowClosedBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            Session session;
            IPageMap pageMap;
            ModalWindow.this.shown = false;
            if (ModalWindow.this.deletePageMap && (pageMap = (session = Session.get()).pageMapForName(ModalWindow.this.getPageMapName(), false)) != null) {
                session.removePageMap(pageMap);
                ModalWindow.this.deletePageMap = false;
            }
            if (ModalWindow.this.windowClosedCallback != null) {
                ModalWindow.this.windowClosedCallback.onClose(target);
            }
        }

        protected CharSequence getCallbackScript() {
            return super.getCallbackScript();
        }
    }

    public static final class MaskType
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;
        public static final MaskType TRANSPARENT = new MaskType("TRANSPARENT");
        public static final MaskType SEMI_TRANSPARENT = new MaskType("SEMI_TRANSPARENT");

        public MaskType(String name) {
            super(name);
        }
    }

    public static interface WindowClosedCallback
    extends IClusterable {
        public void onClose(AjaxRequestTarget var1);
    }

    public static interface CloseButtonCallback
    extends IClusterable {
        public boolean onCloseButtonClicked(AjaxRequestTarget var1);
    }

    public static interface PageCreator
    extends IClusterable {
        public Page createPage();
    }
}

