/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.dao;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.PostActivate;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import net.sf.json.JSONObject;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.entity.User;
import org.dcm4chee.usr.entity.UserRoleAssignment;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.model.Group;
import org.dcm4chee.usr.model.Role;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.system.server.ServerConfigLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@LocalBinding(jndiBinding="dcm4chee-usr-dao/UserAccess/local")
public class UserAccessBean
implements UserAccess {
    private static Logger log = LoggerFactory.getLogger(UserAccessBean.class);
    @PersistenceContext(unitName="dcm4chee-usr")
    private EntityManager em;
    private File rolesMappingFile;
    private File groupsFile;
    private File aetGroupsFile;
    private String userRoleName;
    private String adminRoleName;
    private boolean ensureUserAndAdminRole;

    @PostConstruct
    @PostActivate
    private void config() {
        if (this.rolesMappingFile == null) {
            this.userRoleName = System.getProperty("dcm4chee-usr.cfg.userrole", "+WebUser");
            this.adminRoleName = System.getProperty("dcm4chee-usr.cfg.adminrole", "+WebAdmin");
            this.rolesMappingFile = new File(System.getProperty("dcm4chee-web3.cfg.path", "conf/dcm4chee-web3") + "roles.json");
            if (!this.rolesMappingFile.isAbsolute()) {
                this.rolesMappingFile = new File(ServerConfigLocator.locate().getServerHomeDir(), this.rolesMappingFile.getPath());
            }
            if (log.isDebugEnabled()) {
                log.debug("UserAccess configuration:\nuserRoleName:" + this.userRoleName);
                log.debug("adminRoleName:" + this.adminRoleName);
                log.debug("ensureUserAndAdminRole:" + this.ensureUserAndAdminRole);
                log.debug("mappingFile:" + this.rolesMappingFile);
            }
            if (!this.rolesMappingFile.exists()) {
                try {
                    if (this.rolesMappingFile.getParentFile().mkdirs()) {
                        log.info("M-WRITE dir:" + this.rolesMappingFile.getParent());
                    }
                    this.rolesMappingFile.createNewFile();
                }
                catch (IOException e) {
                    log.error("RolesMapping file doesn't exist and can't be created!", (Throwable)e);
                }
            }
        }
        this.groupsFile = this.checkFile(this.groupsFile, "groups.json");
        this.aetGroupsFile = this.checkFile(this.aetGroupsFile, "aet-groups.json");
        List<Role> roles = null;
        if (this.userRoleName.charAt(0) == '+') {
            Role userRole;
            this.userRoleName = this.userRoleName.substring(1);
            roles = this.getAllRoles();
            if (!roles.contains(userRole = new Role(this.userRoleName))) {
                this.addRole(userRole);
                roles.add(userRole);
            }
        }
        if (this.adminRoleName.charAt(0) == '+') {
            this.adminRoleName = this.adminRoleName.substring(1);
            Role adminRole = new Role(this.adminRoleName);
            if (roles == null) {
                roles = this.getAllRoles();
            }
            if (!roles.contains(adminRole)) {
                this.addRole(adminRole);
            }
        }
    }

    private File checkFile(File file, String jsonFilename) {
        if (file == null) {
            file = new File(System.getProperty("dcm4chee-web3.cfg.path", "conf/dcm4chee-web3") + jsonFilename);
            if (!file.isAbsolute()) {
                file = new File(ServerConfigLocator.locate().getServerHomeDir(), file.getPath());
            }
            if (log.isDebugEnabled()) {
                log.debug(jsonFilename + ":" + file);
            }
            if (!file.exists()) {
                try {
                    if (file.getParentFile().mkdirs()) {
                        log.info("M-WRITE dir:" + file.getParent());
                    }
                    file.createNewFile();
                }
                catch (IOException e) {
                    log.error(jsonFilename + " file doesn't exist and can't be created!", (Throwable)e);
                }
            }
        }
        return file;
    }

    @Override
    public String getUserRoleName() {
        return this.userRoleName;
    }

    @Override
    public String getAdminRoleName() {
        return this.adminRoleName;
    }

    @Override
    public List<User> getAllUsers(String userID) {
        List myRoles = this.em.createQuery("SELECT DISTINCT ura.role FROM UserRoleAssignment ura WHERE ura.userID = :userID").setParameter("userID", (Object)userID).getResultList();
        List<Role> allRoles = this.getAllRoles();
        boolean superuser = false;
        ArrayList<String> superusers = new ArrayList<String>();
        for (Role role : allRoles) {
            if (!role.isSuperuser()) continue;
            superusers.add(role.getRolename());
            if (!myRoles.contains(role.getRolename())) continue;
            superuser = true;
        }
        if (!superuser && superusers.size() > 0) {
            return this.em.createQuery("SELECT DISTINCT u FROM User u LEFT JOIN FETCH u.roles r WHERE u.roles IS EMPTY OR r.role NOT IN (:superusers) ORDER BY u.userID").setParameter("superusers", superusers).getResultList();
        }
        return this.em.createQuery("SELECT DISTINCT u FROM User u LEFT JOIN FETCH u.roles ORDER BY u.userID").getResultList();
    }

    @Override
    public User getUser(String userId) {
        return (User)this.em.find(User.class, (Object)userId);
    }

    @Override
    public User getUserIgnoreCase(String userId) {
        return (User)this.em.createQuery("SELECT DISTINCT u FROM User u WHERE UPPER(u.userID) = UPPER(:userID)").setParameter("userID", (Object)userId).getSingleResult();
    }

    @Override
    public void createUser(User user) {
        this.em.persist((Object)user);
    }

    @Override
    public void updateUser(String userId, String password) {
        User managedUser = (User)this.em.find(User.class, (Object)userId);
        managedUser.setPassword(password);
    }

    @Override
    public void deleteUser(String userId) {
        this.em.createQuery("DELETE FROM UserRoleAssignment ura WHERE ura.userID = :userID").setParameter("userID", (Object)userId).executeUpdate();
        this.em.createQuery("DELETE FROM User u WHERE u.userID = :userID").setParameter("userID", (Object)userId).executeUpdate();
    }

    @Override
    public Boolean userExists(String username) {
        try {
            this.em.createQuery("SELECT DISTINCT u FROM User u WHERE u.userID = :userID").setParameter("userID", (Object)username).getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    @Override
    public Boolean hasPassword(String username, String password) {
        try {
            this.em.createQuery("SELECT DISTINCT u FROM User u WHERE u.userID = :userID AND u.password = :password").setParameter("userID", (Object)username).setParameter("password", (Object)password).getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    @Override
    public void assignRole(UserRoleAssignment ura) {
        this.em.persist((Object)ura);
    }

    @Override
    public void unassignRole(UserRoleAssignment ura) {
        this.em.createQuery("DELETE FROM UserRoleAssignment ura WHERE ura.userID = :userID AND ura.role = :rolename").setParameter("userID", (Object)ura.getUserID()).setParameter("rolename", (Object)ura.getRole()).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Role> getAllRoles() {
        ArrayList<Role> arrayList;
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<Role> roleList = new ArrayList<Role>();
            reader = new BufferedReader(new FileReader(this.rolesMappingFile));
            while ((line = reader.readLine()) != null) {
                roleList.add((Role)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)line), Role.class));
            }
            List<Group> allGroups = this.getAllGroups();
            ArrayList<String> groupUuidList = new ArrayList<String>(allGroups.size());
            for (Group group : allGroups) {
                groupUuidList.add(group.getUuid());
            }
            Collections.sort(roleList);
            arrayList = roleList;
            this.close(reader, "mapping file reader");
        }
        catch (Exception e) {
            List<Role> list;
            try {
                log.error("Can't get roles from roles mapping file!", (Throwable)e);
                list = null;
                this.close(reader, "mapping file reader");
            }
            catch (Throwable throwable) {
                this.close(reader, "mapping file reader");
                throw throwable;
            }
            return list;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(Role role) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.rolesMappingFile, true));
            JSONObject jsonObject = JSONObject.fromObject((Object)role);
            writer.write(jsonObject.toString());
            writer.newLine();
            this.close(writer, "mapping file reader");
        }
        catch (IOException e) {
            try {
                log.error("Can't add role to roles mapping file!", (Throwable)e);
                this.close(writer, "mapping file reader");
            }
            catch (Throwable throwable) {
                this.close(writer, "mapping file reader");
                throw throwable;
            }
        }
    }

    @Override
    public void updateRole(Role role) {
        Role oldRole = null;
        List<Role> roles = this.getAllRoles();
        for (Role current : roles) {
            if (!role.getUuid().equals(current.getUuid())) continue;
            oldRole = current;
        }
        if (oldRole != null) {
            if (!oldRole.getRolename().equals(role.getRolename())) {
                this.em.createQuery("UPDATE UserRoleAssignment ura SET ura.role = :newRolename WHERE ura.role = :oldRolename").setParameter("oldRolename", (Object)oldRole.getRolename()).setParameter("newRolename", (Object)role.getRolename()).executeUpdate();
            }
            roles.set(roles.indexOf(oldRole), role);
            this.saveRoles(roles);
        } else {
            log.warn("Update Role " + role + " failed! Removed from roles mapping file!");
        }
    }

    @Override
    public void removeRole(Role role) {
        this.em.createQuery("DELETE FROM StudyPermission sp WHERE sp.role = :rolename").setParameter("rolename", (Object)role.getRolename()).executeUpdate();
        this.em.createQuery("DELETE FROM UserRoleAssignment ura WHERE ura.role = :rolename").setParameter("rolename", (Object)role.getRolename()).executeUpdate();
        List<Role> roles = this.getAllRoles();
        if (roles.remove(role)) {
            this.saveRoles(roles);
        } else {
            log.warn("Role " + role + " already removed from roles mapping file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRoles(List<Role> roles) {
        BufferedWriter writer = null;
        try {
            File tmpFile = File.createTempFile(this.rolesMappingFile.getName(), null, this.rolesMappingFile.getParentFile());
            writer = new BufferedWriter(new FileWriter(tmpFile, true));
            int len = roles.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jsonObject = JSONObject.fromObject((Object)roles.get(i));
                writer.write(jsonObject.toString());
                writer.newLine();
            }
            if (this.close(writer, "Temporary mapping file")) {
                writer = null;
            }
            this.rolesMappingFile.delete();
            tmpFile.renameTo(this.rolesMappingFile);
            this.close(writer, "Temporary mapping file (in finally block)");
        }
        catch (IOException e) {
            log.error("Can't save roles in roles mapping file!", (Throwable)e);
        }
        finally {
            this.close(writer, "Temporary mapping file (in finally block)");
        }
    }

    @Override
    public Boolean roleExists(String rolename) {
        return this.getAllRoles().contains(new Role(rolename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getAllGroups() {
        ArrayList<Group> arrayList;
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<Group> groupList = new ArrayList<Group>();
            reader = new BufferedReader(new FileReader(this.groupsFile));
            while ((line = reader.readLine()) != null) {
                groupList.add((Group)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)line), Group.class));
            }
            Collections.sort(groupList);
            int webPos = -1;
            int dicomPos = -1;
            int aetPos = -1;
            for (int i = 0; i < groupList.size(); ++i) {
                if (((Group)groupList.get(i)).getGroupname().equalsIgnoreCase("Web")) {
                    webPos = i;
                }
                if (((Group)groupList.get(i)).getGroupname().equalsIgnoreCase("Dicom")) {
                    dicomPos = i;
                }
                if (!((Group)groupList.get(i)).getGroupname().equalsIgnoreCase("AET")) continue;
                aetPos = i;
            }
            if (aetPos > 0) {
                Group aetGroup = (Group)groupList.get(aetPos);
                groupList.remove(aetPos);
                groupList.add(0, aetGroup);
            } else if (aetPos == -1) {
                Group group = new Group();
                group.setGroupname("AET");
                this.addGroup(group);
                groupList.add(0, group);
            }
            if (dicomPos > 0) {
                Group dicomGroup = (Group)groupList.get(dicomPos);
                groupList.remove(dicomPos);
                groupList.add(0, dicomGroup);
            } else if (dicomPos == -1) {
                Group group = new Group();
                group.setGroupname("Dicom");
                this.addGroup(group);
                groupList.add(0, group);
            }
            if (webPos > 0) {
                Group webGroup = (Group)groupList.get(webPos);
                groupList.remove(webPos);
                groupList.add(0, webGroup);
            } else if (webPos == -1) {
                Group group = new Group();
                group.setGroupname("Web");
                this.addGroup(group);
                groupList.add(0, group);
            }
            arrayList = groupList;
            this.close(reader, "groups file reader");
        }
        catch (Exception e) {
            List<Group> list;
            try {
                log.error("Can't get groups from groups file!", (Throwable)e);
                list = null;
                this.close(reader, "groups file reader");
            }
            catch (Throwable throwable) {
                this.close(reader, "groups file reader");
                throw throwable;
            }
            return list;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(Group group) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.groupsFile, true));
            JSONObject jsonObject = JSONObject.fromObject((Object)group);
            writer.write(jsonObject.toString());
            writer.newLine();
            this.close(writer, "groups file reader");
        }
        catch (IOException e) {
            try {
                log.error("Can't add group to groups file!", (Throwable)e);
                this.close(writer, "groups file reader");
            }
            catch (Throwable throwable) {
                this.close(writer, "groups file reader");
                throw throwable;
            }
        }
    }

    @Override
    public void updateGroup(Group group) {
        Group oldGroup = null;
        List<Group> groups = this.getAllGroups();
        for (Group current : groups) {
            if (!group.getUuid().equals(current.getUuid())) continue;
            oldGroup = current;
        }
        if (oldGroup != null) {
            groups.set(groups.indexOf(oldGroup), group);
            this.saveGroups(groups);
        } else {
            log.warn("Update Group " + group + " failed! Removed from groups file!");
        }
    }

    @Override
    public void removeGroup(Group group) {
        List<Role> roles = this.getAllRoles();
        for (Role role : roles) {
            if (!role.getRoleGroups().contains(role.getUuid())) continue;
            role.getRoleGroups().remove(role.getUuid());
        }
        List<Group> groups = this.getAllGroups();
        if (groups.remove(group)) {
            this.saveGroups(groups);
        } else {
            log.warn("Group " + group + " already removed from groups file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGroups(List<Group> groups) {
        BufferedWriter writer = null;
        try {
            File tmpFile = File.createTempFile(this.groupsFile.getName(), null, this.groupsFile.getParentFile());
            writer = new BufferedWriter(new FileWriter(tmpFile, true));
            int len = groups.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jsonObject = JSONObject.fromObject((Object)groups.get(i));
                writer.write(jsonObject.toString());
                writer.newLine();
            }
            if (this.close(writer, "Temporary groups file")) {
                writer = null;
            }
            this.groupsFile.delete();
            tmpFile.renameTo(this.groupsFile);
            this.close(writer, "Temporary groups file (in finally block)");
        }
        catch (IOException e) {
            log.error("Can't save groups in groups file!", (Throwable)e);
        }
        finally {
            this.close(writer, "Temporary groups file (in finally block)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AETGroup> getAllAETGroups() {
        ArrayList<AETGroup> arrayList;
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<AETGroup> aetGroupList = new ArrayList<AETGroup>();
            reader = new BufferedReader(new FileReader(this.aetGroupsFile));
            while ((line = reader.readLine()) != null) {
                aetGroupList.add((AETGroup)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)line), AETGroup.class));
            }
            Collections.sort(aetGroupList);
            arrayList = aetGroupList;
            this.close(reader, "aet groups file reader");
        }
        catch (Exception e) {
            List<AETGroup> list;
            try {
                log.error("Can't get aet groups from aet groups file!", (Throwable)e);
                list = null;
                this.close(reader, "aet groups file reader");
            }
            catch (Throwable throwable) {
                this.close(reader, "aet groups file reader");
                throw throwable;
            }
            return list;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAETGroup(AETGroup aetGroup) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.aetGroupsFile, true));
            JSONObject jsonObject = JSONObject.fromObject((Object)aetGroup);
            writer.write(jsonObject.toString());
            writer.newLine();
            this.close(writer, "aet groups file reader");
        }
        catch (IOException e) {
            try {
                log.error("Can't add aet group to aet groups file!", (Throwable)e);
                this.close(writer, "aet groups file reader");
            }
            catch (Throwable throwable) {
                this.close(writer, "aet groups file reader");
                throw throwable;
            }
        }
    }

    @Override
    public void updateAETGroup(AETGroup aetGroup) {
        AETGroup oldAetGroup = null;
        List<AETGroup> aetGroups = this.getAllAETGroups();
        for (AETGroup current : aetGroups) {
            if (!aetGroup.getUuid().equals(current.getUuid())) continue;
            oldAetGroup = current;
        }
        if (oldAetGroup != null) {
            aetGroups.set(aetGroups.indexOf(oldAetGroup), aetGroup);
            this.saveAETGroups(aetGroups);
        } else {
            log.warn("Update AET Group " + aetGroup + " failed! Removed from aet groups file!");
        }
    }

    @Override
    public void removeAETGroup(AETGroup aetGroup) {
        List<Role> roles = this.getAllRoles();
        for (Role role : roles) {
            if (!role.getAETGroups().contains(aetGroup.getUuid())) continue;
            role.getAETGroups().remove(aetGroup.getUuid());
        }
        List<AETGroup> aetGroups = this.getAllAETGroups();
        if (aetGroups.remove(aetGroup)) {
            this.saveAETGroups(aetGroups);
        } else {
            log.warn("AET Group " + aetGroup + " already removed from aet groups file!");
        }
    }

    @Override
    public List<AETGroup> getAETGroups(List<String> roles) {
        HashSet<String> aetGroupUuids = new HashSet<String>();
        for (Role role : this.getAllRoles()) {
            if (!role.isAETRole() || !roles.contains(role.getRolename())) continue;
            aetGroupUuids.addAll(role.getAETGroups());
        }
        List<AETGroup> aetGroups = this.getAllAETGroups();
        for (int i = 0; i < aetGroups.size(); ++i) {
            AETGroup aetGroup = aetGroups.get(i);
            if (aetGroupUuids.contains(aetGroup.getUuid())) continue;
            aetGroups.remove(aetGroup);
            --i;
        }
        Collections.sort(aetGroups);
        if (aetGroupUuids.contains("*")) {
            aetGroups.add(0, new AETGroup("*"));
        }
        return aetGroups;
    }

    @Override
    public List<String> listAETitles() {
        return this.em.createQuery("SELECT ae.title FROM AE ae ORDER BY ae.title").getResultList();
    }

    @Override
    public void updateAETInAETGroups(String oldAET, String newAET) {
        List<AETGroup> aetGroups = this.getAllAETGroups();
        for (AETGroup aetGroup : aetGroups) {
            aetGroup.getAets().remove(oldAET);
            aetGroup.getAets().add(newAET);
        }
        this.saveAETGroups(aetGroups);
    }

    @Override
    public void removeAETFromAETGroups(String aet) {
        List<AETGroup> aetGroups = this.getAllAETGroups();
        for (AETGroup aetGroup : aetGroups) {
            aetGroup.getAets().remove(aet);
        }
        this.saveAETGroups(aetGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAETGroups(List<AETGroup> aetGroups) {
        BufferedWriter writer = null;
        try {
            File tmpFile = File.createTempFile(this.aetGroupsFile.getName(), null, this.aetGroupsFile.getParentFile());
            writer = new BufferedWriter(new FileWriter(tmpFile, true));
            int len = aetGroups.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jsonObject = JSONObject.fromObject((Object)aetGroups.get(i));
                writer.write(jsonObject.toString());
                writer.newLine();
            }
            if (this.close(writer, "Temporary aet groups file")) {
                writer = null;
            }
            this.aetGroupsFile.delete();
            tmpFile.renameTo(this.aetGroupsFile);
            this.close(writer, "Temporary aet groups file (in finally block)");
        }
        catch (IOException e) {
            log.error("Can't save aet groups in aet groups file!", (Throwable)e);
        }
        finally {
            this.close(writer, "Temporary aet groups file (in finally block)");
        }
    }

    private boolean close(Closeable toClose, String desc) {
        log.debug("Closing ", (Object)desc);
        if (toClose != null) {
            try {
                toClose.close();
                return true;
            }
            catch (IOException ignore) {
                log.warn("Error closing : " + desc, (Throwable)ignore);
            }
        }
        return false;
    }
}

