/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.PersonName;
import org.dcm4chex.rid.mbean.xml.XMLResponseObject;
import org.dcm4chex.rid.mbean.xml.XMLUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IHEDocumentList
implements XMLResponseObject {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat DATETIME_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private static Logger log = Logger.getLogger((String)IHEDocumentList.class.getName());
    private List<Dataset> datasets = new ArrayList<Dataset>();
    private HashSet<String> iuids = new HashSet();
    private Dataset queryDS = null;
    private TransformerHandler th = null;
    private XMLUtil util = null;
    private String docCode;
    private String docCodeSystem;
    private String docDisplayName;
    private long lowerDateTime = Long.MIN_VALUE;
    private long upperDateTime = Long.MAX_VALUE;
    private int mostRecentResults = 0;
    private String xslFile;
    private String reqURL = "";
    private String docRIDUrl = "http://localhost:8080";
    private URL xslt;
    private Collection<String> docSopCuids;

    public IHEDocumentList() {
    }

    public IHEDocumentList(Collection<Dataset> datasets) {
        this.addAll(datasets);
    }

    public void setQueryDS(Dataset ds) {
        this.queryDS = ds;
    }

    public boolean add(Dataset ds) {
        long ms;
        if (this.iuids.contains(ds.getString(524312))) {
            return false;
        }
        Date date = ds.getDateTime(524323, 524339);
        if (date != null && ((ms = date.getTime()) < this.lowerDateTime || ms > this.upperDateTime)) {
            return false;
        }
        this.iuids.add(ds.getString(524312));
        return this.datasets.add(ds);
    }

    private void applyMostRecentResults() {
        Collections.sort(this.datasets, new DatasetDateComparator());
        if (this.mostRecentResults > 0 && this.datasets.size() > this.mostRecentResults) {
            this.datasets.subList(this.mostRecentResults, this.datasets.size()).clear();
        }
    }

    private Date getDateFromDS(Dataset ds) {
        Date d = ds.getDateTime(524323, 524339);
        if (d == null) {
            d = ds.getDate(524330);
        }
        return d;
    }

    public void addAll(Collection<Dataset> col) {
        if (col == null || col.isEmpty()) {
            return;
        }
        for (Dataset ds : col) {
            this.add(ds);
        }
    }

    public int size() {
        return this.datasets.size();
    }

    public String getDocCode() {
        return this.docCode;
    }

    public void setDocCode(String docCode) {
        this.docCode = docCode;
    }

    public String getDocCodeSystem() {
        return this.docCodeSystem;
    }

    public void setDocCodeSystem(String docCodeSystem) {
        this.docCodeSystem = docCodeSystem;
    }

    public String getDocDisplayName() {
        return this.docDisplayName;
    }

    public void setDocDisplayName(String docDisplayName) {
        this.docDisplayName = docDisplayName;
    }

    public void setLowerDateTime(Date lowerDateTime) {
        this.lowerDateTime = lowerDateTime.getTime();
    }

    public int getMostRecentResults() {
        return this.mostRecentResults;
    }

    public void setMostRecentResults(int mostRecentResults) {
        this.mostRecentResults = mostRecentResults;
    }

    public void setUpperDateTime(Date upperDateTime) {
        this.upperDateTime = upperDateTime.getTime();
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    public URL getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) throws MalformedURLException {
        this.xslt = xslt != null ? (xslt.startsWith("http:") ? new URL(xslt) : new URL(this.getDocRIDUrl() + "/" + xslt)) : null;
    }

    public void setReqURL(String reqURL) {
        this.reqURL = reqURL;
    }

    public String getDocRIDUrl() {
        return this.docRIDUrl;
    }

    public void setDocRIDUrl(String docRIDUrl) {
        this.docRIDUrl = docRIDUrl;
    }

    @Override
    public void toXML(OutputStream out) throws TransformerConfigurationException, SAXException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.applyMostRecentResults();
        if (this.xslt != null) {
            try {
                this.th = tf.newTransformerHandler(new StreamSource(this.xslt.openStream(), this.xslt.toExternalForm()));
            }
            catch (IOException x) {
                log.error((Object)("Cant open xsl file:" + this.xslt), (Throwable)x);
            }
        } else {
            this.th = tf.newTransformerHandler();
            this.th.getTransformer().setOutputProperty("indent", "yes");
        }
        this.th.setResult(new StreamResult(out));
        this.th.startDocument();
        if (this.xslFile != null) {
            this.th.processingInstruction("xml-stylesheet", "href='" + this.xslFile + "' type='text/xsl'");
        }
        this.toXML();
        this.th.endDocument();
        try {
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close stream.", (Throwable)e);
        }
    }

    private void toXML() throws SAXException {
        Dataset ds;
        this.util = new XMLUtil(this.th);
        this.util.startElement("IHEDocumentList", EMPTY_ATTRIBUTES);
        this.addDocCode();
        this.addActivityTime();
        if (this.datasets.size() > 0) {
            ds = this.datasets.get(0);
        } else if (this.queryDS != null) {
            ds = this.queryDS;
        } else {
            ds = DcmObjectFactory.getInstance().newDataset();
            ds.putLO(0x100020, "");
        }
        this.addRecordTarget(ds);
        this.addAuthor();
        this.addDocuments();
        this.util.endElement("IHEDocumentList");
    }

    @Override
    public void embedXML(TransformerHandler th) throws SAXException {
        this.th = th;
        this.toXML();
    }

    private void addDocCode() throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        if (this.docCode != null) {
            this.util.addAttribute(attr, "code", this.docCode);
        }
        if (this.docCodeSystem != null) {
            this.util.addAttribute(attr, "codeSystem", this.docCodeSystem);
        }
        if (this.docDisplayName != null) {
            this.util.addAttribute(attr, "displayName", this.docDisplayName);
        }
        this.util.startElement("code", attr);
        this.util.endElement("code");
    }

    private void addActivityTime() throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "value", DATETIME_FORMATTER.format(new Date()));
        this.util.startElement("activityTime", attr);
        this.util.endElement("activityTime");
    }

    private void addRecordTarget(Dataset ds) throws SAXException {
        this.util.startElement("recordTarget", EMPTY_ATTRIBUTES);
        this.util.startElement("patient", EMPTY_ATTRIBUTES);
        AttributesImpl attrsPatID = new AttributesImpl();
        this.util.addAttribute(attrsPatID, "root", ds.getString(0x100021));
        this.util.addAttribute(attrsPatID, "extension", ds.getString(0x100020));
        this.util.startElement("id", attrsPatID);
        this.util.endElement("id");
        this.addPatientPatient(ds);
        this.util.startElement("providerOrganization", EMPTY_ATTRIBUTES);
        AttributesImpl attrsOrgID = new AttributesImpl();
        this.util.addAttribute(attrsOrgID, "id", "");
        this.util.startElement("id", attrsOrgID);
        this.util.endElement("id");
        this.util.startElement("name", EMPTY_ATTRIBUTES);
        String orgName = ds.getString(524416);
        if (orgName != null) {
            this.th.characters(orgName.toCharArray(), 0, orgName.length());
        }
        this.util.endElement("name");
        this.util.endElement("providerOrganization");
        this.util.endElement("patient");
        this.util.endElement("recordTarget");
    }

    private void addPatientPatient(Dataset ds) throws SAXException {
        String familyName = "";
        String givenName = "";
        String genderCode = "121103";
        String birthDate = "";
        try {
            Date date;
            String s;
            PersonName pn = ds.getPersonName(0x100010);
            if (pn != null) {
                familyName = pn.get(0);
                givenName = pn.get(1);
                if (givenName == null) {
                    givenName = "";
                }
            }
            if ("M".equals(s = ds.getString(0x100040)) || "F".equals(s)) {
                genderCode = s;
            }
            if ((date = ds.getDate(0x100030)) != null) {
                birthDate = DATE_FORMATTER.format(date);
            }
        }
        catch (Exception x) {
            log.warn((Object)"Exception getting person informations:", (Throwable)x);
        }
        this.util.startElement("patientPatient", EMPTY_ATTRIBUTES);
        this.util.startElement("name", EMPTY_ATTRIBUTES);
        this.util.startElement("family", EMPTY_ATTRIBUTES);
        this.th.characters(familyName.toCharArray(), 0, familyName.length());
        this.util.endElement("family");
        this.util.startElement("given", EMPTY_ATTRIBUTES);
        this.th.characters(givenName.toCharArray(), 0, givenName.length());
        this.util.endElement("given");
        this.util.endElement("name");
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "code", genderCode);
        this.util.addAttribute(attr, "codeSystem", "1.2.840.10008.2.16.4");
        this.util.startElement("administrativeGenderCode", attr);
        this.util.endElement("administrativeGenderCode");
        AttributesImpl attrBirth = new AttributesImpl();
        this.util.addAttribute(attrBirth, "value", birthDate);
        this.util.startElement("birthTime", attrBirth);
        this.util.endElement("birthTime");
        this.util.endElement("patientPatient");
    }

    private void addAuthor() throws SAXException {
        this.util.startElement("author", EMPTY_ATTRIBUTES);
        this.util.startElement("noteText", EMPTY_ATTRIBUTES);
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "value", this.reqURL);
        this.util.startElement("reference", attr);
        this.util.endElement("reference");
        this.util.endElement("noteText");
        this.util.startElement("assignedAuthor", EMPTY_ATTRIBUTES);
        AttributesImpl attrsID = new AttributesImpl();
        this.util.addAttribute(attrsID, "root", "");
        this.util.addAttribute(attrsID, "extension", "");
        this.util.startElement("id", attrsID);
        this.util.endElement("id");
        this.util.startElement("assignedDevice", EMPTY_ATTRIBUTES);
        AttributesImpl attrsCode = new AttributesImpl();
        this.util.addAttribute(attrsCode, "code", "");
        this.util.addAttribute(attrsCode, "codeSystem", "");
        this.util.addAttribute(attrsCode, "displayName", "");
        this.util.startElement("code", attrsCode);
        this.util.endElement("code");
        this.util.startElement("manufacturerModelName", EMPTY_ATTRIBUTES);
        this.util.endElement("manufacturerModelName");
        this.util.startElement("softwareName", EMPTY_ATTRIBUTES);
        this.util.endElement("softwareName");
        this.util.endElement("assignedDevice");
        this.util.endElement("assignedAuthor");
        this.util.endElement("author");
    }

    private void addDocuments() throws SAXException {
        for (Dataset ds : this.datasets) {
            this.addComponent(ds);
        }
    }

    private void addComponent(Dataset ds) throws SAXException {
        Date date;
        String uid = ds.getString(524312);
        if (uid == null) {
            uid = "---";
        }
        if ((date = ds.getDateTime(524323, 524339)) == null) {
            date = ds.getDate(524330);
        }
        String acquisTime = date == null ? "" : DATETIME_FORMATTER.format(date);
        String title = "DocumentTitle";
        String mime = ds.getString(4325394, "application/pdf");
        String link = this.docRIDUrl + "/IHERetrieveDocument?requestType=DOCUMENT&documentUID=" + uid + "&preferredContentType=" + mime;
        this.util.startElement("component", EMPTY_ATTRIBUTES);
        this.util.startElement("documentInformation", EMPTY_ATTRIBUTES);
        AttributesImpl attrID = new AttributesImpl();
        this.util.addAttribute(attrID, "root", uid);
        this.util.startElement("id", attrID);
        this.util.endElement("id");
        this.addComponentCode(ds);
        this.util.startElement("title", EMPTY_ATTRIBUTES);
        this.th.characters(title.toCharArray(), 0, title.length());
        this.util.endElement("title");
        this.util.startElement("text", EMPTY_ATTRIBUTES);
        AttributesImpl attrTxt = new AttributesImpl();
        this.util.addAttribute(attrTxt, "value", link);
        this.util.startElement("reference", attrTxt);
        this.util.endElement("reference");
        this.util.endElement("text");
        this.addComponentStatusCode(ds);
        AttributesImpl attrEff = new AttributesImpl();
        this.util.addAttribute(attrEff, "value", acquisTime);
        this.util.startElement("effectiveTime", attrEff);
        this.util.endElement("effectiveTime");
        this.util.endElement("documentInformation");
        this.util.endElement("component");
    }

    private void addComponentStatusCode(Dataset ds) throws SAXException {
        String statusCode = ds.getString(4236433, "") + "/" + ds.getString(4236435, "");
        AttributesImpl attrStatusCode = new AttributesImpl();
        this.util.addAttribute(attrStatusCode, "code", statusCode);
        this.util.addAttribute(attrStatusCode, "codeSystem", "");
        this.util.startElement("statusCode", attrStatusCode);
        this.util.endElement("statusCode");
    }

    private void addComponentCode(Dataset ds) throws SAXException {
        String code = "";
        String codeSystem = "";
        String displayname = "";
        String cuid = ds.getString(524310);
        if ("SR".equals(ds.getString(524384)) || this.docSopCuids != null && this.docSopCuids.contains(cuid)) {
            DcmElement elem = ds.get(4235331);
            if (elem != null && elem.countItems() > 0) {
                Dataset ds1 = elem.getItem(0);
                code = ds1.getString(524544);
                codeSystem = ds1.getString(524546);
                displayname = ds1.getString(524548);
            } else {
                displayname = ds.getString(4325392);
            }
            if (displayname == null) {
                displayname = ds.getString(528432);
            }
        } else if ("1.2.840.10008.5.1.4.1.1.9.1.1".equals(cuid)) {
            displayname = "12-lead ECG";
        } else if ("1.2.840.10008.5.1.4.1.1.9.1.2".equals(cuid)) {
            displayname = "General ECG";
        } else if ("1.2.840.10008.5.1.4.1.1.9.1.3".equals(cuid)) {
            displayname = "Ambulatory ECG";
        } else if ("1.2.840.10008.5.1.4.1.1.9.2.1".equals(cuid)) {
            displayname = "Hemodynamic";
        } else if ("1.2.840.10008.5.1.4.1.1.9.3.1".equals(cuid)) {
            displayname = "Cardiac Electrophysiology";
        }
        AttributesImpl attrCode = new AttributesImpl();
        this.util.addAttribute(attrCode, "code", code);
        this.util.addAttribute(attrCode, "codeSystem", codeSystem);
        this.util.addAttribute(attrCode, "displayName", displayname);
        this.util.startElement("code", attrCode);
        this.util.endElement("code");
    }

    public void setDocSopCuids(Collection<String> cuids) {
        this.docSopCuids = cuids;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DatasetDateComparator
    implements Comparator<Dataset> {
        @Override
        public int compare(Dataset arg0, Dataset arg1) {
            Date d1 = IHEDocumentList.this.getDateFromDS(arg0);
            if (d1 == null) {
                return 1;
            }
            Date d2 = IHEDocumentList.this.getDateFromDS(arg1);
            return d2 == null ? -1 : d2.compareTo(d1);
        }
    }
}

