/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg.xml;

import org.dcm4chex.rid.mbean.ecg.xml.WaveformArea;
import org.dcm4chex.rid.mbean.ecg.xml.WaveformTemplate;

public class WaveformFlowTemplate
implements WaveformTemplate {
    public static final float MIN_WIDTH = 1000.0f;
    public static final float MIN_HEIGHT = 1000.0f;
    public static final float CAL_PULSE_WIDTH = 120.0f;
    private float width;
    private float height;
    private int nrOfChannels;
    private boolean useCalPulse;
    private WaveformArea[] calPulseAreas;
    private WaveformArea[] wfAreas;

    public WaveformFlowTemplate(float w, float h, int nrOfChannels, boolean useCalPulse) {
        if (w < 1000.0f | h < 1000.0f) {
            throw new IllegalArgumentException("Template size too small ( " + w + " x " + h + " )! Min size: " + 1000.0f + " x " + 1000.0f);
        }
        this.width = w;
        this.height = h;
        this.nrOfChannels = nrOfChannels;
        this.useCalPulse = useCalPulse;
        this.initAreas();
    }

    private void initAreas() {
        float lineHeight = this.height / (float)this.nrOfChannels;
        float wfWidth = this.width;
        float wfX = 0.0f;
        this.wfAreas = new WaveformArea[this.nrOfChannels];
        if (this.useCalPulse) {
            wfWidth -= 120.0f;
            wfX += 120.0f;
            this.calPulseAreas = new WaveformArea[this.nrOfChannels];
        }
        float topY = 0.0f;
        int i = 0;
        while (i < this.nrOfChannels) {
            if (this.useCalPulse) {
                this.calPulseAreas[i] = WaveformArea.getCalPulseArea(0.0f, topY, 120.0f, lineHeight);
            }
            this.wfAreas[i] = WaveformArea.getWaveformArea(wfX, topY, wfWidth, lineHeight, i, null, null);
            ++i;
            topY += lineHeight;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public WaveformArea[] getAreas() {
        if (this.useCalPulse) {
            WaveformArea[] all = new WaveformArea[this.calPulseAreas.length << 1];
            System.arraycopy(this.calPulseAreas, 0, all, 0, this.calPulseAreas.length);
            System.arraycopy(this.wfAreas, 0, all, this.calPulseAreas.length, this.calPulseAreas.length << 1);
            return all;
        }
        return this.wfAreas;
    }

    public WaveformArea[] getCalPulseAreas() {
        return this.calPulseAreas;
    }

    public WaveformArea[] getWaveformAreas() {
        return this.wfAreas;
    }

    public String getFooterText() {
        return null;
    }
}

